/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.pojos;

import avail.descriptor.numbers.A_Number;
import avail.descriptor.pojos.PojoDescriptor;
import avail.descriptor.pojos.RawPojoDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PojoTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import java.lang.reflect.Array;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lavail/interpreter/primitive/pojos/P_CreatePojoArray;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_CreatePojoArray
extends Primitive {
    @NotNull
    public static final P_CreatePojoArray INSTANCE = new P_CreatePojoArray();

    private P_CreatePojoArray() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject elementType = interpreter.argument(0);
        AvailObject length = interpreter.argument(1);
        AvailLoader availLoader = interpreter.availLoaderOrNull();
        if (availLoader != null) {
            availLoader.statementCanBeSummarized(false);
        }
        AvailObject pojoType = PojoTypeDescriptor.Companion.pojoArrayType(elementType, IntegerRangeTypeDescriptor.Companion.singleInteger(length));
        Object object = elementType.marshalToJava(null);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.lang.Class<*>");
        Object array = Array.newInstance((Class)object, A_Number.Companion.getExtractInt(length));
        AvailObject pojo2 = PojoDescriptor.Companion.newPojo(RawPojoDescriptor.Companion.identityPojo(array), pojoType);
        return interpreter.primitiveSuccess(pojo2);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(InstanceMetaDescriptor.Companion.anyMeta(), IntegerRangeTypeDescriptor.Companion.getWholeNumbers()), PojoTypeDescriptor.Companion.mostGeneralPojoArrayType(), null, 4, null);
    }
}

