/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.sockets;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.maps.A_Map;
import avail.descriptor.maps.MapDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.MapTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousServerSocketChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\u000b"}, d2={"Lavail/interpreter/primitive/sockets/P_ServerSocketSetOption;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "Options", "avail"})
@SourceDebugExtension(value={"SMAP\nP_ServerSocketSetOption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P_ServerSocketSetOption.kt\navail/interpreter/primitive/sockets/P_ServerSocketSetOption\n+ 2 Casts.kt\navail/utility/CastsKt\n*L\n1#1,156:1\n46#2:157\n46#2:158\n*S KotlinDebug\n*F\n+ 1 P_ServerSocketSetOption.kt\navail/interpreter/primitive/sockets/P_ServerSocketSetOption\n*L\n100#1:157\n106#1:158\n*E\n"})
public final class P_ServerSocketSetOption
extends Primitive {
    @NotNull
    public static final P_ServerSocketSetOption INSTANCE = new P_ServerSocketSetOption();

    private P_ServerSocketSetOption() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject handle2 = interpreter.argument(0);
        AvailObject options = interpreter.argument(1);
        AvailObject pojo2 = A_Atom.Companion.getAtomProperty(handle2, AtomDescriptor.SpecialAtom.SERVER_SOCKET_KEY.getAtom());
        if (pojo2.isNil()) {
            return interpreter.primitiveFailure(A_Atom.Companion.isAtomSpecial(handle2) ? AvailErrorCode.E_SPECIAL_ATOM : AvailErrorCode.E_INVALID_HANDLE);
        }
        AsynchronousServerSocketChannel socket = (AsynchronousServerSocketChannel)pojo2.javaObjectNotNull();
        try {
            for (MapDescriptor.Entry entry : A_Map.Companion.getMapIterable(options)) {
                boolean $i$f$cast;
                SocketOption<?> $this$cast$iv;
                SocketOption<?> option;
                AvailObject key = entry.component1();
                AvailObject value = entry.component2();
                Intrinsics.checkNotNull(Options.INSTANCE.getSocketOptions()[A_Number.Companion.getExtractInt(key)]);
                if (Intrinsics.areEqual(option.type(), Boolean.class) && value.isBoolean()) {
                    $this$cast$iv = option;
                    $i$f$cast = false;
                    SocketOption booleanOption = (SocketOption)((Object)$this$cast$iv);
                    socket.setOption(booleanOption, (Object)A_Atom.Companion.getExtractBoolean(value));
                    continue;
                }
                if (Intrinsics.areEqual(option.type(), Integer.class) && A_Number.Companion.isInt(value)) {
                    $this$cast$iv = option;
                    $i$f$cast = false;
                    SocketOption intOption = (SocketOption)((Object)$this$cast$iv);
                    socket.setOption(intOption, (Object)A_Number.Companion.getExtractInt(value));
                    continue;
                }
                return interpreter.primitiveFailure(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE);
            }
            object = interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        catch (IllegalArgumentException e) {
            object = interpreter.primitiveFailure(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE);
        }
        catch (IOException e) {
            object = interpreter.primitiveFailure(AvailErrorCode.E_IO_ERROR);
        }
        return object;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ATOM.getO(), MapTypeDescriptor.Companion.mapTypeForSizesKeyTypeValueType(IntegerRangeTypeDescriptor.Companion.inclusive(0L, Options.INSTANCE.getSocketOptions().length - 1), IntegerRangeTypeDescriptor.Companion.inclusive(1L, Options.INSTANCE.getSocketOptions().length - 1), PrimitiveTypeDescriptor.Types.ANY.getO())), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INVALID_HANDLE, AvailErrorCode.E_SPECIAL_ATOM, AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE, AvailErrorCode.E_IO_ERROR};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lavail/interpreter/primitive/sockets/P_ServerSocketSetOption$Options;", "", "()V", "socketOptions", "", "Ljava/net/SocketOption;", "getSocketOptions", "()[Ljava/net/SocketOption;", "[Ljava/net/SocketOption;", "avail"})
    public static final class Options {
        @NotNull
        public static final Options INSTANCE = new Options();
        @NotNull
        private static final SocketOption<?>[] socketOptions;

        private Options() {
        }

        @NotNull
        public final SocketOption<?>[] getSocketOptions() {
            return socketOptions;
        }

        static {
            SocketOption[] socketOptionArray = new SocketOption[]{null, StandardSocketOptions.SO_RCVBUF, StandardSocketOptions.SO_REUSEADDR};
            socketOptions = socketOptionArray;
        }
    }
}

