/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer;

import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2ReadOperand;
import avail.interpreter.levelTwo.operation.L2_PHI_PSEUDO_OPERATION;
import avail.optimizer.DataCouplingMode;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2ControlFlowGraph;
import avail.optimizer.L2EntityAndKind;
import avail.optimizer.values.L2SemanticValue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\"\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u000fJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lavail/optimizer/DeadCodeAnalyzer;", "", "dataCouplingMode", "Lavail/optimizer/DataCouplingMode;", "controlFlowGraph", "Lavail/optimizer/L2ControlFlowGraph;", "(Lavail/optimizer/DataCouplingMode;Lavail/optimizer/L2ControlFlowGraph;)V", "edgeNeeds", "", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "", "Lavail/optimizer/L2EntityAndKind;", "liveInstructions", "Lavail/interpreter/levelTwo/L2Instruction;", "analyzeReads", "", "", "avail"})
@SourceDebugExtension(value={"SMAP\nDeadCodeAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeadCodeAnalyzer.kt\navail/optimizer/DeadCodeAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Casts.kt\navail/utility/CastsKt\n*L\n1#1,234:1\n766#2:235\n857#2:236\n1726#2,3:237\n858#2:240\n1855#2,2:241\n1549#2:243\n1620#2,3:244\n1855#2:248\n1726#2,3:249\n1856#2:252\n46#3:247\n*S KotlinDebug\n*F\n+ 1 DeadCodeAnalyzer.kt\navail/optimizer/DeadCodeAnalyzer\n*L\n117#1:235\n117#1:236\n118#1:237,3\n117#1:240\n129#1:241,2\n160#1:243\n160#1:244,3\n201#1:248\n212#1:249,3\n201#1:252\n165#1:247\n*E\n"})
public final class DeadCodeAnalyzer {
    @NotNull
    private final DataCouplingMode dataCouplingMode;
    @NotNull
    private final L2ControlFlowGraph controlFlowGraph;
    @NotNull
    private final Map<L2PcOperand, Set<L2EntityAndKind>> edgeNeeds;
    @NotNull
    private final Set<L2Instruction> liveInstructions;

    public DeadCodeAnalyzer(@NotNull DataCouplingMode dataCouplingMode, @NotNull L2ControlFlowGraph controlFlowGraph) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataCouplingMode), (String)"dataCouplingMode");
        Intrinsics.checkNotNullParameter((Object)controlFlowGraph, (String)"controlFlowGraph");
        this.dataCouplingMode = dataCouplingMode;
        this.controlFlowGraph = controlFlowGraph;
        this.edgeNeeds = new LinkedHashMap();
        this.liveInstructions = new LinkedHashSet();
    }

    /*
     * WARNING - void declaration
     */
    public final void analyzeReads() {
        void $this$filterTo$iv$iv;
        Object entity;
        Object pair;
        Object edge2;
        boolean bl = this.liveInstructions.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        for (L2BasicBlock block : this.controlFlowGraph.getBasicBlockOrder()) {
            for (int i2 = block.predecessorEdges().size() - 1; -1 < i2; --i2) {
                Object clamped;
                edge2 = block.predecessorEdges().get(i2);
                if (((L2PcOperand)edge2).getForcedClampedEntities() == null) continue;
                boolean bl2 = false;
                Set needs = new LinkedHashSet();
                Iterator iterator2 = clamped.iterator();
                while (iterator2.hasNext()) {
                    pair = (L2EntityAndKind)iterator2.next();
                    entity = ((L2EntityAndKind)pair).component1();
                    if (entity instanceof L2SemanticValue) {
                        if (!this.dataCouplingMode.getConsidersSemanticValues()) continue;
                        needs.add(pair);
                        continue;
                    }
                    if (!this.dataCouplingMode.getConsidersRegisters()) continue;
                    needs.add(pair);
                }
                this.edgeNeeds.put((L2PcOperand)edge2, needs);
            }
        }
        Iterable $this$filter$iv = this.controlFlowGraph.getBasicBlockOrder();
        boolean $i$f$filter = false;
        edge2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl3;
            block23: {
                void $this$all$iv;
                L2BasicBlock block = (L2BasicBlock)element$iv$iv;
                boolean bl4 = false;
                pair = block.successorEdges();
                entity = this.edgeNeeds;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        L2PcOperand p0 = (L2PcOperand)element$iv;
                        boolean bl5 = false;
                        if (entity.containsKey(p0)) continue;
                        bl3 = false;
                        break block23;
                    }
                    bl3 = true;
                }
            }
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection2 = (List)destination$iv$iv;
        ArrayDeque<L2BasicBlock> toVisit = new ArrayDeque<L2BasicBlock>(collection2);
        while (!toVisit.isEmpty()) {
            boolean phiInstruction2;
            L2Instruction instruction2;
            L2BasicBlock block;
            block = (L2BasicBlock)toVisit.removeFirst();
            Set neededEntities = new LinkedHashSet();
            Iterable $this$forEach$iv = block.successorEdges();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                L2PcOperand it = (L2PcOperand)element$iv;
                boolean bl6 = false;
                Set<L2EntityAndKind> set2 = this.edgeNeeds.get(it);
                Intrinsics.checkNotNull(set2);
                neededEntities.addAll((Collection)set2);
            }
            int predecessorCount = block.predecessorEdges().size();
            List<L2Instruction> instructions2 = block.instructions();
            int index2 = instructions2.size();
            while (--index2 >= 0 && !(instruction2 = instructions2.get(index2)).getOperation().isPhi()) {
                if (!neededEntities.removeAll((Collection)this.dataCouplingMode.writeEntitiesOf(instruction2)) && !instruction2.getHasSideEffect()) continue;
                this.liveInstructions.add(instruction2);
                neededEntities.addAll((Collection)this.dataCouplingMode.readEntitiesOf(instruction2));
            }
            List entitiesByPredecessor = null;
            if (index2 >= 0) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable it = (Iterable)new IntRange(0, predecessorCount);
                boolean $i$f$map = false;
                void bl4 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator $i$f$all = $this$mapTo$iv$iv.iterator();
                while ($i$f$all.hasNext()) {
                    int item$iv$iv;
                    int element$iv = item$iv$iv = ((IntIterator)$i$f$all).nextInt();
                    Collection collection3 = destination$iv$iv2;
                    boolean bl7 = false;
                    collection3.add(CollectionsKt.toMutableSet((Iterable)neededEntities));
                }
                entitiesByPredecessor = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
                while (index2 >= 0) {
                    L2Instruction phiInstruction2 = instructions2.get(index2);
                    L2Operation $this$cast$iv = phiInstruction2.getOperation();
                    boolean $i$f$cast = false;
                    L2_PHI_PSEUDO_OPERATION phiOperation = (L2_PHI_PSEUDO_OPERATION)$this$cast$iv;
                    List readOperands = phiOperation.sourceRegisterReads(phiInstruction2);
                    for (int predecessorIndex = 0; predecessorIndex < predecessorCount; ++predecessorIndex) {
                        Set entities = (Set)entitiesByPredecessor.get(predecessorIndex);
                        if (!entities.removeAll((Collection)this.dataCouplingMode.writeEntitiesOf(phiInstruction2)) && !phiInstruction2.getHasSideEffect()) continue;
                        this.liveInstructions.add(phiInstruction2);
                        L2ReadOperand readOperand = (L2ReadOperand)readOperands.get(predecessorIndex);
                        this.dataCouplingMode.addEntitiesFromRead(readOperand, entities);
                        entities.addAll((Collection)this.dataCouplingMode.readEntitiesOf(readOperand));
                    }
                    --index2;
                }
            } else {
                List list2 = Collections.nCopies(predecessorCount, neededEntities);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"nCopies(...)");
                entitiesByPredecessor = list2;
            }
            boolean bl8 = phiInstruction2 = !((Collection)block.predecessorEdges()).isEmpty() || neededEntities.isEmpty();
            if (_Assertions.ENABLED && !phiInstruction2) {
                boolean $i$a$-assert-DeadCodeAnalyzer$analyzeReads$52 = false;
                String $i$a$-assert-DeadCodeAnalyzer$analyzeReads$52 = "Instruction consumes " + neededEntities + " but a preceding definition was not found";
                throw new AssertionError((Object)$i$a$-assert-DeadCodeAnalyzer$analyzeReads$52);
            }
            Iterator<Set> entitySetIterator = entitiesByPredecessor.iterator();
            Iterable $this$forEach$iv2 = block.predecessorEdges();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                boolean bl9;
                L2BasicBlock predecessorBlock;
                block24: {
                    void $this$all$iv;
                    boolean bl7;
                    L2PcOperand predecessor = (L2PcOperand)element$iv;
                    boolean bl10 = false;
                    Set entities = entitySetIterator.next();
                    boolean bl11 = bl7 = this.edgeNeeds.containsKey(predecessor) == predecessor.isBackward();
                    if (_Assertions.ENABLED && !bl7) {
                        String bl5 = "Assertion failed";
                        throw new AssertionError((Object)bl5);
                    }
                    if (predecessor.isBackward()) continue;
                    this.edgeNeeds.put(predecessor, entities);
                    predecessorBlock = predecessor.getInstruction().basicBlock();
                    Iterable bl5 = predecessorBlock.successorEdges();
                    Map<L2PcOperand, Set<L2EntityAndKind>> map = this.edgeNeeds;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl9 = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            L2PcOperand p0 = (L2PcOperand)element$iv2;
                            boolean bl12 = false;
                            if (map.containsKey(p0)) continue;
                            bl9 = false;
                            break block24;
                        }
                        bl9 = true;
                    }
                }
                if (!bl9) continue;
                toVisit.add(predecessorBlock);
            }
        }
    }

    @NotNull
    public final Set<L2Instruction> liveInstructions() {
        boolean bl;
        boolean bl2 = bl = !((Collection)this.liveInstructions).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Set<L2Instruction> set2 = Collections.unmodifiableSet(this.liveInstructions);
        Intrinsics.checkNotNullExpressionValue(set2, (String)"unmodifiableSet(...)");
        return set2;
    }
}

