/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer;

import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2ControlFlowGraphVisualizer;
import avail.utility.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0003#$%B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u001c\u0010\u0011\u001a\u00020\u00122\u0014\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\u0014J\u001c\u0010\u0015\u001a\u00020\u00122\u0014\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\u0014J\u001c\u0010\u0016\u001a\u00020\u00122\u0014\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\u0014J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0000J\u0014\u0010\u0019\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0004J\u001c\u0010\u001c\u001a\u00020\u00122\u0014\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\u0014J\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0005J\b\u0010!\u001a\u00020\u001eH\u0016J\u0006\u0010\"\u001a\u00020\u001eR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001f\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006&"}, d2={"Lavail/optimizer/L2ControlFlowGraph;", "", "()V", "basicBlockOrder", "", "Lavail/optimizer/L2BasicBlock;", "getBasicBlockOrder", "()Ljava/util/List;", "state", "", "Lkotlin/reflect/KClass;", "Lavail/optimizer/L2ControlFlowGraph$StateFlag;", "getState", "()Ljava/util/Set;", "allRegisters", "", "Lavail/interpreter/levelTwo/register/L2Register;", "check", "", "flags", "", "checkNot", "clear", "evacuateTo", "destinationControlFlowGraph", "generateOn", "instructions", "Lavail/interpreter/levelTwo/L2Instruction;", "set", "simplyVisualize", "", "startBlock", "block", "toString", "visualize", "StateFlag", "Zone", "ZoneType", "avail"})
@SourceDebugExtension(value={"SMAP\nL2ControlFlowGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 L2ControlFlowGraph.kt\navail/optimizer/L2ControlFlowGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n1855#2,2:346\n*S KotlinDebug\n*F\n+ 1 L2ControlFlowGraph.kt\navail/optimizer/L2ControlFlowGraph\n*L\n267#1:346,2\n*E\n"})
public final class L2ControlFlowGraph {
    @NotNull
    private final Set<KClass<? extends StateFlag>> state;
    @NotNull
    private final List<L2BasicBlock> basicBlockOrder;

    public L2ControlFlowGraph() {
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(StateFlag.IS_SSA.class)};
        this.state = SetsKt.mutableSetOf((Object[])objectArray);
        this.basicBlockOrder = new ArrayList();
    }

    @NotNull
    public final Set<KClass<? extends StateFlag>> getState() {
        return this.state;
    }

    public final void set(@NotNull Collection<? extends KClass<? extends StateFlag>> flags) {
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        this.state.addAll(flags);
    }

    public final void clear(@NotNull Collection<? extends KClass<? extends StateFlag>> flags) {
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        this.state.removeAll(flags);
    }

    public final void check(@NotNull Collection<? extends KClass<? extends StateFlag>> flags) {
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        boolean bl = this.state.containsAll(flags);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    public final void checkNot(@NotNull Collection<? extends KClass<? extends StateFlag>> flags) {
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        boolean bl = Collections.disjoint((Collection)this.state, flags);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    public final List<L2BasicBlock> getBasicBlockOrder() {
        return this.basicBlockOrder;
    }

    public final void startBlock(@NotNull L2BasicBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        boolean bl = block.instructions().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl2 = bl = !this.basicBlockOrder.contains(block);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        if (block.isIrremovable() || !((Collection)block.predecessorEdges()).isEmpty()) {
            this.basicBlockOrder.add(block);
        }
    }

    @NotNull
    public final List<L2Register> allRegisters() {
        Set allRegisters = new LinkedHashSet();
        for (L2BasicBlock block : this.basicBlockOrder) {
            for (L2Instruction instruction2 : block.instructions()) {
                allRegisters.addAll((Collection)instruction2.getDestinationRegisters());
            }
        }
        return CollectionsKt.toMutableList((Collection)allRegisters);
    }

    public final void evacuateTo(@NotNull L2ControlFlowGraph destinationControlFlowGraph) {
        Intrinsics.checkNotNullParameter((Object)destinationControlFlowGraph, (String)"destinationControlFlowGraph");
        boolean bl = destinationControlFlowGraph.basicBlockOrder.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        destinationControlFlowGraph.basicBlockOrder.addAll((Collection<L2BasicBlock>)this.basicBlockOrder);
        this.basicBlockOrder.clear();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (L2BasicBlock block : this.basicBlockOrder) {
            $this$toString_u24lambda_u241.append(block.name());
            $this$toString_u24lambda_u241.append(":\n");
            Iterable $this$forEach$iv = block.predecessorEdges();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                L2PcOperand edge2 = (L2PcOperand)element$iv;
                boolean bl2 = false;
                $this$toString_u24lambda_u241.append("\t\tFrom: ");
                L2PcOperand l2PcOperand = edge2;
                Intrinsics.checkNotNull((Object)l2PcOperand);
                $this$toString_u24lambda_u241.append(l2PcOperand.sourceBlock().name());
                $this$toString_u24lambda_u241.append("\n\t\t\t[");
                $this$toString_u24lambda_u241.append("always live-in: ");
                $this$toString_u24lambda_u241.append(edge2.getAlwaysLiveInRegisters());
                $this$toString_u24lambda_u241.append(", sometimes live-in: ");
                $this$toString_u24lambda_u241.append(edge2.getSometimesLiveInRegisters());
                $this$toString_u24lambda_u241.append("]\n");
            }
            for (L2Instruction instruction2 : block.instructions()) {
                $this$toString_u24lambda_u241.append("\t");
                $this$toString_u24lambda_u241.append(Strings.INSTANCE.increaseIndentation(instruction2.toString(), 1));
                $this$toString_u24lambda_u241.append("\n");
            }
            $this$toString_u24lambda_u241.append("\n");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public final void generateOn(@NotNull List<L2Instruction> instructions2) {
        Intrinsics.checkNotNullParameter(instructions2, (String)"instructions");
        for (L2BasicBlock block : this.basicBlockOrder) {
            block.generateOn(instructions2);
        }
    }

    @NotNull
    public final String visualize() {
        StringBuilder builder = new StringBuilder();
        boolean bl = false;
        new L2ControlFlowGraphVisualizer("\u00abcontrol flow graph\u00bb", "\u00abchunk\u00bb", 80, this, true, true, true, builder).visualize();
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"let(...)");
        return string2;
    }

    @NotNull
    public final String simplyVisualize() {
        StringBuilder builder = new StringBuilder();
        boolean bl = false;
        new L2ControlFlowGraphVisualizer("\u00abSIMPLE control flow graph\u00bb", "\u00abchunk\u00bb", 80, this, false, false, false, builder).visualize();
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"let(...)");
        return string2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lavail/optimizer/L2ControlFlowGraph$StateFlag;", "", "()V", "HAS_ELIMINATED_PHIS", "IS_EDGE_SPLIT", "IS_SSA", "avail"})
    public static abstract class StateFlag {

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lavail/optimizer/L2ControlFlowGraph$StateFlag$HAS_ELIMINATED_PHIS;", "Lavail/optimizer/L2ControlFlowGraph$StateFlag;", "()V", "avail"})
        public static final class HAS_ELIMINATED_PHIS
        extends StateFlag {
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lavail/optimizer/L2ControlFlowGraph$StateFlag$IS_EDGE_SPLIT;", "Lavail/optimizer/L2ControlFlowGraph$StateFlag;", "()V", "avail"})
        public static final class IS_EDGE_SPLIT
        extends StateFlag {
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lavail/optimizer/L2ControlFlowGraph$StateFlag$IS_SSA;", "Lavail/optimizer/L2ControlFlowGraph$StateFlag;", "()V", "avail"})
        public static final class IS_SSA
        extends StateFlag {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lavail/optimizer/L2ControlFlowGraph$Zone;", "", "zoneType", "Lavail/optimizer/L2ControlFlowGraph$ZoneType;", "zoneName", "", "(Lavail/optimizer/L2ControlFlowGraph$ZoneType;Ljava/lang/String;)V", "getZoneName", "()Ljava/lang/String;", "getZoneType", "()Lavail/optimizer/L2ControlFlowGraph$ZoneType;", "avail"})
    public static final class Zone {
        @NotNull
        private final ZoneType zoneType;
        @NotNull
        private final String zoneName;

        public Zone(@NotNull ZoneType zoneType, @NotNull String zoneName) {
            Intrinsics.checkNotNullParameter((Object)((Object)zoneType), (String)"zoneType");
            Intrinsics.checkNotNullParameter((Object)zoneName, (String)"zoneName");
            this.zoneType = zoneType;
            this.zoneName = zoneName;
        }

        @NotNull
        public final ZoneType getZoneType() {
            return this.zoneType;
        }

        @NotNull
        public final String getZoneName() {
            return this.zoneName;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lavail/optimizer/L2ControlFlowGraph$ZoneType;", "", "color", "", "bgcolor", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getBgcolor", "()Ljava/lang/String;", "getColor", "createZone", "Lavail/optimizer/L2ControlFlowGraph$Zone;", "zoneName", "BEGIN_REIFICATION_FOR_INTERRUPT", "BEGIN_REIFICATION_FOR_LABEL", "PROPAGATE_REIFICATION_FOR_INVOKE", "avail"})
    public static final class ZoneType
    extends Enum<ZoneType> {
        @NotNull
        private final String color;
        @NotNull
        private final String bgcolor;
        public static final /* enum */ ZoneType BEGIN_REIFICATION_FOR_INTERRUPT = new ZoneType("#c0c0ff/505090", "#d8d8ff/282850");
        public static final /* enum */ ZoneType BEGIN_REIFICATION_FOR_LABEL = new ZoneType("#e0d090/604010", "#ffe0b0/302010");
        public static final /* enum */ ZoneType PROPAGATE_REIFICATION_FOR_INVOKE = new ZoneType("#c0e0c0/10a010", "#e0ffe0/103010");
        private static final /* synthetic */ ZoneType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ZoneType(String color, String bgcolor) {
            this.color = color;
            this.bgcolor = bgcolor;
        }

        @NotNull
        public final String getColor() {
            return this.color;
        }

        @NotNull
        public final String getBgcolor() {
            return this.bgcolor;
        }

        @NotNull
        public final Zone createZone(@NotNull String zoneName) {
            Intrinsics.checkNotNullParameter((Object)zoneName, (String)"zoneName");
            return new Zone(this, zoneName);
        }

        public static ZoneType[] values() {
            return (ZoneType[])$VALUES.clone();
        }

        public static ZoneType valueOf(String value) {
            return Enum.valueOf(ZoneType.class, value);
        }

        @NotNull
        public static EnumEntries<ZoneType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = zoneTypeArray = new ZoneType[]{ZoneType.BEGIN_REIFICATION_FOR_INTERRUPT, ZoneType.BEGIN_REIFICATION_FOR_LABEL, ZoneType.PROPAGATE_REIFICATION_FOR_INVOKE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

