/*
 * Decompiled with CFR 0.152.
 */
package avail.tools.options;

import avail.tools.options.DefaultOption;
import avail.tools.options.InvalidArgumentException;
import avail.tools.options.MissingArgumentException;
import avail.tools.options.Option;
import avail.tools.options.OptionProcessingException;
import avail.tools.options.OptionProcessorFactory;
import avail.tools.options.UnrecognizedKeywordException;
import avail.utility.ParagraphFormatter;
import avail.utility.ParagraphFormatterStream;
import avail.utility.structures.EnumMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 0*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u00010Bb\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\n\u0012#\u0010\f\u001a\u001f\u0012\u001b\u0012\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\b\u000f0\n\u00a2\u0006\u0002\u0010\u0010J\u001b\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u001c\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\bH\u0002J\u0019\u0010\"\u001a\u00020\u000e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0$\u00a2\u0006\u0002\u0010%J\u001e\u0010&\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0(H\u0002J\u001e\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0(H\u0002J\u0013\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010+J\u0012\u0010,\u001a\u00020\u000e2\n\u0010-\u001a\u00060.j\u0002`/R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\f\u001a\u001f\u0012\u001b\u0012\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\b\u000f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00170\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lavail/tools/options/OptionProcessor;", "OptionKeyType", "", "", "optionKeyType", "Ljava/lang/Class;", "keywords", "", "", "options", "", "Lavail/tools/options/Option;", "rules", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Class;Ljava/util/Map;Ljava/util/Collection;Ljava/util/Collection;)V", "allKeywords", "allOptions", "Lavail/utility/structures/EnumMap;", "getRules", "()Ljava/util/Collection;", "timesEncountered", "Ljava/util/concurrent/atomic/AtomicInteger;", "checkEncountered", "key", "timesAllowed", "", "(Ljava/lang/Enum;I)V", "performDefaultAction", "argument", "performKeywordAction", "keyword", "processLongKeyword", "processOptions", "strings", "", "([Ljava/lang/String;)V", "processShortKeywords", "argumentIterator", "", "processString", "string", "(Ljava/lang/Enum;)I", "writeOptionDescriptions", "appendable", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "Companion", "avail"})
@SourceDebugExtension(value={"SMAP\nOptionProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptionProcessor.kt\navail/tools/options/OptionProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionExtensions.kt\navail/utility/CollectionExtensionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,446:1\n1222#2,4:447\n1855#2,2:458\n1855#2,2:460\n1855#2:462\n1855#2,2:463\n1856#2:465\n59#3,2:451\n61#3:455\n13309#4,2:453\n32#5,2:456\n*S KotlinDebug\n*F\n+ 1 OptionProcessor.kt\navail/tools/options/OptionProcessor\n*L\n115#1:447,4\n332#1:458,2\n349#1:460,2\n411#1:462\n421#1:463,2\n411#1:465\n119#1:451,2\n119#1:455\n119#1:453,2\n321#1:456,2\n*E\n"})
public final class OptionProcessor<OptionKeyType extends Enum<OptionKeyType>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<Function1<OptionProcessor<OptionKeyType>, Unit>> rules;
    @NotNull
    private final Map<String, OptionKeyType> allKeywords;
    @NotNull
    private final EnumMap<OptionKeyType, Option<OptionKeyType>> allOptions;
    @NotNull
    private final EnumMap<OptionKeyType, AtomicInteger> timesEncountered;
    private static final ThreadLocal<Boolean> continueProcessingKeywords = ThreadLocal.withInitial(OptionProcessor::continueProcessingKeywords$lambda$10);

    /*
     * WARNING - void declaration
     */
    public OptionProcessor(@NotNull Class<OptionKeyType> optionKeyType, @NotNull Map<String, ? extends OptionKeyType> keywords, @NotNull Collection<? extends Option<OptionKeyType>> options, @NotNull Collection<? extends Function1<? super OptionProcessor<OptionKeyType>, Unit>> rules) {
        void $this$toEnumMap$iv;
        EnumMap enumMap;
        void destination$iv;
        Enum[] $this$associateByTo$iv;
        Intrinsics.checkNotNullParameter(optionKeyType, (String)"optionKeyType");
        Intrinsics.checkNotNullParameter(keywords, (String)"keywords");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        this.rules = rules;
        this.allKeywords = MapsKt.toMap(keywords);
        Iterable iterable = options;
        OptionKeyType[] OptionKeyTypeArray = optionKeyType.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(OptionKeyTypeArray, (String)"getEnumConstants(...)");
        Map map = new EnumMap((Enum[])OptionKeyTypeArray);
        OptionProcessor optionProcessor = this;
        boolean $i$f$associateByTo = false;
        for (Object t : $this$associateByTo$iv) {
            void it;
            Option option = (Option)t;
            enumMap = destination$iv;
            boolean bl = false;
            enumMap.put(it.getKey(), t);
        }
        optionProcessor.allOptions = (EnumMap)destination$iv;
        OptionKeyType[] OptionKeyTypeArray2 = optionKeyType.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(OptionKeyTypeArray2, (String)"getEnumConstants(...)");
        $this$associateByTo$iv = (Enum[])OptionKeyTypeArray2;
        optionProcessor = this;
        boolean $i$f$toEnumMap = false;
        EnumMap map$iv = new EnumMap((Enum[])$this$toEnumMap$iv);
        void $this$forEach$iv$iv = $this$toEnumMap$iv;
        boolean bl = false;
        int n = ((void)$this$forEach$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void key$iv = element$iv$iv = $this$forEach$iv$iv[j];
            boolean bl2 = false;
            void var15_21 = key$iv;
            void var19_23 = key$iv;
            enumMap = map$iv;
            boolean bl22 = false;
            AtomicInteger atomicInteger = new AtomicInteger(0);
            enumMap.set(var19_23, atomicInteger);
        }
        optionProcessor.timesEncountered = map$iv;
    }

    @NotNull
    public final Collection<Function1<OptionProcessor<OptionKeyType>, Unit>> getRules() {
        return this.rules;
    }

    private final void performKeywordAction(String keyword, String argument) throws OptionProcessingException {
        Enum enum_ = (Enum)this.allKeywords.get(keyword);
        if (enum_ == null) {
            throw new UnrecognizedKeywordException(keyword);
        }
        Enum optionKey = enum_;
        Option<OptionKeyType> option = this.allOptions.get(optionKey);
        Intrinsics.checkNotNull(option);
        Option<OptionKeyType> option2 = option;
        AtomicInteger atomicInteger = this.timesEncountered.get(optionKey);
        Intrinsics.checkNotNull((Object)atomicInteger);
        atomicInteger.getAndIncrement();
        this.checkEncountered(optionKey, option2.getCardinality().getMax());
        if (option2.getTakesArgument()) {
            if (argument == null) {
                throw new MissingArgumentException(keyword);
            }
            OptionProcessorFactory.OptionInvocationWithArgument $this$performKeywordAction_u24lambda_u242 = new OptionProcessorFactory.OptionInvocationWithArgument(this, keyword, argument);
            boolean bl = false;
            Function1<OptionProcessorFactory.OptionInvocationWithArgument<OptionKeyType>, Unit> function1 = option2.getAction2();
            Intrinsics.checkNotNull(function1);
            function1.invoke($this$performKeywordAction_u24lambda_u242);
        } else {
            if (argument != null) {
                throw new InvalidArgumentException(keyword);
            }
            OptionProcessorFactory.OptionInvocation $this$performKeywordAction_u24lambda_u243 = new OptionProcessorFactory.OptionInvocation(this, keyword);
            boolean bl = false;
            Function1<OptionProcessorFactory.OptionInvocation<OptionKeyType>, Unit> function1 = option2.getAction();
            Intrinsics.checkNotNull(function1);
            function1.invoke($this$performKeywordAction_u24lambda_u243);
        }
    }

    static /* synthetic */ void performKeywordAction$default(OptionProcessor optionProcessor, String string2, String string3, int n, Object object) throws OptionProcessingException {
        if ((n & 2) != 0) {
            string3 = null;
        }
        optionProcessor.performKeywordAction(string2, string3);
    }

    private final void processLongKeyword(String keyword) throws OptionProcessingException {
        if (((CharSequence)keyword).length() == 0) {
            continueProcessingKeywords.set(false);
        } else {
            int index2 = StringsKt.indexOf$default((CharSequence)keyword, (char)'=', (int)0, (boolean)false, (int)6, null);
            if (index2 == -1) {
                this.performKeywordAction(keyword, null);
            } else {
                String string2 = keyword.substring(0, index2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String string3 = keyword.substring(index2 + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                this.performKeywordAction(string2, string3);
            }
        }
    }

    private final void processShortKeywords(String keywords, Iterator<String> argumentIterator) throws OptionProcessingException {
        int i2 = 0;
        int n = keywords.length() - 2;
        if (i2 <= n) {
            while (true) {
                Option<OptionKeyType> option;
                Enum optionKey;
                String keyword;
                Intrinsics.checkNotNullExpressionValue((Object)keywords.substring(i2, i2 + 1), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                if ((Enum)this.allKeywords.get(keyword) == null) {
                    throw new UnrecognizedKeywordException(keyword);
                }
                Intrinsics.checkNotNull(this.allOptions.get(optionKey));
                if (option.getTakesArgument()) {
                    throw new OptionProcessingException("\"" + keyword + "\" requires an argument, so it may only be at the end of a grouped option set (e.g, the z in '-xyz').  Perhaps two dashes were intended.");
                }
                OptionProcessor.performKeywordAction$default(this, keyword, null, 2, null);
                if (i2 == n) break;
                ++i2;
            }
        }
        String keyword = StringsKt.takeLast((String)keywords, (int)1);
        Enum enum_ = (Enum)this.allKeywords.get(keyword);
        if (enum_ == null) {
            throw new UnrecognizedKeywordException(keyword);
        }
        Enum optionKey = enum_;
        Option<OptionKeyType> option = this.allOptions.get(optionKey);
        Intrinsics.checkNotNull(option);
        Option<OptionKeyType> option2 = option;
        String argument = null;
        if (option2.getTakesArgument()) {
            if (!argumentIterator.hasNext()) {
                throw new MissingArgumentException(keyword);
            }
            argument = argumentIterator.next();
            if (Intrinsics.areEqual((Object)StringsKt.take((String)argument, (int)1), (Object)"-")) {
                throw new MissingArgumentException(keyword);
            }
        }
        this.performKeywordAction(keyword, argument);
    }

    private final void performDefaultAction(String argument) throws OptionProcessingException {
        this.performKeywordAction("", argument);
    }

    private final void processString(String string2, Iterator<String> argumentIterator) throws OptionProcessingException {
        if (!Intrinsics.areEqual((Object)StringsKt.take((String)string2, (int)1), (Object)"-")) {
            this.performDefaultAction(string2);
        } else {
            if (Intrinsics.areEqual((Object)string2, (Object)"-")) {
                throw new OptionProcessingException("option syntax error -- bare hyphen encountered");
            }
            if (Intrinsics.areEqual((Object)StringsKt.take((String)string2, (int)2), (Object)"--")) {
                String string3 = string2.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                this.processLongKeyword(string3);
            } else {
                String string4 = string2.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                this.processShortKeywords(string4, argumentIterator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processOptions(@NotNull String[] strings2) throws OptionProcessingException {
        Intrinsics.checkNotNullParameter((Object)strings2, (String)"strings");
        try {
            Object it;
            Object element$iv;
            Iterator<String> iterator2 = ArrayIteratorKt.iterator((Object[])strings2);
            Object $this$forEach$iv = iterator2;
            boolean $i$f$forEach = false;
            Iterator<String> iterator3 = $this$forEach$iv;
            while (iterator3.hasNext()) {
                element$iv = iterator3.next();
                it = (String)element$iv;
                boolean bl = false;
                Boolean bl2 = continueProcessingKeywords.get();
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"get(...)");
                if (bl2.booleanValue()) {
                    this.processString((String)it, iterator2);
                    continue;
                }
                this.performDefaultAction((String)it);
            }
            $this$forEach$iv = this.allOptions.values();
            $i$f$forEach = false;
            iterator3 = $this$forEach$iv.iterator();
            while (iterator3.hasNext()) {
                element$iv = iterator3.next();
                it = (Option)element$iv;
                boolean bl = false;
                int actual = this.timesEncountered(it.getKey());
                OptionProcessorFactory.Cardinality $this$processOptions_u24lambda_u246_u24lambda_u245 = it.getCardinality();
                boolean bl3 = false;
                if (actual >= $this$processOptions_u24lambda_u246_u24lambda_u245.getMin()) continue;
                String atLeast = $this$processOptions_u24lambda_u246_u24lambda_u245.getMin() == $this$processOptions_u24lambda_u246_u24lambda_u245.getMax() ? "exactly" : "at least ";
                String actualTimes = actual == 1 ? "time" : "times";
                String minTimes = $this$processOptions_u24lambda_u246_u24lambda_u245.getMin() == 1 ? "time" : "times";
                throw new OptionProcessingException(it.getKey() + ": encountered only " + actual + " " + actualTimes + ", but must occur " + atLeast + " " + $this$processOptions_u24lambda_u246_u24lambda_u245.getMin() + " " + minTimes);
            }
            $this$forEach$iv = this.rules;
            $i$f$forEach = false;
            iterator3 = $this$forEach$iv.iterator();
            while (iterator3.hasNext()) {
                element$iv = iterator3.next();
                it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)this);
            }
        }
        finally {
            continueProcessingKeywords.remove();
        }
    }

    public final int timesEncountered(@NotNull OptionKeyType key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        AtomicInteger atomicInteger = this.timesEncountered.get((Object)key);
        Intrinsics.checkNotNull((Object)atomicInteger);
        return atomicInteger.get();
    }

    public final void checkEncountered(@NotNull OptionKeyType key, int timesAllowed) throws OptionProcessingException {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int timesActuallyEncountered = this.timesEncountered(key);
        if (this.timesEncountered(key) > timesAllowed) {
            String string2 = "%s: encountered %d time(s), but allowed only %d time(s)";
            Object[] objectArray = new Object[]{key, timesActuallyEncountered + 1, timesAllowed + 1};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            throw new OptionProcessingException(string3);
        }
    }

    public final void writeOptionDescriptions(@NotNull Appendable appendable) throws IOException {
        Intrinsics.checkNotNullParameter((Object)appendable, (String)"appendable");
        Iterable $this$forEach$iv = this.allOptions.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Option option = (Option)element$iv;
            boolean bl = false;
            ParagraphFormatter keywordFormatter = new ParagraphFormatter(80, 0, 0, 0, 0, 30, null);
            ParagraphFormatterStream keywordStream = new ParagraphFormatterStream(keywordFormatter, appendable);
            ParagraphFormatter descriptionFormatter = new ParagraphFormatter(80, 4, 4, 0, 0, 24, null);
            ParagraphFormatterStream descriptionStream = new ParagraphFormatterStream(descriptionFormatter, appendable);
            Set keywords = CollectionsKt.toSet((Iterable)option.getKeywords());
            Iterable $this$forEach$iv2 = keywords;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String keyword = (String)element$iv2;
                boolean bl2 = false;
                if (option instanceof DefaultOption) {
                    keywordStream.append("<bareword>\n");
                    continue;
                }
                String string2 = "%s%s%n";
                Object[] objectArray = new Object[]{keyword.length() == 1 ? "-" : "--", keyword};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                keywordStream.append(string3);
            }
            String string4 = "%s%n%n";
            Object[] objectArray = new Object[]{option.getDescription()};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
            descriptionStream.append(string5);
        }
    }

    private static final Boolean continueProcessingKeywords$lambda$10() {
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lavail/tools/options/OptionProcessor$Companion;", "", "()V", "continueProcessingKeywords", "Ljava/lang/ThreadLocal;", "", "kotlin.jvm.PlatformType", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

