/*
 * Decompiled with CFR 0.152.
 */
package avail.builder;

import avail.annotations.ThreadSafe;
import avail.builder.ModuleName;
import avail.builder.ModuleRoot;
import avail.builder.ModuleRoots;
import avail.builder.ResolvedModuleName;
import avail.builder.UnreachableRootException;
import avail.builder.UnresolvedDependencyException;
import avail.builder.UnresolvedModuleException;
import avail.builder.UnresolvedRootException;
import avail.persistence.cache.Repositories;
import avail.resolver.ModuleRootResolver;
import avail.resolver.ResolverReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.cache.LRUCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 (2\u00020\u0001:\u0002()B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u0006\u0010\u001d\u001a\u00020\u0018J\u0006\u0010\u001e\u001a\u00020\u0018J\u0006\u0010\u001f\u001a\u00020\u0018J\u0006\u0010 \u001a\u00020\u0018J\u0015\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u001a\u0010%\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u00152\n\b\u0002\u0010'\u001a\u0004\u0018\u00010&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR-\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\r0\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lavail/builder/ModuleNameResolver;", "", "moduleRoots", "Lavail/builder/ModuleRoots;", "(Lavail/builder/ModuleRoots;)V", "getModuleRoots", "()Lavail/builder/ModuleRoots;", "renameRules", "", "", "getRenameRules", "()Ljava/util/Map;", "renameRulesInverted", "", "getRenameRulesInverted", "renameRulesInverted$delegate", "Lkotlin/Lazy;", "renames", "", "resolutionCache", "Lorg/availlang/cache/LRUCache;", "Lavail/builder/ModuleName;", "Lavail/builder/ModuleNameResolver$ModuleNameResolutionResult;", "addRenameRule", "", "modulePath", "substitutePath", "canonicalNameFor", "qualifiedName", "clearCache", "clearRenameRules", "commitRepositories", "destroy", "hasRenameRuleFor", "", "hasRenameRuleFor$avail", "privateResolve", "resolve", "Lavail/builder/ResolvedModuleName;", "dependent", "Companion", "ModuleNameResolutionResult", "avail"})
@ThreadSafe
public final class ModuleNameResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModuleRoots moduleRoots;
    @NotNull
    private final Map<String, String> renames;
    @NotNull
    private final LRUCache<ModuleName, ModuleNameResolutionResult> resolutionCache;
    @NotNull
    private final Lazy renameRulesInverted$delegate;
    @NotNull
    public static final String availExtension = ".avail";
    @NotNull
    public static final String availExtensionWithSlash = ".avail/";

    public ModuleNameResolver(@NotNull ModuleRoots moduleRoots) {
        Intrinsics.checkNotNullParameter(moduleRoots, "moduleRoots");
        this.moduleRoots = moduleRoots;
        this.renames = new LinkedHashMap();
        this.resolutionCache = new LRUCache(10000, 100, new Function1<ModuleName, ModuleNameResolutionResult>((Object)this){

            @NotNull
            public final ModuleNameResolutionResult invoke(@NotNull ModuleName p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ModuleNameResolver.access$privateResolve((ModuleNameResolver)this.receiver, p0);
            }
        }, null, 8, null);
        this.renameRulesInverted$delegate = LazyKt.lazy((Function0)new Function0<Map<String, ? extends List<? extends String>>>(this){
            final /* synthetic */ ModuleNameResolver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, List<String>> invoke() {
                void $this$groupByTo$iv$iv;
                Iterable $this$groupBy$iv = ModuleNameResolver.access$getRenames$p(this.this$0).entrySet();
                boolean $i$f$groupBy = false;
                Iterable iterable = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$groupByTo = false;
                for (T element$iv$iv : $this$groupByTo$iv$iv) {
                    void it;
                    Object object;
                    Map.Entry it2 = (Map.Entry)element$iv$iv;
                    boolean $i$a$-groupBy-ModuleNameResolver$renameRulesInverted$2$32 = false;
                    String key$iv$iv = (String)it2.getValue();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl = false;
                        List answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    Map.Entry $i$a$-groupBy-ModuleNameResolver$renameRulesInverted$2$32 = (Map.Entry)element$iv$iv;
                    List list2 = list$iv$iv;
                    boolean bl = false;
                    list2.add((String)it.getKey());
                }
                return destination$iv$iv;
            }
        });
    }

    @NotNull
    public final ModuleRoots getModuleRoots() {
        return this.moduleRoots;
    }

    @NotNull
    public final Map<String, String> getRenameRules() {
        Map<String, String> map = Collections.unmodifiableMap(this.renames);
        Intrinsics.checkNotNullExpressionValue(map, "unmodifiableMap(...)");
        return map;
    }

    @NotNull
    public final Map<String, List<String>> getRenameRulesInverted() {
        Lazy lazy = this.renameRulesInverted$delegate;
        return (Map)lazy.getValue();
    }

    public final boolean hasRenameRuleFor$avail(@NotNull String modulePath2) {
        Intrinsics.checkNotNullParameter(modulePath2, "modulePath");
        return this.renames.containsKey(modulePath2);
    }

    public final void clearRenameRules() {
        this.renames.clear();
    }

    public final void addRenameRule(@NotNull String modulePath2, @NotNull String substitutePath) {
        boolean bl;
        Intrinsics.checkNotNullParameter(modulePath2, "modulePath");
        Intrinsics.checkNotNullParameter(substitutePath, "substitutePath");
        boolean bl2 = bl = !this.renames.containsKey(modulePath2);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.renames.put(modulePath2, substitutePath);
    }

    private final ModuleName canonicalNameFor(ModuleName qualifiedName2) {
        String substitute = this.renames.get(qualifiedName2.getQualifiedName());
        return substitute != null ? new ModuleName(substitute, true) : qualifiedName2;
    }

    public final void clearCache() {
        this.resolutionCache.clear();
    }

    public final void destroy() {
        Repositories.INSTANCE.closeAndRemoveAllRepositories();
    }

    private final ModuleNameResolutionResult privateResolve(ModuleName qualifiedName2) {
        ModuleName canonicalName = this.canonicalNameFor(qualifiedName2);
        String enclosingRoot = canonicalName.getRootName();
        ModuleRoot moduleRoot = this.moduleRoots.moduleRootFor(enclosingRoot);
        if (moduleRoot == null) {
            return new ModuleNameResolutionResult(new UnresolvedRootException(null, qualifiedName2.getLocalName(), enclosingRoot));
        }
        ModuleRoot root = moduleRoot;
        ModuleRootResolver rootResolver = root.getResolver();
        if (!rootResolver.resolvesToValidModuleRoot()) {
            return new ModuleNameResolutionResult(new UnreachableRootException(null, qualifiedName2.getLocalName(), enclosingRoot, rootResolver));
        }
        ResolverReference reference = rootResolver.getResolverReference(canonicalName.getQualifiedName());
        if (reference == null) {
            ModuleNameResolutionResult result2 = rootResolver.find(qualifiedName2, canonicalName, this);
            if (result2 != null) {
                return result2;
            }
            for (ModuleRoot other : this.moduleRoots) {
                if (Intrinsics.areEqual(other.getName(), enclosingRoot)) continue;
                ModuleRootResolver resolver = other.getResolver();
                canonicalName = new ModuleName("/" + other.getName() + "/" + canonicalName.getLocalName(), canonicalName.isRename());
                ResolverReference resolverReference = resolver.getResolverReference(canonicalName.getQualifiedName());
                if (resolverReference == null) continue;
                reference = resolverReference;
                if (reference.isPackage()) {
                    canonicalName = new ModuleName("/" + other.getName() + "/" + canonicalName.getLocalName() + "/" + canonicalName.getLocalName(), canonicalName.isRename());
                    ResolverReference resolverReference2 = resolver.getResolverReference(canonicalName.getQualifiedName());
                    if (resolverReference2 == null) {
                        return new ModuleNameResolutionResult(new UnresolvedModuleException(null, qualifiedName2.getLocalName(), rootResolver));
                    }
                    reference = resolverReference2;
                }
                return new ModuleNameResolutionResult(new ResolvedModuleName(canonicalName, this.moduleRoots, reference, canonicalName.isRename()));
            }
            return new ModuleNameResolutionResult(new UnresolvedModuleException(null, qualifiedName2.getLocalName(), rootResolver));
        }
        if (reference.isPackage() && (reference = rootResolver.getResolverReference((canonicalName = new ModuleName(qualifiedName2.getQualifiedName(), canonicalName.getLocalName(), canonicalName.isRename())).getQualifiedName())) == null) {
            return new ModuleNameResolutionResult(new UnresolvedModuleException(null, qualifiedName2.getLocalName(), rootResolver));
        }
        return new ModuleNameResolutionResult(new ResolvedModuleName(canonicalName, this.moduleRoots, reference, canonicalName.isRename()));
    }

    @NotNull
    public final ResolvedModuleName resolve(@NotNull ModuleName qualifiedName2, @Nullable ResolvedModuleName dependent) throws UnresolvedDependencyException {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        ModuleNameResolutionResult result2 = this.resolutionCache.get(qualifiedName2);
        if (!result2.isResolved()) {
            result2 = this.privateResolve(qualifiedName2);
        }
        if (!result2.isResolved()) {
            if (dependent != null) {
                UnresolvedDependencyException unresolvedDependencyException = result2.getException$avail();
                Intrinsics.checkNotNull(unresolvedDependencyException);
                unresolvedDependencyException.setReferringModuleName(dependent);
            }
            UnresolvedDependencyException unresolvedDependencyException = result2.getException$avail();
            Intrinsics.checkNotNull(unresolvedDependencyException);
            throw unresolvedDependencyException;
        }
        ResolvedModuleName resolvedModuleName = result2.getResolvedModule$avail();
        Intrinsics.checkNotNull(resolvedModuleName);
        return resolvedModuleName;
    }

    public static /* synthetic */ ResolvedModuleName resolve$default(ModuleNameResolver moduleNameResolver, ModuleName moduleName2, ResolvedModuleName resolvedModuleName, int n, Object object) throws UnresolvedDependencyException {
        if ((n & 2) != 0) {
            resolvedModuleName = null;
        }
        return moduleNameResolver.resolve(moduleName2, resolvedModuleName);
    }

    public final void commitRepositories() {
        for (ModuleRoot root : this.moduleRoots) {
            root.getRepository().commit();
        }
    }

    public static final /* synthetic */ ModuleNameResolutionResult access$privateResolve(ModuleNameResolver $this, ModuleName qualifiedName2) {
        return $this.privateResolve(qualifiedName2);
    }

    public static final /* synthetic */ Map access$getRenames$p(ModuleNameResolver $this) {
        return $this.renames;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lavail/builder/ModuleNameResolver$Companion;", "", "()V", "availExtension", "", "availExtensionWithSlash", "filenameFor", "packageName", "localName", "filenameFor$avail", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String filenameFor$avail(@NotNull String packageName, @NotNull String localName2) {
            Intrinsics.checkNotNullParameter(packageName, "packageName");
            Intrinsics.checkNotNullParameter(localName2, "localName");
            return packageName + "/" + localName2 + ModuleNameResolver.availExtension;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lavail/builder/ModuleNameResolver$ModuleNameResolutionResult;", "", "resolvedModule", "Lavail/builder/ResolvedModuleName;", "(Lavail/builder/ResolvedModuleName;)V", "e", "Lavail/builder/UnresolvedDependencyException;", "(Lavail/builder/UnresolvedDependencyException;)V", "exception", "getException$avail", "()Lavail/builder/UnresolvedDependencyException;", "isResolved", "", "()Z", "getResolvedModule$avail", "()Lavail/builder/ResolvedModuleName;", "avail"})
    public static final class ModuleNameResolutionResult {
        @Nullable
        private final ResolvedModuleName resolvedModule;
        @Nullable
        private final UnresolvedDependencyException exception;

        @Nullable
        public final ResolvedModuleName getResolvedModule$avail() {
            return this.resolvedModule;
        }

        @Nullable
        public final UnresolvedDependencyException getException$avail() {
            return this.exception;
        }

        public final boolean isResolved() {
            return this.resolvedModule != null;
        }

        public ModuleNameResolutionResult(@NotNull ResolvedModuleName resolvedModule) {
            Intrinsics.checkNotNullParameter(resolvedModule, "resolvedModule");
            this.resolvedModule = resolvedModule;
            this.exception = null;
        }

        public ModuleNameResolutionResult(@NotNull UnresolvedDependencyException e) {
            Intrinsics.checkNotNullParameter(e, "e");
            this.resolvedModule = null;
            this.exception = e;
        }
    }
}

