/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler;

import avail.compiler.AvailCompiler;
import avail.compiler.ParserState;
import avail.compiler.ParsingOperation;
import avail.compiler.ParsingOperationStatistics;
import avail.compiler.ParsingStepState;
import avail.compiler.problems.CompilerDiagnostics;
import avail.descriptor.bundles.A_BundleTree;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J%\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0010\u00a2\u0006\u0002\b\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lavail/compiler/IncreaseIndent;", "Lavail/compiler/ParsingOperation;", "Lavail/compiler/ParsingOperationStatistics;", "()V", "expandingStatisticInNanoseconds", "Lavail/performance/Statistic;", "getExpandingStatisticInNanoseconds", "()Lavail/performance/Statistic;", "parsingStatisticInNanoseconds", "getParsingStatisticInNanoseconds", "execute", "", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute$avail", "avail"})
public final class IncreaseIndent
extends ParsingOperation
implements ParsingOperationStatistics {
    @NotNull
    public static final IncreaseIndent INSTANCE = new IncreaseIndent();
    @NotNull
    private static final Statistic parsingStatisticInNanoseconds = new Statistic(StatisticReport.RUNNING_PARSING_INSTRUCTIONS, INSTANCE.getName());
    @NotNull
    private static final Statistic expandingStatisticInNanoseconds = new Statistic(StatisticReport.EXPANDING_PARSING_INSTRUCTIONS, INSTANCE.getName());

    private IncreaseIndent() {
        super(false, true, null);
    }

    @Override
    public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, @NotNull A_BundleTree successorTree) {
        Intrinsics.checkNotNullParameter(compiler2, "compiler");
        Intrinsics.checkNotNullParameter(stepState, "stepState");
        Intrinsics.checkNotNullParameter(successorTree, "successorTree");
        AvailCompiler.Companion.skipWhitespaceAndComments(stepState.getStart(), (Function1<? super List<ParserState>, Unit>)new Function1<List<? extends ParserState>, Unit>(stepState, compiler2, successorTree){
            final /* synthetic */ ParsingStepState $stepState;
            final /* synthetic */ AvailCompiler $compiler;
            final /* synthetic */ A_BundleTree $successorTree;
            {
                this.$stepState = $stepState;
                this.$compiler = $compiler;
                this.$successorTree = $successorTree;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull List<ParserState> successorStates) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(successorStates, "successorStates");
                Iterable iterable = successorStates;
                ParsingStepState parsingStepState = this.$stepState;
                AvailCompiler availCompiler = this.$compiler;
                A_BundleTree a_BundleTree = this.$successorTree;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ParserState parsingState = (ParserState)element$iv;
                    boolean bl = false;
                    ParsingStepState state2 = parsingStepState.copy((Function1<? super ParsingStepState, Unit>)new Function1<ParsingStepState, Unit>(parsingState){
                        final /* synthetic */ ParserState $parsingState;
                        {
                            this.$parsingState = $parsingState;
                            super(1);
                        }

                        public final void invoke(@NotNull ParsingStepState $this$copy) {
                            Intrinsics.checkNotNullParameter($this$copy, "$this$copy");
                            $this$copy.setStart(this.$parsingState);
                        }
                    });
                    A_String initialIndent = state2.initialIndentationString();
                    A_String currentIndent = ParsingStepState.currentIndentationString$default(state2, false, 1, null);
                    if (currentIndent == null) {
                        state2.getStart().expected$avail(CompilerDiagnostics.ParseNotificationLevel.STRONG, (Function1<? super Function1<? super String, Unit>, Unit>)new Function1<Function1<? super String, ? extends Unit>, Unit>(initialIndent){
                            final /* synthetic */ A_String $initialIndent;
                            {
                                this.$initialIndent = $initialIndent;
                                super(1);
                            }

                            public final void invoke(@NotNull Function1<? super String, Unit> accept) {
                                Intrinsics.checkNotNullParameter(accept, "accept");
                                accept.invoke("an indentation to exceed that at the beginning of the phrase (" + ParsingOperation.getQ(this.$initialIndent) + "), but this position is not after leading whitespace on the line");
                            }
                        });
                        continue;
                    }
                    if (A_Tuple.Companion.getTupleSize(currentIndent) > A_Tuple.Companion.getTupleSize(initialIndent) && A_Tuple.Companion.compareFromToWithStartingAt(currentIndent, 1, A_Tuple.Companion.getTupleSize(initialIndent), initialIndent, 1)) {
                        availCompiler.eventuallyParseRestOfSendNode$avail(a_BundleTree, state2);
                        continue;
                    }
                    if (initialIndent.equals(currentIndent)) {
                        state2.getStart().expected$avail(CompilerDiagnostics.ParseNotificationLevel.STRONG, (Function1<? super Function1<? super String, Unit>, Unit>)new Function1<Function1<? super String, ? extends Unit>, Unit>(currentIndent){
                            final /* synthetic */ A_String $currentIndent;
                            {
                                this.$currentIndent = $currentIndent;
                                super(1);
                            }

                            public final void invoke(@NotNull Function1<? super String, Unit> accept) {
                                Intrinsics.checkNotNullParameter(accept, "accept");
                                accept.invoke("the indentation at this position to be strictly deeper than at the beginning of the phrase, but they're equal (" + ParsingOperation.getQ(this.$currentIndent) + ").");
                            }
                        });
                        continue;
                    }
                    if (currentIndent.equals(initialIndent)) {
                        state2.getStart().expected$avail(CompilerDiagnostics.ParseNotificationLevel.STRONG, (Function1<? super Function1<? super String, Unit>, Unit>)new Function1<Function1<? super String, ? extends Unit>, Unit>(initialIndent, currentIndent){
                            final /* synthetic */ A_String $initialIndent;
                            final /* synthetic */ A_String $currentIndent;
                            {
                                this.$initialIndent = $initialIndent;
                                this.$currentIndent = $currentIndent;
                                super(1);
                            }

                            public final void invoke(@NotNull Function1<? super String, Unit> accept) {
                                Intrinsics.checkNotNullParameter(accept, "accept");
                                accept.invoke("the indentation at this position to be strictly deeper than at the beginning of the phrase. The initial indentation is " + ParsingOperation.getQ(this.$initialIndent) + ", but the current indentation is " + ParsingOperation.getQ(this.$currentIndent) + ".");
                            }
                        });
                        continue;
                    }
                    state2.getStart().expected$avail(CompilerDiagnostics.ParseNotificationLevel.STRONG, (Function1<? super Function1<? super String, Unit>, Unit>)new Function1<Function1<? super String, ? extends Unit>, Unit>(initialIndent, currentIndent){
                        final /* synthetic */ A_String $initialIndent;
                        final /* synthetic */ A_String $currentIndent;
                        {
                            this.$initialIndent = $initialIndent;
                            this.$currentIndent = $currentIndent;
                            super(1);
                        }

                        public final void invoke(@NotNull Function1<? super String, Unit> accept) {
                            Intrinsics.checkNotNullParameter(accept, "accept");
                            accept.invoke("the indentation to exceed that at the beginning of the phrase. The indentation at the beginning was " + ParsingOperation.getQ(this.$initialIndent) + ", but the current line begins with " + ParsingOperation.getQ(this.$currentIndent) + ".");
                        }
                    });
                }
            }
        });
    }

    @Override
    @NotNull
    public Statistic getParsingStatisticInNanoseconds() {
        return parsingStatisticInNanoseconds;
    }

    @Override
    @NotNull
    public Statistic getExpandingStatisticInNanoseconds() {
        return expandingStatisticInNanoseconds;
    }
}

