/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler.splitter;

import avail.AvailRuntimeConfiguration;
import avail.compiler.BranchForward;
import avail.compiler.EmptyList;
import avail.compiler.JumpBackward;
import avail.compiler.JumpForward;
import avail.compiler.JumpParsingOperation;
import avail.compiler.ParsePart;
import avail.compiler.ParsePartCaseInsensitively;
import avail.compiler.ParsingOperation;
import avail.compiler.Placeholder;
import avail.compiler.WrapInList;
import avail.compiler.splitter.Expression;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\nJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\nJ\u001e\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\nJ\u0016\u0010$\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010%\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010&\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u0010J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0(J\u0006\u0010)\u001a\u00020\u001bJ\b\u0010*\u001a\u00020\u001bH\u0002J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\n0(J\u0006\u0010,\u001a\u00020\u001bR\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006."}, d2={"Lavail/compiler/splitter/InstructionGenerator;", "", "()V", "<set-?>", "", "caseInsensitive", "getCaseInsensitive", "()Z", "delayedArgumentInstructions", "", "Lavail/compiler/ParsingOperation;", "delayedExpressionList", "Lavail/compiler/splitter/Expression;", "expressionList", "instructions", "partialListsCount", "", "getPartialListsCount", "()I", "setPartialListsCount", "(I)V", "beCaseInsensitiveWhile", "O", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "emit", "", "expression", "operation", "label", "Lavail/compiler/splitter/InstructionGenerator$Label;", "emitBranchForward", "emitDelayed", "emitIf", "condition", "emitJumpBackward", "emitJumpForward", "emitWrapped", "listSize", "", "flushDelayed", "hoistTokenParsing", "instructionList", "optimizeInstructions", "Label", "avail"})
@SourceDebugExtension(value={"SMAP\nInstructionGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstructionGenerator.kt\navail/compiler/splitter/InstructionGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,398:1\n1#2:399\n1549#3:400\n1620#3,3:401\n*S KotlinDebug\n*F\n+ 1 InstructionGenerator.kt\navail/compiler/splitter/InstructionGenerator\n*L\n382#1:400\n382#1:401,3\n*E\n"})
public final class InstructionGenerator {
    @NotNull
    private final List<ParsingOperation> instructions = new ArrayList();
    @NotNull
    private final List<Expression> expressionList = new ArrayList();
    @NotNull
    private final List<ParsingOperation> delayedArgumentInstructions = new ArrayList();
    @NotNull
    private final List<Expression> delayedExpressionList = new ArrayList();
    private boolean caseInsensitive;
    private int partialListsCount = 1;

    public final boolean getCaseInsensitive() {
        return this.caseInsensitive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <O> O beCaseInsensitiveWhile(@NotNull Function0<? extends O> action2) {
        O o;
        Intrinsics.checkNotNullParameter(action2, "action");
        boolean old = this.caseInsensitive;
        this.caseInsensitive = true;
        try {
            o = action2.invoke();
        }
        finally {
            this.caseInsensitive = old;
        }
        return o;
    }

    public final int getPartialListsCount() {
        return this.partialListsCount;
    }

    public final void setPartialListsCount(int n) {
        this.partialListsCount = n;
    }

    public final void emit(@NotNull Expression expression2, @NotNull ParsingOperation operation) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(operation, "operation");
        this.expressionList.add(expression2);
        this.instructions.add(operation);
    }

    public final void emitIf(boolean condition, @NotNull Expression expression2, @NotNull ParsingOperation operation) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(operation, "operation");
        if (condition) {
            this.emit(expression2, operation);
        }
    }

    public final void emit(@NotNull Label label) {
        boolean bl;
        Intrinsics.checkNotNullParameter(label, "label");
        boolean bl2 = bl = label.getPosition() == -1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Label was already emitted";
            throw new AssertionError((Object)string2);
        }
        label.setPosition(this.instructions.size() + 1);
        for (Pair<Integer, JumpParsingOperation<?>> pair : label.getOperationsToFix()) {
            boolean bl4;
            int index2 = ((Number)pair.component1()).intValue();
            JumpParsingOperation<?> jump = pair.component2();
            boolean bl5 = bl4 = this.instructions.get(index2 - 1) == Placeholder.INSTANCE;
            if (_Assertions.ENABLED && !bl4) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            if (AvailRuntimeConfiguration.INSTANCE.getDebugCompilerSteps() && index2 + 1 == label.getPosition()) {
                System.out.println((Object)"DEBUG: Operation target falls through.");
            }
            this.instructions.set(index2 - 1, (ParsingOperation)jump.newOperand(label.getPosition()));
        }
        label.getOperationsToFix().clear();
    }

    public final void emitJumpForward(@NotNull Expression expression2, @NotNull Label label) {
        boolean bl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(label, "label");
        boolean bl2 = bl = label.getPosition() == -1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Forward jumps must actually be forward";
            throw new AssertionError((Object)string2);
        }
        this.expressionList.add(expression2);
        label.getOperationsToFix().add(TuplesKt.to(this.instructions.size() + 1, new JumpForward(Integer.MIN_VALUE)));
        this.instructions.add(Placeholder.INSTANCE);
    }

    public final void emitJumpBackward(@NotNull Expression expression2, @NotNull Label label) {
        boolean bl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(label, "label");
        boolean bl2 = bl = label.getPosition() != -1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Backward jumps must actually be backward";
            throw new AssertionError((Object)string2);
        }
        this.expressionList.add(expression2);
        this.instructions.add(new JumpBackward(label.getPosition()));
    }

    public final void emitBranchForward(@NotNull Expression expression2, @NotNull Label label) {
        boolean bl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(label, "label");
        boolean bl2 = bl = label.getPosition() == -1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Branches must be forward";
            throw new AssertionError((Object)string2);
        }
        this.expressionList.add(expression2);
        label.getOperationsToFix().add(TuplesKt.to(this.instructions.size() + 1, new BranchForward(Integer.MIN_VALUE)));
        this.instructions.add(Placeholder.INSTANCE);
    }

    public final void emitDelayed(@NotNull Expression expression2, @NotNull ParsingOperation operation) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(operation, "operation");
        this.delayedExpressionList.add(expression2);
        this.delayedArgumentInstructions.add(operation);
    }

    public final void flushDelayed() {
        if (!((Collection)this.delayedArgumentInstructions).isEmpty()) {
            this.expressionList.addAll((Collection<Expression>)this.delayedExpressionList);
            this.instructions.addAll((Collection<ParsingOperation>)this.delayedArgumentInstructions);
            this.delayedExpressionList.clear();
            this.delayedArgumentInstructions.clear();
        }
    }

    public final void emitWrapped(@NotNull Expression expression2, int listSize) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        boolean bl = this.delayedArgumentInstructions.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl2 = bl = listSize >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        if (listSize == 0) {
            this.emit(expression2, EmptyList.INSTANCE);
        } else {
            this.emit(expression2, new WrapInList(listSize));
        }
    }

    public final void optimizeInstructions() {
        this.hoistTokenParsing();
    }

    private final void hoistTokenParsing() {
        ParsingOperation instruction2;
        int instructionsCount = this.instructions.size();
        BitSet branchTargets = new BitSet(instructionsCount);
        int n = this.instructions.size();
        for (int pc = 0; pc < n; ++pc) {
            ParsingOperation parsingOperation = this.instructions.get(pc);
            if ((parsingOperation instanceof JumpParsingOperation ? (JumpParsingOperation)parsingOperation : null) == null) continue;
            instruction2 = instruction2;
            int target = ((Number)instruction2.getOperand()).intValue() - 1;
            branchTargets.set(target);
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i2 = instructionsCount - 1; 0 < i2; --i2) {
                ParsingOperation priorInstruction;
                if (branchTargets.get(i2) || !((instruction2 = this.instructions.get(i2)) instanceof ParsePart) && !(instruction2 instanceof ParsePartCaseInsensitively) || !(priorInstruction = this.instructions.get(i2 - 1)).getCommutesWithParsePart()) continue;
                this.instructions.set(i2, priorInstruction);
                this.instructions.set(i2 - 1, instruction2);
                Expression temp = this.expressionList.get(i2);
                this.expressionList.set(i2, this.expressionList.get(i2 - 1));
                this.expressionList.set(i2 - 1, temp);
                changed = true;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ParsingOperation> instructionList() {
        void $this$mapTo$iv$iv;
        boolean bl;
        boolean bl2 = bl = !this.instructions.contains(Placeholder.INSTANCE);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-InstructionGenerator$instructionList$22 = false;
            String $i$a$-assert-InstructionGenerator$instructionList$22 = "A placeholder instruction using a label was not resolved";
            throw new AssertionError((Object)$i$a$-assert-InstructionGenerator$instructionList$22);
        }
        boolean bl3 = bl = this.instructions.size() == this.expressionList.size();
        if (_Assertions.ENABLED && !bl) {
            String $i$a$-assert-InstructionGenerator$instructionList$22 = "Assertion failed";
            throw new AssertionError((Object)$i$a$-assert-InstructionGenerator$instructionList$22);
        }
        bl = this.delayedExpressionList.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String $i$a$-assert-InstructionGenerator$instructionList$22 = "Assertion failed";
            throw new AssertionError((Object)$i$a$-assert-InstructionGenerator$instructionList$22);
        }
        Iterable $this$map$iv = this.instructions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ParsingOperation parsingOperation = (ParsingOperation)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl4 = false;
            collection2.add(p0.interned());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<Expression> expressionList() {
        boolean bl;
        boolean bl2 = bl = this.instructions.size() == this.expressionList.size();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        List<Expression> list2 = Collections.unmodifiableList(this.expressionList);
        Intrinsics.checkNotNullExpressionValue(list2, "unmodifiableList(...)");
        return list2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R'\u0010\u0006\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lavail/compiler/splitter/InstructionGenerator$Label;", "", "()V", "isUsed", "", "()Z", "operationsToFix", "", "Lkotlin/Pair;", "", "Lavail/compiler/JumpParsingOperation;", "getOperationsToFix", "()Ljava/util/List;", "position", "getPosition", "()I", "setPosition", "(I)V", "avail"})
    public static final class Label {
        private int position = -1;
        @NotNull
        private final List<Pair<Integer, JumpParsingOperation<?>>> operationsToFix = new ArrayList();

        public final int getPosition() {
            return this.position;
        }

        public final void setPosition(int n) {
            this.position = n;
        }

        @NotNull
        public final List<Pair<Integer, JumpParsingOperation<?>>> getOperationsToFix() {
            return this.operationsToFix;
        }

        public final boolean isUsed() {
            return this.position != -1 || !((Collection)this.operationsToFix).isEmpty();
        }
    }
}

