/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.character;

import avail.descriptor.character.A_Character;
import avail.descriptor.character.CharacterDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.BitField;
import avail.descriptor.representation.Descriptor;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.descriptor.types.TypeTag;
import avail.exceptions.MarshalingException;
import avail.serialization.SerializerOperation;
import java.lang.constant.Constable;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 (2\u00020\u0001:\u0002()B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0000H\u0016J\b\u0010\u0006\u001a\u00020\u0000H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J8\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\n\u0010 \u001a\u00060!j\u0002`\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020\bH\u0016J\b\u0010'\u001a\u00020\u0000H\u0016\u00a8\u0006*"}, d2={"Lavail/descriptor/character/CharacterDescriptor;", "Lavail/descriptor/representation/Descriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "(Lavail/descriptor/representation/Mutability;)V", "immutable", "mutable", "o_CodePoint", "", "self", "Lavail/descriptor/representation/AvailObject;", "o_Equals", "", "another", "Lavail/descriptor/representation/A_BasicObject;", "o_EqualsCharacterWithCodePoint", "aCodePoint", "o_Hash", "o_IsCharacter", "o_Kind", "Lavail/descriptor/types/A_Type;", "o_MarshalToJava", "", "classHint", "Ljava/lang/Class;", "o_SerializerOperation", "Lavail/serialization/SerializerOperation;", "o_WriteTo", "", "writer", "Lorg/availlang/json/JSONWriter;", "printObjectOnAvoidingIndent", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recursionMap", "Ljava/util/IdentityHashMap;", "Ljava/lang/Void;", "indent", "shared", "Companion", "IntegerSlots", "avail"})
@SourceDebugExtension(value={"SMAP\nCharacterDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharacterDescriptor.kt\navail/descriptor/character/CharacterDescriptor\n+ 2 AbstractDescriptor.kt\navail/descriptor/representation/AbstractDescriptor\n*L\n1#1,327:1\n624#2,7:328\n*S KotlinDebug\n*F\n+ 1 CharacterDescriptor.kt\navail/descriptor/character/CharacterDescriptor\n*L\n296#1:328,7\n*E\n"})
public final class CharacterDescriptor
extends Descriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final CharacterDescriptor mutable = new CharacterDescriptor(Mutability.MUTABLE);
    @NotNull
    private static final CharacterDescriptor immutable = new CharacterDescriptor(Mutability.IMMUTABLE);
    @NotNull
    private static final CharacterDescriptor shared = new CharacterDescriptor(Mutability.SHARED);
    @NotNull
    private static final AvailObject[] byteCharacters;
    @NotNull
    private static final int[] hashesOfByteCharacters;
    @GuardedBy(value="characterCacheLock")
    @NotNull
    private static final Map<Integer, A_Character> characterCache;
    @NotNull
    private static final ReentrantReadWriteLock characterCacheLock;
    public static final int maxCodePointInt = 0x10FFFF;
    @NotNull
    private static final A_Type digitsType;
    @NotNull
    private static final A_Type nonemptyStringOfDigitsType;

    private CharacterDescriptor(Mutability mutability) {
        super(mutability, TypeTag.CHARACTER_TAG, null, IntegerSlots.class);
    }

    @Override
    public void printObjectOnAvoidingIndent(@NotNull AvailObject self, @NotNull StringBuilder builder, @NotNull IdentityHashMap<A_BasicObject, Void> recursionMap, int indent) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(recursionMap, "recursionMap");
        StringBuilder $this$printObjectOnAvoidingIndent_u24lambda_u240 = builder;
        boolean bl = false;
        $this$printObjectOnAvoidingIndent_u24lambda_u240.append("\u00a2");
        int codePoint = self.get(IntegerSlots.Companion.getCODE_POINT());
        int escapeIndex = StringsKt.indexOf$default((CharSequence)"\n\r\t\\\"", (char)codePoint, 0, false, 6, null);
        if (escapeIndex != -1) {
            $this$printObjectOnAvoidingIndent_u24lambda_u240.append("\"\\");
            $this$printObjectOnAvoidingIndent_u24lambda_u240.append("nrt\\\"".charAt(escapeIndex));
            $this$printObjectOnAvoidingIndent_u24lambda_u240.append('\"');
        } else {
            switch (Character.getType(codePoint)) {
                case 0: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 19: {
                    String string2 = "\"\\(%x)\"";
                    Object[] objectArray = new Object[]{codePoint};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
                    $this$printObjectOnAvoidingIndent_u24lambda_u240.append(string3);
                    break;
                }
                default: {
                    $this$printObjectOnAvoidingIndent_u24lambda_u240.appendCodePoint(codePoint);
                }
            }
        }
    }

    @Override
    public int o_CodePoint(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.get(IntegerSlots.Companion.getCODE_POINT());
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(another, "another");
        return A_Character.Companion.equalsCharacterWithCodePoint((A_Character)another, self.get(IntegerSlots.Companion.getCODE_POINT()));
    }

    @Override
    public boolean o_EqualsCharacterWithCodePoint(@NotNull AvailObject self, int aCodePoint) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.get(IntegerSlots.Companion.getCODE_POINT()) == aCodePoint;
    }

    @Override
    public int o_Hash(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.get(IntegerSlots.Companion.getHASH());
    }

    @Override
    public boolean o_IsCharacter(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return true;
    }

    @Override
    @NotNull
    public A_Type o_Kind(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return PrimitiveTypeDescriptor.Types.CHARACTER.getO();
    }

    @Override
    @NotNull
    public Object o_MarshalToJava(@NotNull AvailObject self, @Nullable Class<?> classHint) {
        Constable constable;
        Intrinsics.checkNotNullParameter(self, "self");
        int codePoint = self.get(IntegerSlots.Companion.getCODE_POINT());
        Class<?> clazz = classHint;
        if (Intrinsics.areEqual(clazz, Integer.TYPE) ? true : Intrinsics.areEqual(clazz, Integer.TYPE)) {
            constable = codePoint;
        } else if (Intrinsics.areEqual(clazz, Character.TYPE) ? true : Intrinsics.areEqual(clazz, Character.TYPE)) {
            if (codePoint > 65535) {
                throw new MarshalingException();
            }
            constable = Character.valueOf((char)codePoint);
        } else {
            boolean bl;
            boolean bl2 = bl = classHint == null;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            constable = codePoint < 65536 ? (Comparable<Character>)Character.valueOf((char)codePoint) : (Comparable<Character>)Integer.valueOf(codePoint);
        }
        return constable;
    }

    @Override
    @NotNull
    public SerializerOperation o_SerializerOperation(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        int n = self.get(IntegerSlots.Companion.getCODE_POINT());
        return (0 <= n ? n < 256 : false) ? SerializerOperation.BYTE_CHARACTER : ((0 <= n ? n < 65536 : false) ? SerializerOperation.SHORT_CHARACTER : SerializerOperation.LARGE_CHARACTER);
    }

    @Override
    public void o_WriteTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(writer, "writer");
        writer.write(ObjectTupleDescriptor.Companion.tuple(self));
    }

    @Override
    @NotNull
    public CharacterDescriptor mutable() {
        return mutable;
    }

    @Override
    @NotNull
    public CharacterDescriptor immutable() {
        return immutable;
    }

    @Override
    @NotNull
    public CharacterDescriptor shared() {
        return shared;
    }

    public static final /* synthetic */ CharacterDescriptor access$getMutable$cp() {
        return mutable;
    }

    /*
     * WARNING - void declaration
     */
    static {
        int n = 0;
        Object[] objectArray = new AvailObject[256];
        while (n < 256) {
            void $this$byteCharacters_u24lambda_u241;
            int n2 = n++;
            AbstractDescriptor $this$iv = mutable;
            int indexedSlotCount$iv = 0;
            boolean $i$f$createShared = false;
            AvailObject $this$createShared_u24lambda_u245$iv = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, $this$iv);
            boolean bl = false;
            AvailObject availObject = $this$createShared_u24lambda_u245$iv;
            int n3 = n2;
            AvailObject[] availObjectArray = objectArray;
            boolean bl2 = false;
            $this$byteCharacters_u24lambda_u241.setSlot(IntegerSlots.Companion.getCODE_POINT(), n2);
            $this$byteCharacters_u24lambda_u241.setSlot(IntegerSlots.Companion.getHASH(), Companion.computeHashOfCharacterWithCodePoint(n2));
            Unit unit = Unit.INSTANCE;
            availObjectArray[n3] = $this$createShared_u24lambda_u245$iv.makeShared();
        }
        byteCharacters = objectArray;
        n = 0;
        objectArray = new int[256];
        Companion companion = Companion;
        while (n < 256) {
            int n4 = n++;
            objectArray[n4] = (AvailObject)companion.computeHashOfCharacterWithCodePoint(n4);
        }
        hashesOfByteCharacters = (int[])objectArray;
        characterCache = new LinkedHashMap();
        characterCacheLock = new ReentrantReadWriteLock();
        digitsType = AbstractEnumerationTypeDescriptor.Companion.enumerationWith(A_Tuple.Companion.getAsSet(StringDescriptor.Companion.stringFrom("0123456789"))).makeShared();
        nonemptyStringOfDigitsType = TupleTypeDescriptor.Companion.oneOrMoreOf(digitsType);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\n\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\tJ\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001cR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lavail/descriptor/character/CharacterDescriptor$Companion;", "", "()V", "byteCharacters", "", "Lavail/descriptor/representation/AvailObject;", "[Lavail/descriptor/representation/AvailObject;", "characterCache", "", "", "Lavail/descriptor/character/A_Character;", "characterCacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "digitsType", "Lavail/descriptor/types/A_Type;", "hashesOfByteCharacters", "", "immutable", "Lavail/descriptor/character/CharacterDescriptor;", "maxCodePointInt", "mutable", "nonemptyStringOfDigitsType", "getNonemptyStringOfDigitsType", "()Lavail/descriptor/types/A_Type;", "shared", "computeHashOfCharacterWithCodePoint", "codePoint", "fromByteCodePoint", "", "fromCodePoint", "hashOfByteCharacterWithCodePoint", "avail"})
    @SourceDebugExtension(value={"SMAP\nCharacterDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharacterDescriptor.kt\navail/descriptor/character/CharacterDescriptor$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Locks.kt\navail/utility/LocksKt\n*L\n1#1,327:1\n1#2:328\n55#3:329\n*S KotlinDebug\n*F\n+ 1 CharacterDescriptor.kt\navail/descriptor/character/CharacterDescriptor$Companion\n*L\n268#1:329\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int computeHashOfCharacterWithCodePoint(int codePoint) {
            return IntegerDescriptor.Companion.computeHashOfInt(codePoint ^ 0xD68E9947);
        }

        public final int hashOfByteCharacterWithCodePoint(short codePoint) {
            short s = codePoint;
            short s2 = 0 <= s ? (s < 256 ? (short)1 : 0) : (s = 0);
            if (_Assertions.ENABLED && s == 0) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return hashesOfByteCharacters[codePoint];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final A_Character fromCodePoint(int codePoint) {
            A_Character a_Character;
            boolean bl = 0 <= codePoint ? codePoint < 256 : false;
            if (bl) {
                return byteCharacters[codePoint];
            }
            ReentrantReadWriteLock.ReadLock readLock = characterCacheLock.readLock();
            readLock.lock();
            try {
                boolean bl2 = false;
                A_Character a_Character2 = (A_Character)characterCache.get(codePoint);
                if (a_Character2 != null) {
                    A_Character it = a_Character2;
                    boolean bl3 = false;
                    A_Character a_Character3 = it;
                    return a_Character3;
                }
                Object $i$a$-read-CharacterDescriptor$Companion$fromCodePoint$2 = null;
            }
            finally {
                readLock.unlock();
            }
            ReentrantReadWriteLock $this$safeWrite$iv = characterCacheLock;
            boolean $i$f$safeWrite = false;
            ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
            Intrinsics.checkNotNullExpressionValue(writeLock, "writeLock(...)");
            Lock lock = writeLock;
            lock.lock();
            try {
                boolean bl4 = false;
                A_Character a_Character4 = characterCache.computeIfAbsent(codePoint, arg_0 -> Companion.fromCodePoint$lambda$3$lambda$2(new Function1<Integer, A_Character>(codePoint){
                    final /* synthetic */ int $codePoint;
                    {
                        this.$codePoint = $codePoint;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final A_Character invoke(int cp) {
                        void $this$iv;
                        AbstractDescriptor abstractDescriptor = CharacterDescriptor.access$getMutable$cp();
                        int n = this.$codePoint;
                        int indexedSlotCount$iv = 0;
                        boolean $i$f$createShared = false;
                        AvailObject $this$createShared_u24lambda_u245$iv = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, (AbstractDescriptor)$this$iv);
                        boolean bl = false;
                        AvailObject $this$invoke_u24lambda_u240 = $this$createShared_u24lambda_u245$iv;
                        boolean bl2 = false;
                        $this$invoke_u24lambda_u240.setSlot(IntegerSlots.Companion.getCODE_POINT(), cp);
                        $this$invoke_u24lambda_u240.setSlot(IntegerSlots.Companion.getHASH(), CharacterDescriptor.Companion.computeHashOfCharacterWithCodePoint(n));
                        return $this$createShared_u24lambda_u245$iv.makeShared();
                    }
                }, arg_0));
                a_Character = a_Character4;
            }
            finally {
                lock.unlock();
            }
            Intrinsics.checkNotNullExpressionValue(a_Character, "safeWrite(...)");
            return a_Character;
        }

        @Nullable
        public final A_Character fromByteCodePoint(short codePoint) {
            short s = codePoint;
            short s2 = 0 <= s ? (s < 256 ? (short)1 : 0) : (s = 0);
            if (_Assertions.ENABLED && s == 0) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return byteCharacters[codePoint];
        }

        @NotNull
        public final A_Type getNonemptyStringOfDigitsType() {
            return nonemptyStringOfDigitsType;
        }

        private static final A_Character fromCodePoint$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (A_Character)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u0000 \u00052\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0006"}, d2={"Lavail/descriptor/character/CharacterDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "CODE_POINT_AND_HASH", "Companion", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final BitField CODE_POINT;
        @NotNull
        private static final BitField HASH;
        public static final /* enum */ IntegerSlots CODE_POINT_AND_HASH;
        private static final /* synthetic */ IntegerSlots[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        @NotNull
        public static EnumEntries<IntegerSlots> getEntries() {
            return $ENTRIES;
        }

        static {
            CODE_POINT_AND_HASH = new IntegerSlots();
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.CODE_POINT_AND_HASH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            CODE_POINT = new BitField(CODE_POINT_AND_HASH, 0, 32, Companion.CODE_POINT.1.INSTANCE);
            HASH = new BitField(CODE_POINT_AND_HASH, 32, 32, Companion.HASH.1.INSTANCE);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lavail/descriptor/character/CharacterDescriptor$IntegerSlots$Companion;", "", "()V", "CODE_POINT", "Lavail/descriptor/representation/BitField;", "getCODE_POINT", "()Lavail/descriptor/representation/BitField;", "HASH", "getHASH", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BitField getCODE_POINT() {
                return CODE_POINT;
            }

            @NotNull
            public final BitField getHASH() {
                return HASH;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

