/*
 * Decompiled with CFR 0.152.
 */
package avail.files;

import avail.error.ErrorCode;
import avail.files.AbstractFileWrapper;
import avail.files.AvailBinaryFile;
import avail.files.AvailFile;
import avail.files.AvailModuleFile;
import avail.files.AvailTextFile;
import avail.files.FileErrorCode;
import avail.files.FileManager;
import avail.resolver.ResolverReference;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.artifact.ResourceType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ:\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u00100\u00122\u001a\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u00020\u00100\u0014H\u0016R\u001b\u0010\t\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lavail/files/ManagedFileWrapper;", "Lavail/files/AbstractFileWrapper;", "id", "Ljava/util/UUID;", "resolverReference", "Lavail/resolver/ResolverReference;", "fileManager", "Lavail/files/FileManager;", "(Ljava/util/UUID;Lavail/resolver/ResolverReference;Lavail/files/FileManager;)V", "file", "Lavail/files/AvailFile;", "getFile", "()Lavail/files/AvailFile;", "file$delegate", "Lkotlin/Lazy;", "delete", "", "success", "Lkotlin/Function1;", "failure", "Lkotlin/Function2;", "Lavail/error/ErrorCode;", "", "Companion", "avail"})
public final class ManagedFileWrapper
extends AbstractFileWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy file$delegate;

    public ManagedFileWrapper(@NotNull UUID id, @NotNull ResolverReference resolverReference, @NotNull FileManager fileManager) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(resolverReference, "resolverReference");
        Intrinsics.checkNotNullParameter(fileManager, "fileManager");
        super(id, resolverReference, fileManager);
        this.file$delegate = LazyKt.lazy((Function0)new Function0<AvailFile>(resolverReference, this){
            final /* synthetic */ ResolverReference $resolverReference;
            final /* synthetic */ ManagedFileWrapper this$0;
            {
                this.$resolverReference = $resolverReference;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AvailFile invoke() {
                return this.$resolverReference.getType() == ResourceType.MODULE || Intrinsics.areEqual(this.$resolverReference.getMimeType(), "text/avail") ? (AvailFile)new AvailModuleFile(this.this$0, null, 2, null) : (AvailFile.Companion.isTextFile(this.$resolverReference.getMimeType()) ? (AvailFile)new AvailTextFile(this.this$0, null, 2, null) : (AvailFile)new AvailBinaryFile(this.this$0));
            }
        });
    }

    @Override
    @NotNull
    public AvailFile getFile() {
        Lazy lazy = this.file$delegate;
        return (AvailFile)lazy.getValue();
    }

    @Override
    public void delete(@NotNull Function1<? super UUID, Unit> success2, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failure) {
        Intrinsics.checkNotNullParameter(success2, "success");
        Intrinsics.checkNotNullParameter(failure, "failure");
        if (!Files.deleteIfExists(Paths.get(this.getReference().getUri()))) {
            failure.invoke(FileErrorCode.FILE_NOT_FOUND, null);
        } else {
            success2.invoke(this.getId());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lavail/files/ManagedFileWrapper$Companion;", "", "()V", "createFile", "Lavail/files/AvailFile;", "mimeType", "", "fileWrapper", "Lavail/files/ManagedFileWrapper;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AvailFile createFile(@NotNull String mimeType, @NotNull ManagedFileWrapper fileWrapper) {
            Intrinsics.checkNotNullParameter(mimeType, "mimeType");
            Intrinsics.checkNotNullParameter(fileWrapper, "fileWrapper");
            return Intrinsics.areEqual(mimeType, "text/avail") ? (AvailFile)new AvailModuleFile(fileWrapper, null, 2, null) : (AvailFile.Companion.isTextFile(mimeType) ? (AvailFile)new AvailTextFile(fileWrapper, null, 2, null) : (AvailFile)new AvailBinaryFile(fileWrapper));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

