/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.InstanceTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2ConditionalJump;
import avail.interpreter.levelTwo.operation.L2_JUMP;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_COMPARE_INT;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2Generator;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.jvm.JVMTranslator;
import avail.optimizer.reoptimizer.L2Regenerator;
import avail.utility.Tuple4;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012BU\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012<\u0010\u0006\u001a8\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t0\u0007\u00a2\u0006\u0002\u0010\u000bJ>\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\r0\u0017H\u0016J.\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 J#\u0010\"\u001a\u00020\r2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'H\u0016\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u0005H\u0016J \u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010\u000e\u001a\u00020\u000fH\u0016RD\u0010\u0006\u001a8\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lavail/interpreter/levelTwo/operation/L2_JUMP_IF_COMPARE_INT;", "Lavail/interpreter/levelTwo/operation/L2ConditionalJump;", "opcode", "", "opcodeName", "", "computeRestrictions", "Lkotlin/Function4;", "", "Lavail/utility/Tuple4;", "Lavail/interpreter/levelTwo/operand/TypeRestriction;", "(ILjava/lang/String;Lkotlin/jvm/functions/Function4;)V", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "", "compareAndBranch", "generator", "Lavail/optimizer/L2Generator;", "int1Reg", "Lavail/interpreter/levelTwo/operand/L2ReadIntOperand;", "int2Reg", "ifTrue", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "ifFalse", "emitTransformedInstruction", "transformedOperands", "", "Lavail/interpreter/levelTwo/operand/L2Operand;", "regenerator", "Lavail/optimizer/reoptimizer/L2Regenerator;", "([Lavail/interpreter/levelTwo/operand/L2Operand;Lavail/optimizer/reoptimizer/L2Regenerator;)V", "instructionWasAdded", "manifest", "Lavail/optimizer/L2ValueManifest;", "toString", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "Companion", "avail"})
public final class L2_JUMP_IF_COMPARE_INT
extends L2ConditionalJump {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int opcode;
    @NotNull
    private final String opcodeName;
    @NotNull
    private final Function4<Long, Long, Long, Long, Tuple4<TypeRestriction, TypeRestriction, TypeRestriction, TypeRestriction>> computeRestrictions;
    @NotNull
    private static final L2_JUMP_IF_COMPARE_INT less = new L2_JUMP_IF_COMPARE_INT(161, "<", Companion.less.1.INSTANCE);
    @NotNull
    private static final L2_JUMP_IF_COMPARE_INT greater = new L2_JUMP_IF_COMPARE_INT(163, ">", Companion.greater.1.INSTANCE);
    @NotNull
    private static final L2_JUMP_IF_COMPARE_INT lessOrEqual = new L2_JUMP_IF_COMPARE_INT(164, "\u2264", Companion.lessOrEqual.1.INSTANCE);
    @NotNull
    private static final L2_JUMP_IF_COMPARE_INT greaterOrEqual = new L2_JUMP_IF_COMPARE_INT(162, "\u2265", Companion.greaterOrEqual.1.INSTANCE);
    @NotNull
    private static final L2_JUMP_IF_COMPARE_INT equal = new L2_JUMP_IF_COMPARE_INT(159, "=", Companion.equal.1.INSTANCE);
    @NotNull
    private static final L2_JUMP_IF_COMPARE_INT notEqual = new L2_JUMP_IF_COMPARE_INT(160, "\u2260", Companion.notEqual.1.INSTANCE);

    private L2_JUMP_IF_COMPARE_INT(int opcode, String opcodeName, Function4<? super Long, ? super Long, ? super Long, ? super Long, Tuple4<TypeRestriction, TypeRestriction, TypeRestriction, TypeRestriction>> computeRestrictions) {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.READ_INT.named("int1"), L2OperandType.READ_INT.named("int2"), L2OperandType.PC.named("if true", L2NamedOperandType.Purpose.SUCCESS), L2OperandType.PC.named("if false", L2NamedOperandType.Purpose.FAILURE)};
        super(l2NamedOperandTypeArray);
        this.opcode = opcode;
        this.opcodeName = opcodeName;
        this.computeRestrictions = computeRestrictions;
    }

    public final void compareAndBranch(@NotNull L2Generator generator, @NotNull L2ReadIntOperand int1Reg, @NotNull L2ReadIntOperand int2Reg, @NotNull L2PcOperand ifTrue, @NotNull L2PcOperand ifFalse) {
        Intrinsics.checkNotNullParameter(generator, "generator");
        Intrinsics.checkNotNullParameter(int1Reg, "int1Reg");
        Intrinsics.checkNotNullParameter(int2Reg, "int2Reg");
        Intrinsics.checkNotNullParameter(ifTrue, "ifTrue");
        Intrinsics.checkNotNullParameter(ifFalse, "ifFalse");
        TypeRestriction restriction1 = int1Reg.restriction();
        TypeRestriction restriction2 = int2Reg.restriction();
        long low1 = A_Number.Companion.getExtractLong(A_Type.Companion.getLowerBound(restriction1.getType()));
        long high1 = A_Number.Companion.getExtractLong(A_Type.Companion.getUpperBound(restriction1.getType()));
        long low2 = A_Number.Companion.getExtractLong(A_Type.Companion.getLowerBound(restriction2.getType()));
        long high2 = A_Number.Companion.getExtractLong(A_Type.Companion.getUpperBound(restriction2.getType()));
        Tuple4<TypeRestriction, TypeRestriction, TypeRestriction, TypeRestriction> tuple4 = this.computeRestrictions.invoke(low1, high1, low2, high2);
        TypeRestriction rest1 = tuple4.component1();
        TypeRestriction rest2 = tuple4.component2();
        TypeRestriction rest3 = tuple4.component3();
        TypeRestriction rest4 = tuple4.component4();
        if (rest1.getType().isBottom() || rest2.getType().isBottom()) {
            generator.getCurrentManifest().setRestriction(int1Reg.semanticValue(), restriction1.intersection(rest3));
            generator.getCurrentManifest().setRestriction(int2Reg.semanticValue(), restriction2.intersection(rest4));
            L2Operand[] l2OperandArray = new L2Operand[]{ifFalse};
            generator.addInstruction(L2_JUMP.INSTANCE, l2OperandArray);
        } else if (rest3.getType().isBottom() || rest4.getType().isBottom()) {
            generator.getCurrentManifest().setRestriction(int1Reg.semanticValue(), restriction1.intersection(rest1));
            generator.getCurrentManifest().setRestriction(int2Reg.semanticValue(), restriction2.intersection(rest2));
            L2Operand[] l2OperandArray = new L2Operand[]{ifTrue};
            generator.addInstruction(L2_JUMP.INSTANCE, l2OperandArray);
        } else {
            L2Operand[] l2OperandArray = new L2Operand[]{int1Reg, int2Reg, ifTrue, ifFalse};
            generator.addInstruction(this, l2OperandArray);
        }
    }

    @Override
    public void instructionWasAdded(@NotNull L2Instruction instruction2, @NotNull L2ValueManifest manifest2) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(manifest2, "manifest");
        boolean bl = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        super.instructionWasAdded(instruction2, manifest2);
        L2ReadIntOperand int1Reg = (L2ReadIntOperand)instruction2.operand(0);
        L2ReadIntOperand int2Reg = (L2ReadIntOperand)instruction2.operand(1);
        L2PcOperand ifTrue = (L2PcOperand)instruction2.operand(2);
        L2PcOperand ifFalse = (L2PcOperand)instruction2.operand(3);
        TypeRestriction restriction1 = int1Reg.restriction();
        TypeRestriction restriction2 = int2Reg.restriction();
        long low1 = A_Number.Companion.getExtractLong(A_Type.Companion.getLowerBound(restriction1.getType()));
        long high1 = A_Number.Companion.getExtractLong(A_Type.Companion.getUpperBound(restriction1.getType()));
        long low2 = A_Number.Companion.getExtractLong(A_Type.Companion.getLowerBound(restriction2.getType()));
        long high2 = A_Number.Companion.getExtractLong(A_Type.Companion.getUpperBound(restriction2.getType()));
        Tuple4<TypeRestriction, TypeRestriction, TypeRestriction, TypeRestriction> tuple4 = this.computeRestrictions.invoke(low1, high1, low2, high2);
        TypeRestriction type1 = tuple4.component1();
        TypeRestriction type2 = tuple4.component2();
        TypeRestriction type3 = tuple4.component3();
        TypeRestriction type4 = tuple4.component4();
        ifTrue.manifest().setRestriction(int1Reg.semanticValue(), restriction1.intersection(type1));
        ifTrue.manifest().setRestriction(int2Reg.semanticValue(), restriction2.intersection(type2));
        ifFalse.manifest().setRestriction(int1Reg.semanticValue(), restriction1.intersection(type3));
        ifFalse.manifest().setRestriction(int2Reg.semanticValue(), restriction2.intersection(type4));
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, "desiredTypes");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, "warningStyleChange");
        boolean bl = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadIntOperand int1Reg = (L2ReadIntOperand)instruction2.operand(0);
        L2ReadIntOperand int2Reg = (L2ReadIntOperand)instruction2.operand(1);
        this.renderPreamble(instruction2, builder);
        builder.append(' ');
        builder.append(int1Reg.registerString());
        builder.append(" ");
        builder.append(this.opcodeName);
        builder.append(" ");
        builder.append(int2Reg.registerString());
        this.renderOperandsStartingAt(instruction2, 2, desiredTypes, builder);
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + "(" + this.opcodeName + ")";
    }

    @Override
    public void emitTransformedInstruction(@NotNull L2Operand[] transformedOperands, @NotNull L2Regenerator regenerator2) {
        Intrinsics.checkNotNullParameter(transformedOperands, "transformedOperands");
        Intrinsics.checkNotNullParameter(regenerator2, "regenerator");
        L2Operand l2Operand = transformedOperands[0];
        Intrinsics.checkNotNull(l2Operand, "null cannot be cast to non-null type avail.interpreter.levelTwo.operand.L2ReadIntOperand");
        L2ReadIntOperand int1Reg = (L2ReadIntOperand)l2Operand;
        L2Operand l2Operand2 = transformedOperands[1];
        Intrinsics.checkNotNull(l2Operand2, "null cannot be cast to non-null type avail.interpreter.levelTwo.operand.L2ReadIntOperand");
        L2ReadIntOperand int2Reg = (L2ReadIntOperand)l2Operand2;
        L2Operand l2Operand3 = transformedOperands[2];
        Intrinsics.checkNotNull(l2Operand3, "null cannot be cast to non-null type avail.interpreter.levelTwo.operand.L2PcOperand");
        L2PcOperand ifTrue = (L2PcOperand)l2Operand3;
        L2Operand l2Operand4 = transformedOperands[3];
        Intrinsics.checkNotNull(l2Operand4, "null cannot be cast to non-null type avail.interpreter.levelTwo.operand.L2PcOperand");
        L2PcOperand ifFalse = (L2PcOperand)l2Operand4;
        this.compareAndBranch(regenerator2.getTargetGenerator(), int1Reg, int2Reg, ifTrue, ifFalse);
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        L2ReadIntOperand int1Reg = (L2ReadIntOperand)instruction2.operand(0);
        L2ReadIntOperand int2Reg = (L2ReadIntOperand)instruction2.operand(1);
        L2PcOperand ifTrue = (L2PcOperand)instruction2.operand(2);
        L2PcOperand ifFalse = (L2PcOperand)instruction2.operand(3);
        translator.load(method, (L2Register)int1Reg.register());
        translator.load(method, (L2Register)int2Reg.register());
        L2ConditionalJump.emitBranch(translator, method, instruction2, this.opcode, ifTrue, ifFalse);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J(\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J(\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J(\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J(\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J(\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001eH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lavail/interpreter/levelTwo/operation/L2_JUMP_IF_COMPARE_INT$Companion;", "", "()V", "equal", "Lavail/interpreter/levelTwo/operation/L2_JUMP_IF_COMPARE_INT;", "getEqual", "()Lavail/interpreter/levelTwo/operation/L2_JUMP_IF_COMPARE_INT;", "greater", "getGreater", "greaterOrEqual", "getGreaterOrEqual", "less", "getLess", "lessOrEqual", "getLessOrEqual", "notEqual", "getNotEqual", "equalHelper", "Lavail/interpreter/levelTwo/operand/TypeRestriction;", "low1", "", "high1", "low2", "high2", "greaterHelper", "greaterOrEqualHelper", "lessHelper", "lessOrEqualHelper", "unequalHelper", "narrow", "Lavail/descriptor/types/A_Type;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        private final A_Type narrow(A_Type $this$narrow) {
            return A_Type.Companion.getLowerBound($this$narrow).equals(A_Type.Companion.getUpperBound($this$narrow)) ? (A_Type)InstanceTypeDescriptor.Companion.instanceType(A_Type.Companion.getLowerBound($this$narrow)) : $this$narrow;
        }

        private final TypeRestriction lessHelper(long low1, long high1, long low2, long high2) {
            return TypeRestriction.Companion.restrictionForType(this.narrow(IntegerRangeTypeDescriptor.Companion.inclusive(low1, Math.min(high1, high2 - 1L))), TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG);
        }

        private final TypeRestriction lessOrEqualHelper(long low1, long high1, long low2, long high2) {
            return TypeRestriction.Companion.restrictionForType(this.narrow(IntegerRangeTypeDescriptor.Companion.inclusive(low1, Math.min(high1, high2))), TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG);
        }

        private final TypeRestriction greaterHelper(long low1, long high1, long low2, long high2) {
            return TypeRestriction.Companion.restrictionForType(this.narrow(IntegerRangeTypeDescriptor.Companion.inclusive(Math.max(low1, low2 + 1L), high1)), TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG);
        }

        private final TypeRestriction greaterOrEqualHelper(long low1, long high1, long low2, long high2) {
            return TypeRestriction.Companion.restrictionForType(this.narrow(IntegerRangeTypeDescriptor.Companion.inclusive(Math.max(low1, low2), high1)), TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG);
        }

        private final TypeRestriction equalHelper(long low1, long high1, long low2, long high2) {
            return TypeRestriction.Companion.restrictionForType(this.narrow(IntegerRangeTypeDescriptor.Companion.inclusive(Math.max(low1, low2), Math.min(high1, high2))), TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG);
        }

        private final TypeRestriction unequalHelper(long low1, long high1, long low2, long high2) {
            if (low2 == high2) {
                return TypeRestriction.Companion.restriction$default(TypeRestriction.Companion, IntegerRangeTypeDescriptor.Companion.inclusive(IntegerDescriptor.Companion.fromLong(low1), IntegerDescriptor.Companion.fromLong(high1)), null, null, SetsKt.setOf(IntegerDescriptor.Companion.fromLong(low2)), null, null, null, null, false, false, true, false, 2548, null);
            }
            return this.lessHelper(low1, high1, low2, high2).union(this.greaterHelper(low1, high1, low2, high2));
        }

        @NotNull
        public final L2_JUMP_IF_COMPARE_INT getLess() {
            return less;
        }

        @NotNull
        public final L2_JUMP_IF_COMPARE_INT getGreater() {
            return greater;
        }

        @NotNull
        public final L2_JUMP_IF_COMPARE_INT getLessOrEqual() {
            return lessOrEqual;
        }

        @NotNull
        public final L2_JUMP_IF_COMPARE_INT getGreaterOrEqual() {
            return greaterOrEqual;
        }

        @NotNull
        public final L2_JUMP_IF_COMPARE_INT getEqual() {
            return equal;
        }

        @NotNull
        public final L2_JUMP_IF_COMPARE_INT getNotEqual() {
            return notEqual;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ TypeRestriction access$lessHelper(Companion $this, long low1, long high1, long low2, long high2) {
            return $this.lessHelper(low1, high1, low2, high2);
        }

        public static final /* synthetic */ TypeRestriction access$greaterHelper(Companion $this, long low1, long high1, long low2, long high2) {
            return $this.greaterHelper(low1, high1, low2, high2);
        }

        public static final /* synthetic */ TypeRestriction access$greaterOrEqualHelper(Companion $this, long low1, long high1, long low2, long high2) {
            return $this.greaterOrEqualHelper(low1, high1, low2, high2);
        }

        public static final /* synthetic */ TypeRestriction access$lessOrEqualHelper(Companion $this, long low1, long high1, long low2, long high2) {
            return $this.lessOrEqualHelper(low1, high1, low2, high2);
        }

        public static final /* synthetic */ TypeRestriction access$equalHelper(Companion $this, long low1, long high1, long low2, long high2) {
            return $this.equalHelper(low1, high1, low2, high2);
        }

        public static final /* synthetic */ TypeRestriction access$unequalHelper(Companion $this, long low1, long high1, long low2, long high2) {
            return $this.unequalHelper(low1, high1, low2, high2);
        }
    }
}

