/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.AbstractNumberDescriptor;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.operand.L2ConstantOperand;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operation.L2ConditionalJump;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2SplitCondition;
import avail.optimizer.jvm.JVMTranslator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0018"}, d2={"Lavail/interpreter/levelTwo/operation/L2_JUMP_IF_LESS_THAN_OR_EQUAL_TO_CONSTANT;", "Lavail/interpreter/levelTwo/operation/L2ConditionalJump;", "()V", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "", "interestingConditions", "", "Lavail/optimizer/L2SplitCondition;", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
public final class L2_JUMP_IF_LESS_THAN_OR_EQUAL_TO_CONSTANT
extends L2ConditionalJump {
    @NotNull
    public static final L2_JUMP_IF_LESS_THAN_OR_EQUAL_TO_CONSTANT INSTANCE = new L2_JUMP_IF_LESS_THAN_OR_EQUAL_TO_CONSTANT();

    private L2_JUMP_IF_LESS_THAN_OR_EQUAL_TO_CONSTANT() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.READ_BOXED.named("value"), L2OperandType.CONSTANT.named("constant"), L2OperandType.PC.named("if less or equal", L2NamedOperandType.Purpose.SUCCESS), L2OperandType.PC.named("if more", L2NamedOperandType.Purpose.FAILURE)};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, "desiredTypes");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, "warningStyleChange");
        boolean bl = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedOperand value = (L2ReadBoxedOperand)instruction2.operand(0);
        L2ConstantOperand constant = (L2ConstantOperand)instruction2.operand(1);
        this.renderPreamble(instruction2, builder);
        builder.append(' ');
        builder.append(value.registerString());
        builder.append(" \u2264 ");
        builder.append(constant.getConstant());
        this.renderOperandsStartingAt(instruction2, 2, desiredTypes, builder);
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        L2ReadBoxedOperand value = (L2ReadBoxedOperand)instruction2.operand(0);
        L2ConstantOperand constant = (L2ConstantOperand)instruction2.operand(1);
        L2PcOperand ifLessOrEqual = (L2PcOperand)instruction2.operand(2);
        L2PcOperand ifNotLessOrEqual = (L2PcOperand)instruction2.operand(3);
        translator.load(method, (L2Register)value.register());
        translator.literal(method, constant.getConstant());
        A_Number.Companion.getNumericCompareMethod().generateCall(method);
        AbstractNumberDescriptor.Order.Companion.isLessOrEqualMethod().generateCall(method);
        L2ConditionalJump.emitBranch(translator, method, instruction2, 154, ifLessOrEqual, ifNotLessOrEqual);
    }

    @Override
    @NotNull
    public List<L2SplitCondition> interestingConditions(@NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        L2ReadBoxedOperand value = (L2ReadBoxedOperand)instruction2.operand(0);
        L2ConstantOperand constant = (L2ConstantOperand)instruction2.operand(1);
        return A_Number.Companion.isInt(constant.getConstant()) ? CollectionsKt.listOf(L2SplitCondition.L2IsUnboxedIntCondition.Companion.unboxedIntCondition(CollectionsKt.listOf(value.register()))) : CollectionsKt.emptyList();
    }
}

