/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.numbers.A_Number;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2ConditionalJump;
import avail.interpreter.levelTwo.operation.L2_MOVE;
import avail.interpreter.levelTwo.operation.L2_UNBOX_INT;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2Generator;
import avail.optimizer.L2SplitCondition;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.jvm.JVMTranslator;
import avail.optimizer.reoptimizer.L2Regenerator;
import avail.optimizer.values.L2SemanticUnboxedInt;
import avail.optimizer.values.L2SemanticValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J#\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\""}, d2={"Lavail/interpreter/levelTwo/operation/L2_JUMP_IF_UNBOX_INT;", "Lavail/interpreter/levelTwo/operation/L2ConditionalJump;", "()V", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "", "emitTransformedInstruction", "transformedOperands", "", "Lavail/interpreter/levelTwo/operand/L2Operand;", "regenerator", "Lavail/optimizer/reoptimizer/L2Regenerator;", "([Lavail/interpreter/levelTwo/operand/L2Operand;Lavail/optimizer/reoptimizer/L2Regenerator;)V", "instructionWasAdded", "manifest", "Lavail/optimizer/L2ValueManifest;", "interestingConditions", "", "Lavail/optimizer/L2SplitCondition;", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
@SourceDebugExtension(value={"SMAP\nL2_JUMP_IF_UNBOX_INT.kt\nKotlin\n*S Kotlin\n*F\n+ 1 L2_JUMP_IF_UNBOX_INT.kt\navail/interpreter/levelTwo/operation/L2_JUMP_IF_UNBOX_INT\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n1549#2:202\n1620#2,3:203\n288#2,2:206\n1855#2,2:208\n*S KotlinDebug\n*F\n+ 1 L2_JUMP_IF_UNBOX_INT.kt\navail/interpreter/levelTwo/operation/L2_JUMP_IF_UNBOX_INT\n*L\n165#1:202\n165#1:203,3\n166#1:206,2\n174#1:208,2\n*E\n"})
public final class L2_JUMP_IF_UNBOX_INT
extends L2ConditionalJump {
    @NotNull
    public static final L2_JUMP_IF_UNBOX_INT INSTANCE = new L2_JUMP_IF_UNBOX_INT();

    private L2_JUMP_IF_UNBOX_INT() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.READ_BOXED.named("source"), L2OperandType.WRITE_INT.named("destination", L2NamedOperandType.Purpose.SUCCESS), L2OperandType.PC.named("if not unboxed", L2NamedOperandType.Purpose.FAILURE), L2OperandType.PC.named("if unboxed", L2NamedOperandType.Purpose.SUCCESS)};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, "desiredTypes");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, "warningStyleChange");
        boolean bl = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedOperand source = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteIntOperand destination = (L2WriteIntOperand)instruction2.operand(1);
        this.renderPreamble(instruction2, builder);
        builder.append(' ');
        builder.append(destination.registerString());
        builder.append(" \u2190? ");
        builder.append(source.registerString());
        this.renderOperandsStartingAt(instruction2, 2, desiredTypes, builder);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void instructionWasAdded(@NotNull L2Instruction instruction2, @NotNull L2ValueManifest manifest2) {
        void $this$instructionWasAdded_u24lambda_u241;
        L2ValueManifest $this$instructionWasAdded_u24lambda_u240;
        L2ValueManifest l2ValueManifest;
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(manifest2, "manifest");
        boolean bl = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedOperand source = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteIntOperand destination = (L2WriteIntOperand)instruction2.operand(1);
        L2PcOperand ifNotUnboxed = (L2PcOperand)instruction2.operand(2);
        L2PcOperand ifUnboxed = (L2PcOperand)instruction2.operand(3);
        source.instructionWasAdded(manifest2);
        L2ValueManifest l2ValueManifest2 = l2ValueManifest = new L2ValueManifest(manifest2);
        L2PcOperand l2PcOperand = ifNotUnboxed;
        boolean bl2 = false;
        $this$instructionWasAdded_u24lambda_u240.subtractType(source.semanticValue(), IntegerRangeTypeDescriptor.Companion.getI32());
        l2PcOperand.instructionWasAdded(l2ValueManifest);
        destination.instructionWasAdded(manifest2);
        $this$instructionWasAdded_u24lambda_u240 = l2ValueManifest = new L2ValueManifest(manifest2);
        l2PcOperand = ifUnboxed;
        boolean bl3 = false;
        $this$instructionWasAdded_u24lambda_u241.intersectType(destination.pickSemanticValue(), IntegerRangeTypeDescriptor.Companion.getI32());
        l2PcOperand.instructionWasAdded(l2ValueManifest);
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        L2ReadBoxedOperand source = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteIntOperand destination = (L2WriteIntOperand)instruction2.operand(1);
        L2PcOperand ifNotUnboxed = (L2PcOperand)instruction2.operand(2);
        L2PcOperand ifUnboxed = (L2PcOperand)instruction2.operand(3);
        translator.load(method, (L2Register)source.register());
        A_Number.Companion.isIntMethod().generateCall(method);
        method.visitJumpInsn(153, translator.labelFor(ifNotUnboxed.offset()));
        translator.load(method, (L2Register)source.register());
        A_Number.Companion.getExtractIntStaticMethod().generateCall(method);
        translator.store(method, (L2Register)destination.register());
        translator.jump(method, instruction2, ifUnboxed);
    }

    @Override
    @NotNull
    public List<L2SplitCondition> interestingConditions(@NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        L2ReadBoxedOperand source = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteIntOperand destination = (L2WriteIntOperand)instruction2.operand(1);
        L2Register[] l2RegisterArray = new L2Register[]{source.register(), destination.register()};
        return CollectionsKt.listOf(L2SplitCondition.L2IsUnboxedIntCondition.Companion.unboxedIntCondition(CollectionsKt.listOf(l2RegisterArray)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void emitTransformedInstruction(@NotNull L2Operand[] transformedOperands, @NotNull L2Regenerator regenerator2) {
        L2SemanticUnboxedInt l2SemanticUnboxedInt;
        Object v4;
        TypeRestriction restriction2;
        L2ValueManifest manifest2;
        L2Generator generator;
        L2PcOperand ifUnboxed;
        L2PcOperand ifNotUnboxed;
        L2WriteIntOperand destination;
        L2ReadBoxedOperand source;
        block10: {
            void $this$firstOrNull$iv;
            Iterator $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter(transformedOperands, "transformedOperands");
            Intrinsics.checkNotNullParameter(regenerator2, "regenerator");
            L2Operand l2Operand = transformedOperands[0];
            Intrinsics.checkNotNull(l2Operand, "null cannot be cast to non-null type avail.interpreter.levelTwo.operand.L2ReadBoxedOperand");
            source = (L2ReadBoxedOperand)l2Operand;
            L2Operand l2Operand2 = transformedOperands[1];
            Intrinsics.checkNotNull(l2Operand2, "null cannot be cast to non-null type avail.interpreter.levelTwo.operand.L2WriteIntOperand");
            destination = (L2WriteIntOperand)l2Operand2;
            L2Operand l2Operand3 = transformedOperands[2];
            Intrinsics.checkNotNull(l2Operand3, "null cannot be cast to non-null type avail.interpreter.levelTwo.operand.L2PcOperand");
            ifNotUnboxed = (L2PcOperand)l2Operand3;
            L2Operand l2Operand4 = transformedOperands[3];
            Intrinsics.checkNotNull(l2Operand4, "null cannot be cast to non-null type avail.interpreter.levelTwo.operand.L2PcOperand");
            ifUnboxed = (L2PcOperand)l2Operand4;
            generator = regenerator2.getTargetGenerator();
            manifest2 = generator.getCurrentManifest();
            restriction2 = manifest2.restrictionFor(source.semanticValue());
            Iterable iterable = manifest2.semanticValueToSynonym(source.semanticValue()).semanticValues();
            boolean $i$f$map = false;
            void var14_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void p0;
                Object item$iv$iv = iterator2.next();
                L2SemanticValue l2SemanticValue = (L2SemanticValue)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(new L2SemanticUnboxedInt((L2SemanticValue)p0));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                L2SemanticValue p0 = (L2SemanticValue)element$iv;
                boolean bl = false;
                if (!manifest2.hasSemanticValue(p0)) continue;
                v4 = element$iv;
                break block10;
            }
            v4 = null;
        }
        if ((l2SemanticUnboxedInt = (L2SemanticUnboxedInt)v4) == null) {
            l2SemanticUnboxedInt = new L2SemanticUnboxedInt(source.semanticValue());
        }
        L2SemanticUnboxedInt sourceInt = l2SemanticUnboxedInt;
        if (manifest2.hasSemanticValue(sourceInt)) {
            Iterable $this$forEach$iv = destination.semanticValues();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                L2SemanticUnboxedInt dest = (L2SemanticUnboxedInt)element$iv;
                boolean bl = false;
                if (manifest2.hasSemanticValue(dest)) continue;
                generator.moveRegister(L2_MOVE.Companion.getUnboxedInt(), sourceInt, dest);
            }
            L2Generator.jumpTo$default(generator, ifUnboxed.targetBlock(), null, 2, null);
        } else if (restriction2.containedByType(IntegerRangeTypeDescriptor.Companion.getI32())) {
            L2Operand[] l2OperandArray = new L2Operand[]{source, destination};
            generator.addInstruction(L2_UNBOX_INT.INSTANCE, l2OperandArray);
            L2Generator.jumpTo$default(generator, ifUnboxed.targetBlock(), null, 2, null);
        } else if (!restriction2.intersectsType(IntegerRangeTypeDescriptor.Companion.getI32())) {
            L2Generator.jumpTo$default(generator, ifNotUnboxed.targetBlock(), null, 2, null);
        } else {
            super.emitTransformedInstruction(transformedOperands, regenerator2);
        }
    }
}

