/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.lexing;

import avail.compiler.AvailRejectedParseException;
import avail.compiler.problems.CompilerDiagnostics;
import avail.descriptor.character.A_Character;
import avail.descriptor.character.CharacterDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.parsing.LexerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tokens.CommentTokenDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.style.P_BootstrapLexerSlashStarCommentBodyStyler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lavail/interpreter/primitive/bootstrap/lexing/P_BootstrapLexerSlashStarCommentBody;", "Lavail/interpreter/Primitive;", "()V", "slashCharacter", "Lavail/descriptor/character/A_Character;", "starCharacter", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "bootstrapStyler", "Lavail/interpreter/primitive/style/P_BootstrapLexerSlashStarCommentBodyStyler;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_BootstrapLexerSlashStarCommentBody
extends Primitive {
    @NotNull
    public static final P_BootstrapLexerSlashStarCommentBody INSTANCE = new P_BootstrapLexerSlashStarCommentBody();
    @NotNull
    private static final A_Character slashCharacter = CharacterDescriptor.Companion.fromCodePoint(47);
    @NotNull
    private static final A_Character starCharacter = CharacterDescriptor.Companion.fromCodePoint(42);

    private P_BootstrapLexerSlashStarCommentBody() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline, Primitive.Flag.Bootstrap};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject source = interpreter.argument(0);
        AvailObject sourcePositionInteger = interpreter.argument(1);
        AvailObject startingLineNumber = interpreter.argument(2);
        int sourceSize = A_Tuple.Companion.getTupleSize(source);
        int startPosition = A_Number.Companion.getExtractInt(sourcePositionInteger);
        int position = startPosition + 1;
        if (position > sourceSize || A_Tuple.Companion.tupleCodePointAt(source, position) != 42) {
            return interpreter.primitiveSuccess(SetDescriptor.Companion.getEmptySet());
        }
        ++position;
        int depth2 = 1;
        while (true) {
            if ((position = A_Tuple.Companion.firstIndexOfOr(source, slashCharacter, starCharacter, position, sourceSize - 1)) == 0) {
                throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "Subsequent '*/' to close this (nestable) block comment", new Object[0]);
            }
            int c = A_Tuple.Companion.tupleCodePointAt(source, position);
            if (c == 42 && A_Tuple.Companion.tupleCodePointAt(source, position + 1) == 47) {
                position += 2;
                if (--depth2 != 0) continue;
                break;
            }
            if (c == 47 && A_Tuple.Companion.tupleCodePointAt(source, position + 1) == 42) {
                position += 2;
                ++depth2;
                continue;
            }
            ++position;
        }
        A_Token token = CommentTokenDescriptor.Companion.newCommentToken(A_String.Companion.copyStringFromToCanDestroy(source, startPosition, position - 1, false), startPosition, A_Number.Companion.getExtractInt(startingLineNumber), A_Fiber.Companion.getCurrentLexer(interpreter.fiber()));
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{ObjectTupleDescriptor.Companion.tuple(token)};
        return interpreter.primitiveSuccess(SetDescriptor.Companion.set(a_BasicObjectArray));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return LexerDescriptor.Companion.lexerBodyFunctionType();
    }

    @Override
    @NotNull
    public P_BootstrapLexerSlashStarCommentBodyStyler bootstrapStyler() {
        return P_BootstrapLexerSlashStarCommentBodyStyler.INSTANCE;
    }
}

