/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.general;

import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_OBJECTS_EQUAL;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Generator;
import avail.optimizer.L2ValueManifest;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016JH\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lavail/interpreter/primitive/general/P_Equality;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_Equality
extends Primitive {
    @NotNull
    public static final P_Equality INSTANCE = new P_Equality();

    private P_Equality() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject a = interpreter.argument(0);
        AvailObject b = interpreter.argument(1);
        return interpreter.primitiveSuccess(AtomDescriptor.Companion.objectFromBoolean(a.equals(b)));
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        AvailObject value;
        A_Type type2;
        boolean bl;
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        boolean bl2 = bl = argumentTypes.size() == 2;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Type type1 = argumentTypes.get(0);
        if (A_Type.Companion.typeIntersection(type1, type2 = argumentTypes.get(1)).isBottom()) {
            return EnumerationTypeDescriptor.Companion.getFalseType();
        }
        if (type1.isEnumeration() && type1.equals(type2) && A_Number.Companion.equalsInt(A_Type.Companion.getInstanceCount(type1), 1) && !(value = (AvailObject)CollectionsKt.single(A_Type.Companion.getInstances(type1))).isType()) {
            return EnumerationTypeDescriptor.Companion.getTrueType();
        }
        return super.returnTypeGuaranteedByVM(rawFunction2, argumentTypes);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ANY.getO(), PrimitiveTypeDescriptor.Types.ANY.getO()), EnumerationTypeDescriptor.Companion.getBooleanType(), null, 4, null);
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments2, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        A_Type type2;
        Intrinsics.checkNotNullParameter(functionToCallReg, "functionToCallReg");
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(callSiteHelper, "callSiteHelper");
        L2ReadBoxedOperand firstReg = arguments2.get(0);
        L2ReadBoxedOperand secondReg = arguments2.get(1);
        L2ValueManifest manifest2 = callSiteHelper.generator().getCurrentManifest();
        if (!((Collection)CollectionsKt.intersect((Iterable)manifest2.synonymsForRegister((L2Register)firstReg.register()), (Iterable)manifest2.synonymsForRegister((L2Register)secondReg.register()))).isEmpty()) {
            callSiteHelper.useAnswer(translator.getGenerator().boxedConstant(AtomDescriptor.Companion.getTrueObject()));
            return true;
        }
        A_Type type1 = firstReg.type();
        if (A_Type.Companion.typeIntersection(type1, type2 = secondReg.type()).isBottom()) {
            callSiteHelper.useAnswer(translator.getGenerator().boxedConstant(AtomDescriptor.Companion.getFalseObject()));
            return true;
        }
        if (type1.equals(type2) && A_Number.Companion.equalsInt(A_Type.Companion.getInstanceCount(type1), 1) && !type1.isInstanceMeta()) {
            callSiteHelper.useAnswer(translator.getGenerator().boxedConstant(AtomDescriptor.Companion.getTrueObject()));
            return true;
        }
        L2Generator $this$tryToGenerateSpecialPrimitiveInvocation_u24lambda_u240 = translator.getGenerator();
        boolean bl = false;
        L2BasicBlock ifEqual = $this$tryToGenerateSpecialPrimitiveInvocation_u24lambda_u240.createBasicBlock("equal");
        L2BasicBlock ifNotEqual = $this$tryToGenerateSpecialPrimitiveInvocation_u24lambda_u240.createBasicBlock("not equal");
        AvailObject c1 = firstReg.constantOrNull();
        AvailObject c2 = secondReg.constantOrNull();
        if (c1 != null) {
            $this$tryToGenerateSpecialPrimitiveInvocation_u24lambda_u240.jumpIfEqualsConstant($this$tryToGenerateSpecialPrimitiveInvocation_u24lambda_u240.readBoxed(secondReg.semanticValue()), c1, ifEqual, ifNotEqual);
        } else if (c2 != null) {
            $this$tryToGenerateSpecialPrimitiveInvocation_u24lambda_u240.jumpIfEqualsConstant($this$tryToGenerateSpecialPrimitiveInvocation_u24lambda_u240.readBoxed(firstReg.semanticValue()), c2, ifEqual, ifNotEqual);
        } else {
            L2Operand[] l2OperandArray = new L2Operand[]{$this$tryToGenerateSpecialPrimitiveInvocation_u24lambda_u240.readBoxed(firstReg.semanticValue()), $this$tryToGenerateSpecialPrimitiveInvocation_u24lambda_u240.readBoxed(secondReg.semanticValue()), L2Generator.Companion.edgeTo$default(L2Generator.Companion, ifEqual, null, 2, null), L2Generator.Companion.edgeTo$default(L2Generator.Companion, ifNotEqual, null, 2, null)};
            $this$tryToGenerateSpecialPrimitiveInvocation_u24lambda_u240.addInstruction(L2_JUMP_IF_OBJECTS_EQUAL.INSTANCE, l2OperandArray);
        }
        L2Generator.startBlock$default($this$tryToGenerateSpecialPrimitiveInvocation_u24lambda_u240, ifEqual, false, null, 6, null);
        callSiteHelper.useAnswer($this$tryToGenerateSpecialPrimitiveInvocation_u24lambda_u240.boxedConstant(AtomDescriptor.Companion.getTrueObject()));
        L2Generator.startBlock$default($this$tryToGenerateSpecialPrimitiveInvocation_u24lambda_u240, ifNotEqual, false, null, 6, null);
        callSiteHelper.useAnswer($this$tryToGenerateSpecialPrimitiveInvocation_u24lambda_u240.boxedConstant(AtomDescriptor.Companion.getFalseObject()));
        return true;
    }
}

