/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.privatehelpers;

import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwoSimple.L2SimpleTranslator;
import avail.interpreter.levelTwoSimple.L2Simple_MoveConstant;
import avail.optimizer.L1Translator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0014J\u001e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010H\u0016JH\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u001eR\u00020\u001cH\u0016\u00a8\u0006\u001f"}, d2={"Lavail/interpreter/primitive/privatehelpers/P_PushConstant;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "attemptToGenerateSimpleInvocation", "Lavail/interpreter/levelTwo/operand/TypeRestriction;", "simpleTranslator", "Lavail/interpreter/levelTwoSimple/L2SimpleTranslator;", "functionIfKnown", "Lavail/descriptor/functions/A_Function;", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argRestrictions", "", "expectedType", "Lavail/descriptor/types/A_Type;", "privateBlockTypeRestriction", "returnTypeGuaranteedByVM", "argumentTypes", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_PushConstant
extends Primitive {
    @NotNull
    public static final P_PushConstant INSTANCE = new P_PushConstant();

    private P_PushConstant() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.SpecialForm, Primitive.Flag.Private, Primitive.Flag.CanInline, Primitive.Flag.CannotFail};
        super(-1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        boolean bl;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        A_Function a_Function = interpreter.function;
        Intrinsics.checkNotNull(a_Function);
        A_RawFunction code = a_Function.code();
        boolean bl2 = bl = code.codePrimitive() == this;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return interpreter.primitiveSuccess(A_RawFunction.Companion.literalAt(code, 1));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return BottomTypeDescriptor.Companion.getBottom();
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        AvailObject value = A_RawFunction.Companion.literalAt(rawFunction2, 1);
        return value.isNil() ? (A_Type)PrimitiveTypeDescriptor.Types.TOP.getO() : AbstractEnumerationTypeDescriptor.Companion.instanceTypeOrMetaOn(value);
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments2, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter(functionToCallReg, "functionToCallReg");
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(callSiteHelper, "callSiteHelper");
        AvailObject constant = A_RawFunction.Companion.literalAt(rawFunction2, 1);
        callSiteHelper.useAnswer(translator.getGenerator().boxedConstant(constant));
        return true;
    }

    @Override
    @NotNull
    public TypeRestriction attemptToGenerateSimpleInvocation(@NotNull L2SimpleTranslator simpleTranslator, @Nullable A_Function functionIfKnown, @NotNull A_RawFunction rawFunction2, @NotNull List<TypeRestriction> argRestrictions, @NotNull A_Type expectedType) {
        Intrinsics.checkNotNullParameter(simpleTranslator, "simpleTranslator");
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argRestrictions, "argRestrictions");
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        AvailObject constant = A_RawFunction.Companion.literalAt(rawFunction2, 1);
        simpleTranslator.add(new L2Simple_MoveConstant(constant, simpleTranslator.getStackp()));
        return TypeRestriction.Companion.restrictionForConstant(constant, TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG);
    }
}

