/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.tuples;

import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/tuples/P_TupleTypeSequenceOfTypes;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_TupleTypeSequenceOfTypes
extends Primitive {
    @NotNull
    public static final P_TupleTypeSequenceOfTypes INSTANCE = new P_TupleTypeSequenceOfTypes();

    private P_TupleTypeSequenceOfTypes() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject tupleType = interpreter.argument(0);
        AvailObject startIndex = interpreter.argument(1);
        AvailObject endIndex = interpreter.argument(2);
        if (!A_Number.Companion.isInt(startIndex) || !A_Number.Companion.isInt(endIndex)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS);
        }
        int startInt = A_Number.Companion.getExtractInt(startIndex);
        int endInt = A_Number.Companion.getExtractInt(endIndex);
        int tupleSize = endInt - startInt + 1;
        if (tupleSize < 0) {
            return interpreter.primitiveFailure(AvailErrorCode.E_NEGATIVE_SIZE);
        }
        AvailObject tupleObject2 = ObjectTupleDescriptor.Companion.generateObjectTupleFrom(tupleSize, (Function1<? super Integer, ? extends A_BasicObject>)new Function1<Integer, A_BasicObject>(tupleType, startInt){
            final /* synthetic */ AvailObject $tupleType;
            final /* synthetic */ int $startInt;
            {
                this.$tupleType = $tupleType;
                this.$startInt = $startInt;
                super(1);
            }

            @NotNull
            public final A_BasicObject invoke(int it) {
                return A_Type.Companion.typeAtIndex(this.$tupleType, it + this.$startInt - 1).makeImmutable();
            }
        });
        return interpreter.primitiveSuccess(tupleObject2);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getTupleMeta(), IntegerRangeTypeDescriptor.Companion.getNaturalNumbers(), IntegerRangeTypeDescriptor.Companion.getWholeNumbers()), TupleTypeDescriptor.Companion.zeroOrMoreOf(InstanceMetaDescriptor.Companion.anyMeta()), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS, AvailErrorCode.E_NEGATIVE_SIZE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

