/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.types;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_KIND_OF_OBJECT;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Generator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016JH\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019R\u00020\u0017H\u0016\u00a8\u0006\u001a"}, d2={"Lavail/interpreter/primitive/types/P_CastInto;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "fallibilityForArgumentTypes", "Lavail/interpreter/Primitive$Fallibility;", "argumentTypes", "", "Lavail/descriptor/types/A_Type;", "privateBlockTypeRestriction", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_CastInto
extends Primitive {
    @NotNull
    public static final P_CastInto INSTANCE = new P_CastInto();

    private P_CastInto() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.Invokes, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject value = interpreter.argument(0);
        AvailObject castFunction = interpreter.argument(1);
        A_Type expectedType = A_Type.Companion.typeAtIndex(A_Type.Companion.getArgsTupleType(castFunction.code().functionType()), 1);
        if (value.isInstanceOf(expectedType)) {
            interpreter.argsBuffer.clear();
            interpreter.argsBuffer.add(value);
            interpreter.function = castFunction;
            return Primitive.Result.READY_TO_INVOKE;
        }
        return interpreter.primitiveFailure(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ANY.getO(), FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(BottomTypeDescriptor.Companion.getBottom()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null)), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        return A_Type.Companion.getReturnType(argumentTypes.get(1));
    }

    @Override
    @NotNull
    public Primitive.Fallibility fallibilityForArgumentTypes(@NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type valueType = argumentTypes.get(0);
        A_Type castFunctionType = argumentTypes.get(1);
        if (A_Number.Companion.equalsInt(A_Type.Companion.getInstanceCount(castFunctionType), 1)) {
            AvailObject function = A_Type.Companion.getInstance(castFunctionType);
            A_RawFunction code = function.code();
            A_Type argType = A_Type.Companion.typeAtIndex(A_Type.Companion.getArgsTupleType(code.functionType()), 1);
            if (A_Type.Companion.isSubtypeOf(valueType, argType)) {
                return Primitive.Fallibility.CallSiteCannotFail;
            }
            if (A_Type.Companion.typeIntersection(valueType, argType).isBottom()) {
                return Primitive.Fallibility.CallSiteMustFail;
            }
        }
        return Primitive.Fallibility.CallSiteCanFail;
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments2, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Boolean bl;
        A_Type typeTest;
        Intrinsics.checkNotNullParameter(functionToCallReg, "functionToCallReg");
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(callSiteHelper, "callSiteHelper");
        L2ReadBoxedOperand valueRead = arguments2.get(0);
        L2ReadBoxedOperand castFunctionRead = arguments2.get(1);
        L2Generator generator = translator.getGenerator();
        L2BasicBlock castBlock = generator.createBasicBlock("cast type matched");
        L2BasicBlock elseBlock = generator.createBasicBlock("cast type did not match");
        AvailObject constantValue = valueRead.constantOrNull();
        A_Type a_Type = typeTest = castFunctionRead.exactSoleArgumentType();
        if (a_Type != null) {
            A_Type $this$tryToGenerateSpecialPrimitiveInvocation_u24lambda_u240 = a_Type;
            boolean bl2 = false;
            AvailObject availObject = constantValue;
            bl = availObject != null ? Boolean.valueOf(availObject.isInstanceOf(typeTest)) : (A_Type.Companion.isSubtypeOf(valueRead.type(), typeTest) ? Boolean.valueOf(true) : (A_Type.Companion.typeIntersection(valueRead.type(), typeTest).isBottom() ? Boolean.valueOf(false) : null));
        } else {
            bl = null;
        }
        Boolean passedTest = bl;
        if (typeTest == null) {
            L2ReadBoxedOperand parameterTypeRead = translator.getGenerator().extractParameterTypeFromFunction(castFunctionRead, 1);
            L2Operand[] l2OperandArray = new L2Operand[]{valueRead, parameterTypeRead, L2Generator.Companion.edgeTo$default(L2Generator.Companion, castBlock, null, 2, null), L2Generator.Companion.edgeTo$default(L2Generator.Companion, elseBlock, null, 2, null)};
            translator.addInstruction(L2_JUMP_IF_KIND_OF_OBJECT.INSTANCE, l2OperandArray);
        } else if (passedTest == null) {
            generator.jumpIfKindOfConstant(valueRead, typeTest, castBlock, elseBlock);
        } else {
            L2Generator.jumpTo$default(translator.getGenerator(), passedTest != false ? castBlock : elseBlock, null, 2, null);
        }
        L2Generator.startBlock$default(generator, castBlock, false, null, 6, null);
        if (generator.currentlyReachable()) {
            translator.generateGeneralFunctionInvocation(castFunctionRead, CollectionsKt.listOf(valueRead), true, callSiteHelper);
        }
        L2Generator.startBlock$default(generator, elseBlock, false, null, 6, null);
        if (generator.currentlyReachable()) {
            translator.generateGeneralFunctionInvocation(functionToCallReg, arguments2, false, callSiteHelper);
        }
        return true;
    }
}

