/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.variables;

import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.VariableTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.VariableGetException;
import avail.exceptions.VariableSetException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operation.L2_VARIABLE_COMPARE_AND_SWAP_NO_CHECK;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Generator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014JH\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lavail/interpreter/primitive/variables/P_AtomicCompareAndSwap;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "arguments", "", "argumentTypes", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_AtomicCompareAndSwap
extends Primitive {
    @NotNull
    public static final P_AtomicCompareAndSwap INSTANCE = new P_AtomicCompareAndSwap();

    private P_AtomicCompareAndSwap() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Primitive.Result result2;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject variable = interpreter.argument(0);
        AvailObject reference = interpreter.argument(1);
        AvailObject newValue = interpreter.argument(2);
        try {
            result2 = interpreter.primitiveSuccess(AtomDescriptor.Companion.objectFromBoolean(variable.compareAndSwapValues(reference, newValue)));
        }
        catch (VariableGetException e) {
            result2 = interpreter.primitiveFailure(e);
        }
        catch (VariableSetException e) {
            result2 = interpreter.primitiveFailure(e);
        }
        return result2;
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments2, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter(functionToCallReg, "functionToCallReg");
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(callSiteHelper, "callSiteHelper");
        L2ReadBoxedOperand variableReg = arguments2.get(0);
        L2ReadBoxedOperand referenceReg = arguments2.get(1);
        L2ReadBoxedOperand newValueReg = arguments2.get(2);
        if (!A_Type.Companion.isSubtypeOf(newValueReg.type(), A_Type.Companion.getWriteType(variableReg.type()))) {
            return super.tryToGenerateSpecialPrimitiveInvocation(functionToCallReg, rawFunction2, arguments2, argumentTypes, translator, callSiteHelper);
        }
        L2Generator generator = translator.getGenerator();
        L2BasicBlock success2 = generator.createBasicBlock("swap success");
        L2BasicBlock failure = generator.createBasicBlock("swap failure");
        L2BasicBlock exception = generator.createBasicBlock("swap exception");
        L2Operand[] l2OperandArray = new L2Operand[]{variableReg, referenceReg, newValueReg, L2Generator.Companion.edgeTo$default(L2Generator.Companion, success2, null, 2, null), L2Generator.Companion.edgeTo$default(L2Generator.Companion, failure, null, 2, null), L2Generator.Companion.edgeTo$default(L2Generator.Companion, exception, null, 2, null)};
        translator.addInstruction(L2_VARIABLE_COMPARE_AND_SWAP_NO_CHECK.INSTANCE, l2OperandArray);
        L2Generator.startBlock$default(generator, success2, false, null, 6, null);
        callSiteHelper.useAnswer(generator.boxedConstant(AtomDescriptor.Companion.getTrueObject()));
        L2Generator.startBlock$default(generator, failure, false, null, 6, null);
        callSiteHelper.useAnswer(generator.boxedConstant(AtomDescriptor.Companion.getFalseObject()));
        L2Generator.startBlock$default(generator, exception, false, null, 6, null);
        translator.generateGeneralFunctionInvocation(functionToCallReg, arguments2, false, callSiteHelper);
        return true;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(VariableTypeDescriptor.Companion.getMostGeneralVariableType(), PrimitiveTypeDescriptor.Types.ANY.getO(), PrimitiveTypeDescriptor.Types.ANY.getO()), EnumerationTypeDescriptor.Companion.getBooleanType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_CANNOT_READ_UNASSIGNED_VARIABLE, AvailErrorCode.E_CANNOT_STORE_INCORRECTLY_TYPED_VALUE, AvailErrorCode.E_CANNOT_MODIFY_FINAL_JAVA_FIELD, AvailErrorCode.E_JAVA_MARSHALING_FAILED, AvailErrorCode.E_CANNOT_OVERWRITE_WRITE_ONCE_VARIABLE, AvailErrorCode.E_OBSERVED_VARIABLE_WRITTEN_WHILE_UNTRACED};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

