/*
 * Decompiled with CFR 0.152.
 */
package avail.io;

import avail.io.TextOutputChannel;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J9\u0010\u000b\u001a\u00020\b\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u0001H\f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\f0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0013J9\u0010\u000b\u001a\u00020\b\"\u0004\b\u0000\u0010\f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u000f\u001a\u0004\u0018\u0001H\f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\f0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lavail/io/ConsoleOutputChannel;", "Lavail/io/TextOutputChannel;", "stream", "Ljava/io/PrintStream;", "(Ljava/io/PrintStream;)V", "out", "Ljava/io/Writer;", "close", "", "isOpen", "", "write", "A", "buffer", "Ljava/nio/CharBuffer;", "attachment", "handler", "Ljava/nio/channels/CompletionHandler;", "", "(Ljava/nio/CharBuffer;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V", "data", "", "(Ljava/lang/String;Ljava/lang/Object;Ljava/nio/channels/CompletionHandler;)V", "avail"})
public final class ConsoleOutputChannel
implements TextOutputChannel {
    @NotNull
    private final Writer out;

    public ConsoleOutputChannel(@NotNull PrintStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.REPLACE);
        encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, encoder));
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public <A> void write(@NotNull CharBuffer buffer, @Nullable A attachment, @NotNull CompletionHandler<Integer, A> handler) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(handler, "handler");
        try {
            this.out.write(buffer.toString());
            this.out.flush();
        }
        catch (IOException e) {
            handler.failed(e, attachment);
            return;
        }
        handler.completed(buffer.limit(), attachment);
    }

    @Override
    public <A> void write(@NotNull String data2, @Nullable A attachment, @NotNull CompletionHandler<Integer, A> handler) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(handler, "handler");
        try {
            this.out.write(data2);
            this.out.flush();
        }
        catch (IOException e) {
            handler.failed(e, attachment);
            return;
        }
        handler.completed(data2.length(), attachment);
    }

    @Override
    public void close() {
    }
}

