/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer;

import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2ControlFlowGraphVisualizer;
import avail.utility.Mutable;
import avail.utility.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0003'()B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u001a\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0014J\u001c\u0010\u0015\u001a\u00020\u00122\u0014\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\u0017J\u001c\u0010\u0018\u001a\u00020\u00122\u0014\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\u0017J\u001c\u0010\u0019\u001a\u00020\u00122\u0014\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\u0017J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0000J\u001a\u0010\u001c\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0014J\u0014\u0010\u001d\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0004J\u001c\u0010 \u001a\u00020\u00122\u0014\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\u0017J\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0005J\b\u0010%\u001a\u00020\"H\u0016J\u0006\u0010&\u001a\u00020\"R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001f\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006*"}, d2={"Lavail/optimizer/L2ControlFlowGraph;", "", "()V", "basicBlockOrder", "", "Lavail/optimizer/L2BasicBlock;", "getBasicBlockOrder", "()Ljava/util/List;", "state", "", "Lkotlin/reflect/KClass;", "Lavail/optimizer/L2ControlFlowGraph$StateFlag;", "getState", "()Ljava/util/Set;", "allRegisters", "", "Lavail/interpreter/levelTwo/register/L2Register;", "backwardVisit", "", "action", "Lkotlin/Function1;", "check", "flags", "", "checkNot", "clear", "evacuateTo", "destinationControlFlowGraph", "forwardVisit", "generateOn", "instructions", "Lavail/interpreter/levelTwo/L2Instruction;", "set", "simplyVisualize", "", "startBlock", "block", "toString", "visualize", "StateFlag", "Zone", "ZoneType", "avail"})
@SourceDebugExtension(value={"SMAP\nL2ControlFlowGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 L2ControlFlowGraph.kt\navail/optimizer/L2ControlFlowGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,426:1\n1855#2:427\n1774#2,4:428\n1856#2:432\n1855#2,2:433\n1726#2,3:435\n1855#2:438\n1774#2,4:439\n1856#2:443\n857#2:444\n1726#2,3:445\n858#2:448\n1855#2,2:449\n1855#2,2:451\n1726#2,3:453\n1855#2,2:456\n*S KotlinDebug\n*F\n+ 1 L2ControlFlowGraph.kt\navail/optimizer/L2ControlFlowGraph\n*L\n249#1:427\n251#1:428,4\n249#1:432\n264#1:433,2\n272#1:435,3\n282#1:438\n284#1:439,4\n282#1:443\n288#1:444\n289#1:445,3\n288#1:448\n292#1:449,2\n301#1:451,2\n309#1:453,3\n348#1:456,2\n*E\n"})
public final class L2ControlFlowGraph {
    @NotNull
    private final Set<KClass<? extends StateFlag>> state;
    @NotNull
    private final List<L2BasicBlock> basicBlockOrder;

    public L2ControlFlowGraph() {
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(StateFlag.IS_SSA.class)};
        this.state = SetsKt.mutableSetOf(kClassArray);
        this.basicBlockOrder = new ArrayList();
    }

    @NotNull
    public final Set<KClass<? extends StateFlag>> getState() {
        return this.state;
    }

    public final void set(@NotNull Collection<? extends KClass<? extends StateFlag>> flags) {
        Intrinsics.checkNotNullParameter(flags, "flags");
        this.state.addAll(flags);
    }

    public final void clear(@NotNull Collection<? extends KClass<? extends StateFlag>> flags) {
        Intrinsics.checkNotNullParameter(flags, "flags");
        this.state.removeAll(flags);
    }

    public final void check(@NotNull Collection<? extends KClass<? extends StateFlag>> flags) {
        Intrinsics.checkNotNullParameter(flags, "flags");
        boolean bl = this.state.containsAll(flags);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    public final void checkNot(@NotNull Collection<? extends KClass<? extends StateFlag>> flags) {
        Intrinsics.checkNotNullParameter(flags, "flags");
        boolean bl = Collections.disjoint((Collection)this.state, flags);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    public final List<L2BasicBlock> getBasicBlockOrder() {
        return this.basicBlockOrder;
    }

    public final void startBlock(@NotNull L2BasicBlock block) {
        Intrinsics.checkNotNullParameter(block, "block");
        boolean bl = block.instructions().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl2 = bl = !this.basicBlockOrder.contains(block);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        if (block.isIrremovable() || !((Collection)block.predecessorEdges()).isEmpty()) {
            this.basicBlockOrder.add(block);
        }
    }

    public final void forwardVisit(@NotNull Function1<? super L2BasicBlock, Unit> action2) {
        boolean bl;
        block11: {
            Intrinsics.checkNotNullParameter(action2, "action");
            Map countdowns = new LinkedHashMap();
            Object $this$forEach$iv = this.basicBlockOrder;
            int $i$f$forEach = 0;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                int n;
                Object element$iv = iterator2.next();
                L2BasicBlock block2 = (L2BasicBlock)element$iv;
                boolean bl2 = false;
                Map map = countdowns;
                Object $this$count$iv = block2.predecessorEdges();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    Iterator iterator3 = $this$count$iv.iterator();
                    while (iterator3.hasNext()) {
                        Object element$iv2 = iterator3.next();
                        L2PcOperand it = (L2PcOperand)element$iv2;
                        boolean bl3 = false;
                        if (!(!it.isBackward()) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                Integer n2 = n;
                $this$count$iv = new Mutable<Integer>(n2);
                map.put(block2, $this$count$iv);
            }
            Object v = countdowns.get(this.basicBlockOrder.get(0));
            Intrinsics.checkNotNull(v);
            $this$forEach$iv = (Mutable)v;
            $i$f$forEach = ((Number)((Mutable)$this$forEach$iv).getValue()).intValue();
            ((Mutable)$this$forEach$iv).setValue($i$f$forEach + 1);
            ArrayDeque<L2BasicBlock> queue = new ArrayDeque<L2BasicBlock>();
            queue.add(this.basicBlockOrder.get(0));
            while (!((Collection)queue).isEmpty()) {
                L2BasicBlock block = (L2BasicBlock)queue.removeFirst();
                Object v2 = countdowns.get(block);
                Intrinsics.checkNotNull(v2);
                Mutable element$iv = (Mutable)v2;
                element$iv.setValue(((Number)element$iv.getValue()).intValue() + -1);
                int countdown = ((Number)element$iv.getValue()).intValue();
                boolean bl4 = element$iv = countdown >= 0;
                if (_Assertions.ENABLED && !element$iv) {
                    String block2 = "Assertion failed";
                    throw new AssertionError((Object)block2);
                }
                if (countdown != 0) continue;
                action2.invoke(block);
                Iterable $this$forEach$iv2 = block.successorEdges();
                boolean $i$f$forEach2 = false;
                for (Object element$iv3 : $this$forEach$iv2) {
                    L2PcOperand edge2 = (L2PcOperand)element$iv3;
                    boolean bl5 = false;
                    if (edge2.isBackward()) continue;
                    queue.add(edge2.targetBlock());
                }
            }
            Iterable $this$all$iv = countdowns.values();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v4 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Mutable it = (Mutable)element$iv;
                    boolean bl6 = false;
                    if (((Number)it.getValue()).intValue() == 0) continue;
                    v4 = false;
                    break block11;
                }
                v4 = bl = true;
            }
        }
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    public final void backwardVisit(@NotNull Function1<? super L2BasicBlock, Unit> action2) {
        boolean bl;
        block17: {
            Iterator it;
            int $i$f$all;
            Object $this$all$iv;
            Intrinsics.checkNotNullParameter(action2, "action");
            Map countdowns = new LinkedHashMap();
            Iterable $this$forEach$iv = this.basicBlockOrder;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int n;
                Iterator block2 = (L2BasicBlock)element$iv;
                boolean bl2 = false;
                Map map = countdowns;
                Object $this$count$iv = ((L2BasicBlock)((Object)block2)).successorEdges();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    Iterator iterator2 = $this$count$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv2 = iterator2.next();
                        L2PcOperand it2 = (L2PcOperand)element$iv2;
                        boolean bl3 = false;
                        if (!(!it2.isBackward()) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                Integer n2 = n;
                $this$count$iv = new Mutable<Integer>(n2);
                map.put(block2, $this$count$iv);
            }
            ArrayDeque<L2BasicBlock> queue = new ArrayDeque<L2BasicBlock>();
            List ends = new ArrayList();
            Iterable $this$filterTo$iv = this.basicBlockOrder;
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                boolean bl4;
                block16: {
                    L2BasicBlock block = (L2BasicBlock)element$iv;
                    boolean bl5 = false;
                    $this$all$iv = block.successorEdges();
                    $i$f$all = 0;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl4 = true;
                    } else {
                        Iterator iterator3 = $this$all$iv.iterator();
                        while (iterator3.hasNext()) {
                            Object element$iv3 = iterator3.next();
                            L2PcOperand it3 = (L2PcOperand)element$iv3;
                            boolean bl6 = false;
                            if (it3.isBackward()) continue;
                            bl4 = false;
                            break block16;
                        }
                        bl4 = true;
                    }
                }
                if (!bl4) continue;
                ((Collection)ends).add(element$iv);
            }
            queue.addAll(ends);
            Iterable $this$forEach$iv2 = ends;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                it = (L2BasicBlock)element$iv;
                boolean bl7 = false;
                Object v = countdowns.get(it);
                Intrinsics.checkNotNull(v);
                $this$all$iv = (Mutable)v;
                $i$f$all = ((Number)((Mutable)$this$all$iv).getValue()).intValue();
                ((Mutable)$this$all$iv).setValue($i$f$all + 1);
            }
            while (!((Collection)queue).isEmpty()) {
                L2BasicBlock block = (L2BasicBlock)queue.removeFirst();
                Object v = countdowns.get(block);
                Intrinsics.checkNotNull(v);
                Mutable block2 = (Mutable)v;
                block2.setValue(((Number)block2.getValue()).intValue() + -1);
                int countdown = ((Number)block2.getValue()).intValue();
                boolean bl8 = block2 = countdown >= 0;
                if (_Assertions.ENABLED && !block2) {
                    String element$iv = "Assertion failed";
                    throw new AssertionError((Object)element$iv);
                }
                if (countdown != 0) continue;
                action2.invoke(block);
                Iterable $this$forEach$iv3 = block.predecessorEdges();
                boolean $i$f$forEach3 = false;
                for (Object element$iv : $this$forEach$iv3) {
                    L2PcOperand edge2 = (L2PcOperand)element$iv;
                    boolean bl9 = false;
                    if (edge2.isBackward()) continue;
                    queue.add(edge2.sourceBlock());
                }
            }
            Iterable $this$all$iv2 = countdowns.values();
            boolean $i$f$all2 = false;
            if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                v5 = true;
            } else {
                for (Object element$iv : $this$all$iv2) {
                    it = (Mutable)element$iv;
                    boolean bl10 = false;
                    if (((Number)((Mutable)((Object)it)).getValue()).intValue() == 0) continue;
                    v5 = false;
                    break block17;
                }
                v5 = bl = true;
            }
        }
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    public final List<L2Register> allRegisters() {
        Set allRegisters = new LinkedHashSet();
        for (L2BasicBlock block : this.basicBlockOrder) {
            for (L2Instruction instruction2 : block.instructions()) {
                allRegisters.addAll((Collection)instruction2.getDestinationRegisters());
            }
        }
        return CollectionsKt.toMutableList(allRegisters);
    }

    public final void evacuateTo(@NotNull L2ControlFlowGraph destinationControlFlowGraph) {
        Intrinsics.checkNotNullParameter(destinationControlFlowGraph, "destinationControlFlowGraph");
        boolean bl = destinationControlFlowGraph.basicBlockOrder.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        destinationControlFlowGraph.basicBlockOrder.addAll((Collection<L2BasicBlock>)this.basicBlockOrder);
        this.basicBlockOrder.clear();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2412 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (L2BasicBlock block : this.basicBlockOrder) {
            $this$toString_u24lambda_u2412.append(block.name());
            $this$toString_u24lambda_u2412.append(":\n");
            Iterable $this$forEach$iv = block.predecessorEdges();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                L2PcOperand edge2 = (L2PcOperand)element$iv;
                boolean bl2 = false;
                $this$toString_u24lambda_u2412.append("\t\tFrom: ");
                L2PcOperand l2PcOperand = edge2;
                Intrinsics.checkNotNull(l2PcOperand);
                $this$toString_u24lambda_u2412.append(l2PcOperand.sourceBlock().name());
                $this$toString_u24lambda_u2412.append("\n\t\t\t[");
                $this$toString_u24lambda_u2412.append("always live-in: ");
                $this$toString_u24lambda_u2412.append(edge2.getAlwaysLiveInRegisters());
                $this$toString_u24lambda_u2412.append(", sometimes live-in: ");
                $this$toString_u24lambda_u2412.append(edge2.getSometimesLiveInRegisters());
                $this$toString_u24lambda_u2412.append("]\n");
            }
            for (L2Instruction instruction2 : block.instructions()) {
                $this$toString_u24lambda_u2412.append("\t");
                $this$toString_u24lambda_u2412.append(Strings.INSTANCE.increaseIndentation(instruction2.toString(), 1));
                $this$toString_u24lambda_u2412.append("\n");
            }
            $this$toString_u24lambda_u2412.append("\n");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public final void generateOn(@NotNull List<L2Instruction> instructions2) {
        Intrinsics.checkNotNullParameter(instructions2, "instructions");
        for (L2BasicBlock block : this.basicBlockOrder) {
            block.generateOn(instructions2);
        }
    }

    @NotNull
    public final String visualize() {
        StringBuilder builder = new StringBuilder();
        boolean bl = false;
        new L2ControlFlowGraphVisualizer("\u00abcontrol flow graph\u00bb", "\u00abchunk\u00bb", 80, this, true, true, true, builder).visualize();
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "let(...)");
        return string2;
    }

    @NotNull
    public final String simplyVisualize() {
        StringBuilder builder = new StringBuilder();
        boolean bl = false;
        new L2ControlFlowGraphVisualizer("\u00abSIMPLE control flow graph\u00bb", "\u00abchunk\u00bb", 80, this, false, false, false, builder).visualize();
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "let(...)");
        return string2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lavail/optimizer/L2ControlFlowGraph$StateFlag;", "", "()V", "HAS_ELIMINATED_PHIS", "IS_EDGE_SPLIT", "IS_SSA", "avail"})
    public static abstract class StateFlag {

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lavail/optimizer/L2ControlFlowGraph$StateFlag$HAS_ELIMINATED_PHIS;", "Lavail/optimizer/L2ControlFlowGraph$StateFlag;", "()V", "avail"})
        public static final class HAS_ELIMINATED_PHIS
        extends StateFlag {
            @NotNull
            public static final HAS_ELIMINATED_PHIS INSTANCE = new HAS_ELIMINATED_PHIS();

            private HAS_ELIMINATED_PHIS() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lavail/optimizer/L2ControlFlowGraph$StateFlag$IS_EDGE_SPLIT;", "Lavail/optimizer/L2ControlFlowGraph$StateFlag;", "()V", "avail"})
        public static final class IS_EDGE_SPLIT
        extends StateFlag {
            @NotNull
            public static final IS_EDGE_SPLIT INSTANCE = new IS_EDGE_SPLIT();

            private IS_EDGE_SPLIT() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lavail/optimizer/L2ControlFlowGraph$StateFlag$IS_SSA;", "Lavail/optimizer/L2ControlFlowGraph$StateFlag;", "()V", "avail"})
        public static final class IS_SSA
        extends StateFlag {
            @NotNull
            public static final IS_SSA INSTANCE = new IS_SSA();

            private IS_SSA() {
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lavail/optimizer/L2ControlFlowGraph$Zone;", "", "zoneType", "Lavail/optimizer/L2ControlFlowGraph$ZoneType;", "zoneName", "", "(Lavail/optimizer/L2ControlFlowGraph$ZoneType;Ljava/lang/String;)V", "getZoneName", "()Ljava/lang/String;", "getZoneType", "()Lavail/optimizer/L2ControlFlowGraph$ZoneType;", "avail"})
    public static final class Zone {
        @NotNull
        private final ZoneType zoneType;
        @NotNull
        private final String zoneName;

        public Zone(@NotNull ZoneType zoneType, @NotNull String zoneName) {
            Intrinsics.checkNotNullParameter((Object)zoneType, "zoneType");
            Intrinsics.checkNotNullParameter(zoneName, "zoneName");
            this.zoneType = zoneType;
            this.zoneName = zoneName;
        }

        @NotNull
        public final ZoneType getZoneType() {
            return this.zoneType;
        }

        @NotNull
        public final String getZoneName() {
            return this.zoneName;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lavail/optimizer/L2ControlFlowGraph$ZoneType;", "", "color", "", "bgcolor", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getBgcolor", "()Ljava/lang/String;", "getColor", "createZone", "Lavail/optimizer/L2ControlFlowGraph$Zone;", "zoneName", "BEGIN_REIFICATION_FOR_INTERRUPT", "BEGIN_REIFICATION_FOR_LABEL", "PROPAGATE_REIFICATION_FOR_INVOKE", "DEAD_END", "MULTI_WAY_EXPANSION", "avail"})
    public static final class ZoneType
    extends Enum<ZoneType> {
        @NotNull
        private final String color;
        @NotNull
        private final String bgcolor;
        public static final /* enum */ ZoneType BEGIN_REIFICATION_FOR_INTERRUPT = new ZoneType("#c0c0ff/505090", "#d8d8ff/282850");
        public static final /* enum */ ZoneType BEGIN_REIFICATION_FOR_LABEL = new ZoneType("#e0d090/604010", "#ffe0b0/302010");
        public static final /* enum */ ZoneType PROPAGATE_REIFICATION_FOR_INVOKE = new ZoneType("#c0e0c0/10a010", "#e0ffe0/103010");
        public static final /* enum */ ZoneType DEAD_END = new ZoneType("#ffc0c0/905050", "#ffd8d8/502828");
        public static final /* enum */ ZoneType MULTI_WAY_EXPANSION = new ZoneType("#ffffc0/909050", "#ffffd8/505028");
        private static final /* synthetic */ ZoneType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ZoneType(String color, String bgcolor) {
            this.color = color;
            this.bgcolor = bgcolor;
        }

        @NotNull
        public final String getColor() {
            return this.color;
        }

        @NotNull
        public final String getBgcolor() {
            return this.bgcolor;
        }

        @NotNull
        public final Zone createZone(@NotNull String zoneName) {
            Intrinsics.checkNotNullParameter(zoneName, "zoneName");
            return new Zone(this, zoneName);
        }

        public static ZoneType[] values() {
            return (ZoneType[])$VALUES.clone();
        }

        public static ZoneType valueOf(String value) {
            return Enum.valueOf(ZoneType.class, value);
        }

        @NotNull
        public static EnumEntries<ZoneType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = zoneTypeArray = new ZoneType[]{ZoneType.BEGIN_REIFICATION_FOR_INTERRUPT, ZoneType.BEGIN_REIFICATION_FOR_LABEL, ZoneType.PROPAGATE_REIFICATION_FOR_INVOKE, ZoneType.DEAD_END, ZoneType.MULTI_WAY_EXPANSION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

