/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer;

import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.character.A_Character;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.methods.A_ChunkDependable;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.DoubleDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ByteTupleDescriptor;
import avail.descriptor.tuples.IntTupleDescriptor;
import avail.descriptor.tuples.LongTupleDescriptor;
import avail.descriptor.tuples.NybbleTupleDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.interpreter.levelTwo.L2Chunk;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2JVMChunk;
import avail.interpreter.levelTwo.L2OperandDispatcher;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2ArbitraryConstantOperand;
import avail.interpreter.levelTwo.operand.L2CommentOperand;
import avail.interpreter.levelTwo.operand.L2ConstantOperand;
import avail.interpreter.levelTwo.operand.L2FloatImmediateOperand;
import avail.interpreter.levelTwo.operand.L2IntImmediateOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2PcVectorOperand;
import avail.interpreter.levelTwo.operand.L2PrimitiveOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2ReadFloatOperand;
import avail.interpreter.levelTwo.operand.L2ReadFloatVectorOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntVectorOperand;
import avail.interpreter.levelTwo.operand.L2ReadOperand;
import avail.interpreter.levelTwo.operand.L2ReadVectorOperand;
import avail.interpreter.levelTwo.operand.L2SelectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteFloatOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operand.L2WriteOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_BOX_FLOAT;
import avail.interpreter.levelTwo.operation.L2_BOX_INT;
import avail.interpreter.levelTwo.operation.L2_CREATE_TUPLE;
import avail.interpreter.levelTwo.operation.L2_FUNCTION_PARAMETER_TYPE;
import avail.interpreter.levelTwo.operation.L2_GET_TYPE;
import avail.interpreter.levelTwo.operation.L2_JUMP;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_COMPARE_INT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_EQUALS_CONSTANT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_KIND_OF_CONSTANT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_KIND_OF_OBJECT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_OBJECTS_EQUAL;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_SUBTYPE_OF_CONSTANT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_SUBTYPE_OF_OBJECT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_UNBOX_FLOAT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_UNBOX_INT;
import avail.interpreter.levelTwo.operation.L2_MAKE_IMMUTABLE;
import avail.interpreter.levelTwo.operation.L2_MOVE;
import avail.interpreter.levelTwo.operation.L2_MOVE_CONSTANT;
import avail.interpreter.levelTwo.operation.L2_RUN_INFALLIBLE_PRIMITIVE;
import avail.interpreter.levelTwo.operation.L2_TUPLE_AT_UPDATE;
import avail.interpreter.levelTwo.operation.L2_UNBOX_FLOAT;
import avail.interpreter.levelTwo.operation.L2_UNBOX_INT;
import avail.interpreter.levelTwo.operation.L2_UNREACHABLE_CODE;
import avail.interpreter.levelTwo.register.L2BoxedRegister;
import avail.interpreter.levelTwo.register.L2FloatRegister;
import avail.interpreter.levelTwo.register.L2IntRegister;
import avail.interpreter.levelTwo.register.L2Register;
import avail.interpreter.primitive.general.P_Equality;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2ControlFlowGraph;
import avail.optimizer.L2Synonym;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.OptimizationLevel;
import avail.optimizer.reoptimizer.L2Regenerator;
import avail.optimizer.values.Frame;
import avail.optimizer.values.L2SemanticConstant;
import avail.optimizer.values.L2SemanticUnboxedFloat;
import avail.optimizer.values.L2SemanticUnboxedInt;
import avail.optimizer.values.L2SemanticValue;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import avail.utility.CollectionExtensionsKt;
import avail.utility.structures.EnumMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\u0018\u0000 \u00a2\u00012\u00020\u0001:\u0006\u00a2\u0001\u00a3\u0001\u00a4\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u0015\u0010.\u001a\u0004\u0018\u00010+2\u0006\u0010/\u001a\u000200\u00a2\u0006\u0002\u00101J)\u0010.\u001a\u0004\u0018\u00010+2\u0006\u00102\u001a\u0002032\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020605\"\u000206\u00a2\u0006\u0002\u00107J\u0006\u00108\u001a\u00020+J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\u0016\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BJ\u001c\u0010=\u001a\u00020>2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020@0D2\u0006\u0010A\u001a\u00020BJ\u000e\u0010E\u001a\u00020>2\u0006\u0010A\u001a\u00020BJ\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010F\u001a\u00020\u00182\u0006\u0010G\u001a\u00020\u0007J\u0018\u0010F\u001a\u00020\u00182\u0006\u0010G\u001a\u00020\u00072\b\u0010H\u001a\u0004\u0018\u00010IJ\u000e\u0010J\u001a\u00020+2\u0006\u0010K\u001a\u00020LJ\u000e\u0010M\u001a\u00020\u00182\u0006\u0010G\u001a\u00020\u0007J\u0014\u0010N\u001a\u00020:2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020:0PJ\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010Q\u001a\u00020RJ\u0010\u0010S\u001a\u0004\u0018\u00010L2\u0006\u0010T\u001a\u00020:J\u0012\u0010U\u001a\u0004\u0018\u00010V2\u0006\u0010W\u001a\u00020:H\u0002J$\u0010X\u001a\n\u0012\u0004\u0012\u00020:\u0018\u00010P2\u0006\u0010Y\u001a\u00020:2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020V0PJ\u0016\u0010[\u001a\u00020:2\u0006\u0010\\\u001a\u00020:2\u0006\u0010]\u001a\u00020)J\u0016\u0010^\u001a\u00020:2\u0006\u0010Y\u001a\u00020:2\u0006\u0010_\u001a\u00020)J(\u0010`\u001a\u00020a2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020b0D2\u0006\u0010A\u001a\u00020B2\n\b\u0002\u0010c\u001a\u0004\u0018\u00010dJ\u000e\u0010e\u001a\u00020a2\u0006\u0010A\u001a\u00020BJ'\u0010f\u001a\u00020+2\u0006\u0010g\u001a\u00020h2\u0017\u0010i\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020+0j\u00a2\u0006\u0002\bkJ(\u0010l\u001a\u00020m2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020n0D2\u0006\u0010A\u001a\u00020B2\n\b\u0002\u0010c\u001a\u0004\u0018\u00010oJ\u000e\u0010p\u001a\u00020m2\u0006\u0010A\u001a\u00020BJ&\u0010q\u001a\u00020+2\u0006\u0010r\u001a\u00020:2\u0006\u0010s\u001a\u00020<2\u0006\u0010t\u001a\u00020\u00182\u0006\u0010u\u001a\u00020\u0018J&\u0010v\u001a\u00020+2\u0006\u0010w\u001a\u00020:2\u0006\u0010x\u001a\u00020V2\u0006\u0010y\u001a\u00020\u00182\u0006\u0010z\u001a\u00020\u0018J\u001a\u0010{\u001a\u00020+2\u0006\u0010|\u001a\u00020\u00182\n\b\u0002\u0010}\u001a\u0004\u0018\u00010\u0007J\u000e\u0010~\u001a\u00020:2\u0006\u0010\u007f\u001a\u00020:J\u008b\u0001\u0010\u0080\u0001\u001a\u00020+\"\n\b\u0000\u0010\u0081\u0001*\u00030\u0082\u0001\"\u0011\b\u0001\u0010\u0083\u0001*\n\u0012\u0005\u0012\u0003H\u0081\u00010\u0084\u0001\"\u0011\b\u0002\u0010\u0085\u0001*\n\u0012\u0005\u0012\u0003H\u0081\u00010\u0086\u0001\"\u0018\b\u0003\u0010\u0087\u0001*\u0011\u0012\u0005\u0012\u0003H\u0081\u0001\u0012\u0005\u0012\u0003H\u0083\u00010\u0088\u00012$\u0010\u0089\u0001\u001a\u001f\u0012\u0005\u0012\u0003H\u0081\u0001\u0012\u0005\u0012\u0003H\u0083\u0001\u0012\u0005\u0012\u0003H\u0085\u0001\u0012\u0005\u0012\u0003H\u0087\u00010\u008a\u00012\u0007\u0010\u008b\u0001\u001a\u00020@2\u0007\u0010\u008c\u0001\u001a\u00020@J\u0007\u0010\u008d\u0001\u001a\u00020@J\u0007\u0010\u008e\u0001\u001a\u00020)J\u0010\u0010\u008f\u0001\u001a\u00020:2\u0007\u0010\u0090\u0001\u001a\u00020>J\u000f\u0010\u008f\u0001\u001a\u00020:2\u0006\u0010?\u001a\u00020@J\u001a\u0010\u0091\u0001\u001a\u00030\u0092\u00012\u0007\u0010\u0093\u0001\u001a\u00020b2\u0007\u0010\u0094\u0001\u001a\u00020\u0018J\u001a\u0010\u0095\u0001\u001a\u00030\u0096\u00012\u0007\u0010\u0093\u0001\u001a\u00020n2\u0007\u0010\u0094\u0001\u001a\u00020\u0018J\u0007\u0010\u0097\u0001\u001a\u00020\u0007J)\u0010\u0098\u0001\u001a\u00020+2\u0007\u0010\u0099\u0001\u001a\u00020\u00182\t\b\u0002\u0010\u009a\u0001\u001a\u00020R2\f\b\u0002\u0010\u009b\u0001\u001a\u0005\u0018\u00010\u009c\u0001J\u0013\u0010\u009d\u0001\u001a\u00030\u0092\u00012\u0007\u0010;\u001a\u00030\u009e\u0001H\u0002J\u0010\u0010\u009f\u0001\u001a\u00030\u0096\u00012\u0006\u0010;\u001a\u00020)J\u0007\u0010\u00a0\u0001\u001a\u00020hJ\u0007\u0010\u00a1\u0001\u001a\u00020\u0007R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001d\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00180\"\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a5\u0001"}, d2={"Lavail/optimizer/L2Generator;", "", "optimizationLevel", "Lavail/optimizer/OptimizationLevel;", "topFrame", "Lavail/optimizer/values/Frame;", "codeName", "", "(Lavail/optimizer/OptimizationLevel;Lavail/optimizer/values/Frame;Ljava/lang/String;)V", "chunk", "Lavail/interpreter/levelTwo/L2Chunk;", "getCodeName", "()Ljava/lang/String;", "contingentValues", "Lavail/descriptor/sets/A_Set;", "getContingentValues", "()Lavail/descriptor/sets/A_Set;", "setContingentValues", "(Lavail/descriptor/sets/A_Set;)V", "controlFlowGraph", "Lavail/optimizer/L2ControlFlowGraph;", "getControlFlowGraph", "()Lavail/optimizer/L2ControlFlowGraph;", "currentBlock", "Lavail/optimizer/L2BasicBlock;", "currentManifest", "Lavail/optimizer/L2ValueManifest;", "getCurrentManifest", "()Lavail/optimizer/L2ValueManifest;", "setCurrentManifest", "(Lavail/optimizer/L2ValueManifest;)V", "getOptimizationLevel", "()Lavail/optimizer/OptimizationLevel;", "specialBlocks", "Lavail/utility/structures/EnumMap;", "Lavail/optimizer/L2Generator$SpecialBlock;", "getSpecialBlocks", "()Lavail/utility/structures/EnumMap;", "getTopFrame", "()Lavail/optimizer/values/Frame;", "uniqueCounter", "", "addContingentValue", "", "contingentValue", "Lavail/descriptor/methods/A_ChunkDependable;", "addInstruction", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "(Lavail/interpreter/levelTwo/L2Instruction;)Lkotlin/Unit;", "operation", "Lavail/interpreter/levelTwo/L2Operation;", "operands", "", "Lavail/interpreter/levelTwo/operand/L2Operand;", "(Lavail/interpreter/levelTwo/L2Operation;[Lavail/interpreter/levelTwo/operand/L2Operand;)Lkotlin/Unit;", "addUnreachableCode", "boxedConstant", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "value", "Lavail/descriptor/representation/A_BasicObject;", "boxedWrite", "Lavail/interpreter/levelTwo/operand/L2WriteBoxedOperand;", "semanticValue", "Lavail/optimizer/values/L2SemanticValue;", "restriction", "Lavail/interpreter/levelTwo/operand/TypeRestriction;", "semanticValues", "", "boxedWriteTemp", "createBasicBlock", "name", "zone", "Lavail/optimizer/L2ControlFlowGraph$Zone;", "createChunk", "code", "Lavail/descriptor/functions/A_RawFunction;", "createLoopHeadBlock", "createTuple", "elements", "", "currentlyReachable", "", "determineRawFunction", "functionToCallReg", "exactFunctionSignatureFor", "Lavail/descriptor/types/A_Type;", "functionReg", "explodeTupleIfPossible", "tupleReg", "requiredTypes", "extractParameterTypeFromFunction", "functionRead", "parameterIndex", "extractTupleElement", "index", "floatWrite", "Lavail/interpreter/levelTwo/operand/L2WriteFloatOperand;", "Lavail/optimizer/values/L2SemanticUnboxedFloat;", "forceRegister", "Lavail/interpreter/levelTwo/register/L2FloatRegister;", "floatWriteTemp", "generateRetroactivelyBeforeEdge", "edge", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "body", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "intWrite", "Lavail/interpreter/levelTwo/operand/L2WriteIntOperand;", "Lavail/optimizer/values/L2SemanticUnboxedInt;", "Lavail/interpreter/levelTwo/register/L2IntRegister;", "intWriteTemp", "jumpIfEqualsConstant", "registerToTest", "constantValue", "passBlock", "failBlock", "jumpIfKindOfConstant", "valueRead", "expectedType", "passedCheck", "failedCheck", "jumpTo", "targetBlock", "optionalName", "makeImmutable", "read", "moveRegister", "R", "Lavail/interpreter/levelTwo/register/L2Register;", "RR", "Lavail/interpreter/levelTwo/operand/L2ReadOperand;", "WR", "Lavail/interpreter/levelTwo/operand/L2WriteOperand;", "RV", "Lavail/interpreter/levelTwo/operand/L2ReadVectorOperand;", "moveOperation", "Lavail/interpreter/levelTwo/operation/L2_MOVE;", "sourceSemanticValue", "targetSemanticValue", "newTemp", "nextUnique", "readBoxed", "write", "readFloat", "Lavail/interpreter/levelTwo/operand/L2ReadFloatOperand;", "semanticUnboxed", "onFailure", "readInt", "Lavail/interpreter/levelTwo/operand/L2ReadIntOperand;", "simplyVisualize", "startBlock", "block", "generatePhis", "regenerator", "Lavail/optimizer/reoptimizer/L2Regenerator;", "unboxedFloatConstant", "", "unboxedIntConstant", "unreachablePcOperand", "visualize", "Companion", "RegisterCounter", "SpecialBlock", "avail"})
@SourceDebugExtension(value={"SMAP\nL2Generator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 L2Generator.kt\navail/optimizer/L2Generator\n+ 2 EnumMap.kt\navail/utility/structures/EnumMap$Companion\n+ 3 CollectionExtensions.kt\navail/utility/CollectionExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Casts.kt\navail/utility/CastsKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1862:1\n209#2:1863\n79#3,4:1864\n79#3,4:1871\n1620#4,3:1868\n1620#4,3:1875\n1855#4,2:1878\n1360#4:1881\n1446#4,5:1882\n766#4:1887\n857#4,2:1888\n1549#4:1890\n1620#4,2:1891\n1622#4:1894\n1963#4,14:1895\n1789#4,3:1909\n1549#4:1912\n1620#4,3:1913\n1726#4,3:1916\n1549#4:1919\n1620#4,3:1920\n1549#4:1923\n1620#4,3:1924\n1864#4,3:1927\n1549#4:1930\n1620#4,3:1931\n1855#4,2:1934\n1855#4:1938\n1856#4:1941\n46#5:1880\n46#5:1893\n72#5:1936\n59#5:1937\n13309#6,2:1939\n*S KotlinDebug\n*F\n+ 1 L2Generator.kt\navail/optimizer/L2Generator\n*L\n229#1:1863\n569#1:1864,4\n585#1:1871,4\n569#1:1868,3\n585#1:1875,3\n649#1:1878,2\n818#1:1881\n818#1:1882,5\n819#1:1887\n819#1:1888,2\n820#1:1890\n820#1:1891,2\n820#1:1894\n824#1:1895,14\n930#1:1909,3\n952#1:1912\n952#1:1913,3\n975#1:1916,3\n982#1:1919\n982#1:1920,3\n1002#1:1923\n1002#1:1924,3\n1004#1:1927,3\n1104#1:1930\n1104#1:1931,3\n1222#1:1934,2\n1678#1:1938\n1678#1:1941\n755#1:1880\n820#1:1893\n1237#1:1936\n1280#1:1937\n1679#1:1939,2\n*E\n"})
public final class L2Generator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OptimizationLevel optimizationLevel;
    @NotNull
    private final Frame topFrame;
    @NotNull
    private final String codeName;
    @NotNull
    private final EnumMap<SpecialBlock, L2BasicBlock> specialBlocks;
    @NotNull
    private A_Set contingentValues;
    private int uniqueCounter;
    @Nullable
    private L2Chunk chunk;
    @Nullable
    private L2BasicBlock currentBlock;
    @NotNull
    private L2ValueManifest currentManifest;
    @NotNull
    private final L2ControlFlowGraph controlFlowGraph;
    public static final int maxPolymorphismToInlineDispatch = 8;
    public static final int maxExpandedEqualityChecks = 3;
    @NotNull
    private static final Statistic finalGenerationStat = new Statistic(StatisticReport.L2_OPTIMIZATION_TIME, "Final chunk generation");

    public L2Generator(@NotNull OptimizationLevel optimizationLevel, @NotNull Frame topFrame, @NotNull String codeName) {
        Intrinsics.checkNotNullParameter((Object)optimizationLevel, "optimizationLevel");
        Intrinsics.checkNotNullParameter(topFrame, "topFrame");
        Intrinsics.checkNotNullParameter(codeName, "codeName");
        this.optimizationLevel = optimizationLevel;
        this.topFrame = topFrame;
        this.codeName = codeName;
        EnumMap.Companion this_$iv = EnumMap.Companion;
        boolean $i$f$enumMap = false;
        T[] TArray = SpecialBlock.class.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(TArray, "getEnumConstants(...)");
        this.specialBlocks = new EnumMap((Enum[])TArray);
        this.contingentValues = SetDescriptor.Companion.getEmptySet();
        this.currentManifest = new L2ValueManifest();
        this.controlFlowGraph = new L2ControlFlowGraph();
    }

    @NotNull
    public final OptimizationLevel getOptimizationLevel() {
        return this.optimizationLevel;
    }

    @NotNull
    public final Frame getTopFrame() {
        return this.topFrame;
    }

    @NotNull
    public final String getCodeName() {
        return this.codeName;
    }

    @NotNull
    public final EnumMap<SpecialBlock, L2BasicBlock> getSpecialBlocks() {
        return this.specialBlocks;
    }

    @NotNull
    public final A_Set getContingentValues() {
        return this.contingentValues;
    }

    public final void setContingentValues(@NotNull A_Set a_Set) {
        Intrinsics.checkNotNullParameter(a_Set, "<set-?>");
        this.contingentValues = a_Set;
    }

    public final int nextUnique() {
        int n = this.uniqueCounter;
        this.uniqueCounter = n + 1;
        return n;
    }

    @NotNull
    public final L2ValueManifest getCurrentManifest() {
        return this.currentManifest;
    }

    public final void setCurrentManifest(@NotNull L2ValueManifest l2ValueManifest) {
        Intrinsics.checkNotNullParameter(l2ValueManifest, "<set-?>");
        this.currentManifest = l2ValueManifest;
    }

    @NotNull
    public final L2ControlFlowGraph getControlFlowGraph() {
        return this.controlFlowGraph;
    }

    public final void addUnreachableCode() {
        this.addInstruction(L2_UNREACHABLE_CODE.INSTANCE, new L2Operand[0]);
    }

    @NotNull
    public final L2PcOperand unreachablePcOperand() {
        L2BasicBlock unreachableBlock = this.specialBlocks.getOrNull((SpecialBlock)((Enum)SpecialBlock.UNREACHABLE));
        if (unreachableBlock == null) {
            unreachableBlock = this.createBasicBlock("UNREACHABLE");
            this.specialBlocks.set((SpecialBlock)((Enum)SpecialBlock.UNREACHABLE), unreachableBlock);
        }
        L2BasicBlock it = unreachableBlock;
        boolean bl = false;
        return it.isLoopHead() ? Companion.backEdgeTo(it) : avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, it, null, 2, null);
    }

    @NotNull
    public final L2SemanticValue newTemp() {
        return this.topFrame.temp(this.nextUnique());
    }

    @NotNull
    public final L2WriteBoxedOperand boxedWriteTemp(@NotNull TypeRestriction restriction2) {
        Intrinsics.checkNotNullParameter(restriction2, "restriction");
        return this.boxedWrite(this.newTemp(), restriction2);
    }

    @NotNull
    public final L2WriteBoxedOperand boxedWrite(@NotNull Set<? extends L2SemanticValue> semanticValues, @NotNull TypeRestriction restriction2) {
        Intrinsics.checkNotNullParameter(semanticValues, "semanticValues");
        Intrinsics.checkNotNullParameter(restriction2, "restriction");
        boolean bl = restriction2.isBoxed();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return new L2WriteBoxedOperand(semanticValues, restriction2, new L2BoxedRegister(this.nextUnique()));
    }

    @NotNull
    public final L2WriteBoxedOperand boxedWrite(@NotNull L2SemanticValue semanticValue, @NotNull TypeRestriction restriction2) {
        Intrinsics.checkNotNullParameter(semanticValue, "semanticValue");
        Intrinsics.checkNotNullParameter(restriction2, "restriction");
        return this.boxedWrite(SetsKt.setOf(semanticValue), restriction2);
    }

    @NotNull
    public final L2WriteIntOperand intWriteTemp(@NotNull TypeRestriction restriction2) {
        Intrinsics.checkNotNullParameter(restriction2, "restriction");
        return L2Generator.intWrite$default(this, SetsKt.setOf(new L2SemanticUnboxedInt(this.newTemp())), restriction2, null, 4, null);
    }

    @NotNull
    public final L2WriteIntOperand intWrite(@NotNull Set<L2SemanticUnboxedInt> semanticValues, @NotNull TypeRestriction restriction2, @Nullable L2IntRegister forceRegister) {
        Intrinsics.checkNotNullParameter(semanticValues, "semanticValues");
        Intrinsics.checkNotNullParameter(restriction2, "restriction");
        boolean bl = restriction2.isUnboxedInt();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2IntRegister l2IntRegister = forceRegister;
        if (l2IntRegister == null) {
            l2IntRegister = new L2IntRegister(this.nextUnique());
        }
        return new L2WriteIntOperand(semanticValues, restriction2, l2IntRegister);
    }

    public static /* synthetic */ L2WriteIntOperand intWrite$default(L2Generator l2Generator, Set set2, TypeRestriction typeRestriction, L2IntRegister l2IntRegister, int n, Object object) {
        if ((n & 4) != 0) {
            l2IntRegister = null;
        }
        return l2Generator.intWrite(set2, typeRestriction, l2IntRegister);
    }

    @NotNull
    public final L2WriteFloatOperand floatWriteTemp(@NotNull TypeRestriction restriction2) {
        Intrinsics.checkNotNullParameter(restriction2, "restriction");
        return L2Generator.floatWrite$default(this, SetsKt.setOf(new L2SemanticUnboxedFloat(this.newTemp())), restriction2, null, 4, null);
    }

    @NotNull
    public final L2WriteFloatOperand floatWrite(@NotNull Set<L2SemanticUnboxedFloat> semanticValues, @NotNull TypeRestriction restriction2, @Nullable L2FloatRegister forceRegister) {
        Intrinsics.checkNotNullParameter(semanticValues, "semanticValues");
        Intrinsics.checkNotNullParameter(restriction2, "restriction");
        boolean bl = restriction2.isUnboxedFloat();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2FloatRegister l2FloatRegister = forceRegister;
        if (l2FloatRegister == null) {
            l2FloatRegister = new L2FloatRegister(this.nextUnique());
        }
        return new L2WriteFloatOperand(semanticValues, restriction2, l2FloatRegister);
    }

    public static /* synthetic */ L2WriteFloatOperand floatWrite$default(L2Generator l2Generator, Set set2, TypeRestriction typeRestriction, L2FloatRegister l2FloatRegister, int n, Object object) {
        if ((n & 4) != 0) {
            l2FloatRegister = null;
        }
        return l2Generator.floatWrite(set2, typeRestriction, l2FloatRegister);
    }

    @NotNull
    public final L2ReadBoxedOperand boxedConstant(@NotNull A_BasicObject value) {
        TypeRestriction restriction2;
        Intrinsics.checkNotNullParameter(value, "value");
        L2SemanticValue semanticConstant = L2SemanticValue.Companion.constant(value);
        if (this.currentManifest.hasSemanticValue(semanticConstant) && (restriction2 = this.currentManifest.restrictionFor(semanticConstant)).isBoxed() && restriction2.isImmutable()) {
            return this.readBoxed(semanticConstant);
        }
        restriction2 = TypeRestriction.Companion.restrictionForConstant(value, TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG);
        L2Operand[] l2OperandArray = new L2Operand[]{new L2ConstantOperand(value), this.boxedWrite(semanticConstant, restriction2)};
        this.addInstruction(L2_MOVE_CONSTANT.boxed, l2OperandArray);
        return this.readBoxed(semanticConstant);
    }

    @NotNull
    public final L2ReadIntOperand unboxedIntConstant(int value) {
        A_Number boxedValue = IntegerDescriptor.Companion.fromInt(value);
        L2SemanticValue semanticConstant = L2SemanticValue.Companion.constant(boxedValue);
        L2SemanticUnboxedInt semanticUnboxedValue = new L2SemanticUnboxedInt(semanticConstant);
        if (this.currentManifest.hasSemanticValue(semanticUnboxedValue)) {
            return this.currentManifest.readInt(semanticUnboxedValue);
        }
        Set<L2SemanticUnboxedInt> unboxedSet = SetsKt.setOf(semanticUnboxedValue);
        L2Synonym synonym = new L2Synonym((Collection<? extends L2SemanticValue>)unboxedSet);
        TypeRestriction restriction2 = TypeRestriction.Companion.restrictionForConstant(boxedValue, TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG);
        this.currentManifest.introduceSynonym(synonym, restriction2);
        L2Operand[] l2OperandArray = new L2Operand[]{new L2IntImmediateOperand(value), L2Generator.intWrite$default(this, unboxedSet, restriction2, null, 4, null)};
        this.addInstruction(L2_MOVE_CONSTANT.unboxedInt, l2OperandArray);
        return new L2ReadIntOperand((L2SemanticValue)semanticUnboxedValue, restriction2, this.currentManifest);
    }

    private final L2ReadFloatOperand unboxedFloatConstant(double value) {
        A_Number boxedValue = DoubleDescriptor.Companion.fromDouble(value);
        L2SemanticValue semanticConstant = L2SemanticValue.Companion.constant(boxedValue);
        L2SemanticUnboxedFloat semanticUnboxedValue = new L2SemanticUnboxedFloat(semanticConstant);
        if (this.currentManifest.hasSemanticValue(semanticUnboxedValue)) {
            return this.currentManifest.readFloat(semanticUnboxedValue);
        }
        Set<L2SemanticUnboxedFloat> unboxedSet = SetsKt.setOf(semanticUnboxedValue);
        L2Synonym synonym = new L2Synonym((Collection<? extends L2SemanticValue>)unboxedSet);
        TypeRestriction restriction2 = TypeRestriction.Companion.restrictionForConstant(boxedValue, TypeRestriction.RestrictionFlagEncoding.UNBOXED_FLOAT_FLAG);
        this.currentManifest.introduceSynonym(synonym, restriction2);
        L2Operand[] l2OperandArray = new L2Operand[]{new L2FloatImmediateOperand(value), L2Generator.floatWrite$default(this, unboxedSet, restriction2, null, 4, null)};
        this.addInstruction(L2_MOVE_CONSTANT.Companion.getUnboxedFloat(), l2OperandArray);
        return new L2ReadFloatOperand((L2SemanticValue)semanticUnboxedValue, restriction2, this.currentManifest);
    }

    @NotNull
    public final L2ReadBoxedOperand readBoxed(@NotNull L2WriteBoxedOperand write2) {
        Intrinsics.checkNotNullParameter(write2, "write");
        return this.currentManifest.readBoxed(write2.pickSemanticValue());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final L2ReadBoxedOperand readBoxed(@NotNull L2SemanticValue semanticValue) {
        boolean bl;
        Intrinsics.checkNotNullParameter(semanticValue, "semanticValue");
        boolean bl2 = bl = !(semanticValue instanceof L2SemanticUnboxedInt);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = !(semanticValue instanceof L2SemanticUnboxedFloat);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        if (this.currentManifest.hasSemanticValue(semanticValue)) {
            return this.currentManifest.readBoxed(semanticValue);
        }
        L2SemanticUnboxedInt unboxedInt2 = new L2SemanticUnboxedInt(semanticValue);
        if (this.currentManifest.hasSemanticValue(unboxedInt2)) {
            L2Operand[] $this$mapToSet_u24default$iv;
            TypeRestriction restriction2 = this.currentManifest.restrictionFor(unboxedInt2);
            Iterable iterable = this.currentManifest.semanticValueToSynonym(unboxedInt2).semanticValues();
            Set destination$iv = new LinkedHashSet();
            boolean $i$f$mapToSet = false;
            void $this$mapTo$iv$iv = $this$mapToSet_u24default$iv;
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                L2SemanticValue l2SemanticValue = (L2SemanticValue)item$iv$iv;
                Collection collection2 = destination$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type avail.optimizer.values.L2SemanticUnboxedInt");
                collection2.add(((L2SemanticUnboxedInt)it).getBase());
            }
            L2BoxedRegister l2BoxedRegister = new L2BoxedRegister(this.nextUnique());
            TypeRestriction typeRestriction = restriction2.forBoxed();
            Set set2 = (Set)((Collection)destination$iv);
            L2WriteBoxedOperand writer = new L2WriteBoxedOperand((Set<? extends L2SemanticValue>)set2, typeRestriction, l2BoxedRegister);
            $this$mapToSet_u24default$iv = new L2Operand[]{this.currentManifest.readInt(unboxedInt2), writer};
            this.addInstruction(L2_BOX_INT.INSTANCE, $this$mapToSet_u24default$iv);
            return this.currentManifest.readBoxed(semanticValue);
        }
        L2SemanticUnboxedFloat unboxedFloat2 = new L2SemanticUnboxedFloat(semanticValue);
        if (this.currentManifest.hasSemanticValue(unboxedFloat2)) {
            void $this$mapToSet_u24default$iv;
            TypeRestriction restriction3 = this.currentManifest.restrictionFor(unboxedFloat2);
            Iterable destination$iv = this.currentManifest.semanticValueToSynonym(unboxedFloat2).semanticValues();
            Set destination$iv2 = new LinkedHashSet();
            boolean $i$f$mapToSet = false;
            void $this$mapTo$iv$iv = $this$mapToSet_u24default$iv;
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                L2SemanticValue bl4 = (L2SemanticValue)item$iv$iv;
                Collection collection3 = destination$iv2;
                boolean bl5 = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type avail.optimizer.values.L2SemanticUnboxedFloat");
                collection3.add(((L2SemanticUnboxedFloat)it).getBase());
            }
            L2BoxedRegister l2BoxedRegister = new L2BoxedRegister(this.nextUnique());
            TypeRestriction typeRestriction = restriction3.forBoxed();
            Set set3 = (Set)((Collection)destination$iv2);
            L2WriteBoxedOperand writer = new L2WriteBoxedOperand((Set<? extends L2SemanticValue>)set3, typeRestriction, l2BoxedRegister);
            L2Operand[] l2OperandArray = new L2Operand[]{this.currentManifest.readFloat(unboxedFloat2), writer};
            this.addInstruction(L2_BOX_FLOAT.INSTANCE, l2OperandArray);
            return this.currentManifest.readBoxed(semanticValue);
        }
        throw new IllegalStateException("Boxed value not available, even from unboxed versions".toString());
    }

    @NotNull
    public final L2ReadIntOperand readInt(@NotNull L2SemanticUnboxedInt semanticUnboxed, @NotNull L2BasicBlock onFailure) {
        L2Operand[] constant;
        Intrinsics.checkNotNullParameter(semanticUnboxed, "semanticUnboxed");
        Intrinsics.checkNotNullParameter(onFailure, "onFailure");
        if (this.currentManifest.hasSemanticValue(semanticUnboxed)) {
            return this.currentManifest.readInt(semanticUnboxed);
        }
        for (L2SemanticValue l2SemanticValue : this.currentManifest.semanticValueToSynonym(semanticUnboxed.getBase()).semanticValues()) {
            L2SemanticUnboxedInt otherUnboxed = new L2SemanticUnboxedInt(l2SemanticValue);
            if (!this.currentManifest.hasSemanticValue(otherUnboxed)) continue;
            return this.currentManifest.readInt(otherUnboxed);
        }
        L2SemanticValue semanticBoxed = semanticUnboxed.getBase();
        Iterable iterable = this.currentManifest.semanticValueToSynonym(semanticBoxed).semanticValues();
        boolean $i$f$forEach232 = false;
        for (Object element$iv : iterable) {
            L2SemanticValue equivalentBoxedSemanticValue = (L2SemanticValue)element$iv;
            boolean bl = false;
            L2SemanticUnboxedInt equivalentUnboxed = new L2SemanticUnboxedInt(equivalentBoxedSemanticValue);
            if (!this.currentManifest.hasSemanticValue(equivalentUnboxed)) continue;
            this.moveRegister(L2_MOVE.Companion.getUnboxedInt(), equivalentUnboxed, semanticUnboxed);
            return this.currentManifest.readInt(semanticUnboxed);
        }
        TypeRestriction typeRestriction = this.currentManifest.restrictionFor(semanticBoxed);
        if (!typeRestriction.intersectsType(IntegerRangeTypeDescriptor.Companion.getI32())) {
            L2Generator.jumpTo$default(this, onFailure, null, 2, null);
            return this.unboxedIntConstant(-999);
        }
        L2Operand[] $i$f$forEach232 = typeRestriction.getConstantOrNull();
        if ($i$f$forEach232 != null) {
            constant = $i$f$forEach232;
            boolean bl = false;
            return this.unboxedIntConstant(A_Number.Companion.getExtractInt((A_Number)constant));
        }
        L2WriteIntOperand intWrite = new L2WriteIntOperand(SetsKt.setOf(semanticUnboxed), typeRestriction.forUnboxedInt(), new L2IntRegister(this.nextUnique()));
        L2ReadBoxedOperand boxedRead = this.currentManifest.readBoxed(semanticBoxed);
        if (typeRestriction.containedByType(IntegerRangeTypeDescriptor.Companion.getI32())) {
            constant = new L2Operand[]{boxedRead, intWrite};
            this.addInstruction(L2_UNBOX_INT.INSTANCE, constant);
        } else {
            L2BasicBlock onSuccess = this.createBasicBlock("successfully unboxed");
            L2Operand[] l2OperandArray = new L2Operand[]{boxedRead, intWrite, avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, onFailure, null, 2, null), avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, onSuccess, null, 2, null)};
            this.addInstruction(L2_JUMP_IF_UNBOX_INT.INSTANCE, l2OperandArray);
            L2Generator.startBlock$default(this, onSuccess, false, null, 6, null);
        }
        return this.currentManifest.readInt(semanticUnboxed);
    }

    @NotNull
    public final L2ReadFloatOperand readFloat(@NotNull L2SemanticUnboxedFloat semanticUnboxed, @NotNull L2BasicBlock onFailure) {
        Intrinsics.checkNotNullParameter(semanticUnboxed, "semanticUnboxed");
        Intrinsics.checkNotNullParameter(onFailure, "onFailure");
        if (this.currentManifest.hasSemanticValue(semanticUnboxed)) {
            return this.currentManifest.readFloat(semanticUnboxed);
        }
        L2SemanticValue semanticBoxed = semanticUnboxed.getBase();
        TypeRestriction restriction2 = this.currentManifest.restrictionFor(semanticBoxed);
        if (!restriction2.intersectsType(PrimitiveTypeDescriptor.Types.DOUBLE.getO())) {
            L2Generator.jumpTo$default(this, onFailure, null, 2, null);
            return this.unboxedFloatConstant(-99.9);
        }
        AvailObject availObject = restriction2.getConstantOrNull();
        if (availObject != null) {
            AvailObject constant = availObject;
            boolean bl = false;
            return this.unboxedFloatConstant(A_Number.Companion.getExtractDouble(constant));
        }
        Set<L2SemanticValue> $this$cast$iv = this.currentManifest.semanticValueToSynonym(semanticUnboxed).semanticValues();
        boolean $i$f$cast2 = false;
        L2WriteFloatOperand floatWrite = new L2WriteFloatOperand($this$cast$iv, restriction2.intersectionWithType(PrimitiveTypeDescriptor.Types.DOUBLE.getO()).withFlag(TypeRestriction.RestrictionFlagEncoding.UNBOXED_FLOAT_FLAG), new L2FloatRegister(this.nextUnique()));
        L2ReadBoxedOperand boxedRead = this.currentManifest.readBoxed(semanticBoxed);
        if (restriction2.containedByType(PrimitiveTypeDescriptor.Types.DOUBLE.getO())) {
            L2Operand[] $i$f$cast2 = new L2Operand[]{boxedRead, floatWrite};
            this.addInstruction(L2_UNBOX_FLOAT.INSTANCE, $i$f$cast2);
        } else {
            L2BasicBlock onSuccess = this.createBasicBlock("successfully unboxed");
            L2Operand[] l2OperandArray = new L2Operand[]{boxedRead, floatWrite, avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, onFailure, null, 2, null), avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, onSuccess, null, 2, null)};
            this.addInstruction(L2_JUMP_IF_UNBOX_FLOAT.INSTANCE, l2OperandArray);
            L2Generator.startBlock$default(this, onSuccess, false, null, 6, null);
        }
        return this.currentManifest.readFloat(semanticUnboxed);
    }

    /*
     * WARNING - void declaration
     */
    public final <R extends L2Register, RR extends L2ReadOperand<R>, WR extends L2WriteOperand<R>, RV extends L2ReadVectorOperand<R, RR>> void moveRegister(@NotNull L2_MOVE<R, RR, WR, RV> moveOperation, @NotNull L2SemanticValue sourceSemanticValue, @NotNull L2SemanticValue targetSemanticValue) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        L2WriteOperand it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        L2Register p0;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter(moveOperation, "moveOperation");
        Intrinsics.checkNotNullParameter(sourceSemanticValue, "sourceSemanticValue");
        Intrinsics.checkNotNullParameter(targetSemanticValue, "targetSemanticValue");
        boolean bl2 = bl = !this.currentManifest.hasSemanticValue(targetSemanticValue);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2BasicBlock block = this.currentBlock();
        List sourceRegisters = this.currentManifest.getDefinitions(sourceSemanticValue);
        Iterable iterable = sourceRegisters;
        boolean $i$f$flatMap = false;
        void var9_13 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            p0 = (L2Register)element$iv$iv;
            boolean bl3 = false;
            Iterable list$iv$iv = p0.definitions();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (L2WriteOperand)element$iv$iv;
            boolean bl4 = false;
            if (!Intrinsics.areEqual(it.getInstruction().basicBlock(), block)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (L2WriteOperand)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl5 = false;
            L2Register $this$cast$iv = p0;
            boolean $i$f$cast = false;
            collection2.add($this$cast$iv);
        }
        List sourceWritesInBlock = (List)destination$iv$iv;
        if (!((Collection)sourceWritesInBlock).isEmpty()) {
            Object v1;
            Iterable $this$maxByOrNull$iv = sourceWritesInBlock;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    L2WriteOperand it2 = (L2WriteOperand)maxElem$iv;
                    boolean bl6 = false;
                    L2WriteOperand l2WriteOperand = it2;
                    Intrinsics.checkNotNull(l2WriteOperand);
                    int maxValue$iv = l2WriteOperand.getInstruction().basicBlock().instructions().indexOf(it2.getInstruction());
                    do {
                        Object e$iv = iterator$iv.next();
                        L2WriteOperand it3 = (L2WriteOperand)e$iv;
                        $i$a$-maxByOrNull-L2Generator$moveRegister$latestWrite$1 = false;
                        L2WriteOperand l2WriteOperand2 = it3;
                        Intrinsics.checkNotNull(l2WriteOperand2);
                        int v$iv = l2WriteOperand2.getInstruction().basicBlock().instructions().indexOf(it3.getInstruction());
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v1);
            L2WriteOperand latestWrite = v1;
            if (!latestWrite.getInstruction().getOperation().isPhi() && 0 <= ($this$maxByOrNull$iv = block.instructions().size() + -1)) {
                do {
                    int i2 = $this$maxByOrNull$iv--;
                    L2Instruction eachInstruction = block.instructions().get(i2);
                    if (!Intrinsics.areEqual(eachInstruction, latestWrite.getInstruction())) continue;
                    L2SemanticValue pickedSemanticValue = latestWrite.pickSemanticValue();
                    latestWrite.retroactivelyIncludeSemanticValue(targetSemanticValue);
                    this.currentManifest.extendSynonym(this.currentManifest.semanticValueToSynonym(pickedSemanticValue), targetSemanticValue);
                    return;
                } while (0 <= $this$maxByOrNull$iv);
            }
        }
        TypeRestriction restriction2 = this.currentManifest.restrictionFor(sourceSemanticValue);
        Object register = this.currentManifest.getDefinition(sourceSemanticValue, moveOperation.getKind());
        Object operand = moveOperation.getKind().readOperand(sourceSemanticValue, restriction2, register);
        L2Operand[] l2OperandArray = new L2Operand[]{operand, L2_MOVE.createWrite$default(moveOperation, this, SetsKt.setOf(targetSemanticValue), restriction2, null, 8, null)};
        this.addInstruction(moveOperation, l2OperandArray);
    }

    @NotNull
    public final L2ReadBoxedOperand makeImmutable(@NotNull L2ReadBoxedOperand read2) {
        Intrinsics.checkNotNullParameter(read2, "read");
        TypeRestriction restriction2 = read2.restriction();
        L2Synonym readSynonym = this.currentManifest.semanticValueToSynonym(read2.semanticValue());
        boolean bl = restriction2.isBoxed();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (restriction2.isImmutable()) {
            return read2;
        }
        L2SemanticValue temp = this.newTemp();
        Set writeSemanticValues = CollectionsKt.toMutableSet((Iterable)readSynonym.semanticValues());
        writeSemanticValues.add(temp);
        TypeRestriction immutableRestriction = restriction2.withFlag(TypeRestriction.RestrictionFlagEncoding.IMMUTABLE_FLAG);
        boolean bl2 = immutableRestriction.isBoxed();
        if (_Assertions.ENABLED && !bl2) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        L2Operand[] l2OperandArray = new L2Operand[]{read2, this.boxedWrite(writeSemanticValues, immutableRestriction)};
        this.addInstruction(L2_MAKE_IMMUTABLE.INSTANCE, l2OperandArray);
        return this.currentManifest.readBoxed(temp);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final L2ReadBoxedOperand createTuple(@NotNull List<L2ReadBoxedOperand> elements) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        L2ReadBoxedOperand it;
        Collection collection2;
        AbstractEnumerationTypeDescriptor.Companion $this$mapTo$iv$iv2;
        A_String a_String;
        Iterator t;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(elements, "elements");
        int size = elements.size();
        if (size == 0) {
            return this.boxedConstant(TupleDescriptor.Companion.emptyTuple());
        }
        Iterable iterable = elements;
        A_Type initial$iv = BottomTypeDescriptor.Companion.getBottom();
        boolean $i$f$fold = false;
        A_Type accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void read2;
            L2ReadBoxedOperand l2ReadBoxedOperand = (L2ReadBoxedOperand)element$iv;
            t = accumulator$iv;
            boolean bl = false;
            accumulator$iv = A_Type.Companion.typeUnion((A_Type)((Object)t), read2.type());
        }
        A_Type unionType = accumulator$iv;
        if (A_Type.Companion.isSubtypeOf(unionType, PrimitiveTypeDescriptor.Types.CHARACTER.getO())) {
            a_String = StringDescriptor.Companion.generateStringFromCodePoints(size, (Function1<? super Integer, Integer>)new Function1<Integer, Integer>(elements){
                final /* synthetic */ List<L2ReadBoxedOperand> $elements;
                {
                    this.$elements = $elements;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int oneBasedIndex) {
                    AvailObject it = this.$elements.get(oneBasedIndex - 1).constantOrNull();
                    boolean bl = false;
                    AvailObject availObject = it;
                    return availObject == null ? 63 : A_Character.Companion.getCodePoint(availObject);
                }
            });
        } else if (A_Type.Companion.isSubtypeOf(unionType, IntegerRangeTypeDescriptor.Companion.getI64())) {
            Iterable $this$map$iv2 = elements;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo = false;
            t = $this$mapTo$iv$iv2.iterator();
            while (t.hasNext()) {
                Object item$iv$iv = t.next();
                L2ReadBoxedOperand l2ReadBoxedOperand = (L2ReadBoxedOperand)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                AvailObject availObject = it.constantOrNull();
                if (availObject == null) {
                    availObject = IntegerDescriptor.Companion.getZero();
                }
                collection2.add(availObject);
            }
            List constantsWithZeros = (List)destination$iv$iv;
            a_String = A_Type.Companion.isSubtypeOf(unionType, IntegerRangeTypeDescriptor.Companion.getU4()) ? NybbleTupleDescriptor.Companion.generateNybbleTupleFrom(size, (Function1<? super Integer, Integer>)new Function1<Integer, Integer>((List<AvailObject>)constantsWithZeros){
                final /* synthetic */ List<AvailObject> $constantsWithZeros;
                {
                    this.$constantsWithZeros = $constantsWithZeros;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int oneIndex) {
                    return A_Number.Companion.getExtractInt(this.$constantsWithZeros.get(oneIndex - 1));
                }
            }) : (A_Type.Companion.isSubtypeOf(unionType, IntegerRangeTypeDescriptor.Companion.getU8()) ? ByteTupleDescriptor.Companion.generateByteTupleFrom(size, (Function1<? super Integer, Integer>)new Function1<Integer, Integer>((List<AvailObject>)constantsWithZeros){
                final /* synthetic */ List<AvailObject> $constantsWithZeros;
                {
                    this.$constantsWithZeros = $constantsWithZeros;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int oneIndex) {
                    return A_Number.Companion.getExtractInt(this.$constantsWithZeros.get(oneIndex - 1));
                }
            }) : (A_Type.Companion.isSubtypeOf(unionType, IntegerRangeTypeDescriptor.Companion.getI32()) ? IntTupleDescriptor.Companion.generateIntTupleFrom(size, (Function1<? super Integer, Integer>)new Function1<Integer, Integer>((List<AvailObject>)constantsWithZeros){
                final /* synthetic */ List<AvailObject> $constantsWithZeros;
                {
                    this.$constantsWithZeros = $constantsWithZeros;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int oneIndex) {
                    return A_Number.Companion.getExtractInt(this.$constantsWithZeros.get(oneIndex - 1));
                }
            }) : LongTupleDescriptor.Companion.generateLongTupleFrom(size, (Function1<? super Integer, Long>)new Function1<Integer, Long>((List<AvailObject>)constantsWithZeros){
                final /* synthetic */ List<AvailObject> $constantsWithZeros;
                {
                    this.$constantsWithZeros = $constantsWithZeros;
                    super(1);
                }

                @NotNull
                public final Long invoke(int oneIndex) {
                    return A_Number.Companion.getExtractLong(this.$constantsWithZeros.get(oneIndex - 1));
                }
            })));
        } else {
            boolean bl;
            block16: {
                Iterable $this$all$iv = elements;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        L2ReadBoxedOperand it2 = (L2ReadBoxedOperand)element$iv;
                        boolean bl2 = false;
                        if (it2.constantOrNull() == null) continue;
                        bl = false;
                        break block16;
                    }
                    bl = true;
                }
            }
            if (bl) {
                Collection<A_Type> collection3;
                L2Operand[] $this$map$iv3;
                Object element$iv;
                Iterable $i$f$all = elements;
                TupleTypeDescriptor.Companion companion = TupleTypeDescriptor.Companion;
                TypeRestriction.Companion companion2 = TypeRestriction.Companion;
                L2Generator l2Generator = this;
                boolean $i$f$map = false;
                element$iv = $this$map$iv3;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
                boolean $i$f$mapTo = false;
                t = $this$mapTo$iv$iv2.iterator();
                while (t.hasNext()) {
                    Object item$iv$iv = t.next();
                    L2ReadBoxedOperand it3 = (L2ReadBoxedOperand)item$iv$iv;
                    collection3 = destination$iv$iv;
                    boolean bl3 = false;
                    collection3.add(it3.type());
                }
                collection3 = (List)destination$iv$iv;
                L2WriteBoxedOperand write2 = l2Generator.boxedWriteTemp(companion2.restrictionForType(companion.tupleTypeForTypesList((List<? extends A_Type>)collection3), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
                $this$map$iv3 = new L2Operand[]{new L2ReadBoxedVectorOperand(elements), write2};
                this.addInstruction(L2_CREATE_TUPLE.INSTANCE, $this$map$iv3);
                return this.readBoxed(write2);
            }
            a_String = ObjectTupleDescriptor.Companion.generateObjectTupleFrom(size, (Function1<? super Integer, ? extends A_BasicObject>)new Function1<Integer, A_BasicObject>(elements){
                final /* synthetic */ List<L2ReadBoxedOperand> $elements;
                {
                    this.$elements = $elements;
                    super(1);
                }

                @NotNull
                public final A_BasicObject invoke(int oneIndex) {
                    AvailObject availObject = this.$elements.get(oneIndex - 1).constantOrNull();
                    return availObject != null ? (A_BasicObject)availObject : (A_BasicObject)AtomDescriptor.Companion.getFalseObject();
                }
            });
        }
        AvailObject template2 = a_String.makeShared();
        L2ReadBoxedOperand latestRead = null;
        latestRead = this.boxedConstant(template2);
        Iterable $i$f$map = template2;
        $this$mapTo$iv$iv2 = AbstractEnumerationTypeDescriptor.Companion;
        boolean $i$f$map2 = false;
        void $i$f$mapTo = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            A_BasicObject a_BasicObject = (A_BasicObject)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add($this$mapTo$iv$iv2.instanceTypeOrMetaOn((A_BasicObject)p0));
        }
        List typesList = CollectionsKt.toMutableList((List)destination$iv$iv);
        Iterable $this$forEachIndexed$iv = elements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void read3;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (L2ReadBoxedOperand)item$iv;
            int zeroIndex = n;
            boolean bl = false;
            if (read3.constantOrNull() != null) continue;
            typesList.set(zeroIndex, read3.type());
            L2WriteBoxedOperand newWrite = this.boxedWriteTemp(TypeRestriction.Companion.restrictionForType(TupleTypeDescriptor.Companion.tupleTypeForTypesList(typesList), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
            L2Operand[] l2OperandArray = new L2Operand[]{latestRead, new L2IntImmediateOperand(zeroIndex + 1), read3, newWrite};
            this.addInstruction(L2_TUPLE_AT_UPDATE.INSTANCE, l2OperandArray);
            latestRead = this.readBoxed(newWrite);
        }
        return latestRead;
    }

    @NotNull
    public final L2ReadBoxedOperand extractTupleElement(@NotNull L2ReadBoxedOperand tupleReg, int index2) {
        Intrinsics.checkNotNullParameter(tupleReg, "tupleReg");
        return tupleReg.definition().getInstruction().getOperation().extractTupleElement(tupleReg, index2, this);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<L2ReadBoxedOperand> explodeTupleIfPossible(@NotNull L2ReadBoxedOperand tupleReg, @NotNull List<? extends A_Type> requiredTypes) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(tupleReg, "tupleReg");
        Intrinsics.checkNotNullParameter(requiredTypes, "requiredTypes");
        A_Type tupleType = tupleReg.type();
        A_Type tupleTypeSizes = A_Type.Companion.getSizeRange(tupleType);
        if (!A_Number.Companion.isInt(A_Type.Companion.getUpperBound(tupleTypeSizes)) || !A_Type.Companion.getLowerBound(tupleTypeSizes).equals(A_Type.Companion.getUpperBound(tupleTypeSizes))) {
            return null;
        }
        int tupleSize = A_Number.Companion.getExtractInt(A_Type.Companion.getUpperBound(tupleTypeSizes));
        if (tupleSize != requiredTypes.size()) {
            return null;
        }
        int i2 = 1;
        if (i2 <= tupleSize) {
            while (true) {
                if (!A_Type.Companion.isSubtypeOf(A_Type.Companion.typeAtIndex(tupleType, i2), requiredTypes.get(i2 - 1))) {
                    return null;
                }
                if (i2 == tupleSize) break;
                ++i2;
            }
        }
        Iterable $this$map$iv = new IntRange(1, tupleSize);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.extractTupleElement(tupleReg, (int)it));
        }
        return (List)destination$iv$iv;
    }

    private final A_Type exactFunctionSignatureFor(L2ReadBoxedOperand functionReg) {
        return functionReg.exactFunctionType();
    }

    @NotNull
    public final L2ReadBoxedOperand extractParameterTypeFromFunction(@NotNull L2ReadBoxedOperand functionRead, int parameterIndex) {
        Intrinsics.checkNotNullParameter(functionRead, "functionRead");
        A_Type exactFunctionType = this.exactFunctionSignatureFor(functionRead);
        if (exactFunctionType != null) {
            return this.boxedConstant(A_Type.Companion.typeAtIndex(A_Type.Companion.getArgsTupleType(exactFunctionType), parameterIndex));
        }
        L2WriteBoxedOperand parameterTypeWrite = this.boxedWriteTemp(TypeRestriction.Companion.restrictionForType(InstanceMetaDescriptor.Companion.anyMeta(), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
        L2Operand[] l2OperandArray = new L2Operand[]{functionRead, new L2IntImmediateOperand(parameterIndex), parameterTypeWrite};
        this.addInstruction(L2_FUNCTION_PARAMETER_TYPE.INSTANCE, l2OperandArray);
        return this.readBoxed(parameterTypeWrite);
    }

    @NotNull
    public final L2BasicBlock createBasicBlock(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new L2BasicBlock(name, false, null, 6, null);
    }

    @NotNull
    public final L2BasicBlock createLoopHeadBlock(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new L2BasicBlock(name, true, null);
    }

    @NotNull
    public final L2BasicBlock createBasicBlock(@NotNull String name, @Nullable L2ControlFlowGraph.Zone zone) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new L2BasicBlock(name, false, zone);
    }

    /*
     * Unable to fully structure code
     */
    public final void startBlock(@NotNull L2BasicBlock block, boolean generatePhis, @Nullable L2Regenerator regenerator) {
        block8: {
            Intrinsics.checkNotNullParameter(block, "block");
            v0 = this.currentBlock;
            if (v0 != null && (v0 = v0.instructions()) != null) {
                $this$startBlock_u24lambda_u2417 = v0;
                $i$a$-run-L2Generator$startBlock$1 = false;
                v1 = var9_8 = ((Collection)$this$startBlock_u24lambda_u2417).isEmpty() == false;
                if (_Assertions.ENABLED && !var9_8) {
                    var10_9 = "Assertion failed";
                    throw new AssertionError((Object)var10_9);
                }
                var9_8 = ((L2Instruction)CollectionsKt.last($this$startBlock_u24lambda_u2417)).getAltersControlFlow();
                if (_Assertions.ENABLED && !var9_8) {
                    $i$a$-assert-L2Generator$startBlock$1$1 = false;
                    v2 = this.currentBlock;
                    Intrinsics.checkNotNull(v2);
                    $i$a$-assert-L2Generator$startBlock$1$1 = "Previous block was not finished: " + v2.name();
                    throw new AssertionError((Object)$i$a$-assert-L2Generator$startBlock$1$1);
                }
            }
            $this$forEach$iv = block.predecessorEdges();
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (L2PcOperand)element$iv;
                $i$a$-forEach-L2Generator$startBlock$2 = false;
                it.getInstruction();
            }
            if (block.isIrremovable()) break block8;
            predecessorCount = block.predecessorEdges().size();
            if (predecessorCount == 0) {
                this.currentBlock = null;
                return;
            }
            if (block.isLoopHead() || predecessorCount != 1 || (jump = (predecessorBlock = (predecessorEdge = block.predecessorEdges().get(0)).sourceBlock()).finalInstruction()).getOperation() != L2_JUMP.INSTANCE) break block8;
            $this$isNullOr$iv = regenerator;
            $i$f$isNullOr = false;
            if ($this$isNullOr$iv == null) ** GOTO lbl-1000
            $this$startBlock_u24lambda_u2419 = $this$isNullOr$iv;
            $i$a$-isNullOr-L2Generator$startBlock$3 = false;
            if ($this$startBlock_u24lambda_u2419.getCanCollapseUnconditionalJumps()) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            if (v3) {
                this.currentManifest.clear();
                this.currentManifest.populateFromIntersection(CollectionsKt.listOf(predecessorEdge.manifest()), this, false, false, regenerator);
                predecessorBlock.instructions().remove(predecessorBlock.instructions().size() - 1);
                jump.justRemoved();
                this.currentBlock = predecessorBlock;
                return;
            }
        }
        this.currentBlock = block;
        this.controlFlowGraph.startBlock(block);
        block.startIn(this, generatePhis, regenerator);
    }

    public static /* synthetic */ void startBlock$default(L2Generator l2Generator, L2BasicBlock l2BasicBlock, boolean bl, L2Regenerator l2Regenerator, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            l2Regenerator = null;
        }
        l2Generator.startBlock(l2BasicBlock, bl, l2Regenerator);
    }

    @NotNull
    public final L2BasicBlock currentBlock() {
        L2BasicBlock l2BasicBlock = this.currentBlock;
        Intrinsics.checkNotNull(l2BasicBlock);
        return l2BasicBlock;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean currentlyReachable() {
        L2BasicBlock $this$notNullAnd$iv = this.currentBlock;
        boolean $i$f$notNullAnd = false;
        if ($this$notNullAnd$iv == null) return false;
        L2BasicBlock p0 = $this$notNullAnd$iv;
        boolean bl = false;
        if (!p0.currentlyReachable()) return false;
        return true;
    }

    @Nullable
    public final Unit addInstruction(@NotNull L2Operation operation, L2Operand ... operands) {
        Unit unit;
        Intrinsics.checkNotNullParameter(operation, "operation");
        Intrinsics.checkNotNullParameter(operands, "operands");
        L2BasicBlock l2BasicBlock = this.currentBlock;
        if (l2BasicBlock != null) {
            L2BasicBlock $this$addInstruction_u24lambda_u2421 = l2BasicBlock;
            boolean bl = false;
            $this$addInstruction_u24lambda_u2421.addInstruction(new L2Instruction(this.currentBlock, operation, Arrays.copyOf(operands, operands.length)), this.currentManifest);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Nullable
    public final Unit addInstruction(@NotNull L2Instruction instruction2) {
        Unit unit;
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        L2BasicBlock l2BasicBlock = this.currentBlock;
        if (l2BasicBlock != null) {
            L2BasicBlock $this$addInstruction_u24lambda_u2422 = l2BasicBlock;
            boolean bl = false;
            $this$addInstruction_u24lambda_u2422.addInstruction(instruction2, this.currentManifest);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public final void jumpTo(@NotNull L2BasicBlock targetBlock, @Nullable String optionalName) {
        Intrinsics.checkNotNullParameter(targetBlock, "targetBlock");
        L2Operand[] l2OperandArray = new L2Operand[]{Companion.edgeTo(targetBlock, optionalName)};
        this.addInstruction(L2_JUMP.INSTANCE, l2OperandArray);
    }

    public static /* synthetic */ void jumpTo$default(L2Generator l2Generator, L2BasicBlock l2BasicBlock, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        l2Generator.jumpTo(l2BasicBlock, string2);
    }

    public final void jumpIfEqualsConstant(@NotNull L2ReadBoxedOperand registerToTest, @NotNull A_BasicObject constantValue, @NotNull L2BasicBlock passBlock, @NotNull L2BasicBlock failBlock) {
        Intrinsics.checkNotNullParameter(registerToTest, "registerToTest");
        Intrinsics.checkNotNullParameter(constantValue, "constantValue");
        Intrinsics.checkNotNullParameter(passBlock, "passBlock");
        Intrinsics.checkNotNullParameter(failBlock, "failBlock");
        TypeRestriction restriction2 = registerToTest.restriction();
        AvailObject availObject = restriction2.getConstantOrNull();
        if (Intrinsics.areEqual(availObject, constantValue)) {
            L2Generator.jumpTo$default(this, passBlock, null, 2, null);
            return;
        }
        if (availObject instanceof Object) {
            L2Generator.jumpTo$default(this, failBlock, null, 2, null);
            return;
        }
        if (constantValue.isBoolean()) {
            boolean constantBool = constantValue.equals(AtomDescriptor.Companion.getTrueObject());
            L2Instruction boolSource = registerToTest.definitionSkippingMoves(true);
            if (boolSource.getOperation() instanceof L2_RUN_INFALLIBLE_PRIMITIVE) {
                if (L2_RUN_INFALLIBLE_PRIMITIVE.Companion.primitiveOf(boolSource) == P_Equality.INSTANCE) {
                    List<L2ReadBoxedOperand> list2 = L2_RUN_INFALLIBLE_PRIMITIVE.Companion.argsOf(boolSource);
                    L2ReadBoxedOperand read1 = list2.get(0);
                    L2ReadBoxedOperand read2 = list2.get(1);
                    AvailObject previousConstant = read1.constantOrNull();
                    L2ReadBoxedOperand previousRegister = read2;
                    if (previousConstant == null) {
                        previousConstant = read2.constantOrNull();
                        previousRegister = read1;
                    }
                    if (previousConstant != null) {
                        this.jumpIfEqualsConstant(previousRegister, previousConstant, constantBool ? passBlock : failBlock, constantBool ? failBlock : passBlock);
                        return;
                    }
                    L2Operand[] l2OperandArray = new L2Operand[]{read1, read2, avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, constantBool ? passBlock : failBlock, null, 2, null), avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, constantBool ? failBlock : passBlock, null, 2, null)};
                    this.addInstruction(L2_JUMP_IF_OBJECTS_EQUAL.INSTANCE, l2OperandArray);
                    return;
                }
                if (boolSource.getOperation() == L2_JUMP_IF_SUBTYPE_OF_CONSTANT.INSTANCE) {
                    L2ReadBoxedOperand firstTypeOperand = (L2ReadBoxedOperand)boolSource.operand(0);
                    L2ConstantOperand secondConstantOperand = (L2ConstantOperand)boolSource.operand(1);
                    L2Instruction firstTypeSource = firstTypeOperand.definitionSkippingMoves(true);
                    if (firstTypeSource.getOperation() == L2_GET_TYPE.INSTANCE) {
                        L2ReadBoxedOperand valueSource = L2_GET_TYPE.sourceValueOf(firstTypeSource);
                        this.jumpIfKindOfConstant(valueSource, secondConstantOperand.getConstant(), constantBool ? passBlock : failBlock, constantBool ? failBlock : passBlock);
                        return;
                    }
                    L2Operand[] valueSource = new L2Operand[]{firstTypeOperand, secondConstantOperand, avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, constantBool ? passBlock : failBlock, null, 2, null), avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, constantBool ? failBlock : passBlock, null, 2, null)};
                    this.addInstruction(L2_JUMP_IF_SUBTYPE_OF_CONSTANT.INSTANCE, valueSource);
                    return;
                }
                if (boolSource.getOperation() == L2_JUMP_IF_SUBTYPE_OF_OBJECT.INSTANCE) {
                    L2ReadBoxedOperand firstTypeOperand = (L2ReadBoxedOperand)boolSource.operand(0);
                    L2ReadBoxedOperand secondTypeOperand = (L2ReadBoxedOperand)boolSource.operand(0);
                    L2Instruction firstTypeSource = firstTypeOperand.definitionSkippingMoves(true);
                    if (firstTypeSource.getOperation() == L2_GET_TYPE.INSTANCE) {
                        L2ReadBoxedOperand valueSource = L2_GET_TYPE.sourceValueOf(firstTypeSource);
                        L2Operand[] l2OperandArray = new L2Operand[]{valueSource, secondTypeOperand, avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, constantBool ? passBlock : failBlock, null, 2, null), avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, constantBool ? failBlock : passBlock, null, 2, null)};
                        this.addInstruction(L2_JUMP_IF_KIND_OF_OBJECT.INSTANCE, l2OperandArray);
                        return;
                    }
                    L2Operand[] l2OperandArray = new L2Operand[]{firstTypeOperand, secondTypeOperand, avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, constantBool ? passBlock : failBlock, null, 2, null), avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, constantBool ? failBlock : passBlock, null, 2, null)};
                    this.addInstruction(L2_JUMP_IF_SUBTYPE_OF_OBJECT.INSTANCE, l2OperandArray);
                    return;
                }
            }
        }
        L2BasicBlock innerPass = new L2BasicBlock("strengthen to constant", false, null, 6, null);
        AvailObject constantValueStrong = (AvailObject)constantValue;
        if (A_Number.Companion.isInt(constantValueStrong) && registerToTest.restriction().containedByType(IntegerRangeTypeDescriptor.Companion.getI32())) {
            trulyUnreachable = new L2BasicBlock("truly unreachable", false, null, 6, null);
            L2_JUMP_IF_COMPARE_INT.Companion.getEqual().compareAndBranch(this, this.readInt(new L2SemanticUnboxedInt(registerToTest.semanticValue()), (L2BasicBlock)trulyUnreachable), this.unboxedIntConstant(A_Number.Companion.getExtractInt(constantValueStrong)), avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, innerPass, null, 2, null), avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, failBlock, null, 2, null));
            boolean bl = trulyUnreachable.predecessorEdges().isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
        } else {
            trulyUnreachable = new L2Operand[]{registerToTest, new L2ConstantOperand(constantValue), avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, innerPass, null, 2, null), avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, failBlock, null, 2, null)};
            this.addInstruction(L2_JUMP_IF_EQUALS_CONSTANT.INSTANCE, trulyUnreachable);
        }
        L2Generator.startBlock$default(this, innerPass, false, null, 6, null);
        L2SemanticConstant semanticConstant = new L2SemanticConstant(constantValue);
        if (!this.currentManifest.hasSemanticValue(semanticConstant)) {
            this.moveRegister(L2_MOVE.Companion.getBoxed(), registerToTest.semanticValue(), semanticConstant);
        }
        L2Generator.jumpTo$default(this, passBlock, null, 2, null);
    }

    public final void jumpIfKindOfConstant(@NotNull L2ReadBoxedOperand valueRead, @NotNull A_Type expectedType, @NotNull L2BasicBlock passedCheck, @NotNull L2BasicBlock failedCheck) {
        Intrinsics.checkNotNullParameter(valueRead, "valueRead");
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        Intrinsics.checkNotNullParameter(passedCheck, "passedCheck");
        Intrinsics.checkNotNullParameter(failedCheck, "failedCheck");
        TypeRestriction restriction2 = this.currentManifest.restrictionFor(valueRead.semanticValue());
        if (restriction2.containedByType(expectedType)) {
            L2Generator.jumpTo$default(this, passedCheck, null, 2, null);
            return;
        }
        if (!restriction2.intersectsType(expectedType)) {
            L2Generator.jumpTo$default(this, failedCheck, null, 2, null);
            return;
        }
        A_RawFunction rawFunction2 = this.determineRawFunction(valueRead);
        if (rawFunction2 != null) {
            A_Type exactKind = rawFunction2.functionType();
            if (A_Type.Companion.isSubtypeOf(exactKind, expectedType)) {
                L2Generator.jumpTo$default(this, passedCheck, null, 2, null);
                return;
            }
            if (!expectedType.isEnumeration()) {
                L2Generator.jumpTo$default(this, failedCheck, null, 2, null);
                return;
            }
        }
        L2Operand[] l2OperandArray = new L2Operand[]{valueRead, new L2ConstantOperand(expectedType), avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, passedCheck, null, 2, null), avail.optimizer.L2Generator$Companion.edgeTo$default(Companion, failedCheck, null, 2, null)};
        this.addInstruction(L2_JUMP_IF_KIND_OF_CONSTANT.INSTANCE, l2OperandArray);
    }

    @Nullable
    public final A_RawFunction determineRawFunction(@NotNull L2ReadBoxedOperand functionToCallReg) {
        Intrinsics.checkNotNullParameter(functionToCallReg, "functionToCallReg");
        A_Function functionIfKnown = functionToCallReg.constantOrNull();
        if (functionIfKnown != null) {
            return functionIfKnown.code();
        }
        L2Instruction functionDefinition = functionToCallReg.definitionSkippingMoves(true);
        return functionDefinition.getOperation().getConstantCodeFrom(functionDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateRetroactivelyBeforeEdge(@NotNull L2PcOperand edge2, @NotNull Function1<? super L2Generator, Unit> body2) {
        Intrinsics.checkNotNullParameter(edge2, "edge");
        Intrinsics.checkNotNullParameter(body2, "body");
        L2BasicBlock sourceBlock = edge2.sourceBlock();
        L2ValueManifest savedManifest = this.currentManifest;
        L2BasicBlock savedBlock = this.currentBlock;
        L2Instruction savedFinalInstruction = CollectionExtensionsKt.removeLast(sourceBlock.instructions());
        this.currentManifest = edge2.manifest();
        this.currentBlock = sourceBlock;
        sourceBlock.removedControlFlowInstruction();
        try {
            body2.invoke(this);
        }
        finally {
            sourceBlock.instructions().add(savedFinalInstruction);
            sourceBlock.readdedControlFlowInstruction();
            this.currentManifest = savedManifest;
            this.currentBlock = savedBlock;
        }
    }

    public final void addContingentValue(@NotNull A_ChunkDependable contingentValue) {
        Intrinsics.checkNotNullParameter(contingentValue, "contingentValue");
        this.contingentValues = A_Set.Companion.setWithElementCanDestroy(this.contingentValues, contingentValue, true);
    }

    public final void createChunk(@NotNull A_RawFunction code) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter(code, "code");
        boolean bl3 = bl2 = this.chunk == null;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        List instructions2 = new ArrayList();
        this.controlFlowGraph.generateOn(instructions2);
        RegisterCounter registerCounter = new RegisterCounter();
        Iterable $this$forEach$iv = instructions2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            L2Instruction instruction2 = (L2Instruction)element$iv;
            boolean bl4 = false;
            L2Operand[] $this$forEach$iv2 = instruction2.getOperands();
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int j = 0; j < n; ++j) {
                L2Operand element$iv2;
                L2Operand it = element$iv2 = $this$forEach$iv2[j];
                boolean bl5 = false;
                it.dispatchOperand(registerCounter);
            }
        }
        L2BasicBlock l2BasicBlock = this.specialBlocks.get((Object)SpecialBlock.AFTER_OPTIONAL_PRIMITIVE);
        Intrinsics.checkNotNull(l2BasicBlock);
        int afterPrimitiveOffset = l2BasicBlock.offset();
        boolean bl6 = bl = afterPrimitiveOffset >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        L2Chunk l2Chunk = this.chunk = (L2Chunk)L2JVMChunk.Companion.allocate(code, afterPrimitiveOffset, instructions2, this.controlFlowGraph, this.contingentValues);
        Intrinsics.checkNotNull(l2Chunk);
        A_RawFunction.Companion.setStartingChunkAndReoptimizationCountdown(code, l2Chunk, this.optimizationLevel.getCountdown());
    }

    @NotNull
    public final L2Chunk chunk() {
        L2Chunk l2Chunk = this.chunk;
        Intrinsics.checkNotNull(l2Chunk);
        return l2Chunk;
    }

    @NotNull
    public final String visualize() {
        return this.controlFlowGraph.visualize();
    }

    @NotNull
    public final String simplyVisualize() {
        return this.controlFlowGraph.simplyVisualize();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lavail/optimizer/L2Generator$Companion;", "", "()V", "finalGenerationStat", "Lavail/performance/Statistic;", "getFinalGenerationStat", "()Lavail/performance/Statistic;", "maxExpandedEqualityChecks", "", "maxPolymorphismToInlineDispatch", "backEdgeTo", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "targetBlock", "Lavail/optimizer/L2BasicBlock;", "edgeTo", "optionalName", "", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final L2PcOperand edgeTo(@NotNull L2BasicBlock targetBlock, @Nullable String optionalName) {
            Intrinsics.checkNotNullParameter(targetBlock, "targetBlock");
            boolean bl = targetBlock.instructions().isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return new L2PcOperand(targetBlock, false, null, optionalName, 4, null);
        }

        public static /* synthetic */ L2PcOperand edgeTo$default(Companion companion, L2BasicBlock l2BasicBlock, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.edgeTo(l2BasicBlock, string2);
        }

        @NotNull
        public final L2PcOperand backEdgeTo(@NotNull L2BasicBlock targetBlock) {
            Intrinsics.checkNotNullParameter(targetBlock, "targetBlock");
            boolean bl = targetBlock.isLoopHead();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return new L2PcOperand(targetBlock, true, null, null, 12, null);
        }

        @NotNull
        public final Statistic getFinalGenerationStat() {
            return finalGenerationStat;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\rH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000fH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0011H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0012H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0013H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0014H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0015H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0016H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0017H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0018H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0019H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001aH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lavail/optimizer/L2Generator$RegisterCounter;", "Lavail/interpreter/levelTwo/L2OperandDispatcher;", "()V", "floatMax", "", "intMax", "objectMax", "doOperand", "", "operand", "Lavail/interpreter/levelTwo/operand/L2ArbitraryConstantOperand;", "Lavail/interpreter/levelTwo/operand/L2CommentOperand;", "Lavail/interpreter/levelTwo/operand/L2ConstantOperand;", "Lavail/interpreter/levelTwo/operand/L2FloatImmediateOperand;", "Lavail/interpreter/levelTwo/operand/L2IntImmediateOperand;", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "Lavail/interpreter/levelTwo/operand/L2PcVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2PrimitiveOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadFloatOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadFloatVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadIntOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadIntVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2SelectorOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteBoxedOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteFloatOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteIntOperand;", "avail"})
    public static final class RegisterCounter
    implements L2OperandDispatcher {
        private int objectMax = -1;
        private int intMax = -1;
        private int floatMax = -1;

        @Override
        public void doOperand(@NotNull L2ArbitraryConstantOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2CommentOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2ConstantOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2IntImmediateOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2FloatImmediateOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2PcOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2PrimitiveOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2ReadIntOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            this.intMax = RangesKt.coerceAtLeast(this.intMax, operand.finalIndex());
        }

        @Override
        public void doOperand(@NotNull L2ReadFloatOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            this.floatMax = RangesKt.coerceAtLeast(this.floatMax, operand.finalIndex());
        }

        @Override
        public void doOperand(@NotNull L2ReadBoxedOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            this.objectMax = RangesKt.coerceAtLeast(this.objectMax, operand.finalIndex());
        }

        @Override
        public void doOperand(@NotNull L2ReadBoxedVectorOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            for (L2ReadBoxedOperand register : operand.getElements()) {
                this.objectMax = RangesKt.coerceAtLeast(this.objectMax, register.finalIndex());
            }
        }

        @Override
        public void doOperand(@NotNull L2ReadIntVectorOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            for (L2ReadIntOperand register : operand.getElements()) {
                this.intMax = RangesKt.coerceAtLeast(this.intMax, register.finalIndex());
            }
        }

        @Override
        public void doOperand(@NotNull L2ReadFloatVectorOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            for (L2ReadFloatOperand register : operand.getElements()) {
                this.floatMax = RangesKt.coerceAtLeast(this.floatMax, register.finalIndex());
            }
        }

        @Override
        public void doOperand(@NotNull L2SelectorOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2WriteIntOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            this.intMax = RangesKt.coerceAtLeast(this.intMax, operand.finalIndex());
        }

        @Override
        public void doOperand(@NotNull L2WriteFloatOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            this.floatMax = RangesKt.coerceAtLeast(this.floatMax, operand.finalIndex());
        }

        @Override
        public void doOperand(@NotNull L2WriteBoxedOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            this.objectMax = RangesKt.coerceAtLeast(this.objectMax, operand.finalIndex());
        }

        @Override
        public void doOperand(@NotNull L2PcVectorOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/optimizer/L2Generator$SpecialBlock;", "", "(Ljava/lang/String;I)V", "START", "AFTER_OPTIONAL_PRIMITIVE", "RESTART_LOOP_HEAD", "UNREACHABLE", "avail"})
    public static final class SpecialBlock
    extends Enum<SpecialBlock> {
        public static final /* enum */ SpecialBlock START = new SpecialBlock();
        public static final /* enum */ SpecialBlock AFTER_OPTIONAL_PRIMITIVE = new SpecialBlock();
        public static final /* enum */ SpecialBlock RESTART_LOOP_HEAD = new SpecialBlock();
        public static final /* enum */ SpecialBlock UNREACHABLE = new SpecialBlock();
        private static final /* synthetic */ SpecialBlock[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SpecialBlock[] values() {
            return (SpecialBlock[])$VALUES.clone();
        }

        public static SpecialBlock valueOf(String value) {
            return Enum.valueOf(SpecialBlock.class, value);
        }

        @NotNull
        public static EnumEntries<SpecialBlock> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = specialBlockArray = new SpecialBlock[]{SpecialBlock.START, SpecialBlock.AFTER_OPTIONAL_PRIMITIVE, SpecialBlock.RESTART_LOOP_HEAD, SpecialBlock.UNREACHABLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

