/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer.reoptimizer;

import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2OperandDispatcher;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2ArbitraryConstantOperand;
import avail.interpreter.levelTwo.operand.L2CommentOperand;
import avail.interpreter.levelTwo.operand.L2ConstantOperand;
import avail.interpreter.levelTwo.operand.L2FloatImmediateOperand;
import avail.interpreter.levelTwo.operand.L2IntImmediateOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2PcVectorOperand;
import avail.interpreter.levelTwo.operand.L2PrimitiveOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2ReadFloatOperand;
import avail.interpreter.levelTwo.operand.L2ReadFloatVectorOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntVectorOperand;
import avail.interpreter.levelTwo.operand.L2ReadOperand;
import avail.interpreter.levelTwo.operand.L2SelectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteFloatOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operand.L2WriteOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_MOVE_CONSTANT;
import avail.interpreter.levelTwo.register.L2BoxedRegister;
import avail.interpreter.levelTwo.register.L2FloatRegister;
import avail.interpreter.levelTwo.register.L2IntRegister;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2ControlFlowGraph;
import avail.optimizer.L2Entity;
import avail.optimizer.L2EntityAndKind;
import avail.optimizer.L2Generator;
import avail.optimizer.L2SplitCondition;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.reoptimizer.L2Regenerator;
import avail.optimizer.values.L2SemanticUnboxedFloat;
import avail.optimizer.values.L2SemanticUnboxedInt;
import avail.optimizer.values.L2SemanticValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\b\b&\u0018\u00002\u00020\u0001:\u0003678B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ'\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 \"\u00020!\u00a2\u0006\u0002\u0010\"J\u0006\u0010#\u001a\u00020\u0019J\u0016\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J(\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020/2\u0018\u00100\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n01J\u001f\u00102\u001a\u0002H3\"\b\b\u0000\u00103*\u00020!2\u0006\u00104\u001a\u0002H3H\u0016\u00a2\u0006\u0002\u00105R/\u0010\u0007\u001a \u0012\u0004\u0012\u00020\t\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\t0\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00069"}, d2={"Lavail/optimizer/reoptimizer/L2Regenerator;", "", "targetGenerator", "Lavail/optimizer/L2Generator;", "generatePhis", "", "(Lavail/optimizer/L2Generator;Z)V", "blockMap", "", "Lavail/optimizer/L2BasicBlock;", "", "Lavail/optimizer/L2SplitCondition;", "getBlockMap", "()Ljava/util/Map;", "canCollapseUnconditionalJumps", "getCanCollapseUnconditionalJumps", "()Z", "inverseSpecialBlockMap", "Lavail/optimizer/L2Generator$SpecialBlock;", "getInverseSpecialBlockMap", "operandInlineTransformer", "Lavail/optimizer/reoptimizer/L2Regenerator$AbstractOperandTransformer;", "getTargetGenerator", "()Lavail/optimizer/L2Generator;", "basicProcessInstruction", "", "sourceInstruction", "Lavail/interpreter/levelTwo/L2Instruction;", "emitInstruction", "operation", "Lavail/interpreter/levelTwo/L2Operation;", "operands", "", "Lavail/interpreter/levelTwo/operand/L2Operand;", "(Lavail/interpreter/levelTwo/L2Operation;[Lavail/interpreter/levelTwo/operand/L2Operand;)V", "forceAllPostponedTranslationsExceptConstantMoves", "forcePostponedTranslationBeforeEdge", "edge", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "semanticValue", "Lavail/optimizer/values/L2SemanticValue;", "forcePostponedTranslationNow", "nextUnique", "", "processInstruction", "processSourceGraph", "oldGraph", "Lavail/optimizer/L2ControlFlowGraph;", "interestingConditionsByOldBlock", "", "transformOperand", "O", "operand", "(Lavail/interpreter/levelTwo/operand/L2Operand;)Lavail/interpreter/levelTwo/operand/L2Operand;", "AbstractOperandTransformer", "OperandRegisterTransformer", "OperandSemanticTransformer", "avail"})
@SourceDebugExtension(value={"SMAP\nL2Regenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 L2Regenerator.kt\navail/optimizer/reoptimizer/L2Regenerator\n+ 2 Casts.kt\navail/utility/CastsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,716:1\n46#2:717\n215#3,2:718\n1855#4,2:720\n*S KotlinDebug\n*F\n+ 1 L2Regenerator.kt\navail/optimizer/reoptimizer/L2Regenerator\n*L\n453#1:717\n654#1:718,2\n667#1:720,2\n*E\n"})
public abstract class L2Regenerator {
    @NotNull
    private final L2Generator targetGenerator;
    private final boolean generatePhis;
    @NotNull
    private final AbstractOperandTransformer operandInlineTransformer;
    @NotNull
    private final Map<L2BasicBlock, Map<Set<L2SplitCondition>, L2BasicBlock>> blockMap;
    @NotNull
    private final Map<L2BasicBlock, L2Generator.SpecialBlock> inverseSpecialBlockMap;

    public L2Regenerator(@NotNull L2Generator targetGenerator, boolean generatePhis) {
        Intrinsics.checkNotNullParameter(targetGenerator, "targetGenerator");
        this.targetGenerator = targetGenerator;
        this.generatePhis = generatePhis;
        this.operandInlineTransformer = this.generatePhis ? (AbstractOperandTransformer)new OperandSemanticTransformer() : (AbstractOperandTransformer)new OperandRegisterTransformer();
        this.blockMap = new LinkedHashMap();
        this.inverseSpecialBlockMap = new LinkedHashMap();
    }

    @NotNull
    public final L2Generator getTargetGenerator() {
        return this.targetGenerator;
    }

    public boolean getCanCollapseUnconditionalJumps() {
        return true;
    }

    @NotNull
    public final Map<L2BasicBlock, Map<Set<L2SplitCondition>, L2BasicBlock>> getBlockMap() {
        return this.blockMap;
    }

    @NotNull
    public final Map<L2BasicBlock, L2Generator.SpecialBlock> getInverseSpecialBlockMap() {
        return this.inverseSpecialBlockMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <O extends L2Operand> O transformOperand(@NotNull O operand) {
        void var2_2;
        Intrinsics.checkNotNullParameter(operand, "operand");
        this.operandInlineTransformer.setCurrentOperand(operand);
        operand.dispatchOperand(this.operandInlineTransformer);
        L2Operand l2Operand = this.operandInlineTransformer.getCurrentOperand();
        Intrinsics.checkNotNull(l2Operand);
        L2Operand $this$cast$iv = l2Operand;
        boolean $i$f$cast = false;
        return var2_2;
    }

    public final void processSourceGraph(@NotNull L2ControlFlowGraph oldGraph, @NotNull Map<L2BasicBlock, ? extends Set<? extends L2SplitCondition>> interestingConditionsByOldBlock) {
        Intrinsics.checkNotNullParameter(oldGraph, "oldGraph");
        Intrinsics.checkNotNullParameter(interestingConditionsByOldBlock, "interestingConditionsByOldBlock");
        L2BasicBlock firstSourceBlock = oldGraph.getBasicBlockOrder().get(0);
        L2BasicBlock start = new L2BasicBlock(firstSourceBlock.name(), false, null, 6, null);
        start.makeIrremovable();
        Map<L2BasicBlock, Map<Set<L2SplitCondition>, L2BasicBlock>> map = this.blockMap;
        Object object = new Pair[]{TuplesKt.to(SetsKt.emptySet(), start)};
        object = MapsKt.mutableMapOf(object);
        map.put(firstSourceBlock, (Map<Set<L2SplitCondition>, L2BasicBlock>)object);
        oldGraph.forwardVisit((Function1<? super L2BasicBlock, Unit>)new Function1<L2BasicBlock, Unit>(this, interestingConditionsByOldBlock){
            final /* synthetic */ L2Regenerator this$0;
            final /* synthetic */ Map<L2BasicBlock, Set<L2SplitCondition>> $interestingConditionsByOldBlock;
            {
                this.this$0 = $receiver;
                this.$interestingConditionsByOldBlock = $interestingConditionsByOldBlock;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull L2BasicBlock originalBlock) {
                void $this$forEach$iv;
                Object noConditionBlock;
                Set<L2SplitCondition> interestingConditions;
                Intrinsics.checkNotNullParameter(originalBlock, "originalBlock");
                Map map = this.this$0.getBlockMap().computeIfAbsent(originalBlock, arg_0 -> processSourceGraph.1.invoke$lambda$0(new Function1<L2BasicBlock, Map<Set<? extends L2SplitCondition>, L2BasicBlock>>(originalBlock){
                    final /* synthetic */ L2BasicBlock $originalBlock;
                    {
                        this.$originalBlock = $originalBlock;
                        super(1);
                    }

                    @NotNull
                    public final Map<Set<L2SplitCondition>, L2BasicBlock> invoke(@NotNull L2BasicBlock it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        Pair[] pairArray = new Pair[]{TuplesKt.to(SetsKt.emptySet(), new L2BasicBlock(this.$originalBlock.name(), this.$originalBlock.isLoopHead(), this.$originalBlock.getZone()))};
                        return MapsKt.mutableMapOf(pairArray);
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue(map, "computeIfAbsent(...)");
                Map submap2 = map;
                Set<L2SplitCondition> set2 = this.$interestingConditionsByOldBlock.get(originalBlock);
                if (set2 == null) {
                    set2 = SetsKt.emptySet();
                }
                if (!((Collection)(interestingConditions = set2)).isEmpty()) {
                    V v = submap2.get(SetsKt.emptySet());
                    Intrinsics.checkNotNull(v);
                    noConditionBlock = (L2BasicBlock)v;
                    List<T> incomingEdges = CollectionsKt.toList((Iterable)((L2BasicBlock)noConditionBlock).predecessorEdges());
                    Iterable $this$forEach$iv2 = incomingEdges;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv2) {
                        L2BasicBlock betterBlock2;
                        void destination$iv;
                        void $this$filterTo$iv;
                        L2PcOperand incomingEdge = (L2PcOperand)element$iv;
                        boolean bl = false;
                        Iterable iterable = interestingConditions;
                        Collection collection2 = new LinkedHashSet<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv2 : $this$filterTo$iv) {
                            L2SplitCondition it = (L2SplitCondition)element$iv2;
                            boolean bl2 = false;
                            if (!it.holdsFor(incomingEdge.manifest())) continue;
                            destination$iv.add(element$iv2);
                        }
                        Set trueConditions = (Set)destination$iv;
                        Intrinsics.checkNotNullExpressionValue(submap2.computeIfAbsent(trueConditions, arg_0 -> processSourceGraph.1.invoke$lambda$3$lambda$2(new Function1<Set<? extends L2SplitCondition>, L2BasicBlock>((Set<L2SplitCondition>)trueConditions, (Map<Set<L2SplitCondition>, L2BasicBlock>)submap2, originalBlock){
                            final /* synthetic */ Set<L2SplitCondition> $trueConditions;
                            final /* synthetic */ Map<Set<L2SplitCondition>, L2BasicBlock> $submap;
                            final /* synthetic */ L2BasicBlock $originalBlock;
                            {
                                this.$trueConditions = $trueConditions;
                                this.$submap = $submap;
                                this.$originalBlock = $originalBlock;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final L2BasicBlock invoke(@NotNull Set<? extends L2SplitCondition> it) {
                                String string2;
                                Intrinsics.checkNotNullParameter(it, "it");
                                if (this.$trueConditions.size() == 1) {
                                    string2 = "\nsplit: " + CollectionsKt.single((Iterable)this.$trueConditions);
                                } else {
                                    void $this$filterTo$iv$iv;
                                    void $this$filter$iv;
                                    Iterable iterable = this.$submap.keySet();
                                    boolean $i$f$filter = false;
                                    void var6_4 = $this$filter$iv;
                                    Collection destination$iv$iv = new ArrayList<E>();
                                    boolean $i$f$filterTo = false;
                                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                                        Set p0 = (Set)element$iv$iv;
                                        boolean bl = false;
                                        if (!(!((Collection)p0).isEmpty())) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    string2 = "\nsplits:\n\t" + CollectionsKt.joinToString$default((List)destination$iv$iv, ",\n\t", null, null, 0, null, processSourceGraph.1.betterBlock.suffix.2.INSTANCE, 30, null);
                                }
                                String suffix2 = string2;
                                L2BasicBlock newBlock = new L2BasicBlock(this.$originalBlock.name() + suffix2, this.$originalBlock.isLoopHead(), this.$originalBlock.getZone());
                                if (this.$originalBlock.isIrremovable()) {
                                    newBlock.makeIrremovable();
                                }
                                return newBlock;
                            }
                        }, arg_0)), "computeIfAbsent(...)");
                        if (betterBlock2 == incomingEdge.targetBlock()) continue;
                        incomingEdge.changeUngeneratedTarget(betterBlock2);
                    }
                }
                noConditionBlock = submap2;
                L2Regenerator l2Regenerator = this.this$0;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> entry = element$iv = iterator2.next();
                    boolean bl = false;
                    L2BasicBlock targetBlock = (L2BasicBlock)entry.getValue();
                    l2Regenerator.getTargetGenerator().startBlock(targetBlock, L2Regenerator.access$getGeneratePhis$p(l2Regenerator), l2Regenerator);
                    if (!l2Regenerator.getTargetGenerator().currentlyReachable()) continue;
                    Iterable $this$forEach$iv3 = originalBlock.instructions();
                    boolean $i$f$forEach2 = false;
                    for (T element$iv3 : $this$forEach$iv3) {
                        L2Instruction p0 = (L2Instruction)element$iv3;
                        boolean bl3 = false;
                        l2Regenerator.processInstruction(p0);
                    }
                }
            }

            private static final Map invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                return (Map)$tmp0.invoke(p0);
            }

            private static final L2BasicBlock invoke$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                return (L2BasicBlock)$tmp0.invoke(p0);
            }
        });
    }

    public void processInstruction(@NotNull L2Instruction sourceInstruction) {
        Intrinsics.checkNotNullParameter(sourceInstruction, "sourceInstruction");
        this.basicProcessInstruction(sourceInstruction);
    }

    public final void basicProcessInstruction(@NotNull L2Instruction sourceInstruction) {
        boolean bl;
        Intrinsics.checkNotNullParameter(sourceInstruction, "sourceInstruction");
        boolean bl2 = bl = !sourceInstruction.getOperation().isPhi();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        sourceInstruction.transformAndEmitOn(this);
    }

    public final void emitInstruction(@NotNull L2Operation operation, L2Operand ... operands) {
        Intrinsics.checkNotNullParameter(operation, "operation");
        Intrinsics.checkNotNullParameter(operands, "operands");
        this.targetGenerator.addInstruction(operation, Arrays.copyOf(operands, operands.length));
    }

    public final void forcePostponedTranslationNow(@NotNull L2Instruction sourceInstruction) {
        Intrinsics.checkNotNullParameter(sourceInstruction, "sourceInstruction");
        L2ValueManifest manifest2 = this.targetGenerator.getCurrentManifest();
        for (L2ReadOperand<?> read2 : sourceInstruction.getReadOperands()) {
            L2SemanticValue semanticValue = read2.semanticValue();
            if (!manifest2.getPostponedInstructions().containsKey(semanticValue)) continue;
            this.forcePostponedTranslationNow(manifest2.removePostponedSourceInstruction(semanticValue));
        }
        this.basicProcessInstruction(sourceInstruction);
    }

    public final void forceAllPostponedTranslationsExceptConstantMoves() {
        block0: while (true) {
            Map.Entry<L2SemanticValue, List<L2Instruction>> element$iv;
            Set postponedSet = new LinkedHashSet();
            Object $this$forEach$iv = this.targetGenerator.getCurrentManifest().getPostponedInstructions();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<L2SemanticValue, List<L2Instruction>>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<L2SemanticValue, List<L2Instruction>> entry = element$iv = iterator2.next();
                boolean bl = false;
                List<L2Instruction> instructions2 = entry.getValue();
                L2Instruction instruction2 = CollectionsKt.last(instructions2);
                if (instruction2.getOperation() instanceof L2_MOVE_CONSTANT) continue;
                postponedSet.add(instruction2);
            }
            if (postponedSet.isEmpty()) {
                return;
            }
            $this$forEach$iv = postponedSet;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block0;
                element$iv = iterator2.next();
                L2Instruction sourceInstruction = (L2Instruction)((Object)element$iv);
                boolean bl = false;
                L2WriteOperand<?> someWrite = sourceInstruction.getWriteOperands().get(0);
                L2SemanticValue sv2 = someWrite.pickSemanticValue();
                L2ValueManifest manifest2 = this.targetGenerator.getCurrentManifest();
                List<L2Instruction> list2 = manifest2.getPostponedInstructions().get(sv2);
                boolean bl2 = list2 != null ? !((Collection)list2).isEmpty() : false;
                if (!bl2) continue;
                this.forcePostponedTranslationNow(manifest2.removePostponedSourceInstruction(sv2));
            }
            break;
        }
    }

    public final void forcePostponedTranslationBeforeEdge(@NotNull L2PcOperand edge2, @NotNull L2SemanticValue semanticValue) {
        Intrinsics.checkNotNullParameter(edge2, "edge");
        Intrinsics.checkNotNullParameter(semanticValue, "semanticValue");
        this.targetGenerator.generateRetroactivelyBeforeEdge(edge2, (Function1<? super L2Generator, Unit>)new Function1<L2Generator, Unit>(this, semanticValue){
            final /* synthetic */ L2Regenerator this$0;
            final /* synthetic */ L2SemanticValue $semanticValue;
            {
                this.this$0 = $receiver;
                this.$semanticValue = $semanticValue;
                super(1);
            }

            public final void invoke(@NotNull L2Generator $this$generateRetroactivelyBeforeEdge) {
                Intrinsics.checkNotNullParameter($this$generateRetroactivelyBeforeEdge, "$this$generateRetroactivelyBeforeEdge");
                this.this$0.forcePostponedTranslationNow(this.this$0.getTargetGenerator().getCurrentManifest().removePostponedSourceInstruction(this.$semanticValue));
            }
        });
    }

    public final int nextUnique() {
        return this.targetGenerator.nextUnique();
    }

    public static final /* synthetic */ boolean access$getGeneratePhis$p(L2Regenerator $this) {
        return $this.generatePhis;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a6\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0011H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0012H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0013H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0014H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0016H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Lavail/optimizer/reoptimizer/L2Regenerator$AbstractOperandTransformer;", "Lavail/interpreter/levelTwo/L2OperandDispatcher;", "(Lavail/optimizer/reoptimizer/L2Regenerator;)V", "currentOperand", "Lavail/interpreter/levelTwo/operand/L2Operand;", "getCurrentOperand", "()Lavail/interpreter/levelTwo/operand/L2Operand;", "setCurrentOperand", "(Lavail/interpreter/levelTwo/operand/L2Operand;)V", "doOperand", "", "operand", "Lavail/interpreter/levelTwo/operand/L2ArbitraryConstantOperand;", "Lavail/interpreter/levelTwo/operand/L2CommentOperand;", "Lavail/interpreter/levelTwo/operand/L2ConstantOperand;", "Lavail/interpreter/levelTwo/operand/L2FloatImmediateOperand;", "Lavail/interpreter/levelTwo/operand/L2IntImmediateOperand;", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "Lavail/interpreter/levelTwo/operand/L2PcVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2PrimitiveOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadFloatVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadIntVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2SelectorOperand;", "mapBlock", "Lavail/optimizer/L2BasicBlock;", "block", "mapSemanticValue", "Lavail/optimizer/values/L2SemanticValue;", "oldSemanticValue", "avail"})
    @SourceDebugExtension(value={"SMAP\nL2Regenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 L2Regenerator.kt\navail/optimizer/reoptimizer/L2Regenerator$AbstractOperandTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,716:1\n1855#2,2:717\n1549#2:719\n1620#2,3:720\n1549#2:723\n1620#2,3:724\n1549#2:727\n1620#2,3:728\n1549#2:731\n1620#2,3:732\n*S KotlinDebug\n*F\n+ 1 L2Regenerator.kt\navail/optimizer/reoptimizer/L2Regenerator$AbstractOperandTransformer\n*L\n210#1:717,2\n236#1:719\n236#1:720,3\n243#1:723\n243#1:724,3\n250#1:727\n250#1:728,3\n258#1:731\n258#1:732,3\n*E\n"})
    public abstract class AbstractOperandTransformer
    implements L2OperandDispatcher {
        @Nullable
        private L2Operand currentOperand;

        @Nullable
        public final L2Operand getCurrentOperand() {
            return this.currentOperand;
        }

        public final void setCurrentOperand(@Nullable L2Operand l2Operand) {
            this.currentOperand = l2Operand;
        }

        @NotNull
        public L2BasicBlock mapBlock(@NotNull L2BasicBlock block) {
            Intrinsics.checkNotNullParameter(block, "block");
            L2Generator.SpecialBlock special = L2Regenerator.this.getInverseSpecialBlockMap().get(block);
            Map map = L2Regenerator.this.getBlockMap().computeIfAbsent(block, arg_0 -> AbstractOperandTransformer.mapBlock$lambda$0(mapBlock.submap.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue(map, "computeIfAbsent(...)");
            Map submap2 = map;
            L2BasicBlock l2BasicBlock = submap2.computeIfAbsent(SetsKt.emptySet(), arg_0 -> AbstractOperandTransformer.mapBlock$lambda$1(new Function1<Set<? extends L2SplitCondition>, L2BasicBlock>(block, special, L2Regenerator.this){
                final /* synthetic */ L2BasicBlock $block;
                final /* synthetic */ L2Generator.SpecialBlock $special;
                final /* synthetic */ L2Regenerator this$0;
                {
                    this.$block = $block;
                    this.$special = $special;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final L2BasicBlock invoke(@NotNull Set<? extends L2SplitCondition> it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    L2BasicBlock newBlock = new L2BasicBlock(this.$block.name(), this.$block.isLoopHead(), this.$block.getZone());
                    if (this.$block.isIrremovable()) {
                        newBlock.makeIrremovable();
                    }
                    if (this.$special != null) {
                        boolean bl;
                        boolean bl2 = bl = this.this$0.getTargetGenerator().getSpecialBlocks().get((Object)((Object)this.$special)) == null;
                        if (_Assertions.ENABLED && !bl) {
                            String string2 = "Assertion failed";
                            throw new AssertionError((Object)string2);
                        }
                        this.this$0.getTargetGenerator().getSpecialBlocks().set((L2Generator.SpecialBlock)((Enum)this.$special), newBlock);
                    }
                    return newBlock;
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue(l2BasicBlock, "computeIfAbsent(...)");
            return l2BasicBlock;
        }

        @NotNull
        public L2SemanticValue mapSemanticValue(@NotNull L2SemanticValue oldSemanticValue) {
            Intrinsics.checkNotNullParameter(oldSemanticValue, "oldSemanticValue");
            return oldSemanticValue;
        }

        @Override
        public void doOperand(@NotNull L2ArbitraryConstantOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2CommentOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2ConstantOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2IntImmediateOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2FloatImmediateOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        @Override
        public void doOperand(@NotNull L2PcOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            L2PcOperand edge2 = new L2PcOperand(this.mapBlock(operand.targetBlock()), operand.isBackward(), L2Regenerator.this.getTargetGenerator().getCurrentManifest(), operand.getOptionalName());
            Set<L2EntityAndKind> set2 = operand.getForcedClampedEntities();
            if (set2 != null) {
                Set<L2EntityAndKind> set3 = set2;
                L2Regenerator l2Regenerator = L2Regenerator.this;
                Set<L2EntityAndKind> oldClamped = set3;
                boolean bl = false;
                L2ValueManifest manifest2 = l2Regenerator.getTargetGenerator().getCurrentManifest();
                Set newClamped = new LinkedHashSet();
                Iterable $this$forEach$iv = oldClamped;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    L2EntityAndKind entityAndKind = (L2EntityAndKind)element$iv;
                    boolean bl2 = false;
                    L2Entity entity = entityAndKind.component1();
                    L2Register.RegisterKind kind2 = entityAndKind.component2();
                    if (!(entity instanceof L2SemanticValue)) continue;
                    newClamped.add(entityAndKind);
                    newClamped.add(new L2EntityAndKind((L2Entity)manifest2.getDefinition((L2SemanticValue)entity, kind2), kind2));
                }
                edge2.setForcedClampedEntities(newClamped);
            }
            this.currentOperand = edge2;
        }

        @Override
        public void doOperand(@NotNull L2PrimitiveOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doOperand(@NotNull L2ReadBoxedVectorOperand operand) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(operand, "operand");
            Iterable iterable = operand.getElements();
            L2Regenerator l2Regenerator = L2Regenerator.this;
            AbstractOperandTransformer abstractOperandTransformer = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                L2ReadBoxedOperand l2ReadBoxedOperand = (L2ReadBoxedOperand)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add((L2ReadBoxedOperand)l2Regenerator.transformOperand((L2Operand)p0));
            }
            List list2 = (List)destination$iv$iv;
            abstractOperandTransformer.currentOperand = new L2ReadBoxedVectorOperand(list2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doOperand(@NotNull L2ReadIntVectorOperand operand) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(operand, "operand");
            Iterable iterable = operand.getElements();
            L2Regenerator l2Regenerator = L2Regenerator.this;
            AbstractOperandTransformer abstractOperandTransformer = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                L2ReadIntOperand l2ReadIntOperand = (L2ReadIntOperand)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add((L2ReadIntOperand)l2Regenerator.transformOperand((L2Operand)p0));
            }
            List list2 = (List)destination$iv$iv;
            abstractOperandTransformer.currentOperand = new L2ReadIntVectorOperand(list2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doOperand(@NotNull L2ReadFloatVectorOperand operand) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(operand, "operand");
            Iterable iterable = operand.getElements();
            L2Regenerator l2Regenerator = L2Regenerator.this;
            AbstractOperandTransformer abstractOperandTransformer = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                L2ReadFloatOperand l2ReadFloatOperand = (L2ReadFloatOperand)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add((L2ReadFloatOperand)l2Regenerator.transformOperand((L2Operand)p0));
            }
            List list2 = (List)destination$iv$iv;
            abstractOperandTransformer.currentOperand = new L2ReadFloatVectorOperand(list2);
        }

        @Override
        public void doOperand(@NotNull L2SelectorOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doOperand(@NotNull L2PcVectorOperand operand) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(operand, "operand");
            Iterable iterable = operand.getEdges();
            L2Regenerator l2Regenerator = L2Regenerator.this;
            AbstractOperandTransformer abstractOperandTransformer = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                L2PcOperand l2PcOperand = (L2PcOperand)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add((L2PcOperand)l2Regenerator.transformOperand((L2Operand)p0));
            }
            List list2 = (List)destination$iv$iv;
            abstractOperandTransformer.currentOperand = new L2PcVectorOperand(list2);
        }

        private static final Map mapBlock$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (Map)$tmp0.invoke(p0);
        }

        private static final L2BasicBlock mapBlock$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (L2BasicBlock)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\rH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lavail/optimizer/reoptimizer/L2Regenerator$OperandRegisterTransformer;", "Lavail/optimizer/reoptimizer/L2Regenerator$AbstractOperandTransformer;", "Lavail/optimizer/reoptimizer/L2Regenerator;", "(Lavail/optimizer/reoptimizer/L2Regenerator;)V", "registerMap", "", "Lavail/interpreter/levelTwo/register/L2Register;", "doOperand", "", "operand", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadFloatOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadIntOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteBoxedOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteFloatOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteIntOperand;", "avail"})
    public final class OperandRegisterTransformer
    extends AbstractOperandTransformer {
        @NotNull
        private final Map<L2Register, L2Register> registerMap = new LinkedHashMap();

        @Override
        public void doOperand(@NotNull L2ReadIntOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            L2SemanticValue l2SemanticValue = operand.semanticValue();
            TypeRestriction typeRestriction = L2Regenerator.this.getTargetGenerator().getCurrentManifest().restrictionFor(operand.semanticValue());
            L2Register l2Register = this.registerMap.get(operand.register());
            Intrinsics.checkNotNull(l2Register, "null cannot be cast to non-null type avail.interpreter.levelTwo.register.L2IntRegister");
            this.setCurrentOperand(new L2ReadIntOperand(l2SemanticValue, typeRestriction, (L2IntRegister)l2Register));
        }

        @Override
        public void doOperand(@NotNull L2ReadFloatOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            L2SemanticValue l2SemanticValue = operand.semanticValue();
            TypeRestriction typeRestriction = L2Regenerator.this.getTargetGenerator().getCurrentManifest().restrictionFor(operand.semanticValue());
            L2Register l2Register = this.registerMap.get(operand.register());
            Intrinsics.checkNotNull(l2Register, "null cannot be cast to non-null type avail.interpreter.levelTwo.register.L2FloatRegister");
            this.setCurrentOperand(new L2ReadFloatOperand(l2SemanticValue, typeRestriction, (L2FloatRegister)l2Register));
        }

        @Override
        public void doOperand(@NotNull L2ReadBoxedOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            L2SemanticValue l2SemanticValue = operand.semanticValue();
            TypeRestriction typeRestriction = L2Regenerator.this.getTargetGenerator().getCurrentManifest().restrictionFor(operand.semanticValue());
            L2Register l2Register = this.registerMap.get(operand.register());
            Intrinsics.checkNotNull(l2Register, "null cannot be cast to non-null type avail.interpreter.levelTwo.register.L2BoxedRegister");
            this.setCurrentOperand(new L2ReadBoxedOperand(l2SemanticValue, typeRestriction, (L2BoxedRegister)l2Register));
        }

        @Override
        public void doOperand(@NotNull L2WriteIntOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            L2Register l2Register = this.registerMap.computeIfAbsent((L2Register)operand.register(), (Function<L2Register, L2Register>)((Function<Object, L2Register>)arg_0 -> OperandRegisterTransformer.doOperand$lambda$0(new Function1<L2Register, L2Register>(L2Regenerator.this){
                final /* synthetic */ L2Regenerator this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final L2Register invoke(@NotNull L2Register it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    int unique = this.this$0.getTargetGenerator().nextUnique();
                    return new L2IntRegister(unique);
                }
            }, arg_0)));
            Intrinsics.checkNotNullExpressionValue(l2Register, "computeIfAbsent(...)");
            L2Register newRegister2 = l2Register;
            this.setCurrentOperand(new L2WriteIntOperand(operand.semanticValues(), operand.restriction().restrictingKindsTo(TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG.getMask()), (L2IntRegister)newRegister2));
        }

        @Override
        public void doOperand(@NotNull L2WriteFloatOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            L2Register l2Register = this.registerMap.computeIfAbsent((L2Register)operand.register(), (Function<L2Register, L2Register>)((Function<Object, L2Register>)arg_0 -> OperandRegisterTransformer.doOperand$lambda$1(new Function1<L2Register, L2Register>(L2Regenerator.this){
                final /* synthetic */ L2Regenerator this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final L2Register invoke(@NotNull L2Register it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    int unique = this.this$0.getTargetGenerator().nextUnique();
                    return new L2FloatRegister(unique);
                }
            }, arg_0)));
            Intrinsics.checkNotNullExpressionValue(l2Register, "computeIfAbsent(...)");
            L2Register newRegister2 = l2Register;
            this.setCurrentOperand(new L2WriteFloatOperand(operand.semanticValues(), operand.restriction().restrictingKindsTo(TypeRestriction.RestrictionFlagEncoding.UNBOXED_FLOAT_FLAG.getMask()), (L2FloatRegister)newRegister2));
        }

        @Override
        public void doOperand(@NotNull L2WriteBoxedOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            L2Register l2Register = this.registerMap.computeIfAbsent((L2Register)operand.register(), (Function<L2Register, L2Register>)((Function<Object, L2Register>)arg_0 -> OperandRegisterTransformer.doOperand$lambda$2(new Function1<L2Register, L2Register>(L2Regenerator.this){
                final /* synthetic */ L2Regenerator this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final L2Register invoke(@NotNull L2Register it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    int unique = this.this$0.getTargetGenerator().nextUnique();
                    return new L2BoxedRegister(unique);
                }
            }, arg_0)));
            Intrinsics.checkNotNullExpressionValue(l2Register, "computeIfAbsent(...)");
            L2Register newRegister2 = l2Register;
            this.setCurrentOperand(new L2WriteBoxedOperand(operand.semanticValues(), operand.restriction().restrictingKindsTo(TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG.getMask()), (L2BoxedRegister)newRegister2));
        }

        private static final L2Register doOperand$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (L2Register)$tmp0.invoke(p0);
        }

        private static final L2Register doOperand$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (L2Register)$tmp0.invoke(p0);
        }

        private static final L2Register doOperand$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (L2Register)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\bH\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nH\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lavail/optimizer/reoptimizer/L2Regenerator$OperandSemanticTransformer;", "Lavail/optimizer/reoptimizer/L2Regenerator$AbstractOperandTransformer;", "Lavail/optimizer/reoptimizer/L2Regenerator;", "(Lavail/optimizer/reoptimizer/L2Regenerator;)V", "doOperand", "", "operand", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadFloatOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadIntOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteBoxedOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteFloatOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteIntOperand;", "avail"})
    @SourceDebugExtension(value={"SMAP\nL2Regenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 L2Regenerator.kt\navail/optimizer/reoptimizer/L2Regenerator$OperandSemanticTransformer\n+ 2 CollectionExtensions.kt\navail/utility/CollectionExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,716:1\n79#2,4:717\n79#2,4:724\n79#2,4:731\n1620#3,3:721\n1620#3,3:728\n1620#3,3:735\n*S KotlinDebug\n*F\n+ 1 L2Regenerator.kt\navail/optimizer/reoptimizer/L2Regenerator$OperandSemanticTransformer\n*L\n300#1:717,4\n310#1:724,4\n321#1:731,4\n300#1:721,3\n310#1:728,3\n321#1:735,3\n*E\n"})
    public final class OperandSemanticTransformer
    extends AbstractOperandTransformer {
        @Override
        public void doOperand(@NotNull L2ReadIntOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            this.setCurrentOperand(new L2ReadIntOperand(this.mapSemanticValue(operand.semanticValue()), L2Regenerator.this.getTargetGenerator().getCurrentManifest().restrictionFor(operand.semanticValue()), L2Regenerator.this.getTargetGenerator().getCurrentManifest()));
        }

        @Override
        public void doOperand(@NotNull L2ReadFloatOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            this.setCurrentOperand(new L2ReadFloatOperand(this.mapSemanticValue(operand.semanticValue()), L2Regenerator.this.getTargetGenerator().getCurrentManifest().restrictionFor(operand.semanticValue()), L2Regenerator.this.getTargetGenerator().getCurrentManifest()));
        }

        @Override
        public void doOperand(@NotNull L2ReadBoxedOperand operand) {
            Intrinsics.checkNotNullParameter(operand, "operand");
            this.setCurrentOperand(new L2ReadBoxedOperand(this.mapSemanticValue(operand.semanticValue()), L2Regenerator.this.getTargetGenerator().getCurrentManifest().restrictionFor(operand.semanticValue()), L2Regenerator.this.getTargetGenerator().getCurrentManifest()));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doOperand(@NotNull L2WriteIntOperand operand) {
            void $this$mapToSet_u24default$iv;
            Intrinsics.checkNotNullParameter(operand, "operand");
            Iterable iterable = operand.semanticValues();
            OperandSemanticTransformer operandSemanticTransformer = this;
            Set destination$iv = new LinkedHashSet();
            boolean $i$f$mapToSet = false;
            void $this$mapTo$iv$iv = $this$mapToSet_u24default$iv;
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                L2SemanticUnboxedInt l2SemanticUnboxedInt = (L2SemanticUnboxedInt)item$iv$iv;
                Collection collection2 = destination$iv;
                boolean bl = false;
                L2SemanticValue l2SemanticValue = this.mapSemanticValue((L2SemanticValue)it);
                Intrinsics.checkNotNull(l2SemanticValue, "null cannot be cast to non-null type avail.optimizer.values.L2SemanticUnboxedInt");
                collection2.add((L2SemanticUnboxedInt)l2SemanticValue);
            }
            L2IntRegister l2IntRegister = new L2IntRegister(L2Regenerator.this.getTargetGenerator().nextUnique());
            TypeRestriction typeRestriction = operand.restriction().restrictingKindsTo(TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG.getMask());
            Set set2 = (Set)((Collection)destination$iv);
            operandSemanticTransformer.setCurrentOperand(new L2WriteIntOperand(set2, typeRestriction, l2IntRegister));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doOperand(@NotNull L2WriteFloatOperand operand) {
            void $this$mapToSet_u24default$iv;
            Intrinsics.checkNotNullParameter(operand, "operand");
            Iterable iterable = operand.semanticValues();
            OperandSemanticTransformer operandSemanticTransformer = this;
            Set destination$iv = new LinkedHashSet();
            boolean $i$f$mapToSet = false;
            void $this$mapTo$iv$iv = $this$mapToSet_u24default$iv;
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                L2SemanticUnboxedFloat l2SemanticUnboxedFloat = (L2SemanticUnboxedFloat)item$iv$iv;
                Collection collection2 = destination$iv;
                boolean bl = false;
                L2SemanticValue l2SemanticValue = this.mapSemanticValue((L2SemanticValue)it);
                Intrinsics.checkNotNull(l2SemanticValue, "null cannot be cast to non-null type avail.optimizer.values.L2SemanticUnboxedFloat");
                collection2.add((L2SemanticUnboxedFloat)l2SemanticValue);
            }
            L2FloatRegister l2FloatRegister = new L2FloatRegister(L2Regenerator.this.getTargetGenerator().nextUnique());
            TypeRestriction typeRestriction = operand.restriction().restrictingKindsTo(TypeRestriction.RestrictionFlagEncoding.UNBOXED_FLOAT_FLAG.getMask());
            Set set2 = (Set)((Collection)destination$iv);
            operandSemanticTransformer.setCurrentOperand(new L2WriteFloatOperand(set2, typeRestriction, l2FloatRegister));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doOperand(@NotNull L2WriteBoxedOperand operand) {
            void $this$mapToSet_u24default$iv;
            Intrinsics.checkNotNullParameter(operand, "operand");
            Iterable iterable = operand.semanticValues();
            OperandSemanticTransformer operandSemanticTransformer = this;
            Set destination$iv = new LinkedHashSet();
            boolean $i$f$mapToSet = false;
            void $this$mapTo$iv$iv = $this$mapToSet_u24default$iv;
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                L2SemanticValue l2SemanticValue = (L2SemanticValue)item$iv$iv;
                Collection collection2 = destination$iv;
                boolean bl = false;
                collection2.add(this.mapSemanticValue((L2SemanticValue)it));
            }
            L2BoxedRegister l2BoxedRegister = new L2BoxedRegister(L2Regenerator.this.getTargetGenerator().nextUnique());
            TypeRestriction typeRestriction = operand.restriction().restrictingKindsTo(TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG.getMask());
            Set set2 = (Set)((Collection)destination$iv);
            operandSemanticTransformer.setCurrentOperand(new L2WriteBoxedOperand((Set<? extends L2SemanticValue>)set2, typeRestriction, l2BoxedRegister));
        }
    }
}

