/*
 * Decompiled with CFR 0.152.
 */
package avail.persistence.cache;

import avail.builder.ModuleRoot;
import avail.persistence.cache.Repository;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000bJ\u0006\u0010\u0017\u001a\u00020\u0011J\u0006\u0010\u0018\u001a\u00020\u0011J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000bJ\u0013\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\u000bH\u0086\u0002J\u000e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bRN\u0010\t\u001aB\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r \f* \u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r\u0018\u00010\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lavail/persistence/cache/Repositories;", "", "()V", "directory", "Ljava/io/File;", "getDirectory", "()Ljava/io/File;", "setDirectory", "(Ljava/io/File;)V", "repositories", "", "", "kotlin.jvm.PlatformType", "Lavail/persistence/cache/Repository;", "", "repositoryExtension", "addRepository", "", "root", "Lavail/builder/ModuleRoot;", "clearAllRepositories", "clearRepositoryFor", "rootName", "closeAllRepositories", "closeAndRemoveAllRepositories", "deleteRepository", "get", "name", "setDirectoryLocation", "repositoriesPath", "avail"})
@SourceDebugExtension(value={"SMAP\nRepositories.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Repositories.kt\navail/persistence/cache/Repositories\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1855#2,2:155\n1855#2,2:157\n1855#2,2:159\n1#3:161\n*S KotlinDebug\n*F\n+ 1 Repositories.kt\navail/persistence/cache/Repositories\n*L\n121#1:155,2\n141#1:157,2\n150#1:159,2\n*E\n"})
public final class Repositories {
    @NotNull
    public static final Repositories INSTANCE;
    @NotNull
    private static final String repositoryExtension = "repo";
    @NotNull
    private static File directory;
    private static final Map<String, Repository> repositories;

    private Repositories() {
    }

    @NotNull
    public final File getDirectory() {
        return directory;
    }

    public final void setDirectory(@NotNull File file2) {
        Intrinsics.checkNotNullParameter(file2, "<set-?>");
        directory = file2;
    }

    public final void setDirectoryLocation(@NotNull File repositoriesPath) {
        Intrinsics.checkNotNullParameter(repositoriesPath, "repositoriesPath");
        directory = repositoriesPath;
    }

    @Nullable
    public final Repository get(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return repositories.get(name);
    }

    public final void addRepository(@NotNull ModuleRoot root) {
        Intrinsics.checkNotNullParameter(root, "root");
        Map<String, Repository> map = repositories;
        Intrinsics.checkNotNullExpressionValue(map, "repositories");
        Map<String, Repository> map2 = map;
        String string2 = root.getName();
        Repository repository = new Repository(root.getName(), new File(directory.getAbsolutePath() + "/" + root.getName() + ".repo"));
        map2.put(string2, repository);
    }

    public final void deleteRepository(@NotNull String rootName) {
        Intrinsics.checkNotNullParameter(rootName, "rootName");
        repositories.remove(rootName);
    }

    public final void clearAllRepositories() {
        Iterable $this$forEach$iv = repositories.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Repository p0 = (Repository)element$iv;
            boolean bl = false;
            p0.clear();
        }
    }

    public final void clearRepositoryFor(@NotNull String rootName) {
        block0: {
            Intrinsics.checkNotNullParameter(rootName, "rootName");
            Repository repository = repositories.get(rootName);
            if (repository == null) break block0;
            repository.clear();
        }
    }

    public final void closeAllRepositories() {
        Iterable $this$forEach$iv = repositories.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Repository p0 = (Repository)element$iv;
            boolean bl = false;
            p0.close();
        }
    }

    public final void closeAndRemoveAllRepositories() {
        Iterable $this$forEach$iv = repositories.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Repository p0 = (Repository)element$iv;
            boolean bl = false;
            p0.close();
        }
        repositories.clear();
    }

    static {
        Object object;
        INSTANCE = new Repositories();
        String string2 = System.getProperty("avail.repositories");
        if (string2 == null) {
            Repositories $this$_init__u24lambda_u240 = INSTANCE;
            boolean bl = false;
            String home2 = System.getProperty("user.home");
            object = home2 + "/.avail/repositories/";
        } else {
            object = string2;
        }
        String repositoriesPath = object;
        File repos = new File(repositoriesPath);
        repos.mkdirs();
        boolean bl = repos.isDirectory();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string3 = repositoriesPath + " must be a directory";
            throw new AssertionError((Object)string3);
        }
        directory = repos;
        repositories = Collections.synchronizedMap(new LinkedHashMap());
    }
}

