/*
 * Decompiled with CFR 0.152.
 */
package avail.persistence.cache.record;

import avail.persistence.cache.Repository;
import avail.utility.CodingKt;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\tH\u0002J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\tH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lavail/persistence/cache/record/ModuleCompilationKey;", "", "binaryStream", "Ljava/io/DataInputStream;", "(Ljava/io/DataInputStream;)V", "predecessorCompilationTimes", "", "([J)V", "hash", "", "computeHash", "equals", "", "other", "hashCode", "write", "", "Ljava/io/DataOutputStream;", "avail"})
public final class ModuleCompilationKey {
    @NotNull
    private final long[] predecessorCompilationTimes;
    private final int hash;

    public int hashCode() {
        return this.hash;
    }

    private final int computeHash() {
        int h = -1638334171;
        for (long predecessorCompilationTime : this.predecessorCompilationTimes) {
            h = Repository.Companion.mix$avail(h, predecessorCompilationTime);
        }
        return h;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ModuleCompilationKey)) {
            return false;
        }
        ModuleCompilationKey key = (ModuleCompilationKey)other;
        if (this.hash != key.hash) return false;
        if (!Arrays.equals(this.predecessorCompilationTimes, key.predecessorCompilationTimes)) return false;
        return true;
    }

    public final void write(@NotNull DataOutputStream binaryStream) throws IOException {
        Intrinsics.checkNotNullParameter(binaryStream, "binaryStream");
        CodingKt.vlq(binaryStream, this.predecessorCompilationTimes.length);
        for (long predecessorCompilationTime : this.predecessorCompilationTimes) {
            binaryStream.writeLong(predecessorCompilationTime);
        }
    }

    public ModuleCompilationKey(@NotNull DataInputStream binaryStream) throws IOException {
        Intrinsics.checkNotNullParameter(binaryStream, "binaryStream");
        int predecessorsCount = CodingKt.unvlqInt(binaryStream);
        this.predecessorCompilationTimes = new long[predecessorsCount];
        for (int i2 = 0; i2 < predecessorsCount; ++i2) {
            this.predecessorCompilationTimes[i2] = binaryStream.readLong();
        }
        this.hash = this.computeHash();
    }

    public ModuleCompilationKey(@NotNull long[] predecessorCompilationTimes) {
        Intrinsics.checkNotNullParameter(predecessorCompilationTimes, "predecessorCompilationTimes");
        this.predecessorCompilationTimes = (long[])predecessorCompilationTimes.clone();
        this.hash = this.computeHash();
    }
}

