/*
 * Decompiled with CFR 0.152.
 */
package avail.persistence.cache.record;

import avail.builder.ResolvedModuleName;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0002J\u0013\u0010\u0017\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u001dR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lavail/persistence/cache/record/ModuleVersionKey;", "", "binaryStream", "Ljava/io/DataInputStream;", "(Ljava/io/DataInputStream;)V", "moduleName", "Lavail/builder/ResolvedModuleName;", "sourceDigest", "", "(Lavail/builder/ResolvedModuleName;[B)V", "hash", "", "isPackage", "", "shortString", "", "getShortString", "()Ljava/lang/String;", "getSourceDigest", "()[B", "compareTo", "other", "computeHash", "equals", "", "hashCode", "toString", "write", "", "Ljava/io/DataOutputStream;", "avail"})
public final class ModuleVersionKey
implements Comparable<ModuleVersionKey> {
    private final boolean isPackage;
    @NotNull
    private final byte[] sourceDigest;
    private final int hash;

    @NotNull
    public final byte[] getSourceDigest() {
        return this.sourceDigest;
    }

    public int hashCode() {
        return this.hash;
    }

    private final int computeHash() {
        long h = this.isPackage ? 3735928559L : 2896935534L;
        for (byte digestByte : this.sourceDigest) {
            h = h * (long)1664525 + (long)digestByte;
        }
        return (int)h;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ModuleVersionKey)) {
            return false;
        }
        ModuleVersionKey key = (ModuleVersionKey)other;
        return this.hash == key.hash && this.isPackage == key.isPackage && Arrays.equals(this.sourceDigest, key.sourceDigest);
    }

    public final void write(@NotNull DataOutputStream binaryStream) throws IOException {
        Intrinsics.checkNotNullParameter(binaryStream, "binaryStream");
        binaryStream.writeBoolean(this.isPackage);
        binaryStream.write(this.sourceDigest);
    }

    @NotNull
    public String toString() {
        String string2 = "VersionKey(@%s...)";
        Object[] objectArray = new Object[]{this.getShortString()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
        return string3;
    }

    public ModuleVersionKey(@NotNull DataInputStream binaryStream) throws IOException {
        Intrinsics.checkNotNullParameter(binaryStream, "binaryStream");
        this.isPackage = binaryStream.readBoolean();
        this.sourceDigest = new byte[32];
        binaryStream.readFully(this.sourceDigest);
        this.hash = this.computeHash();
    }

    public ModuleVersionKey(@NotNull ResolvedModuleName moduleName2, @NotNull byte[] sourceDigest) {
        boolean bl;
        Intrinsics.checkNotNullParameter(moduleName2, "moduleName");
        Intrinsics.checkNotNullParameter(sourceDigest, "sourceDigest");
        boolean bl2 = bl = sourceDigest.length == 32;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.sourceDigest = (byte[])sourceDigest.clone();
        this.isPackage = moduleName2.isPackage();
        this.hash = this.computeHash();
    }

    @NotNull
    public final String getShortString() {
        String string2 = "%02x%02x%02x";
        Object[] objectArray = new Object[]{this.sourceDigest[0], this.sourceDigest[1], this.sourceDigest[2]};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
        return string3;
    }

    @Override
    public int compareTo(@NotNull ModuleVersionKey other) {
        Intrinsics.checkNotNullParameter(other, "other");
        for (int i2 = 0; i2 < this.sourceDigest.length && i2 < other.sourceDigest.length; ++i2) {
            int d = Intrinsics.compare(UByte.constructor-impl(this.sourceDigest[i2]) & 0xFF, UByte.constructor-impl(other.sourceDigest[i2]) & 0xFF);
            if (d == 0) continue;
            return d;
        }
        return this.sourceDigest.length - other.sourceDigest.length;
    }
}

