/*
 * Decompiled with CFR 0.152.
 */
package avail.tools.bootstrap;

import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.VariableTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.tools.bootstrap.PropertiesFileGenerator;
import avail.tools.bootstrap.Resources;
import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lavail/tools/bootstrap/ErrorCodeNamesGenerator;", "Lavail/tools/bootstrap/PropertiesFileGenerator;", "locale", "Ljava/util/Locale;", "(Ljava/util/Locale;)V", "generateProperties", "", "properties", "Ljava/util/Properties;", "writer", "Ljava/io/PrintWriter;", "Companion", "avail"})
@SourceDebugExtension(value={"SMAP\nErrorCodeNamesGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorCodeNamesGenerator.kt\navail/tools/bootstrap/ErrorCodeNamesGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n1855#2,2:243\n1855#2,2:245\n*S KotlinDebug\n*F\n+ 1 ErrorCodeNamesGenerator.kt\navail/tools/bootstrap/ErrorCodeNamesGenerator\n*L\n93#1:243,2\n143#1:245,2\n*E\n"})
public final class ErrorCodeNamesGenerator
extends PropertiesFileGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ErrorCodeNamesGenerator(@Nullable Locale locale) {
        String string2 = Resources.INSTANCE.getErrorCodesBaseName();
        Locale locale2 = locale;
        Intrinsics.checkNotNull(locale2);
        super(string2, locale2);
    }

    @Override
    protected void generateProperties(@NotNull Properties properties2, @NotNull PrintWriter writer) {
        String key;
        Intrinsics.checkNotNullParameter(properties2, "properties");
        Intrinsics.checkNotNullParameter(writer, "writer");
        PrintWriter $this$generateProperties_u24lambda_u242 = writer;
        boolean bl = false;
        Set keys2 = new LinkedHashSet();
        Iterable $this$forEach$iv = AvailErrorCode.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AvailErrorCode code = (AvailErrorCode)((Object)element$iv);
            boolean bl2 = false;
            if (code.nativeCode() <= 0) continue;
            $this$generateProperties_u24lambda_u242.print("# ");
            $this$generateProperties_u24lambda_u242.print(code.nativeCode());
            $this$generateProperties_u24lambda_u242.print(" : ");
            $this$generateProperties_u24lambda_u242.print(code.name());
            $this$generateProperties_u24lambda_u242.println();
            key = Resources.INSTANCE.errorCodeKey(code);
            keys2.add(key);
            $this$generateProperties_u24lambda_u242.print(key);
            $this$generateProperties_u24lambda_u242.print('=');
            String errorCodeName = properties2.getProperty(key);
            if (errorCodeName != null) {
                $this$generateProperties_u24lambda_u242.print(Resources.INSTANCE.escape(errorCodeName));
            } else if (Intrinsics.areEqual(this.getLocale().getLanguage(), "en")) {
                String string2 = code.name().substring(2);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
                String string3 = string2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                $this$generateProperties_u24lambda_u242.print(StringsKt.replace$default(string3, '_', '-', false, 4, null));
                $this$generateProperties_u24lambda_u242.print(" code");
            }
            $this$generateProperties_u24lambda_u242.println();
            String exceptionKey = Resources.INSTANCE.errorCodeExceptionKey(code);
            keys2.add(exceptionKey);
            $this$generateProperties_u24lambda_u242.print(exceptionKey);
            $this$generateProperties_u24lambda_u242.print('=');
            String exception = properties2.getProperty(exceptionKey);
            if (exception != null) {
                $this$generateProperties_u24lambda_u242.print(Resources.INSTANCE.escape(exception));
            } else if (Intrinsics.areEqual(this.getLocale().getLanguage(), "en")) {
                String string4 = code.name().substring(2);
                Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String).substring(startIndex)");
                String string5 = string4.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                $this$generateProperties_u24lambda_u242.print(StringsKt.replace$default(string5, '_', '-', false, 4, null));
                $this$generateProperties_u24lambda_u242.print(" exception");
            }
            $this$generateProperties_u24lambda_u242.println();
            String commentKey = Resources.INSTANCE.errorCodeCommentKey(code);
            keys2.add(commentKey);
            $this$generateProperties_u24lambda_u242.print(commentKey);
            $this$generateProperties_u24lambda_u242.print('=');
            String comment = properties2.getProperty(commentKey);
            if (comment != null) {
                $this$generateProperties_u24lambda_u242.print(Resources.INSTANCE.escape(comment));
            }
            $this$generateProperties_u24lambda_u242.println();
        }
        Set<Object> set2 = properties2.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        $this$forEach$iv = set2;
        $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object property = element$iv = iterator2.next();
            boolean bl3 = false;
            Intrinsics.checkNotNull(property, "null cannot be cast to non-null type kotlin.String");
            key = (String)property;
            if (keys2.contains(key)) continue;
            keys2.add(key);
            $this$generateProperties_u24lambda_u242.print(key);
            $this$generateProperties_u24lambda_u242.print('=');
            String string6 = properties2.getProperty(key);
            Intrinsics.checkNotNullExpressionValue(string6, "getProperty(...)");
            $this$generateProperties_u24lambda_u242.println(Resources.INSTANCE.escape(string6));
        }
    }

    @JvmStatic
    public static final void main(@NotNull String[] args2) throws Exception {
        Companion.main(args2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lavail/tools/bootstrap/ErrorCodeNamesGenerator$Companion;", "", "()V", "allErrorCodesAreReachableFromPrimitives", "", "main", "", "args", "", "", "([Ljava/lang/String;)V", "avail"})
    @SourceDebugExtension(value={"SMAP\nErrorCodeNamesGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorCodeNamesGenerator.kt\navail/tools/bootstrap/ErrorCodeNamesGenerator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,242:1\n1855#2,2:243\n1855#2,2:247\n215#3,2:245\n13309#4,2:249\n*S KotlinDebug\n*F\n+ 1 ErrorCodeNamesGenerator.kt\navail/tools/bootstrap/ErrorCodeNamesGenerator$Companion\n*L\n170#1:243,2\n205#1:247,2\n179#1:245,2\n235#1:249,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean allErrorCodesAreReachableFromPrimitives() {
            Object element$iv2;
            A_Set allErrorCodes = null;
            allErrorCodes = SetDescriptor.Companion.getEmptySet();
            Iterable $this$forEach$iv = AvailErrorCode.getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                AvailErrorCode code = (AvailErrorCode)((Object)element$iv2);
                boolean bl = false;
                if (code.isCausedByInstructionFailure()) continue;
                allErrorCodes = A_Set.Companion.setWithElementCanDestroy(allErrorCodes, code.numericCode(), true);
            }
            A_Set reachableErrorCodes = null;
            reachableErrorCodes = SetDescriptor.Companion.getEmptySet();
            Map<String, Primitive.PrimitiveHolder> $this$forEach$iv2 = Primitive.PrimitiveHolder.Companion.getHoldersByName();
            boolean $i$f$forEach2 = false;
            element$iv2 = $this$forEach$iv2.entrySet().iterator();
            while (element$iv2.hasNext()) {
                Map.Entry element$iv3;
                Map.Entry entry = element$iv3 = (Map.Entry)element$iv2.next();
                boolean bl = false;
                Primitive.PrimitiveHolder holder = (Primitive.PrimitiveHolder)entry.getValue();
                Primitive primitive2 = holder.getPrimitive();
                if (primitive2.hasFlag(Primitive.Flag.CannotFail)) continue;
                A_Type failureType = primitive2.getFailureVariableType();
                if (failureType.isEnumeration()) {
                    reachableErrorCodes = A_Set.Companion.setUnionCanDestroy(reachableErrorCodes, A_Type.Companion.getInstances(failureType), true);
                    continue;
                }
                if (!A_Type.Companion.isSubtypeOf(failureType, VariableTypeDescriptor.Companion.getMostGeneralVariableType())) continue;
                reachableErrorCodes = A_Set.Companion.setUnionCanDestroy(reachableErrorCodes, A_Type.Companion.getInstances(A_Type.Companion.getReadType(failureType)), true);
            }
            A_Set unreachableErrorCodes = A_Set.Companion.setMinusCanDestroy(allErrorCodes, reachableErrorCodes, true);
            if (A_Set.Companion.getSetSize(unreachableErrorCodes) != 0) {
                EnumSet<AvailErrorCode> unreachable = EnumSet.noneOf(AvailErrorCode.class);
                Iterable $this$forEach$iv3 = unreachableErrorCodes;
                boolean $i$f$forEach3 = false;
                for (Object element$iv4 : $this$forEach$iv3) {
                    AvailObject code = (AvailObject)element$iv4;
                    boolean bl = false;
                    unreachable.add(AvailErrorCode.Companion.byNumericCode(A_Number.Companion.getExtractInt(code)));
                }
                Object[] objectArray = new Object[]{unreachable};
                System.err.printf("some error codes are unreachable: %s%n", objectArray);
                return false;
            }
            return true;
        }

        @JvmStatic
        public final void main(@NotNull String[] args2) throws Exception {
            String[] languages;
            Intrinsics.checkNotNullParameter(args2, "args");
            if (!(args2.length == 0)) {
                v0 = args2;
            } else {
                String[] stringArray = new String[]{System.getProperty("user.language")};
                v0 = languages = stringArray;
            }
            if (this.allErrorCodesAreReachableFromPrimitives()) {
                String[] $this$forEach$iv = languages;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    String element$iv;
                    String language = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    new ErrorCodeNamesGenerator(new Locale(language)).generate();
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

