/*
 * Decompiled with CFR 0.152.
 */
package avail.utility;

import avail.interpreter.execution.Interpreter;
import avail.utility.structures.LeftistHeap;
import avail.utility.structures.LeftistHeapKt;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0010)\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0016\u001a\u00020\u00062\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0018H\u0016J \u0010\u0016\u001a\u00020\u00062\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0096\u0002J\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ%\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00028\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016\u00a2\u0006\u0002\u0010%J\u000f\u0010&\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010'J\u000f\u0010(\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010'J\u001f\u0010(\u001a\u0004\u0018\u00018\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016\u00a2\u0006\u0002\u0010)J\u0015\u0010*\u001a\u00020+2\u0006\u0010 \u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020\u0006H\u0016J\u0015\u0010.\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ\r\u0010/\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010'R.\u0010\b\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u000b*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n0\n0\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0010\u001a\"\u0012\u001e\u0012\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u000b*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n0\n0\t0\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00060"}, d2={"Lavail/utility/WorkStealingQueue;", "E", "", "Ljava/util/concurrent/BlockingQueue;", "Ljava/util/AbstractQueue;", "parallelism", "", "(I)V", "localQueue", "Ljava/util/concurrent/atomic/AtomicReference;", "Lavail/utility/structures/LeftistHeap;", "kotlin.jvm.PlatformType", "getLocalQueue", "()Ljava/util/concurrent/atomic/AtomicReference;", "monitor", "Ljava/lang/Object;", "queues", "", "[Ljava/util/concurrent/atomic/AtomicReference;", "size", "getSize", "()I", "drainTo", "c", "", "maxElements", "iterator", "", "offer", "", "element", "(Ljava/lang/Comparable;)Z", "e", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(Ljava/lang/Comparable;JLjava/util/concurrent/TimeUnit;)Z", "peek", "()Ljava/lang/Comparable;", "poll", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Comparable;", "put", "", "(Ljava/lang/Comparable;)V", "remainingCapacity", "remove", "take", "avail"})
@SourceDebugExtension(value={"SMAP\nWorkStealingQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkStealingQueue.kt\navail/utility/WorkStealingQueue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,275:1\n1#2:276\n12474#3,2:277\n13309#3,2:279\n13309#3,2:281\n*S KotlinDebug\n*F\n+ 1 WorkStealingQueue.kt\navail/utility/WorkStealingQueue\n*L\n245#1:277,2\n260#1:279,2\n268#1:281,2\n*E\n"})
public final class WorkStealingQueue<E extends Comparable<? super E>>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final int parallelism;
    @NotNull
    private final AtomicReference<LeftistHeap<E>>[] queues;
    @NotNull
    private final Object monitor;

    public WorkStealingQueue(int parallelism) {
        this.parallelism = parallelism;
        int n = 0;
        int n2 = this.parallelism;
        AtomicReference[] atomicReferenceArray = new AtomicReference[n2];
        WorkStealingQueue workStealingQueue = this;
        while (n < n2) {
            int n3 = n++;
            atomicReferenceArray[n3] = new AtomicReference(LeftistHeapKt.leftistLeaf());
        }
        workStealingQueue.queues = atomicReferenceArray;
        this.monitor = new Object();
    }

    private final AtomicReference<LeftistHeap<E>> getLocalQueue() {
        return this.queues[Interpreter.Companion.currentIndexOrZero()];
    }

    /*
     * WARNING - void declaration
     */
    public int getSize() {
        AtomicReference<LeftistHeap<E>>[] atomicReferenceArray = this.queues;
        int n = 0;
        int n2 = atomicReferenceArray.length;
        for (int j = 0; j < n2; ++j) {
            void it;
            AtomicReference<LeftistHeap<E>> atomicReference;
            AtomicReference<LeftistHeap<E>> atomicReference2 = atomicReference = atomicReferenceArray[j];
            int n3 = n;
            boolean bl = false;
            int n4 = ((LeftistHeap)it.get()).getSize();
            n = n3 + n4;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int drainTo(@NotNull Collection<? super E> c) {
        Intrinsics.checkNotNullParameter(c, "c");
        AtomicReference<LeftistHeap<E>>[] atomicReferenceArray = this.queues;
        int n = 0;
        int n2 = atomicReferenceArray.length;
        for (int j = 0; j < n2; ++j) {
            void it;
            AtomicReference<LeftistHeap<E>> atomicReference;
            AtomicReference<LeftistHeap<E>> atomicReference2 = atomicReference = atomicReferenceArray[j];
            int n3 = n;
            boolean bl = false;
            LeftistHeap heap = it.getAndSet(LeftistHeapKt.leftistLeaf());
            c.addAll(heap.toList());
            int n4 = heap.getSize();
            n = n3 + n4;
        }
        return n;
    }

    @Override
    public int drainTo(@NotNull Collection<? super E> c, int maxElements) {
        Intrinsics.checkNotNullParameter(c, "c");
        int remaining = maxElements;
        block0: for (AtomicReference<LeftistHeap<E>> queue : this.queues) {
            while (remaining > 0) {
                LeftistHeap<E> oldHeap = queue.get();
                if (oldHeap.isEmpty()) continue block0;
                if (oldHeap.getSize() <= remaining) {
                    if (!queue.compareAndSet(oldHeap, LeftistHeapKt.leftistLeaf())) continue;
                    c.addAll(oldHeap.toList());
                    remaining -= oldHeap.getSize();
                    continue block0;
                }
                LeftistHeap<E> newHeap = oldHeap.getWithoutFirst();
                if (!queue.compareAndSet(oldHeap, newHeap)) continue;
                c.add(oldHeap.getFirst());
                --remaining;
            }
            break block0;
        }
        return maxElements - remaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, "element");
        AtomicReference<LeftistHeap<E>> queue = this.getLocalQueue();
        LeftistHeap<E> oldHeap = null;
        do {
            Intrinsics.checkNotNullExpressionValue(queue.get(), "get(...)");
        } while (!queue.compareAndSet(oldHeap, oldHeap.with(element)));
        int n = oldHeap.getSize() + 1;
        if (n == 1 ? true : n == 2) {
            Object object = this.monitor;
            synchronized (object) {
                boolean $i$a$-synchronized-WorkStealingQueue$offer$42 = false;
                this.monitor.notify();
                Unit $i$a$-synchronized-WorkStealingQueue$offer$42 = Unit.INSTANCE;
            }
        }
        if (n == 5) {
            Object object = this.monitor;
            synchronized (object) {
                boolean $i$a$-synchronized-WorkStealingQueue$offer$52 = false;
                this.monitor.notify();
                this.monitor.notify();
                Unit $i$a$-synchronized-WorkStealingQueue$offer$52 = Unit.INSTANCE;
            }
        }
        if (n == this.parallelism + 1) {
            Object object = this.monitor;
            synchronized (object) {
                boolean bl = false;
                this.monitor.notifyAll();
                Unit unit = Unit.INSTANCE;
            }
        }
        return true;
    }

    @Override
    public boolean offer(@NotNull E e, long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter(e, "e");
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        return this.offer(e);
    }

    @Override
    @Nullable
    public E poll() {
        LeftistHeap<E> heap;
        AtomicReference<LeftistHeap<E>> queue = this.getLocalQueue();
        while (!(heap = queue.get()).isEmpty()) {
            if (!queue.compareAndSet(heap, heap.getWithoutFirst())) continue;
            return heap.getFirst();
        }
        for (AtomicReference<LeftistHeap<E>> q : this.queues) {
            LeftistHeap<E> heap2;
            while (!(heap2 = q.get()).isEmpty()) {
                if (!q.compareAndSet(heap2, heap2.getWithoutFirst())) continue;
                return heap2.getFirst();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public E poll(long timeout, @NotNull TimeUnit unit) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        boolean bl2 = bl = timeout >= 0L;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Object object = this.poll();
        if (object != null) {
            Object it = object;
            boolean bl3 = false;
            return (E)it;
        }
        if (timeout == 0L) {
            Object object2 = this.monitor;
            synchronized (object2) {
                Object object3;
                boolean bl4 = false;
                while (true) {
                    this.monitor.wait();
                    Object object4 = this.poll();
                    if (object4 == null) break block14;
                    Object it = object4;
                    boolean bl5 = false;
                    object3 = it;
                    break;
                }
                {
                    block14: {
                        return (E)object3;
                    }
                    continue;
                }
            }
        }
        long expiry = System.nanoTime() + unit.toNanos(timeout);
        Object object5 = this.monitor;
        synchronized (object5) {
            E e;
            long nanos;
            boolean bl6 = false;
            while (true) {
                if ((nanos = expiry - System.nanoTime()) > 0L) break block15;
                e = null;
                break;
            }
            {
                block16: {
                    block15: {
                        return e;
                    }
                    this.monitor.wait(nanos / (long)1000000, (int)(nanos % (long)1000000));
                    Object object6 = this.poll();
                    if (object6 == null) break block16;
                    Object it = object6;
                    boolean bl7 = false;
                    Object object7 = it;
                    return (E)object7;
                }
                continue;
            }
        }
    }

    @Override
    public void put(@NotNull E e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public E take() {
        Object object = this.poll();
        if (object != null) {
            Object it = object;
            boolean bl = false;
            return (E)it;
        }
        Object object2 = this.monitor;
        synchronized (object2) {
            void var5_8;
            boolean bl = false;
            while (true) {
                void var3_5;
                this.monitor.wait();
                Object object3 = this.poll();
                if (object3 == null) break block6;
                Object it = object3;
                boolean bl2 = false;
                var5_8 = var3_5;
                break;
            }
            {
                block6: {
                    return var5_8;
                }
                continue;
            }
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean remove(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, "element");
        AtomicReference<LeftistHeap<E>>[] $this$any$iv = this.queues;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        if (n < n2) {
            LeftistHeap<E> oldHeap;
            LeftistHeap<E> newHeap;
            AtomicReference<LeftistHeap<E>> element$iv;
            AtomicReference<LeftistHeap<E>> queue = element$iv = $this$any$iv[n];
            boolean bl = false;
            while ((newHeap = (oldHeap = queue.get()).without(element)) != oldHeap) {
                if (!queue.compareAndSet(oldHeap, newHeap)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        List list2 = new ArrayList();
        AtomicReference<LeftistHeap<E>>[] $this$forEach$iv = this.queues;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            AtomicReference<LeftistHeap<E>> element$iv;
            AtomicReference<LeftistHeap<E>> q = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            list2.addAll((Collection)q.get().toList());
        }
        return list2.iterator();
    }

    @Override
    @Nullable
    public E peek() {
        LeftistHeap<E> heap = this.getLocalQueue().get();
        if (!heap.isEmpty()) {
            return heap.getFirst();
        }
        AtomicReference<LeftistHeap<E>>[] $this$forEach$iv = this.queues;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            AtomicReference<LeftistHeap<E>> element$iv;
            AtomicReference<LeftistHeap<E>> q = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            LeftistHeap<E> h = q.get();
            if (h.isEmpty()) continue;
            return h.getFirst();
        }
        return null;
    }
}

