/*
 * Decompiled with CFR 0.152.
 */
package avail.utility.fsm;

import avail.utility.fsm.ExecutionContext;
import avail.utility.fsm.InvalidContextException;
import avail.utility.fsm.InvalidTransitionException;
import avail.utility.fsm.StateSummary;
import avail.utility.fsm.StateTransitionArc;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\u000e\b\u0002\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u0002*\u000e\b\u0003\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u0002*\u0004\b\u0004\u0010\u00062\u00020\u0007B;\b\u0000\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012*\u0010\t\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u000b0\n\u00a2\u0006\u0002\u0010\fJ.\u0010\u0012\u001a\u00020\u00132$\u0010\u0014\u001a \u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u000bH\u0002J1\u0010\u0015\u001a \u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u00162\u0006\u0010\u0017\u001a\u00028\u0004\u00a2\u0006\u0002\u0010\u0018J.\u0010\u0019\u001a\u00020\u00132$\u0010\u001a\u001a \u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u0016H\u0002J=\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00028\u00012$\u0010\u001d\u001a \u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u0016H\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0016\u0010\b\u001a\u00028\u0000X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR8\u0010\u0010\u001a,\u0012\u0004\u0012\u00028\u0000\u0012\"\u0012 \u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u000b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lavail/utility/fsm/StateMachine;", "State", "", "Event", "GuardKey", "ActionKey", "Memento", "", "initialState", "summaries", "", "Lavail/utility/fsm/StateSummary;", "(Ljava/lang/Enum;Ljava/util/Collection;)V", "getInitialState$avail", "()Ljava/lang/Enum;", "Ljava/lang/Enum;", "transitionTable", "Ljava/util/EnumMap;", "addStateSummary", "", "summary", "createExecutionContext", "Lavail/utility/fsm/ExecutionContext;", "memento", "(Ljava/lang/Object;)Lavail/utility/fsm/ExecutionContext;", "followAutomaticTransitions", "executionContext", "handleEvent", "event", "context", "handleEvent$avail", "(Ljava/lang/Enum;Lavail/utility/fsm/ExecutionContext;)V", "avail"})
@SourceDebugExtension(value={"SMAP\nStateMachine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateMachine.kt\navail/utility/fsm/StateMachine\n+ 2 Casts.kt\navail/utility/CastsKt\n*L\n1#1,239:1\n46#2:240\n*S KotlinDebug\n*F\n+ 1 StateMachine.kt\navail/utility/fsm/StateMachine\n*L\n127#1:240\n*E\n"})
public final class StateMachine<State extends Enum<State>, Event extends Enum<Event>, GuardKey extends Enum<GuardKey>, ActionKey extends Enum<ActionKey>, Memento> {
    @NotNull
    private final State initialState;
    @NotNull
    private final EnumMap<State, StateSummary<State, Event, GuardKey, ActionKey, Memento>> transitionTable;

    public StateMachine(@NotNull State initialState, @NotNull Collection<StateSummary<State, Event, GuardKey, ActionKey, Memento>> summaries) {
        Intrinsics.checkNotNullParameter(initialState, "initialState");
        Intrinsics.checkNotNullParameter(summaries, "summaries");
        this.initialState = initialState;
        Class<?> $this$cast$iv = this.initialState.getClass();
        boolean $i$f$cast = false;
        this.transitionTable = new EnumMap((Class)((Object)$this$cast$iv));
        for (StateSummary<State, Event, GuardKey, ActionKey, Memento> summary : summaries) {
            this.addStateSummary(summary);
        }
    }

    @NotNull
    public final State getInitialState$avail() {
        return this.initialState;
    }

    private final void addStateSummary(StateSummary<State, Event, GuardKey, ActionKey, Memento> summary) {
        boolean bl;
        boolean bl2 = bl = !this.transitionTable.containsKey(summary.getState());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        ((Map)this.transitionTable).put(summary.getState(), summary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ExecutionContext<State, Event, GuardKey, ActionKey, Memento> createExecutionContext(Memento memento) {
        ExecutionContext context;
        ExecutionContext executionContext = context = new ExecutionContext(this, memento);
        synchronized (executionContext) {
            boolean bl = false;
            StateSummary<State, Event, GuardKey, ActionKey, Memento> stateSummary = this.transitionTable.get(this.initialState);
            Intrinsics.checkNotNull(stateSummary);
            context.executeAction$avail(stateSummary.getEntryAction());
            this.followAutomaticTransitions(context);
            Unit unit = Unit.INSTANCE;
        }
        return context;
    }

    private final void followAutomaticTransitions(ExecutionContext<State, Event, GuardKey, ActionKey, Memento> executionContext) {
        while (executionContext.getCurrentState() != null) {
            StateTransitionArc<State, Object, GuardKey, ActionKey, Memento> arc;
            StateSummary<State, Event, GuardKey, ActionKey, Memento> sourceStateSummary;
            State sourceState;
            Intrinsics.checkNotNull(this.transitionTable.get(sourceState));
            if (sourceStateSummary.getTransitionArc(null, executionContext) == null) {
                return;
            }
            State targetState = arc.getNewState();
            executionContext.executeAction$avail(sourceStateSummary.getExitAction());
            executionContext.setCurrentState(null);
            executionContext.executeAction$avail(arc.getAction());
            executionContext.setCurrentState(targetState);
            StateSummary<State, Event, GuardKey, ActionKey, Memento> stateSummary = this.transitionTable.get(targetState);
            Intrinsics.checkNotNull(stateSummary);
            executionContext.executeAction$avail(stateSummary.getEntryAction());
        }
        return;
    }

    public final void handleEvent$avail(@NotNull Event event, @NotNull ExecutionContext<State, Event, GuardKey, ActionKey, Memento> context) throws InvalidContextException, InvalidTransitionException {
        Intrinsics.checkNotNullParameter(event, "event");
        Intrinsics.checkNotNullParameter(context, "context");
        State State2 = context.getCurrentState();
        if (State2 == null) {
            throw new InvalidContextException("event " + event + " signaled on invalid context");
        }
        State sourceState = State2;
        StateSummary<State, Event, GuardKey, ActionKey, Memento> stateSummary = this.transitionTable.get(sourceState);
        Intrinsics.checkNotNull(stateSummary);
        StateSummary<State, Event, GuardKey, ActionKey, Memento> summary = stateSummary;
        StateTransitionArc<State, Event, GuardKey, ActionKey, Memento> stateTransitionArc = summary.getTransitionArc(event, context);
        if (stateTransitionArc == null) {
            throw new InvalidTransitionException("state \"" + sourceState + "\" could not transition on event \"" + event + "\"");
        }
        StateTransitionArc<State, Event, GuardKey, ActionKey, Memento> arc = stateTransitionArc;
        State targetState = arc.getNewState();
        context.executeAction$avail(summary.getExitAction());
        context.setCurrentState(null);
        context.executeAction$avail(arc.getAction());
        context.setCurrentState(targetState);
        StateSummary<State, Event, GuardKey, ActionKey, Memento> stateSummary2 = this.transitionTable.get(targetState);
        Intrinsics.checkNotNull(stateSummary2);
        context.executeAction$avail(stateSummary2.getEntryAction());
        this.followAutomaticTransitions(context);
    }
}

