/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact.environment.project;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.availlang.artifact.environment.AvailEnvironment;
import org.availlang.artifact.environment.location.AvailLocation;
import org.availlang.artifact.environment.project.AvailProject;
import org.availlang.artifact.environment.project.AvailProjectRoot;
import org.availlang.artifact.environment.project.LocalSettings;
import org.availlang.artifact.environment.project.ModuleHeaderFileMetadata;
import org.availlang.artifact.environment.project.Palette;
import org.availlang.artifact.environment.project.StyleAttributes;
import org.availlang.artifact.environment.project.StylingGroup;
import org.availlang.artifact.environment.project.StylingSelection;
import org.availlang.artifact.environment.project.TemplateGroup;
import org.availlang.artifact.manifest.AvailRootManifest;
import org.availlang.artifact.roots.AvailRoot;
import org.availlang.json.JSONArray;
import org.availlang.json.JSONFriendly;
import org.availlang.json.JSONObject;
import org.availlang.json.JSONWriter;
import org.availlang.json.UtilityKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 Z2\u00020\u0001:\u0001ZBo\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0014J \u0010J\u001a\u00020K2\b\b\u0002\u0010L\u001a\u00020\u00032\u000e\b\u0002\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fJ\u000e\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020\u0003J\u000e\u0010Q\u001a\u00020O2\u0006\u0010P\u001a\u00020\u0003J\u000e\u0010R\u001a\u00020O2\u0006\u0010P\u001a\u00020\u0003J\u0006\u0010S\u001a\u00020OJ\u0006\u0010T\u001a\u00020OJ\u0006\u0010U\u001a\u00020OJ\b\u0010V\u001a\u00020\u0003H\u0016J\u0010\u0010W\u001a\u00020O2\u0006\u0010X\u001a\u00020YH\u0016R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001fR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u00020100\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0017\u00104\u001a\u00020\u0003\u00a2\u0006\u000e\n\u0000\u0012\u0004\b5\u0010\u001a\u001a\u0004\b6\u0010\u001fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001f\"\u0004\b8\u0010!R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u001fR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u0017\u0010?\u001a\u00020@8F\u00a2\u0006\f\u0012\u0004\bA\u0010\u001a\u001a\u0004\bB\u0010CR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u001a\u0010\u0013\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010#\"\u0004\bI\u0010%\u00a8\u0006["}, d2={"Lorg/availlang/artifact/environment/project/AvailProjectRoot;", "Lorg/availlang/json/JSONFriendly;", "rootConfigDirectory", "", "projectDirectory", "name", "location", "Lorg/availlang/artifact/environment/location/AvailLocation;", "localSettings", "Lorg/availlang/artifact/environment/project/LocalSettings;", "styles", "Lorg/availlang/artifact/environment/project/StylingGroup;", "templateGroup", "Lorg/availlang/artifact/environment/project/TemplateGroup;", "availModuleExtensions", "", "editable", "", "id", "visible", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/availlang/artifact/environment/location/AvailLocation;Lorg/availlang/artifact/environment/project/LocalSettings;Lorg/availlang/artifact/environment/project/StylingGroup;Lorg/availlang/artifact/environment/project/TemplateGroup;Ljava/util/List;ZLjava/lang/String;Z)V", "getAvailModuleExtensions", "()Ljava/util/List;", "availRoot", "Lorg/availlang/artifact/roots/AvailRoot;", "getAvailRoot$annotations", "()V", "getAvailRoot", "()Lorg/availlang/artifact/roots/AvailRoot;", "description", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "getEditable", "()Z", "setEditable", "(Z)V", "getId", "getLocalSettings", "()Lorg/availlang/artifact/environment/project/LocalSettings;", "setLocalSettings", "(Lorg/availlang/artifact/environment/project/LocalSettings;)V", "getLocation", "()Lorg/availlang/artifact/environment/location/AvailLocation;", "setLocation", "(Lorg/availlang/artifact/environment/location/AvailLocation;)V", "moduleHeaders", "", "Lorg/availlang/artifact/environment/project/ModuleHeaderFileMetadata;", "getModuleHeaders", "()Ljava/util/Set;", "modulePath", "getModulePath$annotations", "getModulePath", "getName", "setName", "getProjectDirectory", "getRootConfigDirectory", "getStyles", "()Lorg/availlang/artifact/environment/project/StylingGroup;", "setStyles", "(Lorg/availlang/artifact/environment/project/StylingGroup;)V", "stylingSelection", "Lorg/availlang/artifact/environment/project/StylingSelection;", "getStylingSelection$annotations", "getStylingSelection", "()Lorg/availlang/artifact/environment/project/StylingSelection;", "getTemplateGroup", "()Lorg/availlang/artifact/environment/project/TemplateGroup;", "setTemplateGroup", "(Lorg/availlang/artifact/environment/project/TemplateGroup;)V", "getVisible", "setVisible", "manifest", "Lorg/availlang/artifact/manifest/AvailRootManifest;", "digestAlgorithm", "entryPoints", "refreshLocalSettings", "", "rootConfigDir", "refreshStyles", "refreshTemplates", "saveLocalSettingsToDisk", "saveStylesToDisk", "saveTemplatesToDisk", "toString", "writeTo", "writer", "Lorg/availlang/json/JSONWriter;", "Companion", "avail-artifact"})
@SourceDebugExtension(value={"SMAP\nAvailProjectRoot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvailProjectRoot.kt\norg/availlang/artifact/environment/project/AvailProjectRoot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 JSONWriter.kt\norg/availlang/json/JSONWriter\n*L\n1#1,309:1\n1#2:310\n933#3,4:311\n1667#3,2:315\n1667#3,2:317\n1667#3,2:319\n1667#3,2:321\n1667#3,2:323\n1667#3,2:325\n1667#3,2:327\n1667#3,2:329\n940#3:331\n939#3:332\n*S KotlinDebug\n*F\n+ 1 AvailProjectRoot.kt\norg/availlang/artifact/environment/project/AvailProjectRoot\n*L\n218#1:311,4\n219#1:315,2\n220#1:317,2\n221#1:319,2\n222#1:321,2\n223#1:323,2\n224#1:325,2\n227#1:327,2\n231#1:329,2\n218#1:331\n218#1:332\n*E\n"})
public final class AvailProjectRoot
implements JSONFriendly {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rootConfigDirectory;
    @NotNull
    private final String projectDirectory;
    @NotNull
    private String name;
    @NotNull
    private AvailLocation location;
    @NotNull
    private LocalSettings localSettings;
    @NotNull
    private StylingGroup styles;
    @NotNull
    private TemplateGroup templateGroup;
    @NotNull
    private final List<String> availModuleExtensions;
    private boolean editable;
    @NotNull
    private final String id;
    private boolean visible;
    @NotNull
    private String description;
    @NotNull
    private final Set<ModuleHeaderFileMetadata> moduleHeaders;
    @NotNull
    private final String modulePath;

    public AvailProjectRoot(@NotNull String rootConfigDirectory, @NotNull String projectDirectory, @NotNull String name, @NotNull AvailLocation location, @NotNull LocalSettings localSettings, @NotNull StylingGroup styles, @NotNull TemplateGroup templateGroup, @NotNull List<String> availModuleExtensions, boolean editable, @NotNull String id, boolean visible) {
        Intrinsics.checkNotNullParameter(rootConfigDirectory, "rootConfigDirectory");
        Intrinsics.checkNotNullParameter(projectDirectory, "projectDirectory");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(localSettings, "localSettings");
        Intrinsics.checkNotNullParameter(styles, "styles");
        Intrinsics.checkNotNullParameter(templateGroup, "templateGroup");
        Intrinsics.checkNotNullParameter(availModuleExtensions, "availModuleExtensions");
        Intrinsics.checkNotNullParameter(id, "id");
        this.rootConfigDirectory = rootConfigDirectory;
        this.projectDirectory = projectDirectory;
        this.name = name;
        this.location = location;
        this.localSettings = localSettings;
        this.styles = styles;
        this.templateGroup = templateGroup;
        this.availModuleExtensions = availModuleExtensions;
        this.editable = editable;
        this.id = id;
        this.visible = visible;
        this.description = "";
        this.moduleHeaders = new LinkedHashSet();
        this.modulePath = this.name + "=" + this.location.getFullPath();
    }

    public /* synthetic */ AvailProjectRoot(String string2, String string3, String string4, AvailLocation availLocation, LocalSettings localSettings, StylingGroup stylingGroup, TemplateGroup templateGroup, List list2, boolean bl, String string5, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            stylingGroup = new StylingGroup();
        }
        if ((n & 0x40) != 0) {
            templateGroup = new TemplateGroup(null, 1, null);
        }
        if ((n & 0x80) != 0) {
            String[] stringArray = new String[]{"avail"};
            list2 = CollectionsKt.mutableListOf(stringArray);
        }
        if ((n & 0x100) != 0) {
            bl = availLocation.getEditable();
        }
        if ((n & 0x200) != 0) {
            String string6 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue(string6, "toString(...)");
            string5 = string6;
        }
        if ((n & 0x400) != 0) {
            bl2 = true;
        }
        this(string2, string3, string4, availLocation, localSettings, stylingGroup, templateGroup, list2, bl, string5, bl2);
    }

    @NotNull
    public final String getRootConfigDirectory() {
        return this.rootConfigDirectory;
    }

    @NotNull
    public final String getProjectDirectory() {
        return this.projectDirectory;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.name = string2;
    }

    @NotNull
    public final AvailLocation getLocation() {
        return this.location;
    }

    public final void setLocation(@NotNull AvailLocation availLocation) {
        Intrinsics.checkNotNullParameter(availLocation, "<set-?>");
        this.location = availLocation;
    }

    @NotNull
    public final LocalSettings getLocalSettings() {
        return this.localSettings;
    }

    public final void setLocalSettings(@NotNull LocalSettings localSettings) {
        Intrinsics.checkNotNullParameter(localSettings, "<set-?>");
        this.localSettings = localSettings;
    }

    @NotNull
    public final StylingGroup getStyles() {
        return this.styles;
    }

    public final void setStyles(@NotNull StylingGroup stylingGroup) {
        Intrinsics.checkNotNullParameter(stylingGroup, "<set-?>");
        this.styles = stylingGroup;
    }

    @NotNull
    public final TemplateGroup getTemplateGroup() {
        return this.templateGroup;
    }

    public final void setTemplateGroup(@NotNull TemplateGroup templateGroup) {
        Intrinsics.checkNotNullParameter(templateGroup, "<set-?>");
        this.templateGroup = templateGroup;
    }

    @NotNull
    public final List<String> getAvailModuleExtensions() {
        return this.availModuleExtensions;
    }

    public final boolean getEditable() {
        return this.editable;
    }

    public final void setEditable(boolean bl) {
        this.editable = bl;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final boolean getVisible() {
        return this.visible;
    }

    public final void setVisible(boolean bl) {
        this.visible = bl;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.description = string2;
    }

    @NotNull
    public final StylingSelection getStylingSelection() {
        Palette palette;
        String p = this.localSettings.getPalette();
        boolean bl = false;
        if (this.styles.getPalettes().isEmpty()) {
            palette = Palette.Companion.getEmpty();
        } else if (((CharSequence)p).length() > 0) {
            Palette palette2 = this.styles.getPalettes().get(p);
            if (palette2 == null) {
                palette2 = (Palette)CollectionsKt.first((Iterable)this.styles.getPalettes().values());
            }
            Palette it = palette2;
            boolean bl2 = false;
            palette = new Palette(it.getLightColors(), it.getDarkColors());
        } else if (((CharSequence)p).length() == 0) {
            Palette it = (Palette)CollectionsKt.first((Iterable)this.styles.getPalettes().values());
            boolean bl3 = false;
            palette = new Palette(it.getLightColors(), it.getDarkColors());
        } else {
            palette = Palette.Companion.getEmpty();
        }
        Map<String, StyleAttributes> map = MapsKt.toMutableMap(this.styles.getStylesheet());
        Palette palette3 = palette;
        return new StylingSelection(palette3, map);
    }

    public static /* synthetic */ void getStylingSelection$annotations() {
    }

    @NotNull
    public final Set<ModuleHeaderFileMetadata> getModuleHeaders() {
        return this.moduleHeaders;
    }

    @NotNull
    public final String getModulePath() {
        return this.modulePath;
    }

    public static /* synthetic */ void getModulePath$annotations() {
    }

    public final void refreshTemplates(@NotNull String rootConfigDir) {
        Intrinsics.checkNotNullParameter(rootConfigDir, "rootConfigDir");
        this.templateGroup = new TemplateGroup(UtilityKt.jsonObject$default(FilesKt.readText$default(new File(rootConfigDir, "templates.json"), null, 1, null), null, 2, null));
    }

    public final void refreshStyles(@NotNull String rootConfigDir) {
        Intrinsics.checkNotNullParameter(rootConfigDir, "rootConfigDir");
        this.styles = new StylingGroup(UtilityKt.jsonObject$default(FilesKt.readText$default(new File(rootConfigDir, "styles.json"), null, 1, null), null, 2, null));
    }

    public final void refreshLocalSettings(@NotNull String rootConfigDir) {
        Intrinsics.checkNotNullParameter(rootConfigDir, "rootConfigDir");
        this.localSettings = LocalSettings.Companion.from(new File(rootConfigDir));
    }

    public final void saveTemplatesToDisk() {
        this.templateGroup.saveToDisk(this.rootConfigDirectory + File.separator + "templates.json");
    }

    public final void saveLocalSettingsToDisk() {
        this.localSettings.save();
    }

    public final void saveStylesToDisk() {
        this.styles.saveToDisk(this.rootConfigDirectory + File.separator + "styles.json");
    }

    @NotNull
    public final AvailRootManifest manifest(@NotNull String digestAlgorithm, @NotNull List<String> entryPoints) {
        Intrinsics.checkNotNullParameter(digestAlgorithm, "digestAlgorithm");
        Intrinsics.checkNotNullParameter(entryPoints, "entryPoints");
        return new AvailRootManifest(this.name, this.availModuleExtensions, entryPoints, this.templateGroup.getMarkedForInclusion(), this.styles, this.description, digestAlgorithm);
    }

    public static /* synthetic */ AvailRootManifest manifest$default(AvailProjectRoot availProjectRoot, String string2, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "SHA-256";
        }
        if ((n & 2) != 0) {
            list2 = new ArrayList();
        }
        return availProjectRoot.manifest(string2, list2);
    }

    @NotNull
    public final AvailRoot getAvailRoot() {
        return new AvailRoot(this.name, this.location, null, this.availModuleExtensions, null, this.templateGroup, this.styles, this.description, null, 276, null);
    }

    public static /* synthetic */ void getAvailRoot$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(@NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        JSONWriter this_$iv = writer;
        boolean $i$f$writeObject = false;
        this_$iv.startObject();
        try {
            JSONWriter this_$iv2;
            JSONWriter $this$writeTo_u24lambda_u2411 = this_$iv;
            boolean bl = false;
            JSONWriter jSONWriter = $this$writeTo_u24lambda_u2411;
            String key$iv = "id";
            boolean $i$f$at = false;
            this_$iv2.write(key$iv);
            void $this$writeTo_u24lambda_u2411_u24lambda_u243 = this_$iv2;
            boolean bl2 = false;
            $this$writeTo_u24lambda_u2411_u24lambda_u243.write(this.id);
            this_$iv2 = $this$writeTo_u24lambda_u2411;
            key$iv = "name";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2411_u24lambda_u244 = this_$iv2;
            boolean bl3 = false;
            $this$writeTo_u24lambda_u2411_u24lambda_u244.write(this.name);
            this_$iv2 = $this$writeTo_u24lambda_u2411;
            key$iv = "editable";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2411_u24lambda_u245 = this_$iv2;
            boolean bl4 = false;
            $this$writeTo_u24lambda_u2411_u24lambda_u245.write(this.editable);
            this_$iv2 = $this$writeTo_u24lambda_u2411;
            key$iv = "visible";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2411_u24lambda_u246 = this_$iv2;
            boolean bl5 = false;
            $this$writeTo_u24lambda_u2411_u24lambda_u246.write(this.visible);
            this_$iv2 = $this$writeTo_u24lambda_u2411;
            key$iv = "description";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2411_u24lambda_u247 = this_$iv2;
            boolean bl6 = false;
            $this$writeTo_u24lambda_u2411_u24lambda_u247.write(this.description);
            this_$iv2 = $this$writeTo_u24lambda_u2411;
            key$iv = "location";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2411_u24lambda_u248 = this_$iv2;
            boolean bl7 = false;
            this.location.writeTo($this$writeTo_u24lambda_u2411);
            if (!Intrinsics.areEqual(this.availModuleExtensions, CollectionsKt.listOf("avail"))) {
                this_$iv2 = $this$writeTo_u24lambda_u2411;
                key$iv = "availModuleExtensions";
                $i$f$at = false;
                this_$iv2.write(key$iv);
                JSONWriter $this$writeTo_u24lambda_u2411_u24lambda_u249 = this_$iv2;
                boolean bl8 = false;
                $this$writeTo_u24lambda_u2411_u24lambda_u249.writeStrings((Iterable<String>)this.availModuleExtensions);
            }
            this_$iv2 = $this$writeTo_u24lambda_u2411;
            key$iv = "moduleHeaders";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2411_u24lambda_u2410 = this_$iv2;
            boolean bl9 = false;
            ModuleHeaderFileMetadata.Companion.writeTo($this$writeTo_u24lambda_u2411_u24lambda_u2410, this.moduleHeaders);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endObject();
        }
    }

    @NotNull
    public String toString() {
        return this.name + "=" + this.location.getFullPath();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/availlang/artifact/environment/project/AvailProjectRoot$Companion;", "", "()V", "from", "Lorg/availlang/artifact/environment/project/AvailProjectRoot;", "project", "Lorg/availlang/artifact/environment/project/AvailProject;", "projectFileName", "", "projectDirectory", "obj", "Lorg/availlang/json/JSONObject;", "serializationVersion", "", "avail-artifact"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AvailProjectRoot from(@NotNull AvailProject project2, @NotNull String projectFileName, @NotNull String projectDirectory, @NotNull JSONObject obj, int serializationVersion) {
            String string2;
            List<String> list2;
            List list3;
            List<String> list4;
            Intrinsics.checkNotNullParameter(project2, "project");
            Intrinsics.checkNotNullParameter(projectFileName, "projectFileName");
            Intrinsics.checkNotNullParameter(projectDirectory, "projectDirectory");
            Intrinsics.checkNotNullParameter(obj, "obj");
            String rootName = JSONObject.getString$default(obj, "name", null, 2, null);
            String rootConfigPath = AvailEnvironment.INSTANCE.projectRootConfigPath(StringsKt.removeSuffix(projectFileName, (CharSequence)".json"), rootName, projectDirectory);
            File configDir = project2.optionallyInitializeConfigDirectory(rootConfigPath).component1();
            LocalSettings localSettings = LocalSettings.Companion.from(configDir);
            StylingGroup styles = new StylingGroup(UtilityKt.jsonObject$default(FilesKt.readText$default(new File(configDir, "styles.json"), null, 1, null), null, 2, null));
            TemplateGroup templateGroup = new TemplateGroup(UtilityKt.jsonObject$default(FilesKt.readText$default(new File(configDir, "templates.json"), null, 1, null), null, 2, null));
            String string3 = JSONObject.getString$default(obj, "name", null, 2, null);
            AvailLocation availLocation = AvailLocation.Companion.from(projectDirectory, JSONObject.getObject$default(obj, "location", null, 2, null));
            JSONFriendly jSONFriendly = obj.getArrayOrNull("availModuleExtensions");
            if (jSONFriendly != null && (list4 = ((JSONArray)jSONFriendly).getStrings()) != null && (list3 = CollectionsKt.toMutableList((Collection)list4)) != null) {
                list2 = list3;
            } else {
                String[] stringArray = new String[]{"avail"};
                list2 = CollectionsKt.mutableListOf(stringArray);
            }
            JSONFriendly $this$from_u24lambda_u241 = jSONFriendly = new AvailProjectRoot(rootConfigPath, projectDirectory, string3, availLocation, localSettings, styles, templateGroup, list2, obj.getBoolean("editable", from.1.INSTANCE), JSONObject.getString$default(obj, "id", null, 2, null), obj.getBoolean("visible", from.2.INSTANCE));
            boolean bl = false;
            JSONArray jSONArray = obj.getArrayOrNull("moduleHeaders");
            if (jSONArray != null) {
                JSONArray it = jSONArray;
                boolean bl2 = false;
                Set<ModuleHeaderFileMetadata> set2 = ((AvailProjectRoot)$this$from_u24lambda_u241).getModuleHeaders();
                String string4 = configDir.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue(string4, "getAbsolutePath(...)");
                set2.addAll((Collection<ModuleHeaderFileMetadata>)ModuleHeaderFileMetadata.Companion.from(string4, it));
            }
            if ((string2 = obj.getStringOrNull("description")) == null) {
                string2 = "";
            }
            ((AvailProjectRoot)$this$from_u24lambda_u241).setDescription(string2);
            return jSONFriendly;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

