/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact.environment.project;

import java.awt.Color;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.availlang.json.JSONData;
import org.availlang.json.JSONFriendly;
import org.availlang.json.JSONObject;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B1\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0018\u0010\r\u001a\u00020\u000b8\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\fR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u001a"}, d2={"Lorg/availlang/artifact/environment/project/Palette;", "Lorg/availlang/json/JSONFriendly;", "lightColors", "", "", "Ljava/awt/Color;", "darkColors", "(Ljava/util/Map;Ljava/util/Map;)V", "getDarkColors", "()Ljava/util/Map;", "isEmpty", "", "()Z", "isNotEmpty", "isNotEmpty$annotations", "()V", "getLightColors", "hex", "name", "mergeOnto", "palette", "writeTo", "", "writer", "Lorg/availlang/json/JSONWriter;", "Companion", "avail-artifact"})
@SourceDebugExtension(value={"SMAP\nStylingGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StylingGroup.kt\norg/availlang/artifact/environment/project/Palette\n+ 2 JSONWriter.kt\norg/availlang/json/JSONWriter\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,454:1\n933#2,4:455\n1667#2,2:460\n940#2:463\n939#2:464\n1855#3:459\n1856#3:462\n*S KotlinDebug\n*F\n+ 1 StylingGroup.kt\norg/availlang/artifact/environment/project/Palette\n*L\n82#1:455,4\n86#1:460,2\n82#1:463\n82#1:464\n85#1:459\n85#1:462\n*E\n"})
public final class Palette
implements JSONFriendly {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Color> lightColors;
    @NotNull
    private final Map<String, Color> darkColors;

    public Palette(@NotNull Map<String, ? extends Color> lightColors, @NotNull Map<String, ? extends Color> darkColors) {
        Intrinsics.checkNotNullParameter(lightColors, "lightColors");
        Intrinsics.checkNotNullParameter(darkColors, "darkColors");
        this.lightColors = lightColors;
        this.darkColors = darkColors;
        boolean bl = Intrinsics.areEqual(this.lightColors.keySet(), this.darkColors.keySet());
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "light and dark maps have different keys";
            throw new AssertionError((Object)string2);
        }
    }

    public /* synthetic */ Palette(Map map, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 2) != 0) {
            map2 = new LinkedHashMap();
        }
        this(map, map2);
    }

    @NotNull
    public final Map<String, Color> getLightColors() {
        return this.lightColors;
    }

    @NotNull
    public final Map<String, Color> getDarkColors() {
        return this.darkColors;
    }

    public final boolean isEmpty() {
        return this.lightColors.isEmpty();
    }

    public final boolean isNotEmpty() {
        boolean $i$f$isNotEmpty = false;
        return !this.isEmpty();
    }

    public static /* synthetic */ void isNotEmpty$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(@NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        JSONWriter this_$iv = writer;
        boolean $i$f$writeObject = false;
        this_$iv.startObject();
        try {
            JSONWriter $this$writeTo_u24lambda_u243 = this_$iv;
            boolean bl = false;
            Iterable $this$forEach$iv = this.lightColors.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                JSONWriter this_$iv2 = $this$writeTo_u24lambda_u243;
                boolean $i$f$at = false;
                this_$iv2.write(it);
                JSONWriter $this$writeTo_u24lambda_u243_u24lambda_u242_u24lambda_u241 = this_$iv2;
                boolean bl3 = false;
                $this$writeTo_u24lambda_u243_u24lambda_u242_u24lambda_u241.write(this.hex(it));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endObject();
        }
    }

    @NotNull
    public final Palette mergeOnto(@NotNull Palette palette) {
        Intrinsics.checkNotNullParameter(palette, "palette");
        return new Palette(MapsKt.plus(palette.lightColors, this.lightColors), MapsKt.plus(palette.darkColors, this.darkColors));
    }

    private final String hex(String name) {
        Color color;
        StringBuilder stringBuilder;
        int n = 18;
        StringBuilder $this$hex_u24lambda_u246 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        $this$hex_u24lambda_u246.append('#');
        Color color2 = this.lightColors.get(name);
        Intrinsics.checkNotNull(color2);
        Color $this$hex_u24lambda_u246_u24lambda_u244 = color = color2;
        boolean bl2 = false;
        String string2 = "%02X";
        Object[] objectArray = new Object[]{$this$hex_u24lambda_u246_u24lambda_u244.getRed()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(this, *args)");
        $this$hex_u24lambda_u246.append(string3);
        string2 = "%02X";
        objectArray = new Object[]{$this$hex_u24lambda_u246_u24lambda_u244.getGreen()};
        String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string4, "format(this, *args)");
        $this$hex_u24lambda_u246.append(string4);
        string2 = "%02X";
        objectArray = new Object[]{$this$hex_u24lambda_u246_u24lambda_u244.getBlue()};
        String string5 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string5, "format(this, *args)");
        $this$hex_u24lambda_u246.append(string5);
        string2 = "%02X";
        objectArray = new Object[]{$this$hex_u24lambda_u246_u24lambda_u244.getAlpha()};
        String string6 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string6, "format(this, *args)");
        $this$hex_u24lambda_u246.append(string6);
        $this$hex_u24lambda_u246.append('/');
        Color color3 = this.darkColors.get(name);
        Intrinsics.checkNotNull(color3);
        Color $this$hex_u24lambda_u246_u24lambda_u245 = color = color3;
        boolean bl3 = false;
        string2 = "%02X";
        objectArray = new Object[]{$this$hex_u24lambda_u246_u24lambda_u245.getRed()};
        String string7 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string7, "format(this, *args)");
        $this$hex_u24lambda_u246.append(string7);
        string2 = "%02X";
        objectArray = new Object[]{$this$hex_u24lambda_u246_u24lambda_u245.getGreen()};
        String string8 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string8, "format(this, *args)");
        $this$hex_u24lambda_u246.append(string8);
        string2 = "%02X";
        objectArray = new Object[]{$this$hex_u24lambda_u246_u24lambda_u245.getBlue()};
        String string9 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string9, "format(this, *args)");
        $this$hex_u24lambda_u246.append(string9);
        string2 = "%02X";
        objectArray = new Object[]{$this$hex_u24lambda_u246_u24lambda_u245.getAlpha()};
        String string10 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string10, "format(this, *args)");
        $this$hex_u24lambda_u246.append(string10);
        String string11 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string11, "StringBuilder(capacity).\u2026builderAction).toString()");
        return string11;
    }

    public Palette() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/availlang/artifact/environment/project/Palette$Companion;", "", "()V", "empty", "Lorg/availlang/artifact/environment/project/Palette;", "getEmpty", "()Lorg/availlang/artifact/environment/project/Palette;", "decodeColor", "Ljava/awt/Color;", "hex", "", "decodeColors", "Lkotlin/Pair;", "from", "data", "Lorg/availlang/json/JSONObject;", "avail-artifact"})
    @SourceDebugExtension(value={"SMAP\nStylingGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StylingGroup.kt\norg/availlang/artifact/environment/project/Palette$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,454:1\n1855#2,2:455\n1#3:457\n*S KotlinDebug\n*F\n+ 1 StylingGroup.kt\norg/availlang/artifact/environment/project/Palette$Companion\n*L\n146#1:455,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Palette getEmpty() {
            return new Palette(null, null, 3, null);
        }

        @NotNull
        public final Palette from(@NotNull JSONObject data2) {
            Intrinsics.checkNotNullParameter(data2, "data");
            Map lightColors = new LinkedHashMap();
            Map darkColors = new LinkedHashMap();
            Iterable $this$forEach$iv = data2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                String name = (String)entry.getKey();
                JSONData value = (JSONData)entry.getValue();
                Pair<Color, Color> colors = Companion.decodeColors(value.getString());
                lightColors.put(name, colors.getFirst());
                darkColors.put(name, colors.getSecond());
            }
            return new Palette(lightColors, darkColors);
        }

        private final Pair<Color, Color> decodeColors(String hex2) {
            Object object;
            Color light;
            block3: {
                block2: {
                    String string2 = hex2.substring(1);
                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
                    char[] cArray = new char[]{'/'};
                    List values2 = StringsKt.split$default((CharSequence)string2, cArray, false, 0, 6, null);
                    light = this.decodeColor((String)values2.get(0));
                    object = (String)CollectionsKt.getOrNull(values2, 1);
                    if (object == null) break block2;
                    String it = object;
                    boolean bl = false;
                    Color color = Companion.decodeColor(it);
                    object = color;
                    if (color != null) break block3;
                }
                object = light;
            }
            Object dark = object;
            return TuplesKt.to(light, dark);
        }

        private final Color decodeColor(String hex2) {
            int r = Integer.parseInt(StringsKt.substring(hex2, new IntRange(0, 1)), CharsKt.checkRadix(16));
            int g = Integer.parseInt(StringsKt.substring(hex2, new IntRange(2, 3)), CharsKt.checkRadix(16));
            int b = Integer.parseInt(StringsKt.substring(hex2, new IntRange(4, 5)), CharsKt.checkRadix(16));
            int a = hex2.length() == 8 ? Integer.parseInt(StringsKt.substring(hex2, new IntRange(6, 7)), CharsKt.checkRadix(16)) : 255;
            return new Color(r, g, b, a);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

