/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact.environment.project;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.availlang.artifact.environment.location.ProjectConfig;
import org.availlang.artifact.environment.project.Palette;
import org.availlang.artifact.environment.project.StyleAttributes;
import org.availlang.artifact.environment.project.StylingSelection;
import org.availlang.json.JSONData;
import org.availlang.json.JSONFriendly;
import org.availlang.json.JSONObject;
import org.availlang.json.JSONWriter;
import org.availlang.json.UtilityKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0000J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/availlang/artifact/environment/project/StylingGroup;", "Lorg/availlang/json/JSONFriendly;", "obj", "Lorg/availlang/json/JSONObject;", "(Lorg/availlang/json/JSONObject;)V", "()V", "palettes", "", "", "Lorg/availlang/artifact/environment/project/Palette;", "getPalettes", "()Ljava/util/Map;", "stylesheet", "", "Lorg/availlang/artifact/environment/project/StyleAttributes;", "getStylesheet", "saveToDisk", "", "path", "selection", "Lorg/availlang/artifact/environment/project/StylingSelection;", "paletteName", "updateFrom", "other", "writeTo", "writer", "Lorg/availlang/json/JSONWriter;", "Companion", "avail-artifact"})
@SourceDebugExtension(value={"SMAP\nStylingGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StylingGroup.kt\norg/availlang/artifact/environment/project/StylingGroup\n+ 2 JSONWriter.kt\norg/availlang/json/JSONWriter\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,454:1\n933#2,4:455\n1667#2,2:459\n933#2,4:461\n1667#2,2:466\n940#2:469\n939#2:470\n1667#2,2:471\n933#2,4:473\n1667#2,2:478\n940#2:481\n939#2:482\n940#2:483\n939#2:484\n215#3:465\n216#3:468\n215#3:477\n216#3:480\n1253#4,4:485\n1253#4,4:489\n*S KotlinDebug\n*F\n+ 1 StylingGroup.kt\norg/availlang/artifact/environment/project/StylingGroup\n*L\n382#1:455,4\n383#1:459,2\n384#1:461,4\n386#1:466,2\n384#1:469\n384#1:470\n390#1:471,2\n392#1:473,4\n394#1:478,2\n392#1:481\n392#1:482\n382#1:483\n382#1:484\n385#1:465\n385#1:468\n393#1:477\n393#1:480\n427#1:485,4\n433#1:489,4\n*E\n"})
public final class StylingGroup
implements JSONFriendly {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, StyleAttributes> stylesheet;
    @NotNull
    private final Map<String, Palette> palettes;

    public StylingGroup() {
        this.stylesheet = new LinkedHashMap();
        this.palettes = new LinkedHashMap();
    }

    @NotNull
    public final Map<String, StyleAttributes> getStylesheet() {
        return this.stylesheet;
    }

    @NotNull
    public final Map<String, Palette> getPalettes() {
        return this.palettes;
    }

    public final void updateFrom(@NotNull StylingGroup other) {
        Intrinsics.checkNotNullParameter(other, "other");
        Map<String, StyleAttributes> map = this.stylesheet;
        Intrinsics.checkNotNull(map, "null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, org.availlang.artifact.environment.project.StyleAttributes>");
        TypeIntrinsics.asMutableMap(map).putAll(other.stylesheet);
        this.palettes.putAll(other.palettes);
    }

    @NotNull
    public final StylingSelection selection(@NotNull String paletteName) {
        StylingSelection stylingSelection;
        Intrinsics.checkNotNullParameter(paletteName, "paletteName");
        if (this.palettes.isEmpty()) {
            stylingSelection = new StylingSelection(null, null, 3, null);
        } else if (StringsKt.isBlank(paletteName)) {
            Palette it = (Palette)CollectionsKt.first((Iterable)this.palettes.values());
            boolean bl = false;
            Map<String, StyleAttributes> map = MapsKt.toMutableMap(this.stylesheet);
            Palette palette = new Palette(MapsKt.toMutableMap(it.getLightColors()), MapsKt.toMutableMap(it.getDarkColors()));
            stylingSelection = new StylingSelection(palette, map);
        } else {
            Palette palette = this.palettes.get(paletteName);
            if (palette == null) {
                Palette it = (Palette)CollectionsKt.first((Iterable)this.palettes.values());
                boolean bl = false;
                palette = new Palette(MapsKt.toMutableMap(it.getLightColors()), MapsKt.toMutableMap(it.getDarkColors()));
            }
            Map<String, StyleAttributes> map = MapsKt.toMutableMap(this.stylesheet);
            Palette palette2 = palette;
            stylingSelection = new StylingSelection(palette2, map);
        }
        return stylingSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(@NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        JSONWriter this_$iv = writer;
        boolean $i$f$writeObject = false;
        this_$iv.startObject();
        try {
            Unit unit;
            boolean $i$f$at;
            JSONWriter this_$iv2;
            Map.Entry<String, StyleAttributes> entry;
            Map.Entry<String, JSONFriendly> element$iv;
            Iterator<Map.Entry<String, JSONFriendly>> iterator2;
            boolean $i$f$forEach;
            Map<String, JSONFriendly> $this$forEach$iv;
            JSONWriter this_$iv3;
            JSONWriter $this$writeTo_u24lambda_u2410 = this_$iv;
            boolean bl = false;
            JSONWriter jSONWriter = $this$writeTo_u24lambda_u2410;
            String key$iv = "stylesheet";
            boolean $i$f$at2 = false;
            this_$iv3.write(key$iv);
            void $this$writeTo_u24lambda_u2410_u24lambda_u245 = this_$iv3;
            boolean bl2 = false;
            JSONWriter this_$iv4 = $this$writeTo_u24lambda_u2410_u24lambda_u245;
            boolean $i$f$writeObject2 = false;
            this_$iv4.startObject();
            try {
                void $this$writeTo_u24lambda_u2410_u24lambda_u245_u24lambda_u244 = this_$iv4;
                boolean bl3 = false;
                $this$forEach$iv = this.stylesheet;
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    entry = element$iv = iterator2.next();
                    boolean bl4 = false;
                    String rule2 = entry.getKey();
                    StyleAttributes attributes = entry.getValue();
                    this_$iv2 = $this$writeTo_u24lambda_u2410_u24lambda_u245_u24lambda_u244;
                    $i$f$at = false;
                    this_$iv2.write(rule2);
                    void $this$writeTo_u24lambda_u2410_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u242 = this_$iv2;
                    boolean bl5 = false;
                    $this$writeTo_u24lambda_u2410_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u242.write(attributes);
                }
                unit = Unit.INSTANCE;
            }
            finally {
                this_$iv4.endObject();
            }
            this_$iv3 = $this$writeTo_u24lambda_u2410;
            key$iv = "palettes";
            $i$f$at2 = false;
            this_$iv3.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2410_u24lambda_u249 = this_$iv3;
            boolean bl6 = false;
            this_$iv4 = $this$writeTo_u24lambda_u2410_u24lambda_u249;
            $i$f$writeObject2 = false;
            this_$iv4.startObject();
            try {
                JSONWriter $this$writeTo_u24lambda_u2410_u24lambda_u249_u24lambda_u248 = this_$iv4;
                boolean bl7 = false;
                $this$forEach$iv = this.palettes;
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    entry = element$iv = iterator2.next();
                    boolean bl8 = false;
                    String name = entry.getKey();
                    Palette palette = (Palette)((Object)entry.getValue());
                    this_$iv2 = $this$writeTo_u24lambda_u2410_u24lambda_u249_u24lambda_u248;
                    $i$f$at = false;
                    this_$iv2.write(name);
                    JSONWriter $this$writeTo_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246 = this_$iv2;
                    boolean bl9 = false;
                    $this$writeTo_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246.write(palette);
                }
                unit = Unit.INSTANCE;
            }
            finally {
                this_$iv4.endObject();
            }
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            this_$iv.endObject();
        }
    }

    public final void saveToDisk(@NotNull String path) {
        File file2;
        Intrinsics.checkNotNullParameter(path, "path");
        File $this$saveToDisk_u24lambda_u2411 = file2 = new File(path);
        boolean bl = false;
        if (!$this$saveToDisk_u24lambda_u2411.isDirectory()) {
            FilesKt.writeText$default($this$saveToDisk_u24lambda_u2411, this.getJsonPrettyPrintedFormattedString(), null, 2, null);
        }
    }

    public StylingGroup(@NotNull JSONObject obj) {
        block3: {
            Pair<String, Palette> pair;
            Map<String, Palette> map;
            Iterable $this$associateTo$iv;
            boolean $i$f$associateTo;
            Map<String, Palette> destination$iv;
            JSONObject it;
            Intrinsics.checkNotNullParameter(obj, "obj");
            this();
            JSONObject jSONObject = obj.getObjectOrNull("stylesheet");
            if (jSONObject != null) {
                it = jSONObject;
                boolean bl = false;
                Iterable iterable = it;
                Map<String, StyleAttributes> map2 = this.stylesheet;
                Intrinsics.checkNotNull(map2, "null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, org.availlang.artifact.environment.project.StyleAttributes>");
                destination$iv = TypeIntrinsics.asMutableMap(map2);
                $i$f$associateTo = false;
                for (Object element$iv : $this$associateTo$iv) {
                    map = destination$iv;
                    pair = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    String rule2 = (String)pair.getKey();
                    JSONData attributes = (JSONData)pair.getValue();
                    Intrinsics.checkNotNull(attributes, "null cannot be cast to non-null type org.availlang.json.JSONObject");
                    pair = TuplesKt.to(rule2, new StyleAttributes((JSONObject)attributes));
                    map.put(pair.getFirst(), pair.getSecond());
                }
            }
            JSONObject jSONObject2 = obj.getObjectOrNull("palettes");
            if (jSONObject2 == null) break block3;
            it = jSONObject2;
            boolean bl = false;
            $this$associateTo$iv = it;
            destination$iv = this.palettes;
            $i$f$associateTo = false;
            for (Object element$iv : $this$associateTo$iv) {
                map = destination$iv;
                pair = (Map.Entry)element$iv;
                boolean bl3 = false;
                String name = (String)pair.getKey();
                JSONData palette = (JSONData)pair.getValue();
                Intrinsics.checkNotNull(palette, "null cannot be cast to non-null type org.availlang.json.JSONObject");
                pair = TuplesKt.to(name, Palette.Companion.from((JSONObject)palette));
                map.put(pair.getFirst(), pair.getSecond());
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/availlang/artifact/environment/project/StylingGroup$Companion;", "", "()V", "from", "Lorg/availlang/artifact/environment/project/StylingGroup;", "config", "Lorg/availlang/artifact/environment/location/ProjectConfig;", "avail-artifact"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StylingGroup from(@NotNull ProjectConfig config) {
            Intrinsics.checkNotNullParameter(config, "config");
            return new StylingGroup(UtilityKt.jsonObject$default(FilesKt.readText$default(new File(config.getFullPathNoPrefix()), null, 1, null), null, 2, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

