/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.text;

import avail.anvil.text.DotPosition;
import avail.anvil.text.MarkPosition;
import avail.anvil.text.MarkToDotRange;
import avail.anvil.text.StringCaseTransformQueue;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0002\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000e\u001a\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0012\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u000e*\u00020\u0002\u001a\u001c\u0010\u0016\u001a\u00020\f*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u000e2\b\b\u0002\u0010\u0018\u001a\u00020\u000e\u001a\u0012\u0010\u0019\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000e\u001a\u0012\u0010\u001a\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000e\u001a\n\u0010\u001b\u001a\u00020\u000e*\u00020\u0002\u001a\u0012\u0010\u001c\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000e\u001a\u0010\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e*\u00020\u0002\u001a\u0012\u0010\u001f\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000e\u001a\u0010\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e*\u00020\u0002\u001a\n\u0010!\u001a\u00020\"*\u00020\u0002\u001a\n\u0010#\u001a\u00020$*\u00020\u0002\u001a\f\u0010%\u001a\u00020\u0006*\u00020&H\u0000\u001a\u0012\u0010'\u001a\u00020\f*\u00020\u00022\u0006\u0010(\u001a\u00020$\u001a)\u0010)\u001a\u00020\f*\u00020&2\u0017\u0010*\u001a\u0013\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\f0+\u00a2\u0006\u0002\b,H\u0080\b\u00f8\u0001\u0000\u001a%\u0010-\u001a\u00020\f*\u00020&2\u0017\u0010.\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060+\u00a2\u0006\u0002\b,H\u0000\u001a%\u0010/\u001a\u00020\f*\u00020&2\u0017\u0010.\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060+\u00a2\u0006\u0002\b,H\u0000\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00060"}, d2={"canEdit", "", "Ljavax/swing/text/JTextComponent;", "getCanEdit", "(Ljavax/swing/text/JTextComponent;)Z", "toCamelCase", "", "textToTransform", "toKebabCase", "toPascalCase", "toSnakeCase", "centerCurrentLine", "", "codePointAt", "", "Ljavax/swing/text/Document;", "position", "codePointOrNullAt", "(Ljavax/swing/text/Document;I)Ljava/lang/Integer;", "dotPosition", "Lavail/anvil/text/DotPosition;", "firstLineStartInSelection", "goTo", "line", "characterInLine", "indentationAt", "indentationBefore", "lastLineEndInSelection", "lineEndAfter", "lineEndsInSelection", "", "lineStartBefore", "lineStartsInSelection", "markPosition", "Lavail/anvil/text/MarkPosition;", "markToDotRange", "Lavail/anvil/text/MarkToDotRange;", "selectedLinesText", "Ljavax/swing/JTextPane;", "setCaretFrom", "range", "transaction", "edit", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "transform", "transformer", "transformLines", "avail"})
@SourceDebugExtension(value={"SMAP\nTextKits.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextKits.kt\navail/anvil/text/TextKitsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1795:1\n1392#1,23:1800\n1392#1,23:1823\n1855#2,2:1796\n1855#2,2:1798\n*S KotlinDebug\n*F\n+ 1 TextKits.kt\navail/anvil/text/TextKitsKt\n*L\n1441#1:1800,23\n1471#1:1823,23\n1293#1:1796,2\n1340#1:1798,2\n*E\n"})
public final class TextKitsKt {
    public static final int codePointAt(@NotNull Document $this$codePointAt, int position) {
        Intrinsics.checkNotNullParameter((Object)$this$codePointAt, (String)"<this>");
        String string2 = $this$codePointAt.getText(position, 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String string3 = string2;
        int n = 0;
        return string3.codePointAt(n);
    }

    @NotNull
    public static final DotPosition dotPosition(@NotNull JTextComponent $this$dotPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$dotPosition, (String)"<this>");
        int offset = $this$dotPosition.getCaret().getDot();
        Element root = $this$dotPosition.getDocument().getDefaultRootElement();
        int line = root.getElementIndex(offset);
        Element element = root.getElement(line);
        return new DotPosition(line, offset - element.getStartOffset(), offset);
    }

    @NotNull
    public static final MarkPosition markPosition(@NotNull JTextComponent $this$markPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$markPosition, (String)"<this>");
        int offset = $this$markPosition.getCaret().getMark();
        Element root = $this$markPosition.getDocument().getDefaultRootElement();
        int line = root.getElementIndex(offset);
        Element element = root.getElement(line);
        return new MarkPosition(line, offset - element.getStartOffset(), offset);
    }

    @NotNull
    public static final MarkToDotRange markToDotRange(@NotNull JTextComponent $this$markToDotRange) {
        Intrinsics.checkNotNullParameter((Object)$this$markToDotRange, (String)"<this>");
        return new MarkToDotRange(TextKitsKt.markPosition($this$markToDotRange), TextKitsKt.dotPosition($this$markToDotRange));
    }

    public static final void setCaretFrom(@NotNull JTextComponent $this$setCaretFrom, @NotNull MarkToDotRange range) {
        Caret caret;
        Intrinsics.checkNotNullParameter((Object)$this$setCaretFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Caret $this$setCaretFrom_u24lambda_u240 = caret = $this$setCaretFrom.getCaret();
        boolean bl = false;
        $this$setCaretFrom_u24lambda_u240.setDot(range.getMarkPosition().getOffset());
        $this$setCaretFrom_u24lambda_u240.moveDot(range.getDotPosition().getOffset());
    }

    @Nullable
    public static final Integer codePointOrNullAt(@NotNull Document $this$codePointOrNullAt, int position) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$codePointOrNullAt, (String)"<this>");
        try {
            String string2 = $this$codePointOrNullAt.getText(position, 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            object = string2;
            int n = 0;
            object = ((String)object).codePointAt(n);
        }
        catch (BadLocationException e) {
            object = null;
        }
        return object;
    }

    public static final int lineStartBefore(@NotNull Document $this$lineStartBefore, int position) {
        Intrinsics.checkNotNullParameter((Object)$this$lineStartBefore, (String)"<this>");
        int i2 = position;
        while (i2 > 0 && TextKitsKt.codePointAt($this$lineStartBefore, i2 - 1) != 10) {
            --i2;
        }
        return i2;
    }

    public static final int lineEndAfter(@NotNull Document $this$lineEndAfter, int position) {
        int c;
        int i2;
        Intrinsics.checkNotNullParameter((Object)$this$lineEndAfter, (String)"<this>");
        for (i2 = position; i2 < $this$lineEndAfter.getEndPosition().getOffset() && (c = TextKitsKt.codePointAt($this$lineEndAfter, i2)) != 10; ++i2) {
        }
        return i2;
    }

    public static final int indentationAt(@NotNull Document $this$indentationAt, int position) {
        int c;
        int i2;
        Intrinsics.checkNotNullParameter((Object)$this$indentationAt, (String)"<this>");
        for (i2 = position; i2 < $this$indentationAt.getLength() && (c = TextKitsKt.codePointAt($this$indentationAt, i2)) == 9; ++i2) {
        }
        return i2 - position;
    }

    public static final int indentationBefore(@NotNull Document $this$indentationBefore, int position) {
        Intrinsics.checkNotNullParameter((Object)$this$indentationBefore, (String)"<this>");
        return TextKitsKt.indentationAt($this$indentationBefore, TextKitsKt.lineStartBefore($this$indentationBefore, position));
    }

    public static final boolean getCanEdit(@NotNull JTextComponent $this$canEdit) {
        Intrinsics.checkNotNullParameter((Object)$this$canEdit, (String)"<this>");
        return $this$canEdit.isEnabled() && $this$canEdit.isEditable();
    }

    public static final void centerCurrentLine(@NotNull JTextComponent $this$centerCurrentLine) {
        JViewport viewport;
        Intrinsics.checkNotNullParameter((Object)$this$centerCurrentLine, (String)"<this>");
        Container container = SwingUtilities.getAncestorOfClass(JViewport.class, $this$centerCurrentLine);
        JViewport jViewport = viewport = container instanceof JViewport ? (JViewport)container : null;
        if (viewport == null) {
            return;
        }
        try {
            Rectangle2D rectangle2D = $this$centerCurrentLine.modelToView2D($this$centerCurrentLine.getCaretPosition());
            if (rectangle2D == null) {
                rectangle2D = new Rectangle();
            }
            Rectangle2D bounds = rectangle2D;
            double extentHeight = viewport.getExtentSize().height;
            double viewHeight = viewport.getViewSize().height;
            int y = (int)Math.min(Math.max(0.0, bounds.getY() - (extentHeight - bounds.getHeight()) / (double)2), viewHeight - extentHeight);
            viewport.setViewPosition(new Point(0, y));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void goTo(@NotNull JTextComponent $this$goTo, int line, int characterInLine) {
        Intrinsics.checkNotNullParameter((Object)$this$goTo, (String)"<this>");
        Element root = $this$goTo.getDocument().getDefaultRootElement();
        int normalizedLine = Math.max(0, Math.min(line, root.getElementCount() - 1));
        Element element = root.getElement(normalizedLine);
        int lineStart = element.getStartOffset();
        int position = Math.max(Math.min(lineStart + characterInLine, element.getEndOffset() - 1), lineStart);
        $this$goTo.setCaretPosition(position);
        TextKitsKt.centerCurrentLine($this$goTo);
        $this$goTo.requestFocus();
    }

    public static /* synthetic */ void goTo$default(JTextComponent jTextComponent, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        TextKitsKt.goTo(jTextComponent, n, n2);
    }

    @NotNull
    public static final List<Integer> lineStartsInSelection(@NotNull JTextComponent $this$lineStartsInSelection) {
        Intrinsics.checkNotNullParameter((Object)$this$lineStartsInSelection, (String)"<this>");
        if ($this$lineStartsInSelection.getSelectionStart() == $this$lineStartsInSelection.getSelectionEnd()) {
            Document document2 = $this$lineStartsInSelection.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            return CollectionsKt.listOf((Object)TextKitsKt.lineStartBefore(document2, $this$lineStartsInSelection.getSelectionStart()));
        }
        Document document3 = $this$lineStartsInSelection.getDocument();
        Intrinsics.checkNotNull((Object)document3);
        int firstLineStart = TextKitsKt.lineStartBefore(document3, $this$lineStartsInSelection.getSelectionStart());
        int lastLineStart = TextKitsKt.lineStartBefore(document3, $this$lineStartsInSelection.getSelectionEnd() - 1);
        Object[] objectArray = new Integer[]{firstLineStart};
        List insertionPoints = CollectionsKt.mutableListOf((Object[])objectArray);
        if (firstLineStart == lastLineStart) {
            return insertionPoints;
        }
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)(firstLineStart + 1), (int)(lastLineStart - 2));
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int position = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            int c = TextKitsKt.codePointAt(document3, position);
            if (c != 10) continue;
            insertionPoints.add(position + 1);
        }
        insertionPoints.add(lastLineStart);
        return insertionPoints;
    }

    public static final int firstLineStartInSelection(@NotNull JTextComponent $this$firstLineStartInSelection) {
        Intrinsics.checkNotNullParameter((Object)$this$firstLineStartInSelection, (String)"<this>");
        return ((Number)CollectionsKt.first(TextKitsKt.lineStartsInSelection($this$firstLineStartInSelection))).intValue();
    }

    @NotNull
    public static final List<Integer> lineEndsInSelection(@NotNull JTextComponent $this$lineEndsInSelection) {
        Intrinsics.checkNotNullParameter((Object)$this$lineEndsInSelection, (String)"<this>");
        if ($this$lineEndsInSelection.getSelectionStart() == $this$lineEndsInSelection.getSelectionEnd()) {
            Document document2 = $this$lineEndsInSelection.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            return CollectionsKt.listOf((Object)TextKitsKt.lineEndAfter(document2, $this$lineEndsInSelection.getSelectionStart()));
        }
        Document document3 = $this$lineEndsInSelection.getDocument();
        Intrinsics.checkNotNull((Object)document3);
        int firstLineEnd = TextKitsKt.lineEndAfter(document3, $this$lineEndsInSelection.getSelectionStart());
        int lastLineEnd = TextKitsKt.lineEndAfter(document3, $this$lineEndsInSelection.getSelectionEnd() - 1);
        Object[] objectArray = new Integer[]{firstLineEnd};
        List insertionPoints = CollectionsKt.mutableListOf((Object[])objectArray);
        if (firstLineEnd == lastLineEnd) {
            return insertionPoints;
        }
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)(firstLineEnd + 1), (int)(lastLineEnd - 2));
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int position = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            int c = TextKitsKt.codePointAt(document3, position);
            if (c != 10) continue;
            insertionPoints.add(position + 1);
        }
        insertionPoints.add(lastLineEnd);
        return insertionPoints;
    }

    public static final int lastLineEndInSelection(@NotNull JTextComponent $this$lastLineEndInSelection) {
        Intrinsics.checkNotNullParameter((Object)$this$lastLineEndInSelection, (String)"<this>");
        return ((Number)CollectionsKt.last(TextKitsKt.lineEndsInSelection($this$lastLineEndInSelection))).intValue();
    }

    @NotNull
    public static final String selectedLinesText(@NotNull JTextPane $this$selectedLinesText) {
        Intrinsics.checkNotNullParameter((Object)$this$selectedLinesText, (String)"<this>");
        JTextComponent txt = $this$selectedLinesText;
        int start = TextKitsKt.firstLineStartInSelection(txt);
        int end = TextKitsKt.lastLineEndInSelection(txt);
        String string2 = txt.getDocument().getText(start, end - start);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void transaction(@NotNull JTextPane $this$transaction, @NotNull Function1<? super JTextPane, Unit> edit) {
        UndoManager undoManager;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"<this>");
        Intrinsics.checkNotNullParameter(edit, (String)"edit");
        boolean $i$f$transaction = false;
        Object object = $this$transaction.getClientProperty("undoManager");
        UndoManager undoManager2 = undoManager = object instanceof UndoManager ? (UndoManager)object : null;
        if (undoManager == null) {
            edit.invoke((Object)$this$transaction);
        } else {
            CompoundEdit currentEdit;
            Object object2 = $this$transaction.getClientProperty("currentEdit");
            CompoundEdit compoundEdit = currentEdit = object2 instanceof CompoundEdit ? (CompoundEdit)object2 : null;
            if (compoundEdit != null) {
                compoundEdit.end();
            }
            CompoundEdit compoundEdit2 = new CompoundEdit();
            undoManager.addEdit(compoundEdit2);
            try {
                edit.invoke((Object)$this$transaction);
            }
            finally {
                InlineMarker.finallyStart((int)1);
                compoundEdit2.end();
                InlineMarker.finallyEnd((int)1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void transform(@NotNull JTextPane $this$transform, @NotNull Function1<? super String, String> transformer) {
        UndoManager undoManager$iv;
        Intrinsics.checkNotNullParameter((Object)$this$transform, (String)"<this>");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        JTextComponent txt = $this$transform;
        if (txt.getSelectionStart() == txt.getSelectionEnd()) {
            UIManager.getLookAndFeel().provideErrorFeedback($this$transform);
            return;
        }
        String textToTransform = txt.getSelectedText();
        int startPosition = txt.getSelectionStart();
        Intrinsics.checkNotNull((Object)textToTransform);
        String transformed = (String)transformer.invoke((Object)textToTransform);
        if (Intrinsics.areEqual((Object)transformed, (Object)textToTransform)) {
            UIManager.getLookAndFeel().provideErrorFeedback($this$transform);
            return;
        }
        JTextPane $this$transaction$iv = $this$transform;
        boolean $i$f$transaction = false;
        Object object = $this$transaction$iv.getClientProperty("undoManager");
        UndoManager undoManager = undoManager$iv = object instanceof UndoManager ? (UndoManager)object : null;
        if (undoManager$iv == null) {
            JTextPane $this$transform_u24lambda_u243 = $this$transaction$iv;
            boolean bl = false;
            txt.getDocument().remove(startPosition, textToTransform.length());
            txt.getDocument().insertString(startPosition, transformed, null);
            txt.setSelectionStart(startPosition);
            txt.setSelectionEnd(startPosition + transformed.length());
        } else {
            CompoundEdit currentEdit$iv;
            Object object2 = $this$transaction$iv.getClientProperty("currentEdit");
            CompoundEdit compoundEdit = currentEdit$iv = object2 instanceof CompoundEdit ? (CompoundEdit)object2 : null;
            if (compoundEdit != null) {
                compoundEdit.end();
            }
            CompoundEdit compoundEdit$iv = new CompoundEdit();
            undoManager$iv.addEdit(compoundEdit$iv);
            try {
                JTextPane $this$transform_u24lambda_u243 = $this$transaction$iv;
                boolean bl = false;
                txt.getDocument().remove(startPosition, textToTransform.length());
                txt.getDocument().insertString(startPosition, transformed, null);
                txt.setSelectionStart(startPosition);
                txt.setSelectionEnd(startPosition + transformed.length());
            }
            finally {
                compoundEdit$iv.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void transformLines(@NotNull JTextPane $this$transformLines, @NotNull Function1<? super String, String> transformer) {
        UndoManager undoManager$iv;
        Intrinsics.checkNotNullParameter((Object)$this$transformLines, (String)"<this>");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        JTextComponent txt = $this$transformLines;
        int start = TextKitsKt.firstLineStartInSelection(txt);
        int end = TextKitsKt.lastLineEndInSelection(txt);
        int length = end - start;
        String textToTransform = txt.getDocument().getText(start, length);
        Intrinsics.checkNotNull((Object)textToTransform);
        String transformed = (String)transformer.invoke((Object)textToTransform);
        if (Intrinsics.areEqual((Object)transformed, (Object)textToTransform)) {
            UIManager.getLookAndFeel().provideErrorFeedback($this$transformLines);
            return;
        }
        JTextPane $this$transaction$iv = $this$transformLines;
        boolean $i$f$transaction = false;
        Object object = $this$transaction$iv.getClientProperty("undoManager");
        UndoManager undoManager = undoManager$iv = object instanceof UndoManager ? (UndoManager)object : null;
        if (undoManager$iv == null) {
            JTextPane $this$transformLines_u24lambda_u244 = $this$transaction$iv;
            boolean bl = false;
            txt.getDocument().remove(start, length);
            txt.getDocument().insertString(start, transformed, null);
            txt.setSelectionStart(start);
            txt.setSelectionEnd(start + transformed.length());
        } else {
            CompoundEdit currentEdit$iv;
            Object object2 = $this$transaction$iv.getClientProperty("currentEdit");
            CompoundEdit compoundEdit = currentEdit$iv = object2 instanceof CompoundEdit ? (CompoundEdit)object2 : null;
            if (compoundEdit != null) {
                compoundEdit.end();
            }
            CompoundEdit compoundEdit$iv = new CompoundEdit();
            undoManager$iv.addEdit(compoundEdit$iv);
            try {
                JTextPane $this$transformLines_u24lambda_u244 = $this$transaction$iv;
                boolean bl = false;
                txt.getDocument().remove(start, length);
                txt.getDocument().insertString(start, transformed, null);
                txt.setSelectionStart(start);
                txt.setSelectionEnd(start + transformed.length());
            }
            finally {
                compoundEdit$iv.end();
            }
        }
    }

    @NotNull
    public static final String toCamelCase(@NotNull String textToTransform) {
        Intrinsics.checkNotNullParameter((Object)textToTransform, (String)"textToTransform");
        return new StringCaseTransformQueue(textToTransform).getCamelCase();
    }

    @NotNull
    public static final String toPascalCase(@NotNull String textToTransform) {
        Intrinsics.checkNotNullParameter((Object)textToTransform, (String)"textToTransform");
        return new StringCaseTransformQueue(textToTransform).getPascalCase();
    }

    @NotNull
    public static final String toSnakeCase(@NotNull String textToTransform) {
        Intrinsics.checkNotNullParameter((Object)textToTransform, (String)"textToTransform");
        return new StringCaseTransformQueue(textToTransform).getSnakeCase();
    }

    @NotNull
    public static final String toKebabCase(@NotNull String textToTransform) {
        Intrinsics.checkNotNullParameter((Object)textToTransform, (String)"textToTransform");
        return new StringCaseTransformQueue(textToTransform).getKebabCase();
    }
}

