/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler;

import avail.compiler.AvailCompiler;
import avail.compiler.ParserState;
import avail.compiler.ParsingOperation;
import avail.compiler.ParsingOperationStatistics;
import avail.compiler.ParsingStepState;
import avail.compiler.problems.CompilerDiagnostics;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.bundles.A_BundleTree;
import avail.descriptor.maps.A_Map;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.DeclarationPhraseDescriptor;
import avail.descriptor.phrases.MacroSubstitutionPhraseDescriptor;
import avail.descriptor.phrases.ReferencePhraseDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J,\u0010\n\u001a\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J%\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0010\u00a2\u0006\u0002\b\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lavail/compiler/ParseVariableReference;", "Lavail/compiler/ParsingOperation;", "Lavail/compiler/ParsingOperationStatistics;", "()V", "expandingStatisticInNanoseconds", "Lavail/performance/Statistic;", "getExpandingStatisticInNanoseconds", "()Lavail/performance/Statistic;", "parsingStatisticInNanoseconds", "getParsingStatisticInNanoseconds", "describeWhyVariableUseIsExpected", "Lkotlin/Function1;", "", "", "Lavail/utility/evaluation/Describer;", "successorTree", "Lavail/descriptor/bundles/A_BundleTree;", "execute", "compiler", "Lavail/compiler/AvailCompiler;", "stepState", "Lavail/compiler/ParsingStepState;", "execute$avail", "avail"})
public final class ParseVariableReference
extends ParsingOperation
implements ParsingOperationStatistics {
    @NotNull
    public static final ParseVariableReference INSTANCE = new ParseVariableReference();
    @NotNull
    private static final Statistic parsingStatisticInNanoseconds = new Statistic(StatisticReport.RUNNING_PARSING_INSTRUCTIONS, INSTANCE.getName());
    @NotNull
    private static final Statistic expandingStatisticInNanoseconds = new Statistic(StatisticReport.EXPANDING_PARSING_INSTRUCTIONS, INSTANCE.getName());

    private ParseVariableReference() {
        super(false, true, null);
    }

    @Override
    public void execute$avail(@NotNull AvailCompiler compiler2, @NotNull ParsingStepState stepState, @NotNull A_BundleTree successorTree) {
        AvailCompiler.PartialSubexpressionList partialSubexpressionList;
        Intrinsics.checkNotNullParameter((Object)compiler2, (String)"compiler");
        Intrinsics.checkNotNullParameter((Object)stepState, (String)"stepState");
        Intrinsics.checkNotNullParameter((Object)successorTree, (String)"successorTree");
        if (stepState.getFirstArgOrNull() == null) {
            AvailCompiler.PartialSubexpressionList partialSubexpressionList2 = stepState.getSuperexpressions();
            Intrinsics.checkNotNull((Object)partialSubexpressionList2);
            partialSubexpressionList = partialSubexpressionList2.advancedTo(successorTree);
        } else {
            partialSubexpressionList = stepState.getSuperexpressions();
        }
        AvailCompiler.PartialSubexpressionList partialSubexpressionList3 = partialSubexpressionList;
        compiler2.parseSendArgumentWithExplanationThen$avail(stepState.getStart(), "variable reference", stepState.getFirstArgOrNull(), stepState.getFirstArgOrNull() == null && !Intrinsics.areEqual((Object)stepState.getInitialTokenPosition().getLexingState(), (Object)stepState.getStart().getLexingState()), false, partialSubexpressionList3, (Function2<? super ParserState, ? super A_Phrase, Unit>)((Function2)new Function2<ParserState, A_Phrase, Unit>(stepState, successorTree, compiler2){
            final /* synthetic */ ParsingStepState $stepState;
            final /* synthetic */ A_BundleTree $successorTree;
            final /* synthetic */ AvailCompiler $compiler;
            {
                this.$stepState = $stepState;
                this.$successorTree = $successorTree;
                this.$compiler = $compiler;
                super(2);
            }

            public final void invoke(@NotNull ParserState afterUse, @NotNull A_Phrase variableUse) {
                Intrinsics.checkNotNullParameter((Object)afterUse, (String)"afterUse");
                Intrinsics.checkNotNullParameter((Object)variableUse, (String)"variableUse");
                A_Phrase rawVariableUse = A_Phrase.Companion.getStripMacro(variableUse);
                if (!A_Phrase.Companion.phraseKindIsUnder(rawVariableUse, PhraseTypeDescriptor.PhraseKind.VARIABLE_USE_PHRASE)) {
                    if (this.$stepState.getConsumedAnything()) {
                        afterUse.expected$avail(this.$stepState.getStaticTokens().isEmpty() ? CompilerDiagnostics.ParseNotificationLevel.WEAK : CompilerDiagnostics.ParseNotificationLevel.STRONG, (Function1<? super Function1<? super String, Unit>, Unit>)ParseVariableReference.access$describeWhyVariableUseIsExpected(ParseVariableReference.INSTANCE, this.$successorTree));
                    }
                    return;
                }
                DeclarationPhraseDescriptor.DeclarationKind declarationKind = A_Phrase.Companion.getDeclaration(rawVariableUse).declarationKind();
                if (!declarationKind.isVariable()) {
                    if (this.$stepState.getConsumedAnything()) {
                        afterUse.expected$avail(CompilerDiagnostics.ParseNotificationLevel.WEAK, "variable for reference argument to be assignable, not " + declarationKind.nativeKindName());
                    }
                    return;
                }
                A_Phrase rawVariableReference = ReferencePhraseDescriptor.Companion.referenceNodeFromUse(rawVariableUse);
                A_Phrase variableReference = A_Phrase.Companion.isMacroSubstitutionNode(variableUse) ? MacroSubstitutionPhraseDescriptor.Companion.newMacroSubstitution(A_Phrase.Companion.getMacroOriginalSendNode(variableUse), rawVariableReference) : rawVariableReference;
                ParsingStepState stepStateCopy2 = this.$stepState.copy((Function1<? super ParsingStepState, Unit>)((Function1)new Function1<ParsingStepState, Unit>(afterUse, variableReference){
                    final /* synthetic */ ParserState $afterUse;
                    final /* synthetic */ A_Phrase $variableReference;
                    {
                        this.$afterUse = $afterUse;
                        this.$variableReference = $variableReference;
                        super(1);
                    }

                    public final void invoke(@NotNull ParsingStepState $this$copy) {
                        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"$this$copy");
                        $this$copy.setStart(this.$afterUse);
                        $this$copy.setConsumedAnythingBeforeLatestArgument($this$copy.getConsumedAnything());
                        $this$copy.setConsumedAnything($this$copy.getFirstArgOrNull() == null);
                        $this$copy.setFirstArgOrNull(null);
                        $this$copy.push(this.$variableReference);
                    }
                }));
                this.$compiler.eventuallyParseRestOfSendNode$avail(this.$successorTree, stepStateCopy2);
            }
        }));
    }

    private final Function1<Function1<? super String, Unit>, Unit> describeWhyVariableUseIsExpected(A_BundleTree successorTree) {
        return (Function1)new Function1<Function1<? super String, ? extends Unit>, Unit>(successorTree){
            final /* synthetic */ A_BundleTree $successorTree;
            {
                this.$successorTree = $successorTree;
                super(1);
            }

            public final void invoke(@NotNull Function1<? super String, Unit> continuation) {
                Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
                A_Set bundles = A_Map.Companion.getKeysAsSet(A_BundleTree.Companion.getAllParsingPlansInProgress(this.$successorTree));
                StringBuilder builder = new StringBuilder();
                builder.append("a variable use, for one of:");
                if (A_Set.Companion.getSetSize(bundles) > 2) {
                    builder.append("\n\t");
                } else {
                    builder.append(' ');
                }
                boolean first = true;
                for (AvailObject bundle : bundles) {
                    if (!first) {
                        builder.append(", ");
                    }
                    builder.append(A_Atom.Companion.getAtomName(A_Bundle.Companion.getMessage(bundle)));
                    first = false;
                }
                String string2 = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                continuation.invoke((Object)string2);
            }
        };
    }

    @Override
    @NotNull
    public Statistic getParsingStatisticInNanoseconds() {
        return parsingStatisticInNanoseconds;
    }

    @Override
    @NotNull
    public Statistic getExpandingStatisticInNanoseconds() {
        return expandingStatisticInNanoseconds;
    }

    public static final /* synthetic */ Function1 access$describeWhyVariableUseIsExpected(ParseVariableReference $this, A_BundleTree successorTree) {
        return $this.describeWhyVariableUseIsExpected(successorTree);
    }
}

