/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.atoms;

import avail.AvailRuntimeSupport;
import avail.annotations.HideFieldInDebugger;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.atoms.AtomWithPropertiesDescriptor;
import avail.descriptor.atoms.AtomWithPropertiesSharedDescriptor;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.module.A_Module;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AbstractSlotsEnum;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.BitField;
import avail.descriptor.representation.Descriptor;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TypeTag;
import avail.exceptions.MalformedMessageException;
import avail.serialization.SerializerOperation;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 B2\u00020\u0001:\u0004BCDEB7\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0000H\u0016J\b\u0010\u0011\u001a\u00020\u0000H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010#\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010(\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J2\u0010)\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00150,2\u0012\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0.0,H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u00101\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u0017H\u0016J \u00103\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u001bH\u0016J\u0018\u00105\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00106\u001a\u000207H\u0016J8\u00108\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u00152\n\u00109\u001a\u00060:j\u0002`;2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020>0=2\u0006\u0010?\u001a\u00020 H\u0016J\u0010\u0010@\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010A\u001a\u00020\u0000H\u0017\u00a8\u0006F"}, d2={"Lavail/descriptor/atoms/AtomDescriptor;", "Lavail/descriptor/representation/Descriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "typeTag", "Lavail/descriptor/types/TypeTag;", "objectSlotsEnumClass", "Ljava/lang/Class;", "Lavail/descriptor/representation/ObjectSlotsEnum;", "integerSlotsEnumClass", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Lavail/descriptor/representation/Mutability;Lavail/descriptor/types/TypeTag;Ljava/lang/Class;Ljava/lang/Class;)V", "allowsImmutableToMutableReferenceInField", "", "e", "Lavail/descriptor/representation/AbstractSlotsEnum;", "immutable", "mutable", "o_AtomName", "Lavail/descriptor/tuples/A_String;", "self", "Lavail/descriptor/representation/AvailObject;", "o_BundleOrCreate", "Lavail/descriptor/bundles/A_Bundle;", "o_BundleOrNil", "o_Equals", "another", "Lavail/descriptor/representation/A_BasicObject;", "o_GetAtomProperty", "key", "Lavail/descriptor/atoms/A_Atom;", "o_Hash", "", "o_IsAtom", "o_IsAtomSpecial", "o_IsInstanceOfKind", "aType", "Lavail/descriptor/types/A_Type;", "o_IssuingModule", "Lavail/descriptor/module/A_Module;", "o_Kind", "o_MakeSharedInternal", "", "queueToProcess", "", "fixups", "Lkotlin/Function0;", "o_SerializerOperation", "Lavail/serialization/SerializerOperation;", "o_SetAtomBundle", "bundle", "o_SetAtomProperty", "value", "o_WriteTo", "writer", "Lorg/availlang/json/JSONWriter;", "printObjectOnAvoidingIndent", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recursionMap", "Ljava/util/IdentityHashMap;", "Ljava/lang/Void;", "indent", "propertyMapOrNil", "shared", "Companion", "IntegerSlots", "ObjectSlots", "SpecialAtom", "avail"})
@SourceDebugExtension(value={"SMAP\nAtomDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtomDescriptor.kt\navail/descriptor/atoms/AtomDescriptor\n+ 2 ComparableSupport.kt\navail/utility/ComparableSupportKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 JSONWriter.kt\norg/availlang/json/JSONWriter\n*L\n1#1,604:1\n44#2:605\n215#3,2:606\n933#4,4:608\n1667#4,2:612\n1667#4,2:614\n1667#4,2:616\n940#4:618\n939#4:619\n*S KotlinDebug\n*F\n+ 1 AtomDescriptor.kt\navail/descriptor/atoms/AtomDescriptor\n*L\n223#1:605\n260#1:606,2\n320#1:608,4\n321#1:612,2\n322#1:614,2\n325#1:616,2\n320#1:618\n320#1:619\n*E\n"})
public class AtomDescriptor
extends Descriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final AtomDescriptor mutable = new AtomDescriptor(Mutability.MUTABLE, TypeTag.ATOM_TAG, ObjectSlots.class, IntegerSlots.class);
    @NotNull
    private static final AtomDescriptor immutable = new AtomDescriptor(Mutability.IMMUTABLE, TypeTag.ATOM_TAG, ObjectSlots.class, IntegerSlots.class);
    @NotNull
    private static final AtomDescriptor transientShared = new AtomDescriptor(Mutability.SHARED, TypeTag.ATOM_TAG, ObjectSlots.class, IntegerSlots.class);
    private static final Pattern wordPattern = Pattern.compile("\\w(\\w|\\d|_)*");

    protected AtomDescriptor(@NotNull Mutability mutability, @NotNull TypeTag typeTag, @NotNull Class<? extends ObjectSlotsEnum> objectSlotsEnumClass, @NotNull Class<? extends IntegerSlotsEnum> integerSlotsEnumClass) {
        Intrinsics.checkNotNullParameter((Object)((Object)mutability), (String)"mutability");
        Intrinsics.checkNotNullParameter((Object)((Object)typeTag), (String)"typeTag");
        Intrinsics.checkNotNullParameter(objectSlotsEnumClass, (String)"objectSlotsEnumClass");
        Intrinsics.checkNotNullParameter(integerSlotsEnumClass, (String)"integerSlotsEnumClass");
        super(mutability, typeTag, objectSlotsEnumClass, integerSlotsEnumClass);
    }

    @Override
    protected boolean allowsImmutableToMutableReferenceInField(@NotNull AbstractSlotsEnum e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e == IntegerSlots.HASH_AND_MORE;
    }

    @Override
    public void printObjectOnAvoidingIndent(@NotNull AvailObject self, @NotNull StringBuilder builder, @NotNull IdentityHashMap<A_BasicObject, Void> recursionMap, int indent) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(recursionMap, (String)"recursionMap");
        StringBuilder $this$printObjectOnAvoidingIndent_u24lambda_u240 = builder;
        boolean bl = false;
        String nativeName = A_String.Companion.asNativeString(A_Atom.Companion.getAtomName(self));
        if (A_Atom.Companion.isAtomSpecial(self)) {
            $this$printObjectOnAvoidingIndent_u24lambda_u240.append(nativeName);
        } else if (wordPattern.matcher(nativeName).matches()) {
            $this$printObjectOnAvoidingIndent_u24lambda_u240.append("$" + nativeName);
        } else {
            $this$printObjectOnAvoidingIndent_u24lambda_u240.append("$\"" + nativeName + "\"");
        }
    }

    @Override
    @NotNull
    public A_String o_AtomName(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return self.get(ObjectSlots.NAME);
    }

    @Override
    @NotNull
    public A_Bundle o_BundleOrCreate(@NotNull AvailObject self) throws MalformedMessageException {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return A_Atom.Companion.bundleOrCreate(self.makeShared());
    }

    @Override
    @NotNull
    public A_Bundle o_BundleOrNil(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return NilDescriptor.Companion.getNil();
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return another.traversed().sameAddressAs(self);
    }

    @Override
    @NotNull
    public AvailObject o_GetAtomProperty(@NotNull AvailObject self, @NotNull A_Atom key) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return NilDescriptor.Companion.getNil();
    }

    @Override
    public int o_Hash(@NotNull AvailObject self) {
        int n;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int $this$ifZero$iv = self.get(IntegerSlots.Companion.getHASH_OR_ZERO());
        boolean $i$f$ifZero = false;
        if ($this$ifZero$iv != 0) {
            n = $this$ifZero$iv;
        } else {
            int n2;
            boolean bl = false;
            int hash = n2 = AvailRuntimeSupport.INSTANCE.nextNonzeroHash();
            boolean bl2 = false;
            self.set(IntegerSlots.Companion.getHASH_OR_ZERO(), hash);
            n = n2;
        }
        return n;
    }

    @Override
    public boolean o_IsAtom(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return true;
    }

    @Override
    public boolean o_IsAtomSpecial(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return false;
    }

    @Override
    public boolean o_IsInstanceOfKind(@NotNull AvailObject self, @NotNull A_Type aType) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aType, (String)"aType");
        return A_Type.Companion.isSupertypeOfPrimitiveTypeEnum(aType, PrimitiveTypeDescriptor.Types.ATOM);
    }

    @Override
    @NotNull
    public A_Module o_IssuingModule(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return self.get(ObjectSlots.ISSUING_MODULE);
    }

    @Override
    @NotNull
    public AvailObject o_Kind(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return PrimitiveTypeDescriptor.Types.ATOM.getO();
    }

    @Override
    public void o_MakeSharedInternal(@NotNull AvailObject self, @NotNull List<AvailObject> queueToProcess, @NotNull List<Function0<Unit>> fixups) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter(queueToProcess, (String)"queueToProcess");
        Intrinsics.checkNotNullParameter(fixups, (String)"fixups");
        boolean bl = this.isShared();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        super.o_MakeSharedInternal(self, queueToProcess, fixups);
        AvailObject map = this.propertyMapOrNil(self);
        if (map.getNotNil()) {
            Map propertyMap;
            Map $this$forEach$iv = propertyMap = (Map)map.javaObjectNotNull();
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl2 = false;
                A_Atom key = (A_Atom)entry.getKey();
                AvailObject value = (AvailObject)entry.getValue();
                if (!key.descriptor().isShared()) {
                    key.setDescriptor(key.descriptor().shared());
                    Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                    queueToProcess.add((AvailObject)key);
                }
                if (value.descriptor().isShared()) continue;
                value.setDescriptor(value.descriptor().shared());
                queueToProcess.add(value);
            }
        }
        AvailObject substituteAtom = AtomWithPropertiesSharedDescriptor.Companion.getShared().createInitialized(self.get(ObjectSlots.NAME), self.get(ObjectSlots.ISSUING_MODULE), map, self.get(IntegerSlots.Companion.getHASH_OR_ZERO()));
        boolean bl3 = substituteAtom.descriptor().isShared();
        if (_Assertions.ENABLED && !bl3) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        self.setDescriptor(self.descriptor().mutable());
        self.becomeIndirectionTo(substituteAtom);
        self.setDescriptor(self.descriptor().shared());
    }

    @Override
    public void o_SetAtomBundle(@NotNull AvailObject self, @NotNull A_Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        A_Atom.Companion.setAtomBundle(self.makeShared(), bundle);
    }

    @Override
    public void o_SetAtomProperty(@NotNull AvailObject self, @NotNull A_Atom key, @NotNull A_BasicObject value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean bl2 = bl = !this.isShared();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AvailObject substituteAtom = AtomWithPropertiesDescriptor.Companion.createWithProperties(self.get(ObjectSlots.NAME), self.get(ObjectSlots.ISSUING_MODULE), self.get(IntegerSlots.Companion.getHASH_OR_ZERO()));
        self.becomeIndirectionTo(substituteAtom);
        A_Atom.Companion.setAtomProperty(substituteAtom, key, value);
    }

    @Override
    @NotNull
    public SerializerOperation o_SerializerOperation(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return SerializerOperation.ATOM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void o_WriteTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        JSONWriter this_$iv = writer;
        boolean $i$f$writeObject = false;
        this_$iv.startObject();
        try {
            JSONWriter this_$iv2;
            JSONWriter $this$o_WriteTo_u24lambda_u247 = this_$iv;
            boolean bl = false;
            JSONWriter jSONWriter = $this$o_WriteTo_u24lambda_u247;
            String key$iv = "kind";
            boolean $i$f$at = false;
            this_$iv2.write(key$iv);
            void $this$o_WriteTo_u24lambda_u247_u24lambda_u244 = this_$iv2;
            boolean bl2 = false;
            $this$o_WriteTo_u24lambda_u247_u24lambda_u244.write("atom");
            this_$iv2 = $this$o_WriteTo_u24lambda_u247;
            key$iv = "atom name";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$o_WriteTo_u24lambda_u247_u24lambda_u245 = this_$iv2;
            boolean bl3 = false;
            self.get(ObjectSlots.NAME).writeTo(writer);
            AvailObject module = self.get(ObjectSlots.ISSUING_MODULE);
            if (module.getNotNil()) {
                void this_$iv3;
                key$iv = $this$o_WriteTo_u24lambda_u247;
                String key$iv2 = "issuing module";
                boolean $i$f$at2 = false;
                this_$iv3.write(key$iv2);
                void $this$o_WriteTo_u24lambda_u247_u24lambda_u246 = this_$iv3;
                boolean bl4 = false;
                module.writeSummaryTo(writer);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endObject();
        }
    }

    @NotNull
    protected AvailObject propertyMapOrNil(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return NilDescriptor.Companion.getNil();
    }

    @Override
    @NotNull
    public AtomDescriptor mutable() {
        return mutable;
    }

    @Override
    @NotNull
    public AtomDescriptor immutable() {
        return immutable;
    }

    @Override
    @Deprecated(message="Shared atoms are implemented in subclasses", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ AtomDescriptor shared() {
        return transientShared;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lavail/descriptor/atoms/AtomDescriptor$Companion;", "", "()V", "falseObject", "Lavail/descriptor/atoms/A_Atom;", "getFalseObject", "()Lavail/descriptor/atoms/A_Atom;", "immutable", "Lavail/descriptor/atoms/AtomDescriptor;", "mutable", "transientShared", "trueObject", "getTrueObject", "wordPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "createAtom", "Lavail/descriptor/representation/AvailObject;", "name", "Lavail/descriptor/tuples/A_String;", "issuingModule", "Lavail/descriptor/module/A_Module;", "createSpecialAtom", "", "objectFromBoolean", "aBoolean", "", "avail"})
    @SourceDebugExtension(value={"SMAP\nAtomDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtomDescriptor.kt\navail/descriptor/atoms/AtomDescriptor$Companion\n+ 2 AbstractDescriptor.kt\navail/descriptor/representation/AbstractDescriptor\n*L\n1#1,604:1\n606#2,7:605\n*S KotlinDebug\n*F\n+ 1 AtomDescriptor.kt\navail/descriptor/atoms/AtomDescriptor$Companion\n*L\n561#1:605,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AvailObject createAtom(@NotNull A_String name, @NotNull A_Module issuingModule) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)issuingModule, (String)"issuingModule");
            AbstractDescriptor $this$iv = mutable;
            int indexedSlotCount$iv = 0;
            boolean $i$f$createImmutable = false;
            AvailObject $this$createImmutable_u24lambda_u244$iv = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, $this$iv);
            boolean bl = false;
            AvailObject $this$createAtom_u24lambda_u240 = $this$createImmutable_u24lambda_u244$iv;
            boolean bl2 = false;
            $this$createAtom_u24lambda_u240.setSlot(ObjectSlots.NAME, name.makeShared());
            $this$createAtom_u24lambda_u240.setSlot(ObjectSlots.ISSUING_MODULE, issuingModule);
            $this$createAtom_u24lambda_u240.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return $this$createImmutable_u24lambda_u244$iv.makeImmutable();
        }

        @NotNull
        public final AvailObject createSpecialAtom(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return AtomWithPropertiesSharedDescriptor.Companion.getSharedSpecial().createInitialized(StringDescriptor.Companion.stringFrom(name), NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil(), 0);
        }

        @NotNull
        public final A_Atom getTrueObject() {
            return SpecialAtom.TRUE.getAtom();
        }

        @NotNull
        public final A_Atom getFalseObject() {
            return SpecialAtom.FALSE.getAtom();
        }

        @NotNull
        public final A_Atom objectFromBoolean(boolean aBoolean) {
            return aBoolean ? this.getTrueObject() : this.getFalseObject();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u0000 \u00052\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0006"}, d2={"Lavail/descriptor/atoms/AtomDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "HASH_AND_MORE", "Companion", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final BitField HASH_OR_ZERO;
        @HideFieldInDebugger
        public static final /* enum */ IntegerSlots HASH_AND_MORE;
        private static final /* synthetic */ IntegerSlots[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        @NotNull
        public static EnumEntries<IntegerSlots> getEntries() {
            return $ENTRIES;
        }

        static {
            HASH_AND_MORE = new IntegerSlots();
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.HASH_AND_MORE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            HASH_OR_ZERO = new BitField(HASH_AND_MORE, 0, 32, (Function1<? super Integer, String>)((Function1)Companion.HASH_OR_ZERO.1.INSTANCE));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/atoms/AtomDescriptor$IntegerSlots$Companion;", "", "()V", "HASH_OR_ZERO", "Lavail/descriptor/representation/BitField;", "getHASH_OR_ZERO", "()Lavail/descriptor/representation/BitField;", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BitField getHASH_OR_ZERO() {
                return HASH_OR_ZERO;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lavail/descriptor/atoms/AtomDescriptor$ObjectSlots;", "", "Lavail/descriptor/representation/ObjectSlotsEnum;", "(Ljava/lang/String;I)V", "NAME", "ISSUING_MODULE", "avail"})
    public static final class ObjectSlots
    extends Enum<ObjectSlots>
    implements ObjectSlotsEnum {
        public static final /* enum */ ObjectSlots NAME = new ObjectSlots();
        public static final /* enum */ ObjectSlots ISSUING_MODULE = new ObjectSlots();
        private static final /* synthetic */ ObjectSlots[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ObjectSlots[] values() {
            return (ObjectSlots[])$VALUES.clone();
        }

        public static ObjectSlots valueOf(String value) {
            return Enum.valueOf(ObjectSlots.class, value);
        }

        @NotNull
        public static EnumEntries<ObjectSlots> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = objectSlotsArray = new ObjectSlots[]{ObjectSlots.NAME, ObjectSlots.ISSUING_MODULE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u0086\u0081\u0002\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001 B\u0019\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001f\u00a8\u0006!"}, d2={"Lavail/descriptor/atoms/AtomDescriptor$SpecialAtom;", "", "name", "", "heritable", "", "(Ljava/lang/String;ILjava/lang/String;Z)V", "atom", "Lavail/descriptor/atoms/A_Atom;", "(Ljava/lang/String;ILavail/descriptor/atoms/A_Atom;Z)V", "getAtom", "()Lavail/descriptor/atoms/A_Atom;", "getHeritable", "()Z", "TRUE", "FALSE", "OBJECT_TYPE_NAME_PROPERTY_KEY", "COMPILER_SCOPE_MAP_KEY", "COMPILER_SCOPE_STACK_KEY", "ALL_TOKENS_KEY", "STATIC_TOKENS_KEY", "STATIC_TOKEN_INDICES_KEY", "MACRO_BUNDLE_KEY", "RUNNING_LEXER", "IS_STYLING", "CLIENT_DATA_GLOBAL_KEY", "FILE_KEY", "SERVER_SOCKET_KEY", "SOCKET_KEY", "HERITABLE_KEY", "EXPLICIT_SUBCLASSING_KEY", "DONT_DEBUG_KEY", "Companion", "avail"})
    @SourceDebugExtension(value={"SMAP\nAtomDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtomDescriptor.kt\navail/descriptor/atoms/AtomDescriptor$SpecialAtom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,604:1\n1855#2,2:605\n*S KotlinDebug\n*F\n+ 1 AtomDescriptor.kt\navail/descriptor/atoms/AtomDescriptor$SpecialAtom\n*L\n506#1:605,2\n*E\n"})
    public static final class SpecialAtom
    extends Enum<SpecialAtom> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final A_Atom atom;
        private final boolean heritable;
        public static final /* enum */ SpecialAtom TRUE;
        public static final /* enum */ SpecialAtom FALSE;
        public static final /* enum */ SpecialAtom OBJECT_TYPE_NAME_PROPERTY_KEY;
        public static final /* enum */ SpecialAtom COMPILER_SCOPE_MAP_KEY;
        public static final /* enum */ SpecialAtom COMPILER_SCOPE_STACK_KEY;
        public static final /* enum */ SpecialAtom ALL_TOKENS_KEY;
        public static final /* enum */ SpecialAtom STATIC_TOKENS_KEY;
        public static final /* enum */ SpecialAtom STATIC_TOKEN_INDICES_KEY;
        public static final /* enum */ SpecialAtom MACRO_BUNDLE_KEY;
        public static final /* enum */ SpecialAtom RUNNING_LEXER;
        public static final /* enum */ SpecialAtom IS_STYLING;
        public static final /* enum */ SpecialAtom CLIENT_DATA_GLOBAL_KEY;
        public static final /* enum */ SpecialAtom FILE_KEY;
        public static final /* enum */ SpecialAtom SERVER_SOCKET_KEY;
        public static final /* enum */ SpecialAtom SOCKET_KEY;
        public static final /* enum */ SpecialAtom HERITABLE_KEY;
        public static final /* enum */ SpecialAtom EXPLICIT_SUBCLASSING_KEY;
        public static final /* enum */ SpecialAtom DONT_DEBUG_KEY;
        private static final /* synthetic */ SpecialAtom[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SpecialAtom(A_Atom atom, boolean heritable) {
            this.atom = atom;
            this.heritable = heritable;
        }

        /* synthetic */ SpecialAtom(String string2, int n, A_Atom a_Atom, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                bl = false;
            }
            this(a_Atom, bl);
        }

        @NotNull
        public final A_Atom getAtom() {
            return this.atom;
        }

        public final boolean getHeritable() {
            return this.heritable;
        }

        private SpecialAtom(String name, boolean heritable) {
            this(Companion.createSpecialAtom(name), heritable);
        }

        /* synthetic */ SpecialAtom(String string2, int n, String string3, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                bl = false;
            }
            this(string3, bl);
        }

        public static SpecialAtom[] values() {
            return (SpecialAtom[])$VALUES.clone();
        }

        public static SpecialAtom valueOf(String value) {
            return Enum.valueOf(SpecialAtom.class, value);
        }

        @NotNull
        public static EnumEntries<SpecialAtom> getEntries() {
            return $ENTRIES;
        }

        static {
            TRUE = new SpecialAtom("TRUE", 0, AtomWithPropertiesSharedDescriptor.Companion.getSharedForTrue().createInitialized(StringDescriptor.Companion.stringFrom("true").makeShared(), NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil(), 0), false, 2, null);
            FALSE = new SpecialAtom("FALSE", 1, AtomWithPropertiesSharedDescriptor.Companion.getSharedForFalse().createInitialized(StringDescriptor.Companion.stringFrom("false").makeShared(), NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil(), 0), false, 2, null);
            OBJECT_TYPE_NAME_PROPERTY_KEY = new SpecialAtom("OBJECT_TYPE_NAME_PROPERTY_KEY", 2, "object names", false, 2, null);
            COMPILER_SCOPE_MAP_KEY = new SpecialAtom("COMPILER_SCOPE_MAP_KEY", 3, "Compilation scope", false, 2, null);
            COMPILER_SCOPE_STACK_KEY = new SpecialAtom("COMPILER_SCOPE_STACK_KEY", 4, "Compilation scope stack", false, 2, null);
            ALL_TOKENS_KEY = new SpecialAtom("ALL_TOKENS_KEY", 5, "All tokens", false, 2, null);
            STATIC_TOKENS_KEY = new SpecialAtom("STATIC_TOKENS_KEY", 6, "Static tokens", false, 2, null);
            STATIC_TOKEN_INDICES_KEY = new SpecialAtom("STATIC_TOKEN_INDICES_KEY", 7, "Static token indices", false, 2, null);
            MACRO_BUNDLE_KEY = new SpecialAtom("MACRO_BUNDLE_KEY", 8, "Macro bundle", false, 2, null);
            RUNNING_LEXER = new SpecialAtom("running lexer", true);
            IS_STYLING = new SpecialAtom("IS_STYLING", 10, "is styling", false, 2, null);
            CLIENT_DATA_GLOBAL_KEY = new SpecialAtom("CLIENT_DATA_GLOBAL_KEY", 11, "Compiler client data", false, 2, null);
            FILE_KEY = new SpecialAtom("FILE_KEY", 12, "file key", false, 2, null);
            SERVER_SOCKET_KEY = new SpecialAtom("SERVER_SOCKET_KEY", 13, "server socket key", false, 2, null);
            SOCKET_KEY = new SpecialAtom("SOCKET_KEY", 14, "socket key", false, 2, null);
            HERITABLE_KEY = new SpecialAtom("HERITABLE_KEY", 15, "heritability", false, 2, null);
            EXPLICIT_SUBCLASSING_KEY = new SpecialAtom("EXPLICIT_SUBCLASSING_KEY", 16, "explicit subclassing", false, 2, null);
            DONT_DEBUG_KEY = new SpecialAtom("don't debug", true);
            $VALUES = specialAtomArray = new SpecialAtom[]{SpecialAtom.TRUE, SpecialAtom.FALSE, SpecialAtom.OBJECT_TYPE_NAME_PROPERTY_KEY, SpecialAtom.COMPILER_SCOPE_MAP_KEY, SpecialAtom.COMPILER_SCOPE_STACK_KEY, SpecialAtom.ALL_TOKENS_KEY, SpecialAtom.STATIC_TOKENS_KEY, SpecialAtom.STATIC_TOKEN_INDICES_KEY, SpecialAtom.MACRO_BUNDLE_KEY, SpecialAtom.RUNNING_LEXER, SpecialAtom.IS_STYLING, SpecialAtom.CLIENT_DATA_GLOBAL_KEY, SpecialAtom.FILE_KEY, SpecialAtom.SERVER_SOCKET_KEY, SpecialAtom.SOCKET_KEY, SpecialAtom.HERITABLE_KEY, SpecialAtom.EXPLICIT_SUBCLASSING_KEY, SpecialAtom.DONT_DEBUG_KEY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Iterable $this$forEach$iv = (Iterable)SpecialAtom.getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SpecialAtom specialAtom = (SpecialAtom)((Object)element$iv);
                boolean bl = false;
                if (!specialAtom.heritable) continue;
                A_Atom.Companion.setAtomProperty(specialAtom.atom, SpecialAtom.HERITABLE_KEY.atom, Companion.getTrueObject());
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lavail/descriptor/atoms/AtomDescriptor$SpecialAtom$Companion;", "", "()V", "avail"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

