/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.functions;

import avail.annotations.HideFieldInDebugger;
import avail.annotations.ThreadSafe;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.methods.A_Method;
import avail.descriptor.methods.A_Sendable;
import avail.descriptor.methods.MethodDescriptor;
import avail.descriptor.module.A_Module;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.BlockPhraseDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.AvailObjectFieldHelper;
import avail.descriptor.representation.Descriptor;
import avail.descriptor.representation.Mutability;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TypeTag;
import avail.interpreter.levelOne.L1Decompiler;
import avail.interpreter.levelOne.L1InstructionWriter;
import avail.interpreter.levelOne.L1Operation;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import avail.serialization.SerializerOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 32\u00020\u0001:\u000234B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0000H\u0016J\b\u0010\u0006\u001a\u00020\u0000H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J\u0018\u0010 \u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J \u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\nH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010&\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010'\u001a\u00020(H\u0016J8\u0010*\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\n2\n\u0010+\u001a\u00060,j\u0002`-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002000/2\u0006\u00101\u001a\u00020\u0017H\u0016J\b\u00102\u001a\u00020\u0000H\u0016\u00a8\u00065"}, d2={"Lavail/descriptor/functions/FunctionDescriptor;", "Lavail/descriptor/representation/Descriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "(Lavail/descriptor/representation/Mutability;)V", "immutable", "mutable", "o_Code", "Lavail/descriptor/functions/A_RawFunction;", "self", "Lavail/descriptor/representation/AvailObject;", "o_DescribeForDebugger", "", "Lavail/descriptor/representation/AvailObjectFieldHelper;", "(Lavail/descriptor/representation/AvailObject;)[Lavail/descriptor/representation/AvailObjectFieldHelper;", "o_Equals", "", "another", "Lavail/descriptor/representation/A_BasicObject;", "o_EqualsFunction", "aFunction", "Lavail/descriptor/functions/A_Function;", "o_Hash", "", "o_IsFunction", "o_Kind", "Lavail/descriptor/types/A_Type;", "o_NameForDebugger", "", "o_NumOuterVars", "o_OptionallyNilOuterVar", "index", "o_OuterVarAt", "o_OuterVarAtPut", "", "value", "o_SerializerOperation", "Lavail/serialization/SerializerOperation;", "o_WriteSummaryTo", "writer", "Lorg/availlang/json/JSONWriter;", "o_WriteTo", "printObjectOnAvoidingIndent", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recursionMap", "Ljava/util/IdentityHashMap;", "Ljava/lang/Void;", "indent", "shared", "Companion", "ObjectSlots", "avail"})
@SourceDebugExtension(value={"SMAP\nFunctionDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionDescriptor.kt\navail/descriptor/functions/FunctionDescriptor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 JSONWriter.kt\norg/availlang/json/JSONWriter\n*L\n1#1,762:1\n37#2,2:763\n1747#3,3:765\n1789#3,3:768\n933#4,4:771\n1667#4,2:775\n1667#4,2:777\n1667#4,2:779\n1006#4,8:781\n940#4:789\n939#4:790\n933#4,4:791\n1667#4,2:795\n1667#4,2:797\n1667#4,2:799\n1006#4,8:801\n940#4:809\n939#4:810\n*S KotlinDebug\n*F\n+ 1 FunctionDescriptor.kt\navail/descriptor/functions/FunctionDescriptor\n*L\n171#1:763,2\n184#1:765,3\n208#1:768,3\n265#1:771,4\n266#1:775,2\n267#1:777,2\n268#1:779,2\n269#1:781,8\n265#1:789\n265#1:790\n279#1:791,4\n280#1:795,2\n281#1:797,2\n284#1:799,2\n285#1:801,8\n279#1:809\n279#1:810\n*E\n"})
public final class FunctionDescriptor
extends Descriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final CheckedMethod functionCodeMethod = CheckedMethod.Companion.instanceMethod(A_Function.class, "code", A_RawFunction.class, new Class[0]);
    @NotNull
    private static final CheckedMethod createExceptOutersMethod;
    @NotNull
    private static final CheckedMethod createWithOuters1Method;
    @NotNull
    private static final CheckedMethod createWithOuters2Method;
    @NotNull
    private static final CheckedMethod createWithOuters3Method;
    @NotNull
    private static final CheckedMethod createWithOuters4Method;
    @NotNull
    private static final CheckedMethod createWithOuters5Method;
    @NotNull
    private static final CheckedMethod outerVarAtMethod;
    @NotNull
    private static final CheckedMethod outerVarAtPutMethod;
    @NotNull
    private static final FunctionDescriptor mutable;
    @NotNull
    private static final FunctionDescriptor immutable;
    @NotNull
    private static final FunctionDescriptor shared;

    private FunctionDescriptor(Mutability mutability) {
        super(mutability, TypeTag.FUNCTION_TAG, ObjectSlots.class, null);
    }

    @Override
    public void printObjectOnAvoidingIndent(@NotNull AvailObject self, @NotNull StringBuilder builder, @NotNull IdentityHashMap<A_BasicObject, Void> recursionMap, int indent) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(recursionMap, (String)"recursionMap");
        A_Phrase phrase = A_RawFunction.Companion.getOriginatingPhrase(self.code());
        if (phrase.isNil()) {
            phrase = L1Decompiler.Companion.decompile(self.code());
        }
        phrase.printOnAvoidingIndent(builder, recursionMap, indent + 1);
    }

    @Override
    @NotNull
    public A_RawFunction o_Code(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return self.get(ObjectSlots.CODE);
    }

    @Override
    @NotNull
    public AvailObjectFieldHelper[] o_DescribeForDebugger(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        List fields = ArraysKt.toMutableList((Object[])super.o_DescribeForDebugger(self));
        AvailObject code = self.get(ObjectSlots.CODE);
        A_Tuple allDeclarationNames = A_RawFunction.Companion.getDeclarationNames(code);
        A_Tuple outerNames = A_Tuple.Companion.copyTupleFromToCanDestroy(allDeclarationNames, A_Tuple.Companion.getTupleSize(allDeclarationNames) + 1 - A_RawFunction.Companion.getNumOuters(code), A_Tuple.Companion.getTupleSize(allDeclarationNames), true);
        int i2 = 1;
        int n = A_Tuple.Companion.getTupleSize(outerNames);
        if (i2 <= n) {
            while (true) {
                String outerName = A_String.Companion.asNativeString(A_Tuple.Companion.tupleAt(outerNames, i2));
                fields.add(new AvailObjectFieldHelper(self, AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT, -1, self.outerVarAt(i2), "Outer[" + i2 + ": " + outerName + "]", null, null, 96, null));
                if (i2 == n) break;
                ++i2;
            }
        }
        Collection $this$toTypedArray$iv = fields;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new AvailObjectFieldHelper[0]);
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return another.equalsFunction(self);
    }

    @Override
    public boolean o_EqualsFunction(@NotNull AvailObject self, @NotNull A_Function aFunction) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)aFunction, (String)"aFunction");
            if (!self.code().equals(aFunction.code())) {
                return false;
            }
            Iterable $this$any$iv = (Iterable)new IntRange(1, A_Function.Companion.getNumOuterVars(self));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!(!self.outerVarAt(it).equals(aFunction.outerVarAt(it)))) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        if (!this.isShared()) {
            self.becomeIndirectionTo(aFunction.makeImmutable());
        } else if (!aFunction.descriptor().isShared()) {
            aFunction.becomeIndirectionTo(self.makeImmutable());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int o_Hash(@NotNull AvailObject self) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Iterable iterable = (Iterable)new IntRange(1, A_Function.Companion.getNumOuterVars(self.makeImmutable()));
        int initial$iv = AvailObject.Companion.combine2(self.get(ObjectSlots.CODE).hash(), 327603446);
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        Iterator iterator2 = $this$fold$iv.iterator();
        while (iterator2.hasNext()) {
            void i2;
            int element$iv;
            int n = element$iv = ((IntIterator)iterator2).nextInt();
            int h = accumulator$iv;
            boolean bl = false;
            accumulator$iv = AvailObject.Companion.combine3(h, self.outerVarAt((int)i2).hash(), 958506482);
        }
        return accumulator$iv;
    }

    @Override
    public boolean o_IsFunction(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return true;
    }

    @Override
    @NotNull
    public A_Type o_Kind(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return self.get(ObjectSlots.CODE).functionType();
    }

    @Override
    @NotNull
    public String o_NameForDebugger(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return super.o_NameForDebugger(self) + " /* " + A_String.Companion.asNativeString(A_RawFunction.Companion.getMethodName(self.code())) + " */";
    }

    @Override
    public int o_NumOuterVars(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return self.variableObjectSlotsCount();
    }

    @Override
    public boolean o_OptionallyNilOuterVar(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        if (this.isMutable()) {
            self.set(ObjectSlots.OUTER_VAR_AT_, index2, NilDescriptor.Companion.getNil());
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public AvailObject o_OuterVarAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return self.get(ObjectSlots.OUTER_VAR_AT_, index2);
    }

    @Override
    public void o_OuterVarAtPut(@NotNull AvailObject self, int index2, @NotNull AvailObject value) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        self.set(ObjectSlots.OUTER_VAR_AT_, index2, value);
    }

    @Override
    @ThreadSafe
    @NotNull
    public SerializerOperation o_SerializerOperation(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return A_Function.Companion.getNumOuterVars(self) == 0 ? SerializerOperation.CLEAN_FUNCTION : SerializerOperation.GENERAL_FUNCTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void o_WriteTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        JSONWriter this_$iv = writer;
        boolean $i$f$writeObject = false;
        this_$iv.startObject();
        try {
            JSONWriter this_$iv2;
            JSONWriter $this$o_WriteTo_u24lambda_u246 = this_$iv;
            boolean bl = false;
            JSONWriter jSONWriter = $this$o_WriteTo_u24lambda_u246;
            String key$iv = "kind";
            boolean $i$f$at = false;
            this_$iv2.write(key$iv);
            void $this$o_WriteTo_u24lambda_u246_u24lambda_u242 = this_$iv2;
            boolean bl2 = false;
            $this$o_WriteTo_u24lambda_u246_u24lambda_u242.write("function");
            this_$iv2 = $this$o_WriteTo_u24lambda_u246;
            key$iv = "function implementation";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$o_WriteTo_u24lambda_u246_u24lambda_u243 = this_$iv2;
            boolean bl3 = false;
            self.get(ObjectSlots.CODE).writeTo(writer);
            this_$iv2 = $this$o_WriteTo_u24lambda_u246;
            key$iv = "outers";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$o_WriteTo_u24lambda_u246_u24lambda_u245 = this_$iv2;
            boolean bl4 = false;
            JSONWriter this_$iv3 = $this$o_WriteTo_u24lambda_u246_u24lambda_u245;
            boolean $i$f$writeArray = false;
            this_$iv3.startArray();
            try {
                JSONWriter $this$o_WriteTo_u24lambda_u246_u24lambda_u245_u24lambda_u244 = this_$iv3;
                boolean bl5 = false;
                int i2 = 1;
                int n = self.variableObjectSlotsCount();
                if (i2 <= n) {
                    while (true) {
                        self.get(ObjectSlots.OUTER_VAR_AT_, i2).writeSummaryTo(writer);
                        if (i2 == n) break;
                        ++i2;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv3.endArray();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void o_WriteSummaryTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        JSONWriter this_$iv = writer;
        boolean $i$f$writeObject = false;
        this_$iv.startObject();
        try {
            JSONWriter this_$iv2;
            JSONWriter $this$o_WriteSummaryTo_u24lambda_u2411 = this_$iv;
            boolean bl = false;
            JSONWriter jSONWriter = $this$o_WriteSummaryTo_u24lambda_u2411;
            String key$iv = "kind";
            boolean $i$f$at = false;
            this_$iv2.write(key$iv);
            void $this$o_WriteSummaryTo_u24lambda_u2411_u24lambda_u247 = this_$iv2;
            boolean bl2 = false;
            $this$o_WriteSummaryTo_u24lambda_u2411_u24lambda_u247.write("function");
            this_$iv2 = $this$o_WriteSummaryTo_u24lambda_u2411;
            key$iv = "function implementation";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$o_WriteSummaryTo_u24lambda_u2411_u24lambda_u248 = this_$iv2;
            boolean bl3 = false;
            self.get(ObjectSlots.CODE).writeSummaryTo(writer);
            this_$iv2 = $this$o_WriteSummaryTo_u24lambda_u2411;
            key$iv = "outers";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$o_WriteSummaryTo_u24lambda_u2411_u24lambda_u2410 = this_$iv2;
            boolean bl4 = false;
            JSONWriter this_$iv3 = $this$o_WriteSummaryTo_u24lambda_u2411_u24lambda_u2410;
            boolean $i$f$writeArray = false;
            this_$iv3.startArray();
            try {
                JSONWriter $this$o_WriteSummaryTo_u24lambda_u2411_u24lambda_u2410_u24lambda_u249 = this_$iv3;
                boolean bl5 = false;
                int i2 = 1;
                int n = self.variableObjectSlotsCount();
                if (i2 <= n) {
                    while (true) {
                        self.get(ObjectSlots.OUTER_VAR_AT_, i2).writeSummaryTo(writer);
                        if (i2 == n) break;
                        ++i2;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv3.endArray();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endObject();
        }
    }

    @Override
    @NotNull
    public FunctionDescriptor mutable() {
        return mutable;
    }

    @Override
    @NotNull
    public FunctionDescriptor immutable() {
        return immutable;
    }

    @Override
    @NotNull
    public FunctionDescriptor shared() {
        return shared;
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final AvailObject createExceptOuters(@NotNull A_RawFunction code, int outersCount) {
        return Companion.createExceptOuters(code, outersCount);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final AvailObject createWithOuters1(@NotNull A_RawFunction code, @NotNull AvailObject outer1) {
        return Companion.createWithOuters1(code, outer1);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final AvailObject createWithOuters2(@NotNull A_RawFunction code, @NotNull AvailObject outer1, @NotNull AvailObject outer2) {
        return Companion.createWithOuters2(code, outer1, outer2);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final AvailObject createWithOuters3(@NotNull A_RawFunction code, @NotNull AvailObject outer1, @NotNull AvailObject outer2, @NotNull AvailObject outer3) {
        return Companion.createWithOuters3(code, outer1, outer2, outer3);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final AvailObject createWithOuters4(@NotNull A_RawFunction code, @NotNull AvailObject outer1, @NotNull AvailObject outer2, @NotNull AvailObject outer3, @NotNull AvailObject outer4) {
        return Companion.createWithOuters4(code, outer1, outer2, outer3, outer4);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final AvailObject createWithOuters5(@NotNull A_RawFunction code, @NotNull AvailObject outer1, @NotNull AvailObject outer2, @NotNull AvailObject outer3, @NotNull AvailObject outer4, @NotNull AvailObject outer5) {
        return Companion.createWithOuters5(code, outer1, outer2, outer3, outer4, outer5);
    }

    static {
        Class[] classArray = new Class[2];
        classArray[0] = A_RawFunction.class;
        Intrinsics.checkNotNull(Integer.TYPE);
        createExceptOutersMethod = CheckedMethod.Companion.staticMethod(FunctionDescriptor.class, "createExceptOuters", AvailObject.class, classArray);
        classArray = new Class[]{A_RawFunction.class, AvailObject.class};
        createWithOuters1Method = CheckedMethod.Companion.staticMethod(FunctionDescriptor.class, "createWithOuters1", AvailObject.class, classArray);
        classArray = new Class[]{A_RawFunction.class, AvailObject.class, AvailObject.class};
        createWithOuters2Method = CheckedMethod.Companion.staticMethod(FunctionDescriptor.class, "createWithOuters2", AvailObject.class, classArray);
        classArray = new Class[]{A_RawFunction.class, AvailObject.class, AvailObject.class, AvailObject.class};
        createWithOuters3Method = CheckedMethod.Companion.staticMethod(FunctionDescriptor.class, "createWithOuters3", AvailObject.class, classArray);
        classArray = new Class[]{A_RawFunction.class, AvailObject.class, AvailObject.class, AvailObject.class, AvailObject.class};
        createWithOuters4Method = CheckedMethod.Companion.staticMethod(FunctionDescriptor.class, "createWithOuters4", AvailObject.class, classArray);
        classArray = new Class[]{A_RawFunction.class, AvailObject.class, AvailObject.class, AvailObject.class, AvailObject.class, AvailObject.class};
        createWithOuters5Method = CheckedMethod.Companion.staticMethod(FunctionDescriptor.class, "createWithOuters5", AvailObject.class, classArray);
        classArray = new Class[1];
        Intrinsics.checkNotNull(Integer.TYPE);
        outerVarAtMethod = CheckedMethod.Companion.instanceMethod(A_Function.class, "outerVarAt", AvailObject.class, classArray);
        Class<Void> clazz = Void.TYPE;
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"TYPE");
        classArray = new Class[2];
        Intrinsics.checkNotNull(Integer.TYPE);
        classArray[1] = AvailObject.class;
        outerVarAtPutMethod = CheckedMethod.Companion.instanceMethod(A_Function.class, "outerVarAtPut", clazz, classArray);
        mutable = new FunctionDescriptor(Mutability.MUTABLE);
        immutable = new FunctionDescriptor(Mutability.IMMUTABLE);
        shared = new FunctionDescriptor(Mutability.SHARED);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J\u0016\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u001e\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\"J\u0016\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u0016\u00103\u001a\u00020$2\u0006\u0010/\u001a\u0002002\u0006\u00104\u001a\u00020$J\u0018\u00105\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u00106\u001a\u00020\u001eH\u0007J \u00107\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u00106\u001a\u00020\u001e2\u0006\u00108\u001a\u00020\u001eH\u0007J(\u00109\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u00106\u001a\u00020\u001e2\u0006\u00108\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020\u001eH\u0007J0\u0010;\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u00106\u001a\u00020\u001e2\u0006\u00108\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020\u001eH\u0007J8\u0010=\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u00106\u001a\u00020\u001e2\u0006\u00108\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020\u001eH\u0007J\u0016\u0010?\u001a\u00020$2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020'R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0006R\u0011\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0006R\u000e\u0010\u001c\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lavail/descriptor/functions/FunctionDescriptor$Companion;", "", "()V", "createExceptOutersMethod", "Lavail/optimizer/jvm/CheckedMethod;", "getCreateExceptOutersMethod", "()Lavail/optimizer/jvm/CheckedMethod;", "createWithOuters1Method", "getCreateWithOuters1Method", "createWithOuters2Method", "getCreateWithOuters2Method", "createWithOuters3Method", "getCreateWithOuters3Method", "createWithOuters4Method", "getCreateWithOuters4Method", "createWithOuters5Method", "getCreateWithOuters5Method", "functionCodeMethod", "getFunctionCodeMethod", "immutable", "Lavail/descriptor/functions/FunctionDescriptor;", "mutable", "getMutable", "()Lavail/descriptor/functions/FunctionDescriptor;", "outerVarAtMethod", "getOuterVarAtMethod", "outerVarAtPutMethod", "getOuterVarAtPutMethod", "shared", "createExceptOuters", "Lavail/descriptor/representation/AvailObject;", "code", "Lavail/descriptor/functions/A_RawFunction;", "outersCount", "", "createFunction", "Lavail/descriptor/functions/A_Function;", "Lavail/descriptor/representation/A_BasicObject;", "copiedTuple", "Lavail/descriptor/tuples/A_Tuple;", "createFunctionForPhrase", "phrase", "Lavail/descriptor/phrases/A_Phrase;", "module", "Lavail/descriptor/module/A_Module;", "lineNumber", "createStubToCallMethod", "functionType", "Lavail/descriptor/types/A_Type;", "atom", "Lavail/descriptor/atoms/A_Atom;", "createStubWithSignature", "function", "createWithOuters1", "outer1", "createWithOuters2", "outer2", "createWithOuters3", "outer3", "createWithOuters4", "outer4", "createWithOuters5", "outer5", "newCrashFunction", "messageString", "", "paramTypes", "avail"})
    @SourceDebugExtension(value={"SMAP\nFunctionDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionDescriptor.kt\navail/descriptor/functions/FunctionDescriptor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 AbstractDescriptor.kt\navail/descriptor/representation/AbstractDescriptor\n*L\n1#1,762:1\n1549#2:763\n1620#2,3:764\n1747#2,3:770\n1549#2:773\n1620#2,3:774\n37#3,2:767\n37#3,2:777\n1#4:769\n575#5:779\n575#5:780\n*S KotlinDebug\n*F\n+ 1 FunctionDescriptor.kt\navail/descriptor/functions/FunctionDescriptor$Companion\n*L\n328#1:763\n328#1:764,3\n383#1:770,3\n391#1:773\n391#1:774,3\n331#1:767,2\n394#1:777,2\n427#1:779\n455#1:780\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CheckedMethod getFunctionCodeMethod() {
            return functionCodeMethod;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final A_Function createStubWithSignature(@NotNull A_Type functionType, @NotNull A_Function function) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)functionType, (String)"functionType");
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            A_Type argTypes2 = A_Type.Companion.getArgsTupleType(functionType);
            int numArgs = A_Number.Companion.getExtractInt(A_Type.Companion.getLowerBound(A_Type.Companion.getSizeRange(argTypes2)));
            Iterable $this$map$iv = (Iterable)new IntRange(1, numArgs);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Object object = $this$mapTo$iv$iv.iterator();
            while (object.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)object).nextInt();
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(A_Type.Companion.typeAtIndex(argTypes2, (int)it));
            }
            List argTypesList = (List)destination$iv$iv;
            A_Type functionReturnType = A_Type.Companion.getReturnType(functionType);
            L1InstructionWriter $this$createStubWithSignature_u24lambda_u241 = new L1InstructionWriter(NilDescriptor.Companion.getNil(), 0, NilDescriptor.Companion.getNil());
            boolean bl = false;
            Collection $this$toTypedArray$iv = argTypesList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] bl2 = thisCollection$iv.toArray(new A_Type[0]);
            $this$createStubWithSignature_u24lambda_u241.argumentTypes(Arrays.copyOf(bl2, bl2.length));
            $this$createStubWithSignature_u24lambda_u241.setReturnType(functionReturnType);
            $this$createStubWithSignature_u24lambda_u241.setReturnTypeIfPrimitiveFails(functionReturnType);
            bl2 = new int[1];
            bl2[0] = (A_Type)$this$createStubWithSignature_u24lambda_u241.addLiteral(function);
            $this$createStubWithSignature_u24lambda_u241.write(0, L1Operation.L1_doPushLiteral, (int[])bl2);
            int i2 = 1;
            if (i2 <= numArgs) {
                while (true) {
                    object = new int[1];
                    object[0] = i2;
                    $this$createStubWithSignature_u24lambda_u241.write(0, L1Operation.L1_doPushLastLocal, (int[])object);
                    if (i2 == numArgs) break;
                    ++i2;
                }
            }
            int[] nArray = new int[]{numArgs};
            $this$createStubWithSignature_u24lambda_u241.write(0, L1Operation.L1_doMakeTuple, nArray);
            nArray = new int[]{$this$createStubWithSignature_u24lambda_u241.addLiteral(MethodDescriptor.SpecialMethodAtom.APPLY.getBundle()), $this$createStubWithSignature_u24lambda_u241.addLiteral(functionReturnType)};
            $this$createStubWithSignature_u24lambda_u241.write(0, L1Operation.L1_doCall, nArray);
            AvailObject code = $this$createStubWithSignature_u24lambda_u241.compiledCode();
            A_Function newFunction = this.createFunction(code, TupleDescriptor.Companion.getEmptyTuple());
            newFunction.makeImmutable();
            return newFunction;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final A_Function createStubToCallMethod(@NotNull A_Type functionType, @NotNull A_Atom atom) {
            void $this$mapTo$iv$iv;
            boolean ok;
            Iterable<AvailObject> it;
            A_Type argTypes2;
            A_Bundle bundle;
            block8: {
                Intrinsics.checkNotNullParameter((Object)functionType, (String)"functionType");
                Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
                bundle = A_Atom.Companion.getBundleOrNil(atom);
                if (!bundle.getNotNil()) {
                    boolean $i$a$-require-FunctionDescriptor$Companion$createStubToCallMethod$32 = false;
                    String $i$a$-require-FunctionDescriptor$Companion$createStubToCallMethod$32 = "Atom to invoke has no method";
                    throw new IllegalArgumentException($i$a$-require-FunctionDescriptor$Companion$createStubToCallMethod$32.toString());
                }
                A_Method method = A_Bundle.Companion.getBundleMethod(bundle);
                argTypes2 = A_Type.Companion.getArgsTupleType(functionType);
                Iterable $this$any$iv = A_Method.Companion.getDefinitionsTuple(method);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (AvailObject)element$iv;
                        boolean bl = false;
                        if (!A_Type.Companion.isSubtypeOf(A_Sendable.Companion.bodySignature((A_Sendable)((Object)it)), functionType)) continue;
                        v0 = true;
                        break block8;
                    }
                    v0 = ok = false;
                }
            }
            if (!ok) {
                boolean $i$a$-require-FunctionDescriptor$Companion$createStubToCallMethod$42 = false;
                String $i$a$-require-FunctionDescriptor$Companion$createStubToCallMethod$42 = "Function signature is not strong enough to call method safely";
                throw new IllegalArgumentException($i$a$-require-FunctionDescriptor$Companion$createStubToCallMethod$42.toString());
            }
            int numArgs = A_Number.Companion.getExtractInt(A_Type.Companion.getLowerBound(A_Type.Companion.getSizeRange(argTypes2)));
            Iterable $this$map$iv = (Iterable)new IntRange(1, numArgs);
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it2;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(A_Type.Companion.typeAtIndex(argTypes2, (int)it2));
            }
            List argTypesList = (List)destination$iv$iv;
            A_Type functionReturnType = A_Type.Companion.getReturnType(functionType);
            L1InstructionWriter $this$createStubToCallMethod_u24lambda_u246 = new L1InstructionWriter(NilDescriptor.Companion.getNil(), 0, NilDescriptor.Companion.getNil());
            boolean bl = false;
            Collection $this$toTypedArray$iv = argTypesList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            A_Type[] it2 = thisCollection$iv.toArray(new A_Type[0]);
            $this$createStubToCallMethod_u24lambda_u246.argumentTypes(Arrays.copyOf(it2, it2.length));
            $this$createStubToCallMethod_u24lambda_u246.setReturnType(functionReturnType);
            $this$createStubToCallMethod_u24lambda_u246.setReturnTypeIfPrimitiveFails(functionReturnType);
            int i2 = 1;
            if (i2 <= numArgs) {
                do {
                    int[] nArray = new int[]{++i2};
                    $this$createStubToCallMethod_u24lambda_u246.write(0, L1Operation.L1_doPushLastLocal, nArray);
                } while (i2 != numArgs);
            }
            int[] nArray = new int[]{$this$createStubToCallMethod_u24lambda_u246.addLiteral(bundle), $this$createStubToCallMethod_u24lambda_u246.addLiteral(functionReturnType)};
            $this$createStubToCallMethod_u24lambda_u246.write(0, L1Operation.L1_doCall, nArray);
            return Companion.createFunction($this$createStubToCallMethod_u24lambda_u246.compiledCode(), TupleDescriptor.Companion.getEmptyTuple()).makeImmutable();
        }

        @NotNull
        public final A_Function createFunction(@NotNull A_BasicObject code, @NotNull A_Tuple copiedTuple) {
            AvailObject availObject;
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)copiedTuple, (String)"copiedTuple");
            int copiedSize = A_Tuple.Companion.getTupleSize(copiedTuple);
            AbstractDescriptor this_$iv = this.getMutable();
            boolean $i$f$create = false;
            AvailObject $this$createFunction_u24lambda_u247 = availObject = AvailObject.Companion.newIndexedDescriptor(copiedSize, this_$iv);
            boolean bl = false;
            $this$createFunction_u24lambda_u247.setSlot(ObjectSlots.CODE, code);
            if (copiedSize > 0) {
                $this$createFunction_u24lambda_u247.setSlotsFromTuple(ObjectSlots.OUTER_VAR_AT_, 1, copiedTuple, 1, copiedSize);
            }
            return availObject;
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final AvailObject createExceptOuters(@NotNull A_RawFunction code, int outersCount) {
            AvailObject availObject;
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            AbstractDescriptor this_$iv = this.getMutable();
            boolean $i$f$create = false;
            AvailObject $this$createExceptOuters_u24lambda_u248 = availObject = AvailObject.Companion.newIndexedDescriptor(outersCount, this_$iv);
            boolean bl = false;
            $this$createExceptOuters_u24lambda_u248.setSlot(ObjectSlots.CODE, code);
            return availObject;
        }

        @NotNull
        public final CheckedMethod getCreateExceptOutersMethod() {
            return createExceptOutersMethod;
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final AvailObject createWithOuters1(@NotNull A_RawFunction code, @NotNull AvailObject outer1) {
            AvailObject availObject;
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)outer1, (String)"outer1");
            AvailObject $this$createWithOuters1_u24lambda_u249 = availObject = this.createExceptOuters(code, 1);
            boolean bl = false;
            $this$createWithOuters1_u24lambda_u249.setSlot(ObjectSlots.OUTER_VAR_AT_, 1, outer1);
            return availObject;
        }

        @NotNull
        public final CheckedMethod getCreateWithOuters1Method() {
            return createWithOuters1Method;
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final AvailObject createWithOuters2(@NotNull A_RawFunction code, @NotNull AvailObject outer1, @NotNull AvailObject outer2) {
            AvailObject availObject;
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)outer1, (String)"outer1");
            Intrinsics.checkNotNullParameter((Object)outer2, (String)"outer2");
            AvailObject $this$createWithOuters2_u24lambda_u2410 = availObject = this.createExceptOuters(code, 2);
            boolean bl = false;
            $this$createWithOuters2_u24lambda_u2410.setSlot(ObjectSlots.OUTER_VAR_AT_, 1, outer1);
            $this$createWithOuters2_u24lambda_u2410.setSlot(ObjectSlots.OUTER_VAR_AT_, 2, outer2);
            return availObject;
        }

        @NotNull
        public final CheckedMethod getCreateWithOuters2Method() {
            return createWithOuters2Method;
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final AvailObject createWithOuters3(@NotNull A_RawFunction code, @NotNull AvailObject outer1, @NotNull AvailObject outer2, @NotNull AvailObject outer3) {
            AvailObject availObject;
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)outer1, (String)"outer1");
            Intrinsics.checkNotNullParameter((Object)outer2, (String)"outer2");
            Intrinsics.checkNotNullParameter((Object)outer3, (String)"outer3");
            AvailObject $this$createWithOuters3_u24lambda_u2411 = availObject = this.createExceptOuters(code, 3);
            boolean bl = false;
            $this$createWithOuters3_u24lambda_u2411.setSlot(ObjectSlots.OUTER_VAR_AT_, 1, outer1);
            $this$createWithOuters3_u24lambda_u2411.setSlot(ObjectSlots.OUTER_VAR_AT_, 2, outer2);
            $this$createWithOuters3_u24lambda_u2411.setSlot(ObjectSlots.OUTER_VAR_AT_, 3, outer3);
            return availObject;
        }

        @NotNull
        public final CheckedMethod getCreateWithOuters3Method() {
            return createWithOuters3Method;
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final AvailObject createWithOuters4(@NotNull A_RawFunction code, @NotNull AvailObject outer1, @NotNull AvailObject outer2, @NotNull AvailObject outer3, @NotNull AvailObject outer4) {
            AvailObject availObject;
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)outer1, (String)"outer1");
            Intrinsics.checkNotNullParameter((Object)outer2, (String)"outer2");
            Intrinsics.checkNotNullParameter((Object)outer3, (String)"outer3");
            Intrinsics.checkNotNullParameter((Object)outer4, (String)"outer4");
            AvailObject $this$createWithOuters4_u24lambda_u2412 = availObject = this.createExceptOuters(code, 4);
            boolean bl = false;
            $this$createWithOuters4_u24lambda_u2412.setSlot(ObjectSlots.OUTER_VAR_AT_, 1, outer1);
            $this$createWithOuters4_u24lambda_u2412.setSlot(ObjectSlots.OUTER_VAR_AT_, 2, outer2);
            $this$createWithOuters4_u24lambda_u2412.setSlot(ObjectSlots.OUTER_VAR_AT_, 3, outer3);
            $this$createWithOuters4_u24lambda_u2412.setSlot(ObjectSlots.OUTER_VAR_AT_, 4, outer4);
            return availObject;
        }

        @NotNull
        public final CheckedMethod getCreateWithOuters4Method() {
            return createWithOuters4Method;
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final AvailObject createWithOuters5(@NotNull A_RawFunction code, @NotNull AvailObject outer1, @NotNull AvailObject outer2, @NotNull AvailObject outer3, @NotNull AvailObject outer4, @NotNull AvailObject outer5) {
            AvailObject availObject;
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)outer1, (String)"outer1");
            Intrinsics.checkNotNullParameter((Object)outer2, (String)"outer2");
            Intrinsics.checkNotNullParameter((Object)outer3, (String)"outer3");
            Intrinsics.checkNotNullParameter((Object)outer4, (String)"outer4");
            Intrinsics.checkNotNullParameter((Object)outer5, (String)"outer5");
            AvailObject $this$createWithOuters5_u24lambda_u2413 = availObject = this.createExceptOuters(code, 5);
            boolean bl = false;
            $this$createWithOuters5_u24lambda_u2413.setSlot(ObjectSlots.OUTER_VAR_AT_, 1, outer1);
            $this$createWithOuters5_u24lambda_u2413.setSlot(ObjectSlots.OUTER_VAR_AT_, 2, outer2);
            $this$createWithOuters5_u24lambda_u2413.setSlot(ObjectSlots.OUTER_VAR_AT_, 3, outer3);
            $this$createWithOuters5_u24lambda_u2413.setSlot(ObjectSlots.OUTER_VAR_AT_, 4, outer4);
            $this$createWithOuters5_u24lambda_u2413.setSlot(ObjectSlots.OUTER_VAR_AT_, 5, outer5);
            return availObject;
        }

        @NotNull
        public final CheckedMethod getCreateWithOuters5Method() {
            return createWithOuters5Method;
        }

        @NotNull
        public final CheckedMethod getOuterVarAtMethod() {
            return outerVarAtMethod;
        }

        @NotNull
        public final CheckedMethod getOuterVarAtPutMethod() {
            return outerVarAtPutMethod;
        }

        @NotNull
        public final A_Function createFunctionForPhrase(@NotNull A_Phrase phrase, @NotNull A_Module module, int lineNumber) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)phrase, (String)"phrase");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            A_Phrase block = BlockPhraseDescriptor.Companion.newBlockNode(TupleDescriptor.Companion.getEmptyTuple(), null, ObjectTupleDescriptor.Companion.tuple(phrase), PrimitiveTypeDescriptor.Types.TOP.getO(), SetDescriptor.Companion.getEmptySet(), lineNumber);
            BlockPhraseDescriptor.Companion.recursivelyValidate(block);
            A_RawFunction compiledBlock = A_Phrase.Companion.generateInModule(block, module);
            boolean bl2 = bl = A_RawFunction.Companion.getNumOuters(compiledBlock) == 0;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return this.createFunction(compiledBlock, TupleDescriptor.Companion.getEmptyTuple()).makeImmutable();
        }

        @NotNull
        public final A_Function newCrashFunction(@NotNull String messageString, @NotNull A_Tuple paramTypes) {
            Intrinsics.checkNotNullParameter((Object)messageString, (String)"messageString");
            Intrinsics.checkNotNullParameter((Object)paramTypes, (String)"paramTypes");
            L1InstructionWriter $this$newCrashFunction_u24lambda_u2414 = new L1InstructionWriter(NilDescriptor.Companion.getNil(), 0, NilDescriptor.Companion.getNil());
            boolean bl = false;
            $this$newCrashFunction_u24lambda_u2414.argumentTypesTuple(paramTypes);
            $this$newCrashFunction_u24lambda_u2414.setReturnType(BottomTypeDescriptor.Companion.getBottom());
            $this$newCrashFunction_u24lambda_u2414.setReturnTypeIfPrimitiveFails(BottomTypeDescriptor.Companion.getBottom());
            int[] nArray = new int[]{$this$newCrashFunction_u24lambda_u2414.addLiteral(StringDescriptor.Companion.stringFrom(messageString))};
            $this$newCrashFunction_u24lambda_u2414.write(0, L1Operation.L1_doPushLiteral, nArray);
            int numArgs = A_Tuple.Companion.getTupleSize(paramTypes);
            int i22 = 1;
            if (i22 <= numArgs) {
                do {
                    int[] nArray2 = new int[]{++i22};
                    $this$newCrashFunction_u24lambda_u2414.write(0, L1Operation.L1_doPushLastLocal, nArray2);
                } while (i22 != numArgs);
            }
            int[] i22 = new int[]{numArgs + 1};
            $this$newCrashFunction_u24lambda_u2414.write(0, L1Operation.L1_doMakeTuple, i22);
            i22 = new int[]{$this$newCrashFunction_u24lambda_u2414.addLiteral(MethodDescriptor.SpecialMethodAtom.CRASH.getBundle()), $this$newCrashFunction_u24lambda_u2414.addLiteral(BottomTypeDescriptor.Companion.getBottom())};
            $this$newCrashFunction_u24lambda_u2414.write(0, L1Operation.L1_doCall, i22);
            A_RawFunction code = $this$newCrashFunction_u24lambda_u2414.compiledCode();
            A_RawFunction.Companion.setMethodName(code, StringDescriptor.Companion.stringFrom("VM crash function: " + messageString));
            return Companion.createFunction(code, TupleDescriptor.Companion.getEmptyTuple()).makeShared();
        }

        @NotNull
        public final FunctionDescriptor getMutable() {
            return mutable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lavail/descriptor/functions/FunctionDescriptor$ObjectSlots;", "", "Lavail/descriptor/representation/ObjectSlotsEnum;", "(Ljava/lang/String;I)V", "CODE", "OUTER_VAR_AT_", "avail"})
    public static final class ObjectSlots
    extends Enum<ObjectSlots>
    implements ObjectSlotsEnum {
        public static final /* enum */ ObjectSlots CODE = new ObjectSlots();
        @HideFieldInDebugger
        public static final /* enum */ ObjectSlots OUTER_VAR_AT_ = new ObjectSlots();
        private static final /* synthetic */ ObjectSlots[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ObjectSlots[] values() {
            return (ObjectSlots[])$VALUES.clone();
        }

        public static ObjectSlots valueOf(String value) {
            return Enum.valueOf(ObjectSlots.class, value);
        }

        @NotNull
        public static EnumEntries<ObjectSlots> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = objectSlotsArray = new ObjectSlots[]{ObjectSlots.CODE, ObjectSlots.OUTER_VAR_AT_};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

