/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.tuples;

import avail.annotations.HideFieldInDebugger;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.BitField;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.SubrangeTupleDescriptor;
import avail.descriptor.tuples.TreeTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000 @2\u00020\u0001:\u0003@ABB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0000H\u0016J\b\u0010\u0006\u001a\u00020\u0000H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J0\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J0\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J0\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J0\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J0\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J \u0010\u001f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0010H\u0016J \u0010\"\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010#\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010$\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010%\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010&\u001a\u00020\fH\u0016J\u0018\u0010'\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010(\u001a\u00020\bH\u0016J(\u0010)\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0010H\u0016J(\u0010-\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0010H\u0016J(\u0010.\u001a\u00020/2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u00102\u0006\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u00103\u001a\u00020\u0010H\u0016J(\u00104\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u00103\u001a\u00020\u00102\u0006\u00105\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u00106\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u00103\u001a\u00020\u0010H\u0016J(\u00107\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u00102\u0006\u00108\u001a\u000209H\u0016J\u0018\u0010:\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u00103\u001a\u00020\u0010H\u0016J\u0018\u0010;\u001a\u00020<2\u0006\u0010\t\u001a\u00020\n2\u0006\u00103\u001a\u00020\u0010H\u0016J\u0010\u0010=\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010>\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010?\u001a\u00020\u0000H\u0016\u00a8\u0006C"}, d2={"Lavail/descriptor/tuples/SubrangeTupleDescriptor;", "Lavail/descriptor/tuples/TupleDescriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "(Lavail/descriptor/representation/Mutability;)V", "immutable", "mutable", "o_AppendCanDestroy", "Lavail/descriptor/tuples/A_Tuple;", "self", "Lavail/descriptor/representation/AvailObject;", "newElement", "Lavail/descriptor/representation/A_BasicObject;", "canDestroy", "", "o_BitsPerEntry", "", "o_CompareFromToWithByteStringStartingAt", "startIndex1", "endIndex1", "aByteString", "Lavail/descriptor/tuples/A_String;", "startIndex2", "o_CompareFromToWithByteTupleStartingAt", "aByteTuple", "o_CompareFromToWithNybbleTupleStartingAt", "aNybbleTuple", "o_CompareFromToWithObjectTupleStartingAt", "anObjectTuple", "o_CompareFromToWithStartingAt", "anotherObject", "o_ComputeHashFromTo", "start", "end", "o_ConcatenateWith", "otherTuple", "o_CopyTupleFromToCanDestroy", "o_Equals", "another", "o_EqualsAnyTuple", "aTuple", "o_FirstIndexOf", "value", "startIndex", "endIndex", "o_LastIndexOf", "o_TransferIntoByteBuffer", "", "outputByteBuffer", "Ljava/nio/ByteBuffer;", "o_TupleAt", "index", "o_TupleAtPuttingCanDestroy", "newValueObject", "o_TupleCodePointAt", "o_TupleElementsInRangeAreInstancesOf", "type", "Lavail/descriptor/types/A_Type;", "o_TupleIntAt", "o_TupleLongAt", "", "o_TupleReverse", "o_TupleSize", "shared", "Companion", "IntegerSlots", "ObjectSlots", "avail"})
@SourceDebugExtension(value={"SMAP\nSubrangeTupleDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubrangeTupleDescriptor.kt\navail/descriptor/tuples/SubrangeTupleDescriptor\n+ 2 AbstractDescriptor.kt\navail/descriptor/representation/AbstractDescriptor\n*L\n1#1,600:1\n572#2,4:601\n*S KotlinDebug\n*F\n+ 1 SubrangeTupleDescriptor.kt\navail/descriptor/tuples/SubrangeTupleDescriptor\n*L\n529#1:601,4\n*E\n"})
public final class SubrangeTupleDescriptor
extends TupleDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int minSize = 10;
    @NotNull
    private static final SubrangeTupleDescriptor mutable = new SubrangeTupleDescriptor(Mutability.MUTABLE);
    @NotNull
    private static final SubrangeTupleDescriptor immutable = new SubrangeTupleDescriptor(Mutability.IMMUTABLE);
    @NotNull
    private static final SubrangeTupleDescriptor shared = new SubrangeTupleDescriptor(Mutability.SHARED);

    private SubrangeTupleDescriptor(Mutability mutability) {
        super(mutability, ObjectSlots.class, IntegerSlots.class);
    }

    @Override
    @NotNull
    public A_Tuple o_AppendCanDestroy(@NotNull AvailObject self, @NotNull A_BasicObject newElement, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
        int startIndex = self.get(IntegerSlots.Companion.getSTART_INDEX());
        int originalSize = self.get(IntegerSlots.Companion.getSIZE());
        int endIndex = startIndex + originalSize - 1;
        AvailObject basisTuple = self.get(ObjectSlots.BASIS_TUPLE);
        if (endIndex < A_Tuple.Companion.getTupleSize(basisTuple) && A_Tuple.Companion.tupleAt(basisTuple, endIndex).equals(newElement)) {
            if (canDestroy && this.isMutable()) {
                self.set(IntegerSlots.Companion.getSIZE(), originalSize + 1);
                self.set(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
                return self;
            }
            basisTuple.makeImmutable();
            return Companion.createSubrange(basisTuple, startIndex, originalSize + 1);
        }
        A_Tuple singleton2 = ObjectTupleDescriptor.Companion.tuple(newElement);
        return A_Tuple.Companion.concatenateWith(self, singleton2, canDestroy);
    }

    @Override
    public int o_BitsPerEntry(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return 63;
    }

    @Override
    public boolean o_CompareFromToWithByteStringStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_String aByteString, int startIndex2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aByteString, (String)"aByteString");
        return this.o_CompareFromToWithStartingAt(self, startIndex1, endIndex1, aByteString, startIndex2);
    }

    @Override
    public boolean o_CompareFromToWithByteTupleStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple aByteTuple, int startIndex2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aByteTuple, (String)"aByteTuple");
        return this.o_CompareFromToWithStartingAt(self, startIndex1, endIndex1, aByteTuple, startIndex2);
    }

    @Override
    public boolean o_CompareFromToWithNybbleTupleStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple aNybbleTuple, int startIndex2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aNybbleTuple, (String)"aNybbleTuple");
        return this.o_CompareFromToWithStartingAt(self, startIndex1, endIndex1, aNybbleTuple, startIndex2);
    }

    @Override
    public boolean o_CompareFromToWithObjectTupleStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple anObjectTuple, int startIndex2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anObjectTuple, (String)"anObjectTuple");
        return this.o_CompareFromToWithStartingAt(self, startIndex1, endIndex1, anObjectTuple, startIndex2);
    }

    @Override
    public boolean o_CompareFromToWithStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple anotherObject, int startIndex2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anotherObject, (String)"anotherObject");
        if (self.sameAddressAs(anotherObject) && startIndex1 == startIndex2) {
            return true;
        }
        int offset = self.get(IntegerSlots.Companion.getSTART_INDEX());
        if (!A_Tuple.Companion.compareFromToWithStartingAt(self.get(ObjectSlots.BASIS_TUPLE), startIndex1 + offset - 1, endIndex1 + offset - 1, anotherObject, startIndex2)) {
            return false;
        }
        if (startIndex1 == 1 && startIndex2 == 1 && endIndex1 == A_Tuple.Companion.getTupleSize(self) && endIndex1 == A_Tuple.Companion.getTupleSize(anotherObject)) {
            if (!this.isShared()) {
                anotherObject.makeImmutable();
                self.becomeIndirectionTo(anotherObject);
            } else if (!anotherObject.descriptor().isShared()) {
                self.makeImmutable();
                anotherObject.becomeIndirectionTo(self);
            }
        }
        return true;
    }

    @Override
    public int o_ComputeHashFromTo(@NotNull AvailObject self, int start, int end) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        A_Tuple basis = self.get(ObjectSlots.BASIS_TUPLE);
        int size = self.get(IntegerSlots.Companion.getSIZE());
        boolean bl2 = 1 <= start ? start <= size : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = start - 1 <= end ? end <= size : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        int adjustment = self.get(IntegerSlots.Companion.getSTART_INDEX()) - 1;
        return A_Tuple.Companion.computeHashFromTo(basis, start + adjustment, end + adjustment);
    }

    @Override
    @NotNull
    public A_Tuple o_ConcatenateWith(@NotNull AvailObject self, @NotNull A_Tuple otherTuple, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)otherTuple, (String)"otherTuple");
        boolean bl2 = bl = A_Tuple.Companion.getTupleSize(self) > 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (A_Tuple.Companion.getTupleSize(otherTuple) == 0) {
            if (!canDestroy) {
                self.makeImmutable();
            }
            return self;
        }
        if (!canDestroy) {
            self.makeImmutable();
            otherTuple.makeImmutable();
        }
        return A_Tuple.Companion.getTreeTupleLevel(otherTuple) == 0 ? (A_Tuple)TreeTupleDescriptor.Companion.createTwoPartTreeTuple(self, otherTuple, 1, 0) : TreeTupleDescriptor.Companion.concatenateAtLeastOneTree(self, otherTuple, true);
    }

    @Override
    @NotNull
    public A_Tuple o_CopyTupleFromToCanDestroy(@NotNull AvailObject self, int start, int end, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int oldSize = self.get(IntegerSlots.Companion.getSIZE());
        boolean bl2 = bl = (1 <= start ? start <= end + 1 : false) && end <= oldSize;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int newSize = end - start + 1;
        if (newSize == 0) {
            return TupleDescriptor.Companion.getEmptyTuple();
        }
        int oldStartIndex = self.get(IntegerSlots.Companion.getSTART_INDEX());
        if (canDestroy && this.isMutable() && newSize >= 10) {
            self.set(IntegerSlots.Companion.getSTART_INDEX(), oldStartIndex + start - 1);
            self.set(IntegerSlots.Companion.getSIZE(), newSize);
            return self;
        }
        AvailObject basis = self.get(ObjectSlots.BASIS_TUPLE);
        if (!canDestroy) {
            basis.makeImmutable();
        }
        return A_Tuple.Companion.copyTupleFromToCanDestroy(basis, start + oldStartIndex - 1, end + oldStartIndex - 1, canDestroy);
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return another.equalsAnyTuple(self);
    }

    @Override
    public boolean o_EqualsAnyTuple(@NotNull AvailObject self, @NotNull A_Tuple aTuple) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aTuple, (String)"aTuple");
        if (self.sameAddressAs(aTuple)) {
            return true;
        }
        if (A_Tuple.Companion.getTupleSize(self) != A_Tuple.Companion.getTupleSize(aTuple)) {
            return false;
        }
        if (self.hash() != aTuple.hash()) {
            return false;
        }
        int startIndex = self.get(IntegerSlots.Companion.getSTART_INDEX());
        int size = self.get(IntegerSlots.Companion.getSIZE());
        return A_Tuple.Companion.compareFromToWithStartingAt(self.get(ObjectSlots.BASIS_TUPLE), startIndex, startIndex + size - 1, aTuple, 1);
    }

    @Override
    public int o_FirstIndexOf(@NotNull AvailObject self, @NotNull A_BasicObject value, int startIndex, int endIndex) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int size = self.get(IntegerSlots.Companion.getSIZE());
        boolean bl2 = 1 <= startIndex ? startIndex <= size : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = 1 <= endIndex ? endIndex <= size : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        int adjustment = self.get(IntegerSlots.Companion.getSTART_INDEX()) - 1;
        return A_Tuple.Companion.firstIndexOf(self.get(ObjectSlots.BASIS_TUPLE), value, startIndex + adjustment, endIndex + adjustment);
    }

    @Override
    public int o_LastIndexOf(@NotNull AvailObject self, @NotNull A_BasicObject value, int startIndex, int endIndex) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int size = self.get(IntegerSlots.Companion.getSIZE());
        boolean bl2 = 1 <= startIndex ? startIndex <= size : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = 1 <= endIndex ? endIndex <= size : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        int adjustment = self.get(IntegerSlots.Companion.getSTART_INDEX()) - 1;
        return A_Tuple.Companion.firstIndexOf(self.get(ObjectSlots.BASIS_TUPLE), value, startIndex + adjustment, endIndex + adjustment);
    }

    @Override
    public void o_TransferIntoByteBuffer(@NotNull AvailObject self, int startIndex, int endIndex, @NotNull ByteBuffer outputByteBuffer) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)outputByteBuffer, (String)"outputByteBuffer");
        A_Tuple basis = self.get(ObjectSlots.BASIS_TUPLE);
        int size = self.get(IntegerSlots.Companion.getSIZE());
        boolean bl2 = 1 <= startIndex ? startIndex <= size : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = startIndex - 1 <= endIndex ? endIndex <= size : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        int adjustment = self.get(IntegerSlots.Companion.getSTART_INDEX()) - 1;
        A_Tuple.Companion.transferIntoByteBuffer(basis, startIndex + adjustment, endIndex + adjustment, outputByteBuffer);
    }

    @Override
    @NotNull
    public AvailObject o_TupleAt(@NotNull AvailObject self, int index2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        boolean bl2 = 1 <= index2 ? index2 <= self.get(IntegerSlots.Companion.getSIZE()) : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int adjustedIndex = index2 + self.get(IntegerSlots.Companion.getSTART_INDEX()) - 1;
        return A_Tuple.Companion.tupleAt(self.get(ObjectSlots.BASIS_TUPLE), adjustedIndex);
    }

    @Override
    @NotNull
    public A_Tuple o_TupleAtPuttingCanDestroy(@NotNull AvailObject self, int index2, @NotNull A_BasicObject newValueObject, boolean canDestroy) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)newValueObject, (String)"newValueObject");
        int tupleSize = self.get(IntegerSlots.Companion.getSIZE());
        boolean bl5 = 1 <= index2 ? index2 <= tupleSize : (bl4 = false);
        if (_Assertions.ENABLED && !bl4) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int adjustment = self.get(IntegerSlots.Companion.getSTART_INDEX()) - 1;
        AvailObject basis = self.get(ObjectSlots.BASIS_TUPLE).traversed();
        if (!canDestroy) {
            basis.makeImmutable();
        }
        boolean bl6 = bl3 = tupleSize >= 3;
        if (_Assertions.ENABLED && !bl3) {
            boolean $i$a$-assert-SubrangeTupleDescriptor$o_TupleAtPuttingCanDestroy$22 = false;
            String $i$a$-assert-SubrangeTupleDescriptor$o_TupleAtPuttingCanDestroy$22 = "subrange is too small; recursion won't bottom out correctly";
            throw new AssertionError((Object)$i$a$-assert-SubrangeTupleDescriptor$o_TupleAtPuttingCanDestroy$22);
        }
        basis.makeImmutable();
        int start = 1 + adjustment;
        int splitPoint = start + (tupleSize >>> 1);
        A_Tuple leftPart = A_Tuple.Companion.copyTupleFromToCanDestroy(basis, start, splitPoint - 1, false);
        boolean bl7 = bl2 = 1 <= A_Tuple.Companion.getTupleSize(leftPart);
        if (_Assertions.ENABLED && !bl2) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        boolean bl8 = bl2 = A_Tuple.Companion.getTupleSize(leftPart) < tupleSize;
        if (_Assertions.ENABLED && !bl2) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        int end = tupleSize + adjustment;
        A_Tuple rightPart = A_Tuple.Companion.copyTupleFromToCanDestroy(basis, splitPoint, end, false);
        boolean bl9 = bl = 1 <= A_Tuple.Companion.getTupleSize(rightPart);
        if (_Assertions.ENABLED && !bl) {
            String string5 = "Assertion failed";
            throw new AssertionError((Object)string5);
        }
        boolean bl10 = bl = A_Tuple.Companion.getTupleSize(rightPart) < tupleSize;
        if (_Assertions.ENABLED && !bl) {
            String string6 = "Assertion failed";
            throw new AssertionError((Object)string6);
        }
        boolean bl11 = bl = A_Tuple.Companion.getTupleSize(leftPart) + A_Tuple.Companion.getTupleSize(rightPart) == tupleSize;
        if (_Assertions.ENABLED && !bl) {
            String string7 = "Assertion failed";
            throw new AssertionError((Object)string7);
        }
        int adjustedIndex = index2 + adjustment;
        if (adjustedIndex < splitPoint) {
            leftPart = A_Tuple.Companion.tupleAtPuttingCanDestroy(leftPart, index2, newValueObject, true);
        } else {
            rightPart = A_Tuple.Companion.tupleAtPuttingCanDestroy(rightPart, index2 + start - splitPoint, newValueObject, canDestroy);
        }
        return A_Tuple.Companion.concatenateWith(leftPart, rightPart, true);
    }

    @Override
    public int o_TupleCodePointAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return A_Tuple.Companion.tupleCodePointAt(self.get(ObjectSlots.BASIS_TUPLE), index2 + self.get(IntegerSlots.Companion.getSTART_INDEX()) - 1);
    }

    @Override
    public boolean o_TupleElementsInRangeAreInstancesOf(@NotNull AvailObject self, int startIndex, int endIndex, @NotNull A_Type type) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        int offset = self.get(IntegerSlots.Companion.getSTART_INDEX()) - 1;
        return A_Tuple.Companion.tupleElementsInRangeAreInstancesOf(self.get(ObjectSlots.BASIS_TUPLE), startIndex + offset, endIndex + offset, type);
    }

    @Override
    public int o_TupleIntAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return A_Tuple.Companion.tupleIntAt(self.get(ObjectSlots.BASIS_TUPLE), index2 + self.get(IntegerSlots.Companion.getSTART_INDEX()) - 1);
    }

    @Override
    public long o_TupleLongAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return A_Tuple.Companion.tupleLongAt(self.get(ObjectSlots.BASIS_TUPLE), index2 + self.get(IntegerSlots.Companion.getSTART_INDEX()) - 1);
    }

    @Override
    @NotNull
    public A_Tuple o_TupleReverse(@NotNull AvailObject self) {
        AvailObject availObject;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        AbstractDescriptor $this$iv = mutable;
        int indexedSlotCount$iv = 0;
        boolean $i$f$create = false;
        AvailObject $this$o_TupleReverse_u24lambda_u241 = availObject = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, $this$iv);
        boolean bl = false;
        $this$o_TupleReverse_u24lambda_u241.setSlot(ObjectSlots.BASIS_TUPLE, A_Tuple.Companion.tupleReverse(self.get(ObjectSlots.BASIS_TUPLE)));
        $this$o_TupleReverse_u24lambda_u241.setSlot(IntegerSlots.Companion.getSTART_INDEX(), A_Tuple.Companion.getTupleSize(self.get(ObjectSlots.BASIS_TUPLE)) + 2 - (A_Tuple.Companion.getTupleSize(self) + self.get(IntegerSlots.Companion.getSTART_INDEX())));
        $this$o_TupleReverse_u24lambda_u241.setSlot(IntegerSlots.Companion.getSIZE(), A_Tuple.Companion.getTupleSize(self));
        return availObject;
    }

    @Override
    public int o_TupleSize(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return self.get(IntegerSlots.Companion.getSIZE());
    }

    @Override
    @NotNull
    public SubrangeTupleDescriptor mutable() {
        return mutable;
    }

    @Override
    @NotNull
    public SubrangeTupleDescriptor immutable() {
        return immutable;
    }

    @Override
    @NotNull
    public SubrangeTupleDescriptor shared() {
        return shared;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lavail/descriptor/tuples/SubrangeTupleDescriptor$Companion;", "", "()V", "immutable", "Lavail/descriptor/tuples/SubrangeTupleDescriptor;", "minSize", "", "mutable", "getMutable", "()Lavail/descriptor/tuples/SubrangeTupleDescriptor;", "shared", "createSubrange", "Lavail/descriptor/representation/AvailObject;", "basisTuple", "Lavail/descriptor/tuples/A_Tuple;", "startIndex", "size", "avail"})
    @SourceDebugExtension(value={"SMAP\nSubrangeTupleDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubrangeTupleDescriptor.kt\navail/descriptor/tuples/SubrangeTupleDescriptor$Companion\n+ 2 AbstractDescriptor.kt\navail/descriptor/representation/AbstractDescriptor\n*L\n1#1,600:1\n575#2:601\n*S KotlinDebug\n*F\n+ 1 SubrangeTupleDescriptor.kt\navail/descriptor/tuples/SubrangeTupleDescriptor$Companion\n*L\n583#1:601\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AvailObject createSubrange(@NotNull A_Tuple basisTuple, int startIndex, int size) {
            AvailObject availObject;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)basisTuple, (String)"basisTuple");
            boolean bl2 = bl = size >= 10;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            boolean bl3 = bl = size < A_Tuple.Companion.getTupleSize(basisTuple);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            basisTuple.makeImmutable();
            AbstractDescriptor this_$iv = this.getMutable();
            boolean $i$f$create = false;
            AvailObject $this$createSubrange_u24lambda_u240 = availObject = AvailObject.Companion.newIndexedDescriptor(size, this_$iv);
            boolean bl4 = false;
            $this$createSubrange_u24lambda_u240.setSlot(ObjectSlots.BASIS_TUPLE, basisTuple);
            $this$createSubrange_u24lambda_u240.setSlot(IntegerSlots.Companion.getSTART_INDEX(), startIndex);
            $this$createSubrange_u24lambda_u240.setSlot(IntegerSlots.Companion.getSIZE(), size);
            return availObject;
        }

        @NotNull
        public final SubrangeTupleDescriptor getMutable() {
            return mutable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/tuples/SubrangeTupleDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "HASH_AND_MORE", "START_AND_SIZE", "Companion", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final BitField HASH_OR_ZERO;
        @NotNull
        private static final BitField START_INDEX;
        @NotNull
        private static final BitField SIZE;
        @HideFieldInDebugger
        public static final /* enum */ IntegerSlots HASH_AND_MORE;
        public static final /* enum */ IntegerSlots START_AND_SIZE;
        private static final /* synthetic */ IntegerSlots[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        @NotNull
        public static EnumEntries<IntegerSlots> getEntries() {
            return $ENTRIES;
        }

        static {
            boolean bl;
            HASH_AND_MORE = new IntegerSlots();
            START_AND_SIZE = new IntegerSlots();
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.HASH_AND_MORE, IntegerSlots.START_AND_SIZE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            HASH_OR_ZERO = new BitField(HASH_AND_MORE, 0, 32, (Function1<? super Integer, String>)((Function1)Companion.HASH_OR_ZERO.1.INSTANCE));
            START_INDEX = new BitField(START_AND_SIZE, 0, 32, (Function1<? super Integer, String>)((Function1)Companion.START_INDEX.1.INSTANCE));
            SIZE = new BitField(START_AND_SIZE, 32, 32, (Function1<? super Integer, String>)((Function1)Companion.SIZE.1.INSTANCE));
            boolean bl2 = bl = TupleDescriptor.IntegerSlots.HASH_AND_MORE.ordinal() == HASH_AND_MORE.ordinal();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lavail/descriptor/tuples/SubrangeTupleDescriptor$IntegerSlots$Companion;", "", "()V", "HASH_OR_ZERO", "Lavail/descriptor/representation/BitField;", "getHASH_OR_ZERO", "()Lavail/descriptor/representation/BitField;", "SIZE", "getSIZE", "START_INDEX", "getSTART_INDEX", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BitField getHASH_OR_ZERO() {
                return HASH_OR_ZERO;
            }

            @NotNull
            public final BitField getSTART_INDEX() {
                return START_INDEX;
            }

            @NotNull
            public final BitField getSIZE() {
                return SIZE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lavail/descriptor/tuples/SubrangeTupleDescriptor$ObjectSlots;", "", "Lavail/descriptor/representation/ObjectSlotsEnum;", "(Ljava/lang/String;I)V", "BASIS_TUPLE", "avail"})
    public static final class ObjectSlots
    extends Enum<ObjectSlots>
    implements ObjectSlotsEnum {
        public static final /* enum */ ObjectSlots BASIS_TUPLE = new ObjectSlots();
        private static final /* synthetic */ ObjectSlots[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ObjectSlots[] values() {
            return (ObjectSlots[])$VALUES.clone();
        }

        public static ObjectSlots valueOf(String value) {
            return Enum.valueOf(ObjectSlots.class, value);
        }

        @NotNull
        public static EnumEntries<ObjectSlots> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = objectSlotsArray = new ObjectSlots[]{ObjectSlots.BASIS_TUPLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

