/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.tuples;

import avail.annotations.HideFieldInDebugger;
import avail.descriptor.character.A_Character;
import avail.descriptor.character.CharacterDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.AvailObjectRepresentation;
import avail.descriptor.representation.BitField;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ByteStringDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TreeTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.tuples.TwentyOneBitStringDescriptor;
import avail.descriptor.tuples.TwoByteStringDescriptor;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import avail.serialization.SerializerOperation;
import avail.utility.MathExtensionsKt;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin._Assertions;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 ?2\u00020\u0001:\u0002?@B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0000H\u0016J\b\u0010\u0010\u001a\u00020\u0000H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u0018\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J0\u0010\u001d\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J \u0010\u001f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0016J \u0010\"\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010$\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u0014H\u0016J\u0018\u0010'\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\fH\u0016J(\u0010)\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005H\u0016J0\u0010-\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005H\u0016J\u0010\u0010/\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u00100\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005H\u0016J\u001e\u00101\u001a\u0002022\u0006\u0010\r\u001a\u00020\u000e2\f\u00103\u001a\b\u0012\u0002\b\u0003\u0018\u000104H\u0016J\u0010\u00105\u001a\u0002062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u00107\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\u0005H\u0016J(\u00109\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010;\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\u0005H\u0016J\u0010\u0010<\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010=\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010>\u001a\u00020\u0000H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006A"}, d2={"Lavail/descriptor/tuples/TwoByteStringDescriptor;", "Lavail/descriptor/tuples/StringDescriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "unusedShortsOfLastLong", "", "(Lavail/descriptor/representation/Mutability;I)V", "getUnusedShortsOfLastLong", "()I", "setUnusedShortsOfLastLong", "(I)V", "copyAsMutableTwoByteString", "Lavail/descriptor/tuples/A_String;", "self", "Lavail/descriptor/representation/AvailObject;", "immutable", "mutable", "o_AppendCanDestroy", "Lavail/descriptor/tuples/A_Tuple;", "newElement", "Lavail/descriptor/representation/A_BasicObject;", "canDestroy", "", "o_BitsPerEntry", "o_CompareFromToWithStartingAt", "startIndex1", "endIndex1", "anotherObject", "startIndex2", "o_CompareFromToWithTwoByteStringStartingAt", "aTwoByteString", "o_ComputeHashFromTo", "start", "end", "o_ConcatenateWith", "otherTuple", "o_CopyTupleFromToCanDestroy", "o_Equals", "another", "o_EqualsTwoByteString", "aString", "o_FirstIndexOf", "value", "startIndex", "endIndex", "o_FirstIndexOfOr", "otherValue", "o_IsTwoByteString", "o_LastIndexOf", "o_MarshalToJava", "", "classHint", "Ljava/lang/Class;", "o_SerializerOperation", "Lavail/serialization/SerializerOperation;", "o_TupleAt", "index", "o_TupleAtPuttingCanDestroy", "newValueObject", "o_TupleCodePointAt", "o_TupleReverse", "o_TupleSize", "shared", "Companion", "IntegerSlots", "avail"})
@SourceDebugExtension(value={"SMAP\nTwoByteStringDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TwoByteStringDescriptor.kt\navail/descriptor/tuples/TwoByteStringDescriptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,685:1\n1726#2,3:686\n1726#2,3:689\n*S KotlinDebug\n*F\n+ 1 TwoByteStringDescriptor.kt\navail/descriptor/tuples/TwoByteStringDescriptor\n*L\n201#1:686,3\n510#1:689,3\n*E\n"})
public final class TwoByteStringDescriptor
extends StringDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int unusedShortsOfLastLong;
    private static final int maximumCopySize = 32;
    @NotNull
    private static final TwoByteStringDescriptor[] descriptors = new TwoByteStringDescriptor[12];
    @NotNull
    private static final CheckedMethod createUninitializedTwoByteStringMethod;

    private TwoByteStringDescriptor(Mutability mutability, int unusedShortsOfLastLong) {
        super(mutability, null, IntegerSlots.class);
        this.unusedShortsOfLastLong = unusedShortsOfLastLong;
    }

    public final int getUnusedShortsOfLastLong() {
        return this.unusedShortsOfLastLong;
    }

    public final void setUnusedShortsOfLastLong(int n) {
        this.unusedShortsOfLastLong = n;
    }

    @Override
    @NotNull
    public A_Tuple o_AppendCanDestroy(@NotNull AvailObject self, @NotNull A_BasicObject newElement, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
        int originalSize = A_Tuple.Companion.getTupleSize(self);
        if (originalSize >= 32 || !A_Character.Companion.isCharacter((A_Character)newElement)) {
            A_Tuple singleton2 = ObjectTupleDescriptor.Companion.tuple(newElement);
            return A_Tuple.Companion.concatenateWith(self, singleton2, canDestroy);
        }
        int intValue = A_Character.Companion.getCodePoint((A_Character)newElement);
        if ((intValue & 0xFFFF0000) != 0) {
            A_Tuple singleton3 = ObjectTupleDescriptor.Companion.tuple(newElement);
            return A_Tuple.Companion.concatenateWith(self, singleton3, canDestroy);
        }
        int newSize = originalSize + 1;
        if (this.isMutable() && canDestroy && (originalSize & 3) != 0) {
            self.setDescriptor(TwoByteStringDescriptor.Companion.descriptorFor(Mutability.MUTABLE, newSize));
            self.setShortSlot(IntegerSlots.RAW_LONGS_, newSize, intValue);
            self.set(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return self;
        }
        AvailObject result2 = AvailObjectRepresentation.Companion.newLike(TwoByteStringDescriptor.Companion.descriptorFor(Mutability.MUTABLE, newSize), self, 0, (originalSize & 3) == 0 ? 1 : 0);
        result2.setShortSlot(IntegerSlots.RAW_LONGS_, newSize, intValue);
        result2.set(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
        return result2;
    }

    @Override
    public boolean o_CompareFromToWithStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple anotherObject, int startIndex2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anotherObject, (String)"anotherObject");
        return A_Tuple.Companion.compareFromToWithTwoByteStringStartingAt(anotherObject, startIndex2, startIndex2 + endIndex1 - startIndex1, self, startIndex1);
    }

    @Override
    public boolean o_CompareFromToWithTwoByteStringStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_String aTwoByteString, int startIndex2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)aTwoByteString, (String)"aTwoByteString");
            if (self.sameAddressAs(aTwoByteString) && startIndex1 == startIndex2) {
                return true;
            }
            AvailObject strongOtherString = (AvailObject)aTwoByteString;
            int index2 = 0;
            index2 = startIndex2;
            Iterable $this$all$iv = (Iterable)new IntRange(startIndex1, endIndex1);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int index1 = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    int n = index2;
                    index2 = n + 1;
                    if (self.shortSlot(IntegerSlots.RAW_LONGS_, index1) == strongOtherString.shortSlot(IntegerSlots.RAW_LONGS_, n)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return another.equalsTwoByteString(self);
    }

    @Override
    public boolean o_EqualsTwoByteString(@NotNull AvailObject self, @NotNull A_String aString) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aString, (String)"aString");
        if (self.sameAddressAs(aString)) {
            return true;
        }
        if (A_Tuple.Companion.getTupleSize(self) != A_Tuple.Companion.getTupleSize(aString)) {
            return false;
        }
        if (self.hash() != aString.hash()) {
            return false;
        }
        if (!self.intSlotsCompare((AvailObject)aString, IntegerSlots.RAW_LONGS_)) {
            return false;
        }
        if (!this.isShared()) {
            aString.makeImmutable();
            self.becomeIndirectionTo(aString);
        } else if (!aString.descriptor().isShared()) {
            self.makeImmutable();
            aString.becomeIndirectionTo(self);
        }
        return true;
    }

    @Override
    public int o_FirstIndexOf(@NotNull AvailObject self, @NotNull A_BasicObject value, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        A_Character strongValue = (A_Character)value;
        if (!A_Character.Companion.isCharacter(strongValue)) {
            return 0;
        }
        int codePoint = A_Character.Companion.getCodePoint(strongValue);
        if (codePoint > 65535) {
            return 0;
        }
        int n = A_Character.Companion.getCodePoint((A_Character)value);
        long shortReplicated = (long)n * 0x1000100010001L;
        int slotIndex = startIndex + 3 >>> 2;
        int n2 = endIndex + 3 >>> 2;
        if (slotIndex <= n2) {
            while (true) {
                int n3;
                int i2;
                long slot;
                if (MathExtensionsKt.hasZeroShort((slot = self.get(IntegerSlots.RAW_LONGS_, slotIndex)) ^ shortReplicated) && (i2 = Math.max((slotIndex << 2) - 3, startIndex)) <= (n3 = Math.min(slotIndex << 2, endIndex))) {
                    while (true) {
                        if (self.shortSlot(IntegerSlots.RAW_LONGS_, i2) == n) {
                            return i2;
                        }
                        if (i2 == n3) break;
                        ++i2;
                    }
                }
                if (slotIndex == n2) break;
                ++slotIndex;
            }
        }
        return 0;
    }

    @Override
    public int o_FirstIndexOfOr(@NotNull AvailObject self, @NotNull A_BasicObject value, @NotNull A_BasicObject otherValue, int startIndex, int endIndex) {
        int short2;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)otherValue, (String)"otherValue");
        if (!A_Character.Companion.isCharacter((A_Character)value) || A_Character.Companion.getCodePoint((A_Character)value) > 65535) {
            return this.o_FirstIndexOf(self, otherValue, startIndex, endIndex);
        }
        if (!A_Character.Companion.isCharacter((A_Character)otherValue) || A_Character.Companion.getCodePoint((A_Character)value) > 65535) {
            return this.o_FirstIndexOf(self, value, startIndex, endIndex);
        }
        int short1 = A_Character.Companion.getCodePoint((A_Character)value);
        if (short1 == (short2 = A_Character.Companion.getCodePoint((A_Character)otherValue))) {
            return this.o_FirstIndexOf(self, value, startIndex, endIndex);
        }
        long short1Replicated = (long)short1 * 0x1000100010001L;
        long short2Replicated = (long)short2 * 0x1000100010001L;
        int slotIndex = startIndex + 3 >>> 2;
        int n = endIndex + 3 >>> 2;
        if (slotIndex <= n) {
            while (true) {
                int n2;
                int i2;
                long slot;
                if ((MathExtensionsKt.hasZeroShort((slot = self.get(IntegerSlots.RAW_LONGS_, slotIndex)) ^ short1Replicated) || MathExtensionsKt.hasZeroShort(slot ^ short2Replicated)) && (i2 = Math.max((slotIndex << 2) - 3, startIndex)) <= (n2 = Math.min(slotIndex << 2, endIndex))) {
                    while (true) {
                        int code;
                        if ((code = self.shortSlot(IntegerSlots.RAW_LONGS_, i2)) == short1 || code == short2) {
                            return i2;
                        }
                        if (i2 == n2) break;
                        ++i2;
                    }
                }
                if (slotIndex == n) break;
                ++slotIndex;
            }
        }
        return 0;
    }

    @Override
    public boolean o_IsTwoByteString(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return true;
    }

    @Override
    public int o_LastIndexOf(@NotNull AvailObject self, @NotNull A_BasicObject value, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        A_Character strongValue = (A_Character)value;
        if (!A_Character.Companion.isCharacter(strongValue)) {
            return 0;
        }
        int codePoint = A_Character.Companion.getCodePoint(strongValue);
        if (codePoint > 65535) {
            return 0;
        }
        int i2 = startIndex;
        if (endIndex <= i2) {
            while (true) {
                if (A_Tuple.Companion.tupleCodePointAt(self, i2) == codePoint) {
                    return i2;
                }
                if (i2 == endIndex) break;
                --i2;
            }
        }
        return 0;
    }

    @Override
    @NotNull
    public AvailObject o_TupleAt(@NotNull AvailObject self, int index2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        boolean bl2 = bl = index2 >= 1 && index2 <= A_Tuple.Companion.getTupleSize(self);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Character a_Character = CharacterDescriptor.Companion.fromCodePoint(self.shortSlot(IntegerSlots.RAW_LONGS_, index2));
        Intrinsics.checkNotNull((Object)a_Character, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
        return (AvailObject)a_Character;
    }

    @Override
    @NotNull
    public A_Tuple o_TupleAtPuttingCanDestroy(@NotNull AvailObject self, int index2, @NotNull A_BasicObject newValueObject, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)newValueObject, (String)"newValueObject");
        boolean bl2 = bl = index2 >= 1 && index2 <= A_Tuple.Companion.getTupleSize(self);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (A_Character.Companion.isCharacter((A_Character)newValueObject)) {
            int codePoint = A_Character.Companion.getCodePoint((A_Character)newValueObject);
            if (codePoint <= 65535) {
                if (canDestroy && this.isMutable()) {
                    self.setShortSlot(IntegerSlots.RAW_LONGS_, index2, codePoint);
                    self.setHashOrZero(0);
                    return self;
                }
                return A_Tuple.Companion.tupleAtPuttingCanDestroy(AvailObjectRepresentation.Companion.newLike(this.mutable(), self, 0, 0), index2, newValueObject, true);
            }
            A_String copy2 = TwentyOneBitStringDescriptor.Companion.copyAsMutableTwentyOneBitString(self);
            A_Tuple.Companion.tupleAtPuttingCanDestroy(copy2, index2, newValueObject, true);
            return copy2;
        }
        return A_Tuple.Companion.tupleAtPuttingCanDestroy(A_Tuple.Companion.copyAsMutableObjectTuple(self), index2, newValueObject, true);
    }

    @Override
    public int o_TupleCodePointAt(@NotNull AvailObject self, int index2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        boolean bl2 = bl = index2 >= 1 && index2 <= A_Tuple.Companion.getTupleSize(self);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return self.shortSlot(IntegerSlots.RAW_LONGS_, index2);
    }

    @Override
    @NotNull
    public A_Tuple o_TupleReverse(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int size = A_Tuple.Companion.getTupleSize(self);
        return size > 32 ? super.o_TupleReverse(self) : (A_Tuple)Companion.generateTwoByteString(size, (Function1<? super Integer, UShort>)((Function1)new Function1<Integer, UShort>(self, size){
            final /* synthetic */ AvailObject $self;
            final /* synthetic */ int $size;
            {
                this.$self = $self;
                this.$size = $size;
                super(1);
            }

            public final short invoke-BwKQO78(int it) {
                return UShort.constructor-impl((short)((short)this.$self.shortSlot(IntegerSlots.RAW_LONGS_, this.$size + 1 - it)));
            }
        }));
    }

    @Override
    public int o_TupleSize(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return (self.variableIntegerSlotsCount() << 2) - this.unusedShortsOfLastLong;
    }

    @Override
    public int o_BitsPerEntry(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return 16;
    }

    @Override
    public int o_ComputeHashFromTo(@NotNull AvailObject self, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int hash = 0;
        int index2 = end;
        if (start <= index2) {
            while (true) {
                int itemHash = CharacterDescriptor.Companion.computeHashOfCharacterWithCodePoint(self.shortSlot(IntegerSlots.RAW_LONGS_, index2)) ^ 0x71E570A6;
                hash = (hash + itemHash) * 1664525;
                if (index2 == start) break;
                --index2;
            }
        }
        return hash;
    }

    @Override
    @NotNull
    public Object o_MarshalToJava(@NotNull AvailObject self, @Nullable Class<?> classHint) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return A_String.Companion.asNativeString(self);
    }

    @Override
    @NotNull
    public A_Tuple o_ConcatenateWith(@NotNull AvailObject self, @NotNull A_Tuple otherTuple, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)otherTuple, (String)"otherTuple");
        int size1 = A_Tuple.Companion.getTupleSize(self);
        if (size1 == 0) {
            if (!canDestroy) {
                otherTuple.makeImmutable();
            }
            return otherTuple;
        }
        int size2 = A_Tuple.Companion.getTupleSize(otherTuple);
        if (size2 == 0) {
            if (!canDestroy) {
                self.makeImmutable();
            }
            return self;
        }
        int newSize = size1 + size2;
        if (newSize <= 32 && (otherTuple.isTwoByteString() || otherTuple.isByteString())) {
            int newLongCount = newSize + 3 >> 2;
            int deltaSlots = newLongCount - self.variableIntegerSlotsCount();
            AvailObject result2 = null;
            if (canDestroy && this.isMutable() && deltaSlots == 0) {
                result2 = self;
                result2.setDescriptor(TwoByteStringDescriptor.Companion.descriptorFor(Mutability.MUTABLE, newSize));
            } else {
                result2 = AvailObjectRepresentation.Companion.newLike(TwoByteStringDescriptor.Companion.descriptorFor(Mutability.MUTABLE, newSize), self, 0, deltaSlots);
            }
            int dest = size1 + 1;
            int src = 1;
            while (src <= size2) {
                result2.setShortSlot(IntegerSlots.RAW_LONGS_, dest, A_Tuple.Companion.tupleCodePointAt(otherTuple, src));
                ++src;
                ++dest;
            }
            result2.set(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return result2;
        }
        if (!canDestroy) {
            self.makeImmutable();
            otherTuple.makeImmutable();
        }
        return A_Tuple.Companion.getTreeTupleLevel(otherTuple) == 0 ? (A_Tuple)TreeTupleDescriptor.Companion.createTwoPartTreeTuple(self, otherTuple, 1, 0) : TreeTupleDescriptor.Companion.concatenateAtLeastOneTree(self, otherTuple, true);
    }

    @Override
    @NotNull
    public A_Tuple o_CopyTupleFromToCanDestroy(@NotNull AvailObject self, int start, int end, boolean canDestroy) {
        A_Tuple a_Tuple;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int tupleSize = A_Tuple.Companion.getTupleSize(self);
        boolean bl2 = bl = (1 <= start ? start <= end + 1 : false) && end <= tupleSize;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int size = end - start + 1;
        if (size == 0) {
            a_Tuple = TupleDescriptor.Companion.getEmptyTuple();
        } else if (size == tupleSize) {
            a_Tuple = canDestroy ? self : self.makeImmutable();
        } else if (size > 32) {
            a_Tuple = super.o_CopyTupleFromToCanDestroy(self, start, end, canDestroy);
        } else {
            boolean bl3;
            block10: {
                Iterable $this$all$iv = (Iterable)new IntRange(start, end);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    Iterator iterator2 = $this$all$iv.iterator();
                    while (iterator2.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator2).nextInt();
                        boolean bl4 = false;
                        if (self.shortSlot(IntegerSlots.RAW_LONGS_, it) <= 255) continue;
                        bl3 = false;
                        break block10;
                    }
                    bl3 = true;
                }
            }
            a_Tuple = bl3 ? (A_Tuple)ByteStringDescriptor.Companion.generateByteString(size, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(self, start){
                final /* synthetic */ AvailObject $self;
                final /* synthetic */ int $start;
                {
                    this.$self = $self;
                    this.$start = $start;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int it) {
                    return this.$self.shortSlot(IntegerSlots.RAW_LONGS_, it + this.$start - 1);
                }
            })) : (A_Tuple)Companion.generateTwoByteString(size, (Function1<? super Integer, UShort>)((Function1)new Function1<Integer, UShort>(self, start){
                final /* synthetic */ AvailObject $self;
                final /* synthetic */ int $start;
                {
                    this.$self = $self;
                    this.$start = $start;
                    super(1);
                }

                public final short invoke-BwKQO78(int it) {
                    return UShort.constructor-impl((short)((short)this.$self.shortSlot(IntegerSlots.RAW_LONGS_, it + this.$start - 1)));
                }
            }));
        }
        return a_Tuple;
    }

    @Override
    @NotNull
    public SerializerOperation o_SerializerOperation(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int i2 = 1;
        int n = A_Tuple.Companion.getTupleSize(self);
        if (i2 <= n) {
            while (true) {
                if (self.shortSlot(IntegerSlots.RAW_LONGS_, i2) > 255) {
                    return SerializerOperation.SHORT_STRING;
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        return SerializerOperation.BYTE_STRING;
    }

    @Override
    @NotNull
    public TwoByteStringDescriptor mutable() {
        TwoByteStringDescriptor twoByteStringDescriptor = descriptors[(4 - this.unusedShortsOfLastLong & 3) * 3 + Mutability.MUTABLE.ordinal()];
        Intrinsics.checkNotNull((Object)twoByteStringDescriptor);
        return twoByteStringDescriptor;
    }

    @Override
    @NotNull
    public TwoByteStringDescriptor immutable() {
        TwoByteStringDescriptor twoByteStringDescriptor = descriptors[(4 - this.unusedShortsOfLastLong & 3) * 3 + Mutability.IMMUTABLE.ordinal()];
        Intrinsics.checkNotNull((Object)twoByteStringDescriptor);
        return twoByteStringDescriptor;
    }

    @Override
    @NotNull
    public TwoByteStringDescriptor shared() {
        TwoByteStringDescriptor twoByteStringDescriptor = descriptors[(4 - this.unusedShortsOfLastLong & 3) * 3 + Mutability.SHARED.ordinal()];
        Intrinsics.checkNotNull((Object)twoByteStringDescriptor);
        return twoByteStringDescriptor;
    }

    private final A_String copyAsMutableTwoByteString(AvailObject self) {
        return AvailObjectRepresentation.Companion.newLike(this.mutable(), self, 0, 0);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final AvailObject mutableTwoByteStringOfSize(int size) {
        return Companion.mutableTwoByteStringOfSize(size);
    }

    static {
        Class[] classArray = new Class[1];
        Intrinsics.checkNotNull(Integer.TYPE);
        createUninitializedTwoByteStringMethod = CheckedMethod.Companion.staticMethod(TwoByteStringDescriptor.class, "mutableTwoByteStringOfSize", AvailObject.class, classArray);
        int i2 = 0;
        int[] nArray = new int[]{0, 3, 2, 1};
        for (int excess : nArray) {
            TwoByteStringDescriptor.descriptors[i2++] = new TwoByteStringDescriptor(Mutability.MUTABLE, excess);
            TwoByteStringDescriptor.descriptors[i2++] = new TwoByteStringDescriptor(Mutability.IMMUTABLE, excess);
            TwoByteStringDescriptor.descriptors[i2++] = new TwoByteStringDescriptor(Mutability.SHARED, excess);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0002J%\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00150\u0014\u00f8\u0001\u0000J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\fH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lavail/descriptor/tuples/TwoByteStringDescriptor$Companion;", "", "()V", "createUninitializedTwoByteStringMethod", "Lavail/optimizer/jvm/CheckedMethod;", "getCreateUninitializedTwoByteStringMethod", "()Lavail/optimizer/jvm/CheckedMethod;", "descriptors", "", "Lavail/descriptor/tuples/TwoByteStringDescriptor;", "[Lavail/descriptor/tuples/TwoByteStringDescriptor;", "maximumCopySize", "", "descriptorFor", "flag", "Lavail/descriptor/representation/Mutability;", "size", "generateTwoByteString", "Lavail/descriptor/representation/AvailObject;", "generator", "Lkotlin/Function1;", "Lkotlin/UShort;", "mutableObjectFromNativeTwoByteString", "aNativeTwoByteString", "", "mutableTwoByteStringOfSize", "avail"})
    @SourceDebugExtension(value={"SMAP\nTwoByteStringDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TwoByteStringDescriptor.kt\navail/descriptor/tuples/TwoByteStringDescriptor$Companion\n+ 2 AbstractDescriptor.kt\navail/descriptor/representation/AbstractDescriptor\n+ 3 AbstractDescriptor.kt\navail/descriptor/representation/AbstractDescriptor$create$1\n*L\n1#1,685:1\n572#2,4:686\n574#3:690\n*S KotlinDebug\n*F\n+ 1 TwoByteStringDescriptor.kt\navail/descriptor/tuples/TwoByteStringDescriptor$Companion\n*L\n563#1:686,4\n563#1:690\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final AvailObject mutableTwoByteStringOfSize(int size) {
            void $this$iv;
            AvailObject availObject;
            AbstractDescriptor abstractDescriptor = this.descriptorFor(Mutability.MUTABLE, size);
            int indexedSlotCount$iv = size + 3 >> 2;
            boolean $i$f$create = false;
            AvailObject availObject2 = availObject = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, (AbstractDescriptor)$this$iv);
            boolean bl = false;
            AvailObject $this$null = availObject2;
            return availObject;
        }

        @NotNull
        public final CheckedMethod getCreateUninitializedTwoByteStringMethod() {
            return createUninitializedTwoByteStringMethod;
        }

        private final TwoByteStringDescriptor descriptorFor(Mutability flag, int size) {
            TwoByteStringDescriptor twoByteStringDescriptor = descriptors[(size & 3) * 3 + flag.ordinal()];
            Intrinsics.checkNotNull((Object)twoByteStringDescriptor);
            return twoByteStringDescriptor;
        }

        @NotNull
        public final AvailObject mutableObjectFromNativeTwoByteString(@NotNull String aNativeTwoByteString) {
            Intrinsics.checkNotNullParameter((Object)aNativeTwoByteString, (String)"aNativeTwoByteString");
            return this.generateTwoByteString(aNativeTwoByteString.length(), (Function1<? super Integer, UShort>)((Function1)new Function1<Integer, UShort>(aNativeTwoByteString){
                final /* synthetic */ String $aNativeTwoByteString;
                {
                    this.$aNativeTwoByteString = $aNativeTwoByteString;
                    super(1);
                }

                public final short invoke-BwKQO78(int it) {
                    return UShort.constructor-impl((short)((short)this.$aNativeTwoByteString.codePointAt(it - 1)));
                }
            }));
        }

        @NotNull
        public final AvailObject generateTwoByteString(int size, @NotNull Function1<? super Integer, UShort> generator) {
            int index2;
            Intrinsics.checkNotNullParameter(generator, (String)"generator");
            AvailObject result2 = this.mutableTwoByteStringOfSize(size);
            int counter = 1;
            int slotIndex = 1;
            int n = size >>> 2;
            if (slotIndex <= n) {
                while (true) {
                    result2.set(IntegerSlots.RAW_LONGS_, slotIndex, ((long)((UShort)generator.invoke((Object)counter++)).unbox-impl() & 0xFFFFL) + (((long)((UShort)generator.invoke((Object)counter++)).unbox-impl() & 0xFFFFL) << 16) + (((long)((UShort)generator.invoke((Object)counter++)).unbox-impl() & 0xFFFFL) << 32) + (((long)((UShort)generator.invoke((Object)counter++)).unbox-impl() & 0xFFFFL) << 48));
                    if (slotIndex == n) break;
                    ++slotIndex;
                }
            }
            if ((index2 = (size & 0xFFFFFFFC) + 1) <= size) {
                while (true) {
                    long c;
                    boolean bl;
                    boolean bl2 = bl = ((c = (long)((UShort)generator.invoke((Object)counter++)).unbox-impl() & 0xFFFFL) & 0xFFFFL) == c;
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    result2.setShortSlot(IntegerSlots.RAW_LONGS_, index2, (int)c);
                    if (index2 == size) break;
                    ++index2;
                }
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/tuples/TwoByteStringDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "HASH_AND_MORE", "RAW_LONGS_", "Companion", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final BitField HASH_OR_ZERO;
        @HideFieldInDebugger
        public static final /* enum */ IntegerSlots HASH_AND_MORE;
        public static final /* enum */ IntegerSlots RAW_LONGS_;
        private static final /* synthetic */ IntegerSlots[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        @NotNull
        public static EnumEntries<IntegerSlots> getEntries() {
            return $ENTRIES;
        }

        static {
            boolean bl;
            HASH_AND_MORE = new IntegerSlots();
            RAW_LONGS_ = new IntegerSlots();
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.HASH_AND_MORE, IntegerSlots.RAW_LONGS_};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            HASH_OR_ZERO = new BitField(HASH_AND_MORE, 0, 32, (Function1<? super Integer, String>)((Function1)Companion.HASH_OR_ZERO.1.INSTANCE));
            boolean bl2 = bl = TupleDescriptor.IntegerSlots.HASH_AND_MORE.ordinal() == HASH_AND_MORE.ordinal();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/tuples/TwoByteStringDescriptor$IntegerSlots$Companion;", "", "()V", "HASH_OR_ZERO", "Lavail/descriptor/representation/BitField;", "getHASH_OR_ZERO", "()Lavail/descriptor/representation/BitField;", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BitField getHASH_OR_ZERO() {
                return HASH_OR_ZERO;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

