/*
 * Decompiled with CFR 0.152.
 */
package avail.files;

import avail.error.ErrorCode;
import avail.files.AvailFile;
import avail.files.FileAction;
import avail.files.FileActionType;
import avail.files.FileManager;
import avail.files.NoAction;
import avail.files.TracedAction;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001a\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\"\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lavail/files/SaveAction;", "Lavail/files/FileAction;", "fileManager", "Lavail/files/FileManager;", "failureHandler", "Lkotlin/Function2;", "Lavail/error/ErrorCode;", "", "", "(Lavail/files/FileManager;Lkotlin/jvm/functions/Function2;)V", "type", "Lavail/files/FileActionType;", "getType", "()Lavail/files/FileActionType;", "execute", "Lavail/files/TracedAction;", "file", "Lavail/files/AvailFile;", "timestamp", "", "originator", "Ljava/util/UUID;", "avail"})
public final class SaveAction
implements FileAction {
    @NotNull
    private final FileManager fileManager;
    @NotNull
    private final Function2<ErrorCode, Throwable, Unit> failureHandler;
    @NotNull
    private final FileActionType type;

    public SaveAction(@NotNull FileManager fileManager, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)fileManager, (String)"fileManager");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        this.fileManager = fileManager;
        this.failureHandler = failureHandler;
        this.type = FileActionType.SAVE;
    }

    @Override
    @NotNull
    public TracedAction execute(@NotNull AvailFile file2, long timestamp, @NotNull UUID originator) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)originator, (String)"originator");
        this.fileManager.saveFile(file2, this.failureHandler);
        return NoAction.INSTANCE.getTracedAction();
    }

    @Override
    @NotNull
    public FileActionType getType() {
        return this.type;
    }
}

