/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.TypeTag;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2IntImmediateOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_MOVE;
import avail.interpreter.levelTwo.operation.L2_MOVE_CONSTANT;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2Generator;
import avail.optimizer.L2SplitCondition;
import avail.optimizer.jvm.JVMTranslator;
import avail.optimizer.reoptimizer.L2Regenerator;
import avail.optimizer.values.L2SemanticUnboxedInt;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J#\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006 "}, d2={"Lavail/interpreter/levelTwo/operation/L2_EXTRACT_TAG_ORDINAL;", "Lavail/interpreter/levelTwo/L2Operation;", "()V", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "", "emitTransformedInstruction", "transformedOperands", "", "Lavail/interpreter/levelTwo/operand/L2Operand;", "regenerator", "Lavail/optimizer/reoptimizer/L2Regenerator;", "([Lavail/interpreter/levelTwo/operand/L2Operand;Lavail/optimizer/reoptimizer/L2Regenerator;)V", "generateReplacement", "interestingConditions", "", "Lavail/optimizer/L2SplitCondition;", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
@SourceDebugExtension(value={"SMAP\nL2_EXTRACT_TAG_ORDINAL.kt\nKotlin\n*S Kotlin\n*F\n+ 1 L2_EXTRACT_TAG_ORDINAL.kt\navail/interpreter/levelTwo/operation/L2_EXTRACT_TAG_ORDINAL\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n288#2,2:199\n1855#2,2:201\n288#2,2:203\n1855#2,2:205\n*S KotlinDebug\n*F\n+ 1 L2_EXTRACT_TAG_ORDINAL.kt\navail/interpreter/levelTwo/operation/L2_EXTRACT_TAG_ORDINAL\n*L\n112#1:199,2\n125#1:201,2\n157#1:203,2\n170#1:205,2\n*E\n"})
public final class L2_EXTRACT_TAG_ORDINAL
extends L2Operation {
    @NotNull
    public static final L2_EXTRACT_TAG_ORDINAL INSTANCE = new L2_EXTRACT_TAG_ORDINAL();

    private L2_EXTRACT_TAG_ORDINAL() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.READ_BOXED.named("value"), L2OperandType.WRITE_INT.named("metatag ordinal")};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, (String)"desiredTypes");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, (String)"warningStyleChange");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedOperand value = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteIntOperand tagOrdinal = (L2WriteIntOperand)instruction2.operand(1);
        this.renderPreamble(instruction2, builder);
        builder.append(' ').append(tagOrdinal.registerString()).append(" \u2190 TAG(").append(value.registerString()).append(")");
    }

    @Override
    @NotNull
    public List<L2SplitCondition> interestingConditions(@NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        L2ReadBoxedOperand value = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteIntOperand tagOrdinal = (L2WriteIntOperand)instruction2.operand(1);
        Object[] objectArray = new L2Register[]{value.register(), tagOrdinal.register()};
        return CollectionsKt.listOf((Object)L2SplitCondition.L2IsUnboxedIntCondition.Companion.unboxedIntCondition(CollectionsKt.listOf((Object[])objectArray)));
    }

    @Override
    public void generateReplacement(@NotNull L2Instruction instruction2, @NotNull L2Regenerator regenerator2) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)regenerator2, (String)"regenerator");
        L2ReadBoxedOperand value = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteIntOperand tagOrdinal = (L2WriteIntOperand)instruction2.operand(1);
        A_Type type = value.type();
        TypeTag baseTag = A_Type.Companion.getInstanceTag(type);
        if (!(baseTag.ordinal() != baseTag.getHighOrdinal() || baseTag.isSubtagOf(TypeTag.TOP_TYPE_TAG) && baseTag != TypeTag.BOTTOM_TYPE_TAG)) {
            Object v0;
            L2Generator $this$generateReplacement_u24lambda_u242;
            block5: {
                $this$generateReplacement_u24lambda_u242 = regenerator2.getTargetGenerator();
                boolean bl = false;
                Iterable $this$firstOrNull$iv = tagOrdinal.semanticValues();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    L2SemanticUnboxedInt it = (L2SemanticUnboxedInt)element$iv;
                    boolean bl2 = false;
                    if (!$this$generateReplacement_u24lambda_u242.getCurrentManifest().hasSemanticValue(it)) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            L2SemanticUnboxedInt existingValue = v0;
            if (existingValue == null) {
                L2Operand[] $i$f$firstOrNull = new L2Operand[]{new L2IntImmediateOperand(baseTag.ordinal()), L2Generator.intWrite$default($this$generateReplacement_u24lambda_u242, tagOrdinal.semanticValues(), TypeRestriction.Companion.restrictionForConstant(IntegerDescriptor.Companion.fromInt(baseTag.ordinal()), TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG), null, 4, null)};
                $this$generateReplacement_u24lambda_u242.addInstruction(L2_MOVE_CONSTANT.unboxedInt, $i$f$firstOrNull);
            } else {
                Iterable $this$forEach$iv = tagOrdinal.semanticValues();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    L2SemanticUnboxedInt otherValue = (L2SemanticUnboxedInt)element$iv;
                    boolean bl = false;
                    if ($this$generateReplacement_u24lambda_u242.getCurrentManifest().hasSemanticValue(otherValue)) continue;
                    $this$generateReplacement_u24lambda_u242.moveRegister(L2_MOVE.Companion.getUnboxedInt(), existingValue, otherValue);
                }
            }
            return;
        }
        super.generateReplacement(instruction2, regenerator2);
    }

    @Override
    public void emitTransformedInstruction(@NotNull L2Operand[] transformedOperands, @NotNull L2Regenerator regenerator2) {
        Intrinsics.checkNotNullParameter((Object)transformedOperands, (String)"transformedOperands");
        Intrinsics.checkNotNullParameter((Object)regenerator2, (String)"regenerator");
        L2Operand l2Operand = transformedOperands[0];
        Intrinsics.checkNotNull((Object)l2Operand, (String)"null cannot be cast to non-null type avail.interpreter.levelTwo.operand.L2ReadBoxedOperand");
        L2ReadBoxedOperand value = (L2ReadBoxedOperand)l2Operand;
        L2Operand l2Operand2 = transformedOperands[1];
        Intrinsics.checkNotNull((Object)l2Operand2, (String)"null cannot be cast to non-null type avail.interpreter.levelTwo.operand.L2WriteIntOperand");
        L2WriteIntOperand tagOrdinal = (L2WriteIntOperand)l2Operand2;
        A_Type type = value.type();
        TypeTag baseTag = A_Type.Companion.getInstanceTag(type);
        if (!(baseTag.ordinal() != baseTag.getHighOrdinal() || baseTag.isSubtagOf(TypeTag.TOP_TYPE_TAG) && baseTag != TypeTag.BOTTOM_TYPE_TAG)) {
            Object v2;
            L2Generator $this$emitTransformedInstruction_u24lambda_u245;
            block5: {
                $this$emitTransformedInstruction_u24lambda_u245 = regenerator2.getTargetGenerator();
                boolean bl = false;
                Iterable $this$firstOrNull$iv = tagOrdinal.semanticValues();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    L2SemanticUnboxedInt it = (L2SemanticUnboxedInt)element$iv;
                    boolean bl2 = false;
                    if (!$this$emitTransformedInstruction_u24lambda_u245.getCurrentManifest().hasSemanticValue(it)) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            L2SemanticUnboxedInt existingValue = v2;
            if (existingValue == null) {
                L2Operand[] $i$f$firstOrNull = new L2Operand[]{new L2IntImmediateOperand(baseTag.ordinal()), L2Generator.intWrite$default($this$emitTransformedInstruction_u24lambda_u245, tagOrdinal.semanticValues(), TypeRestriction.Companion.restrictionForConstant(IntegerDescriptor.Companion.fromInt(baseTag.ordinal()), TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG), null, 4, null)};
                $this$emitTransformedInstruction_u24lambda_u245.addInstruction(L2_MOVE_CONSTANT.unboxedInt, $i$f$firstOrNull);
            } else {
                Iterable $this$forEach$iv = tagOrdinal.semanticValues();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    L2SemanticUnboxedInt otherValue = (L2SemanticUnboxedInt)element$iv;
                    boolean bl = false;
                    if ($this$emitTransformedInstruction_u24lambda_u245.getCurrentManifest().hasSemanticValue(otherValue)) continue;
                    $this$emitTransformedInstruction_u24lambda_u245.moveRegister(L2_MOVE.Companion.getUnboxedInt(), existingValue, otherValue);
                }
            }
            return;
        }
        super.emitTransformedInstruction(transformedOperands, regenerator2);
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        L2ReadBoxedOperand value = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteIntOperand tagOrdinal = (L2WriteIntOperand)instruction2.operand(1);
        translator.load(method, (L2Register)value.register());
        AbstractDescriptor.Companion.getStaticTypeTagOrdinalMethod().generateCall(method);
        translator.store(method, (L2Register)tagOrdinal.register());
    }
}

