/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.operand.L2ConstantOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2ConditionalJump;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_COMPARE_INT;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2Generator;
import avail.optimizer.L2SplitCondition;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.jvm.JVMTranslator;
import avail.optimizer.reoptimizer.L2Regenerator;
import avail.optimizer.values.L2SemanticUnboxedInt;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J#\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006#"}, d2={"Lavail/interpreter/levelTwo/operation/L2_JUMP_IF_EQUALS_CONSTANT;", "Lavail/interpreter/levelTwo/operation/L2ConditionalJump;", "()V", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "", "emitTransformedInstruction", "transformedOperands", "", "Lavail/interpreter/levelTwo/operand/L2Operand;", "regenerator", "Lavail/optimizer/reoptimizer/L2Regenerator;", "([Lavail/interpreter/levelTwo/operand/L2Operand;Lavail/optimizer/reoptimizer/L2Regenerator;)V", "generateReplacement", "instructionWasAdded", "manifest", "Lavail/optimizer/L2ValueManifest;", "interestingConditions", "", "Lavail/optimizer/L2SplitCondition;", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
public final class L2_JUMP_IF_EQUALS_CONSTANT
extends L2ConditionalJump {
    @NotNull
    public static final L2_JUMP_IF_EQUALS_CONSTANT INSTANCE = new L2_JUMP_IF_EQUALS_CONSTANT();

    private L2_JUMP_IF_EQUALS_CONSTANT() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.READ_BOXED.named("value"), L2OperandType.CONSTANT.named("constant"), L2OperandType.PC.named("if equal", L2NamedOperandType.Purpose.SUCCESS), L2OperandType.PC.named("if unequal", L2NamedOperandType.Purpose.FAILURE)};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public void instructionWasAdded(@NotNull L2Instruction instruction2, @NotNull L2ValueManifest manifest2) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)manifest2, (String)"manifest");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedOperand reader = (L2ReadBoxedOperand)instruction2.operand(0);
        L2ConstantOperand constant = (L2ConstantOperand)instruction2.operand(1);
        L2PcOperand ifEqual = (L2PcOperand)instruction2.operand(2);
        L2PcOperand ifNotEqual = (L2PcOperand)instruction2.operand(3);
        super.instructionWasAdded(instruction2, manifest2);
        TypeRestriction oldRestriction = reader.restriction();
        ifEqual.manifest().setRestriction(reader.semanticValue(), TypeRestriction.Companion.restrictionForConstant(constant.getConstant(), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
        ifNotEqual.manifest().setRestriction(reader.semanticValue(), oldRestriction.minusValue(constant.getConstant()));
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, (String)"desiredTypes");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, (String)"warningStyleChange");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedOperand value = (L2ReadBoxedOperand)instruction2.operand(0);
        L2ConstantOperand constant = (L2ConstantOperand)instruction2.operand(1);
        this.renderPreamble(instruction2, builder);
        builder.append(' ');
        builder.append(value.registerString());
        builder.append(" = ");
        builder.append(constant.getConstant());
        this.renderOperandsStartingAt(instruction2, 2, desiredTypes, builder);
    }

    @Override
    public void generateReplacement(@NotNull L2Instruction instruction2, @NotNull L2Regenerator regenerator2) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)regenerator2, (String)"regenerator");
        L2ReadBoxedOperand value = (L2ReadBoxedOperand)regenerator2.transformOperand(instruction2.operand(0));
        L2ConstantOperand constant = (L2ConstantOperand)regenerator2.transformOperand(instruction2.operand(1));
        L2PcOperand ifEqual = (L2PcOperand)regenerator2.transformOperand(instruction2.operand(2));
        L2PcOperand ifUnequal = (L2PcOperand)regenerator2.transformOperand(instruction2.operand(3));
        regenerator2.getTargetGenerator().jumpIfEqualsConstant(value, constant.getConstant(), ifEqual.targetBlock(), ifUnequal.targetBlock());
    }

    @Override
    public void emitTransformedInstruction(@NotNull L2Operand[] transformedOperands, @NotNull L2Regenerator regenerator2) {
        Intrinsics.checkNotNullParameter((Object)transformedOperands, (String)"transformedOperands");
        Intrinsics.checkNotNullParameter((Object)regenerator2, (String)"regenerator");
        L2Operand l2Operand = transformedOperands[0];
        Intrinsics.checkNotNull((Object)l2Operand, (String)"null cannot be cast to non-null type avail.interpreter.levelTwo.operand.L2ReadBoxedOperand");
        L2ReadBoxedOperand value = (L2ReadBoxedOperand)l2Operand;
        L2Operand l2Operand2 = transformedOperands[1];
        Intrinsics.checkNotNull((Object)l2Operand2, (String)"null cannot be cast to non-null type avail.interpreter.levelTwo.operand.L2ConstantOperand");
        L2ConstantOperand constant = (L2ConstantOperand)l2Operand2;
        L2Operand l2Operand3 = transformedOperands[2];
        Intrinsics.checkNotNull((Object)l2Operand3, (String)"null cannot be cast to non-null type avail.interpreter.levelTwo.operand.L2PcOperand");
        L2PcOperand ifEqual = (L2PcOperand)l2Operand3;
        L2Operand l2Operand4 = transformedOperands[3];
        Intrinsics.checkNotNull((Object)l2Operand4, (String)"null cannot be cast to non-null type avail.interpreter.levelTwo.operand.L2PcOperand");
        L2PcOperand ifUnequal = (L2PcOperand)l2Operand4;
        L2Generator generator = regenerator2.getTargetGenerator();
        TypeRestriction valueRestriction = generator.getCurrentManifest().restrictionFor(value.semanticValue());
        AvailObject availObject = valueRestriction.getConstantOrNull();
        if (availObject != null) {
            AvailObject valueValue = availObject;
            boolean bl = false;
            if (valueValue.equals(constant.getConstant())) {
                L2Generator.jumpTo$default(generator, ifEqual.targetBlock(), null, 2, null);
                return;
            }
        }
        if (!valueRestriction.intersectsType(AbstractEnumerationTypeDescriptor.Companion.instanceTypeOrMetaOn(constant.getConstant()))) {
            L2Generator.jumpTo$default(generator, ifUnequal.targetBlock(), null, 2, null);
            return;
        }
        if (A_Number.Companion.isInt(constant.getConstant()) && valueRestriction.isUnboxedInt()) {
            L2_JUMP_IF_COMPARE_INT.Companion.getEqual().compareAndBranch(generator, generator.getCurrentManifest().readInt(new L2SemanticUnboxedInt(value.semanticValue())), generator.unboxedIntConstant(A_Number.Companion.getExtractInt(constant.getConstant())), ifEqual, ifUnequal);
            return;
        }
        super.emitTransformedInstruction(transformedOperands, regenerator2);
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        L2ReadBoxedOperand value = (L2ReadBoxedOperand)instruction2.operand(0);
        L2ConstantOperand constant = (L2ConstantOperand)instruction2.operand(1);
        L2PcOperand ifEqual = (L2PcOperand)instruction2.operand(2);
        L2PcOperand ifUnequal = (L2PcOperand)instruction2.operand(3);
        translator.load(method, (L2Register)value.register());
        translator.literal(method, constant.getConstant());
        A_BasicObject.Companion.getEqualsMethod().generateCall(method);
        L2ConditionalJump.emitBranch(translator, method, instruction2, 154, ifEqual, ifUnequal);
    }

    @Override
    @NotNull
    public List<L2SplitCondition> interestingConditions(@NotNull L2Instruction instruction2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        L2ReadBoxedOperand reader = (L2ReadBoxedOperand)instruction2.operand(0);
        L2ConstantOperand constant = (L2ConstantOperand)instruction2.operand(1);
        List $this$interestingConditions_u24lambda_u241 = list2 = (List)new ArrayList();
        boolean bl = false;
        if (A_Number.Companion.isInt(constant.getConstant())) {
            $this$interestingConditions_u24lambda_u241.add(L2SplitCondition.L2IsUnboxedIntCondition.Companion.unboxedIntCondition(CollectionsKt.listOf(reader.register())));
            $this$interestingConditions_u24lambda_u241.add(L2SplitCondition.L2MeetsRestrictionCondition.Companion.typeRestrictionCondition(SetsKt.setOf(reader.register()), TypeRestriction.Companion.restrictionForConstant(constant.getConstant(), TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG)));
        }
        $this$interestingConditions_u24lambda_u241.add(L2SplitCondition.L2MeetsRestrictionCondition.Companion.typeRestrictionCondition(SetsKt.setOf(reader.register()), TypeRestriction.Companion.restrictionForConstant(constant.getConstant(), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG)));
        return list2;
    }
}

