/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.numbers.A_Number;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operation.L2_MOVE;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2Generator;
import avail.optimizer.L2SplitCondition;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.jvm.JVMTranslator;
import avail.optimizer.reoptimizer.L2Regenerator;
import avail.optimizer.values.L2SemanticUnboxedInt;
import avail.optimizer.values.L2SemanticValue;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J#\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u001f"}, d2={"Lavail/interpreter/levelTwo/operation/L2_UNBOX_INT;", "Lavail/interpreter/levelTwo/L2Operation;", "()V", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "", "emitTransformedInstruction", "transformedOperands", "", "Lavail/interpreter/levelTwo/operand/L2Operand;", "regenerator", "Lavail/optimizer/reoptimizer/L2Regenerator;", "([Lavail/interpreter/levelTwo/operand/L2Operand;Lavail/optimizer/reoptimizer/L2Regenerator;)V", "interestingConditions", "", "Lavail/optimizer/L2SplitCondition;", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
public final class L2_UNBOX_INT
extends L2Operation {
    @NotNull
    public static final L2_UNBOX_INT INSTANCE = new L2_UNBOX_INT();

    private L2_UNBOX_INT() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.READ_BOXED.named("source"), L2OperandType.WRITE_INT.named("destination")};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, (String)"desiredTypes");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, (String)"warningStyleChange");
        L2ReadBoxedOperand source = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteIntOperand destination = (L2WriteIntOperand)instruction2.operand(1);
        this.renderPreamble(instruction2, builder);
        builder.append(' ');
        builder.append(destination.registerString());
        builder.append(" \u2190 ");
        builder.append(source.registerString());
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        L2ReadBoxedOperand source = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteIntOperand destination = (L2WriteIntOperand)instruction2.operand(1);
        translator.load(method, (L2Register)source.register());
        A_Number.Companion.getExtractIntStaticMethod().generateCall(method);
        translator.store(method, (L2Register)destination.register());
    }

    @Override
    @NotNull
    public List<L2SplitCondition> interestingConditions(@NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        L2ReadBoxedOperand source = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteIntOperand destination = (L2WriteIntOperand)instruction2.operand(1);
        Object[] objectArray = new L2Register[]{source.register(), destination.register()};
        return CollectionsKt.listOf((Object)L2SplitCondition.L2IsUnboxedIntCondition.Companion.unboxedIntCondition(CollectionsKt.listOf((Object[])objectArray)));
    }

    @Override
    public void emitTransformedInstruction(@NotNull L2Operand[] transformedOperands, @NotNull L2Regenerator regenerator2) {
        Intrinsics.checkNotNullParameter((Object)transformedOperands, (String)"transformedOperands");
        Intrinsics.checkNotNullParameter((Object)regenerator2, (String)"regenerator");
        L2Operand l2Operand = transformedOperands[0];
        Intrinsics.checkNotNull((Object)l2Operand, (String)"null cannot be cast to non-null type avail.interpreter.levelTwo.operand.L2ReadBoxedOperand");
        L2ReadBoxedOperand source = (L2ReadBoxedOperand)l2Operand;
        L2Operand l2Operand2 = transformedOperands[1];
        Intrinsics.checkNotNull((Object)l2Operand2, (String)"null cannot be cast to non-null type avail.interpreter.levelTwo.operand.L2WriteIntOperand");
        L2WriteIntOperand destination = (L2WriteIntOperand)l2Operand2;
        L2Generator generator = regenerator2.getTargetGenerator();
        L2ValueManifest manifest2 = generator.getCurrentManifest();
        for (L2SemanticValue otherBoxed : manifest2.semanticValueToSynonym(source.semanticValue()).semanticValues()) {
            L2SemanticUnboxedInt otherUnboxed = new L2SemanticUnboxedInt(otherBoxed);
            if (!manifest2.hasSemanticValue(otherUnboxed)) continue;
            for (L2SemanticUnboxedInt destInt : destination.semanticValues()) {
                if (manifest2.hasSemanticValue(destInt)) continue;
                generator.moveRegister(L2_MOVE.Companion.getUnboxedInt(), otherUnboxed, destInt);
            }
            return;
        }
        super.emitTransformedInstruction(transformedOperands, regenerator2);
    }
}

