/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.lexing;

import avail.compiler.AvailRejectedParseException;
import avail.compiler.problems.CompilerDiagnostics;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.parsing.A_Lexer;
import avail.descriptor.parsing.LexerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tokens.LiteralTokenDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.A_Type;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.style.P_BootstrapLexerStringBodyStyler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0014\u00a8\u0006\u001c"}, d2={"Lavail/interpreter/primitive/bootstrap/lexing/P_BootstrapLexerStringBody;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "bootstrapStyler", "Lavail/interpreter/primitive/style/P_BootstrapLexerStringBodyStyler;", "parseString", "Lavail/descriptor/tokens/A_Token;", "source", "Lavail/descriptor/tuples/A_String;", "startPosition", "", "startLineNumber", "lexer", "Lavail/descriptor/parsing/A_Lexer;", "parseUnicodeEscapes", "", "scanner", "Lavail/interpreter/primitive/bootstrap/lexing/P_BootstrapLexerStringBody$Scanner;", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "Scanner", "avail"})
public final class P_BootstrapLexerStringBody
extends Primitive {
    @NotNull
    public static final P_BootstrapLexerStringBody INSTANCE = new P_BootstrapLexerStringBody();

    private P_BootstrapLexerStringBody() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline, Primitive.Flag.Bootstrap};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject source = interpreter.argument(0);
        AvailObject sourcePositionInteger = interpreter.argument(1);
        AvailObject lineNumberInteger = interpreter.argument(2);
        int startPosition = A_Number.Companion.getExtractInt(sourcePositionInteger);
        int startLineNumber = A_Number.Companion.getExtractInt(lineNumberInteger);
        A_Token token = this.parseString(source, startPosition, startLineNumber, A_Fiber.Companion.getCurrentLexer(interpreter.fiber()));
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{ObjectTupleDescriptor.Companion.tuple(token)};
        return interpreter.primitiveSuccess(SetDescriptor.Companion.set(a_BasicObjectArray));
    }

    @NotNull
    public final A_Token parseString(@NotNull A_String source, int startPosition, int startLineNumber, @NotNull A_Lexer lexer) throws AvailRejectedParseException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        Scanner scanner = new Scanner(source, startPosition + 1, startLineNumber);
        StringBuilder builder = new StringBuilder(32);
        boolean canErase = true;
        int erasurePosition = 0;
        block18: while (scanner.hasNext()) {
            int c = scanner.next();
            switch (c) {
                case 34: {
                    A_String a_String = A_String.Companion.copyStringFromToCanDestroy(source, startPosition, scanner.getPosition() - 1, false);
                    String string2 = builder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    return LiteralTokenDescriptor.Companion.literalToken$default(LiteralTokenDescriptor.Companion, a_String, startPosition, startLineNumber, StringDescriptor.Companion.stringFrom(string2), lexer, null, 32, null);
                }
                case 92: {
                    if (!scanner.hasNext()) {
                        throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "more characters after backslash in string literal", new Object[0]);
                    }
                    c = scanner.next();
                    switch (c) {
                        case 110: {
                            builder.append('\n');
                            break;
                        }
                        case 114: {
                            builder.append('\r');
                            break;
                        }
                        case 116: {
                            builder.append('\t');
                            break;
                        }
                        case 92: {
                            builder.append('\\');
                            break;
                        }
                        case 34: {
                            builder.append('\"');
                            break;
                        }
                        case 13: {
                            if (scanner.hasNext() && scanner.peek() == 10) {
                                scanner.next();
                            }
                            canErase = true;
                            break;
                        }
                        case 10: 
                        case 12: 
                        case 133: 
                        case 8232: 
                        case 8233: {
                            canErase = true;
                            break;
                        }
                        case 124: {
                            if (canErase) {
                                builder.setLength(erasurePosition);
                                canErase = false;
                                break;
                            }
                            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "only whitespace characters on line before \"\\|\" ", new Object[0]);
                        }
                        case 40: {
                            this.parseUnicodeEscapes(scanner, builder);
                            break;
                        }
                        case 91: {
                            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.WEAK, "something other than \"\\[\", because power strings are not yet supported", new Object[0]);
                        }
                        default: {
                            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "Backslash escape should be followed by one of n, r, t, \\, \", (, [, |, or a line break, not Unicode character " + c, new Object[0]);
                        }
                    }
                    erasurePosition = builder.length();
                    continue block18;
                }
                case 13: {
                    if (scanner.hasNext() && scanner.peek() == 10) {
                        scanner.next();
                    }
                    builder.appendCodePoint(10);
                    canErase = true;
                    erasurePosition = builder.length();
                    continue block18;
                }
                case 10: {
                    builder.appendCodePoint(c);
                    canErase = true;
                    erasurePosition = builder.length();
                    continue block18;
                }
            }
            builder.appendCodePoint(c);
            if (!canErase || Character.isWhitespace(c)) continue;
            canErase = false;
        }
        throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "close-quote (\") for string literal", new Object[0]);
    }

    private final void parseUnicodeEscapes(Scanner scanner, StringBuilder stringBuilder) {
        if (!scanner.hasNext()) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "Unicode escape sequence in string literal", new Object[0]);
        }
        int c = scanner.next();
        while (c != 41) {
            int value = 0;
            int digitCount = 0;
            while (c != 44 && c != 41) {
                int n = c;
                boolean bl = 48 <= n ? n < 58 : false;
                if (bl) {
                    value = (value << 4) + c - 48;
                } else {
                    boolean bl2 = 65 <= n ? n < 71 : false;
                    if (bl2) {
                        value = (value << 4) + c - 65 + 10;
                    } else {
                        boolean bl3 = 97 <= n ? n < 103 : false;
                        if (bl3) {
                            value = (value << 4) + c - 97 + 10;
                        } else {
                            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "a hex digit or comma or closing parenthesis", new Object[0]);
                        }
                    }
                }
                if (++digitCount > 6) {
                    throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "at most six hex digits per comma-separated Unicode entry", new Object[0]);
                }
                c = scanner.next();
            }
            if (digitCount == 0) {
                throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "a comma-separated list of Unicode code points, each being one to six (upper case) hexadecimal digits", new Object[0]);
            }
            if (value > 0x10FFFF) {
                throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "A valid Unicode code point, which must be <= U+10FFFF", new Object[0]);
            }
            stringBuilder.appendCodePoint(value);
            if (c != 44) continue;
            c = scanner.next();
            while (scanner.hasNext() && Character.isWhitespace(scanner.peek())) {
                scanner.next();
            }
        }
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return LexerDescriptor.Companion.lexerBodyFunctionType();
    }

    @Override
    @NotNull
    public P_BootstrapLexerStringBodyStyler bootstrapStyler() {
        return P_BootstrapLexerStringBodyStyler.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\t\u0010\u0011\u001a\u00020\u0005H\u0086\u0002J\u0006\u0010\u0012\u001a\u00020\u0005R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lavail/interpreter/primitive/bootstrap/lexing/P_BootstrapLexerStringBody$Scanner;", "", "source", "Lavail/descriptor/tuples/A_String;", "position", "", "lineNumber", "(Lavail/descriptor/tuples/A_String;II)V", "getLineNumber", "()I", "setLineNumber", "(I)V", "getPosition", "setPosition", "sourceSize", "hasNext", "", "next", "peek", "avail"})
    public static final class Scanner {
        @NotNull
        private final A_String source;
        private int position;
        private int lineNumber;
        private final int sourceSize;

        public Scanner(@NotNull A_String source, int position, int lineNumber) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.source = source;
            this.position = position;
            this.lineNumber = lineNumber;
            this.sourceSize = A_Tuple.Companion.getTupleSize(this.source);
        }

        public final int getPosition() {
            return this.position;
        }

        public final void setPosition(int n) {
            this.position = n;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        public final void setLineNumber(int n) {
            this.lineNumber = n;
        }

        public final boolean hasNext() {
            return this.position <= this.sourceSize;
        }

        public final int peek() {
            return A_Tuple.Companion.tupleCodePointAt(this.source, this.position);
        }

        public final int next() {
            int n = this.position;
            this.position = n + 1;
            int c = A_Tuple.Companion.tupleCodePointAt(this.source, n);
            if (c == 10) {
                n = this.lineNumber;
                this.lineNumber = n + 1;
            }
            return c;
        }
    }
}

