/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.syntax;

import avail.compiler.AvailRejectedParseException;
import avail.compiler.problems.CompilerDiagnostics;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.SuperCastPhraseDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lavail/interpreter/primitive/bootstrap/syntax/P_BootstrapSuperCastMacro;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_BootstrapSuperCastMacro
extends Primitive {
    @NotNull
    public static final P_BootstrapSuperCastMacro INSTANCE = new P_BootstrapSuperCastMacro();

    private P_BootstrapSuperCastMacro() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanInline, Primitive.Flag.Bootstrap};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject expressionNode = interpreter.argument(0);
        AvailObject typeLiteral = interpreter.argument(1);
        AvailObject type = A_Phrase.Companion.getToken(typeLiteral).literal();
        if (type.isTop() || type.isBottom()) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "supercast type to be something other than " + type, new Object[0]);
        }
        A_Type expressionType = A_Phrase.Companion.getPhraseExpressionType(expressionNode);
        if (!A_Type.Companion.isSubtypeOf(expressionType, type)) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "supercast type (" + type + ") to be a supertype of the expression's type (" + expressionType + ")", new Object[0]);
        }
        A_Phrase superCast = SuperCastPhraseDescriptor.Companion.newSuperCastNode(expressionNode, type);
        return interpreter.primitiveSuccess(superCast.makeImmutable());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PhraseTypeDescriptor.PhraseKind.EXPRESSION_PHRASE.create(PrimitiveTypeDescriptor.Types.ANY.getO()), PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.create(InstanceMetaDescriptor.Companion.anyMeta())), PhraseTypeDescriptor.PhraseKind.SUPER_CAST_PHRASE.getMostGeneralType(), null, 4, null);
    }
}

