/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.doubles;

import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.DoubleDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.LiteralTokenTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lavail/interpreter/primitive/doubles/P_ConstructDoubleFromParts;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_ConstructDoubleFromParts
extends Primitive {
    @NotNull
    public static final P_ConstructDoubleFromParts INSTANCE = new P_ConstructDoubleFromParts();

    private P_ConstructDoubleFromParts() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanInline, Primitive.Flag.CanFold};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject integerPart = interpreter.argument(0);
        AvailObject fractionalPart = interpreter.argument(1);
        AvailObject exponentPart = interpreter.argument(2);
        String numeral = A_String.Companion.asNativeString(integerPart.string()) + "." + A_String.Companion.asNativeString(fractionalPart.string()) + "e" + A_String.Companion.asNativeString(exponentPart.string());
        A_Number result2 = null;
        try {
            Double d = Double.valueOf(numeral);
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"valueOf(...)");
            result2 = DoubleDescriptor.Companion.fromDouble(((Number)d).doubleValue());
        }
        catch (NumberFormatException e) {
            if (_Assertions.ENABLED) {
                boolean bl = false;
                String string2 = "This shouldn't happen, since we control the numeral!";
                throw new AssertionError((Object)string2);
            }
            throw e;
        }
        return interpreter.primitiveSuccess(result2);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(LiteralTokenTypeDescriptor.Companion.literalTokenType(IntegerRangeTypeDescriptor.Companion.getWholeNumbers()), LiteralTokenTypeDescriptor.Companion.literalTokenType(IntegerRangeTypeDescriptor.Companion.getWholeNumbers()), LiteralTokenTypeDescriptor.Companion.literalTokenType(IntegerRangeTypeDescriptor.Companion.getIntegers())), PrimitiveTypeDescriptor.Types.DOUBLE.getO(), null, 4, null);
    }
}

