/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.fibers;

import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.functions.A_Function;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FiberTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/fibers/P_AttemptJoinFiber;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_AttemptJoinFiber
extends Primitive {
    @NotNull
    public static final P_AttemptJoinFiber INSTANCE = new P_AttemptJoinFiber();

    private P_AttemptJoinFiber() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanSuspend, Primitive.Flag.Unknown, Primitive.Flag.WritesToHiddenGlobalState, Primitive.Flag.ReadsFromHiddenGlobalState};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject joinee = interpreter.argument(0);
        A_Fiber current = interpreter.fiber();
        if (current.equals(joinee)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_FIBER_CANNOT_JOIN_ITSELF);
        }
        boolean succeed2 = (Boolean)joinee.lock((Function0)new Function0<Boolean>(joinee, current){
            final /* synthetic */ AvailObject $joinee;
            final /* synthetic */ A_Fiber $current;
            {
                this.$joinee = $joinee;
                this.$current = $current;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                if (A_Fiber.Companion.getExecutionState(this.$joinee).getIndicatesTermination()) {
                    return true;
                }
                A_Fiber.Companion.setJoiningFibers(this.$joinee, A_Set.Companion.setWithElementCanDestroy(A_Fiber.Companion.getJoiningFibers(this.$joinee), this.$current, false));
                return false;
            }
        });
        return succeed2 ? interpreter.primitiveSuccess(NilDescriptor.Companion.getNil()) : (Primitive.Result)((Object)current.lock((Function0)new Function0<Primitive.Result>(current, interpreter){
            final /* synthetic */ A_Fiber $current;
            final /* synthetic */ Interpreter $interpreter;
            {
                this.$current = $current;
                this.$interpreter = $interpreter;
                super(0);
            }

            @NotNull
            public final Primitive.Result invoke() {
                Primitive.Result result2;
                if (A_Fiber.Companion.getAndSetSynchronizationFlag(this.$current, FiberDescriptor.SynchronizationFlag.PERMIT_UNAVAILABLE, true)) {
                    A_Function a_Function = this.$interpreter.function;
                    Intrinsics.checkNotNull((Object)a_Function);
                    result2 = this.$interpreter.primitivePark(a_Function);
                } else {
                    result2 = this.$interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
                }
                return result2;
            }
        }));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(FiberTypeDescriptor.Companion.mostGeneralFiberType()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_FIBER_CANNOT_JOIN_ITSELF};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

