/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.files;

import avail.AvailRuntime;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FiberTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.io.IOSystem;
import java.io.IOException;
import java.nio.channels.AsynchronousFileChannel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/files/P_FileTruncate;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_FileTruncate
extends Primitive {
    @NotNull
    public static final P_FileTruncate INSTANCE = new P_FileTruncate();

    private P_FileTruncate() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(5, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(5);
        AvailObject atom = interpreter.argument(0);
        AvailObject sizeObject = interpreter.argument(1);
        AvailObject succeed2 = interpreter.argument(2);
        AvailObject fail2 = interpreter.argument(3);
        AvailObject priority = interpreter.argument(4);
        AvailObject pojo2 = A_Atom.Companion.getAtomProperty(atom, AtomDescriptor.SpecialAtom.FILE_KEY.getAtom());
        if (pojo2.isNil()) {
            return interpreter.primitiveFailure(A_Atom.Companion.isAtomSpecial(atom) ? AvailErrorCode.E_SPECIAL_ATOM : AvailErrorCode.E_INVALID_HANDLE);
        }
        IOSystem.FileHandle handle2 = (IOSystem.FileHandle)pojo2.javaObjectNotNull();
        if (!handle2.getCanWrite()) {
            return interpreter.primitiveFailure(AvailErrorCode.E_NOT_OPEN_FOR_WRITE);
        }
        AsynchronousFileChannel fileChannel = handle2.getChannel();
        long size = A_Number.Companion.isLong(sizeObject) ? A_Number.Companion.getExtractLong(sizeObject) : Long.MAX_VALUE;
        AvailRuntime runtime = AvailRuntime.Companion.currentRuntime();
        boolean bl2 = bl = size >= 0L;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int priorityInt = A_Number.Companion.getExtractInt(priority);
        A_Fiber current = interpreter.fiber();
        A_Fiber newFiber2 = FiberDescriptor.Companion.newFiber$default(FiberDescriptor.Companion, A_Type.Companion.typeUnion(A_Type.Companion.getReturnType(succeed2.kind()), A_Type.Companion.getReturnType(fail2.kind())), runtime, A_Fiber.Companion.getTextInterface(current), priorityInt, null, (Function0)new Function0<A_String>(handle2){
            final /* synthetic */ IOSystem.FileHandle $handle;
            {
                this.$handle = $handle;
                super(0);
            }

            @NotNull
            public final A_String invoke() {
                return StringDescriptor.Companion.stringFrom("Asynchronous truncate, " + this.$handle.getFilename());
            }
        }, 16, null);
        A_Fiber.Companion.setAvailLoader(newFiber2, A_Fiber.Companion.getAvailLoader(current));
        A_Fiber.Companion.setHeritableFiberGlobals(newFiber2, A_Fiber.Companion.getHeritableFiberGlobals(current).makeShared());
        newFiber2.makeShared();
        succeed2.makeShared();
        fail2.makeShared();
        runtime.getIoSystem().executeFileTask(() -> P_FileTruncate.attempt$lambda$0(fileChannel, size, runtime, newFiber2, fail2, succeed2));
        return interpreter.primitiveSuccess(newFiber2);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ATOM.getO(), IntegerRangeTypeDescriptor.Companion.getWholeNumbers(), FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, TupleDescriptor.Companion.getEmptyTuple(), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null), FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(InstanceTypeDescriptor.Companion.instanceType(AvailErrorCode.E_IO_ERROR.numericCode())), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null), IntegerRangeTypeDescriptor.Companion.getU8()), FiberTypeDescriptor.Companion.fiberType(PrimitiveTypeDescriptor.Types.TOP.getO()), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INVALID_HANDLE, AvailErrorCode.E_NOT_OPEN_FOR_WRITE, AvailErrorCode.E_SPECIAL_ATOM};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    private static final void attempt$lambda$0(AsynchronousFileChannel $fileChannel, long $size, AvailRuntime $runtime, A_Fiber $newFiber, AvailObject $fail, AvailObject $succeed) {
        Intrinsics.checkNotNullParameter((Object)$fileChannel, (String)"$fileChannel");
        Intrinsics.checkNotNullParameter((Object)$runtime, (String)"$runtime");
        Intrinsics.checkNotNullParameter((Object)$newFiber, (String)"$newFiber");
        Intrinsics.checkNotNullParameter((Object)$fail, (String)"$fail");
        Intrinsics.checkNotNullParameter((Object)$succeed, (String)"$succeed");
        try {
            $fileChannel.truncate($size);
        }
        catch (IOException e) {
            $runtime.runOutermostFunction($newFiber, $fail, CollectionsKt.listOf((Object)AvailErrorCode.E_IO_ERROR.numericCode()), false);
            return;
        }
        $runtime.runOutermostFunction($newFiber, $succeed, CollectionsKt.emptyList(), false);
    }
}

