/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.numbers;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.AbstractNumberDescriptor;
import avail.descriptor.numbers.InfinityDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.ArithmeticException;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_BIT_LOGIC_OP;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_COMPARE_INT;
import avail.interpreter.primitive.numbers.P_Division;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Generator;
import avail.optimizer.values.L2SemanticPrimitiveInvocation;
import avail.optimizer.values.L2SemanticUnboxedInt;
import avail.optimizer.values.L2SemanticValue;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016JH\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019R\u00020\u0017H\u0016\u00a8\u0006\u001a"}, d2={"Lavail/interpreter/primitive/numbers/P_Division;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "fallibilityForArgumentTypes", "Lavail/interpreter/Primitive$Fallibility;", "argumentTypes", "", "Lavail/descriptor/types/A_Type;", "privateBlockTypeRestriction", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
@SourceDebugExtension(value={"SMAP\nP_Division.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P_Division.kt\navail/interpreter/primitive/numbers/P_Division\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,320:1\n1855#2:321\n1855#2,2:322\n1856#2:324\n1855#2,2:325\n1855#2,2:327\n1855#2:329\n1855#2,2:330\n1856#2:332\n*S KotlinDebug\n*F\n+ 1 P_Division.kt\navail/interpreter/primitive/numbers/P_Division\n*L\n139#1:321\n140#1:322,2\n139#1:324\n155#1:325,2\n168#1:327,2\n177#1:329\n178#1:330,2\n177#1:332\n*E\n"})
public final class P_Division
extends Primitive {
    @NotNull
    public static final P_Division INSTANCE = new P_Division();

    private P_Division() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Primitive.Result result2;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject a = interpreter.argument(0);
        AvailObject b = interpreter.argument(1);
        if (A_Number.Companion.equalsInt(b, 0) && a.isInstanceOf(IntegerRangeTypeDescriptor.Companion.getIntegers())) {
            return interpreter.primitiveFailure(AvailErrorCode.E_CANNOT_DIVIDE_BY_ZERO);
        }
        try {
            result2 = interpreter.primitiveSuccess(A_Number.Companion.divideCanDestroy(a, b, true));
        }
        catch (ArithmeticException e) {
            result2 = interpreter.primitiveFailure(e);
        }
        return result2;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.NUMBER.getO(), PrimitiveTypeDescriptor.Types.NUMBER.getO()), PrimitiveTypeDescriptor.Types.NUMBER.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_CANNOT_DIVIDE_BY_ZERO, AvailErrorCode.E_CANNOT_DIVIDE_INFINITIES};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        void $this$forEach$iv;
        void $this$forEach$iv2;
        Intrinsics.checkNotNullParameter((Object)rawFunction2, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type aType = argumentTypes.get(0);
        A_Type bType = argumentTypes.get(1);
        if (!A_Type.Companion.isSubtypeOf(aType, IntegerRangeTypeDescriptor.Companion.getIntegers()) || !A_Type.Companion.isSubtypeOf(bType, IntegerRangeTypeDescriptor.Companion.getIntegers())) {
            return AbstractNumberDescriptor.Companion.binaryNumericOperationTypeBound(argumentTypes.get(0), argumentTypes.get(1));
        }
        if (aType.isEnumeration() && bType.isEnumeration() && A_Number.Companion.getExtractInt(A_Type.Companion.getInstanceCount(aType)) * A_Number.Companion.getExtractInt(A_Type.Companion.getInstanceCount(bType)) < 100) {
            A_Set values = null;
            values = SetDescriptor.Companion.getEmptySet();
            A_Set bInstances = A_Set.Companion.setWithoutElementCanDestroy(A_Type.Companion.getInstances(bType), IntegerDescriptor.Companion.getZero(), false);
            Iterable $this$forEach$iv3 = A_Type.Companion.getInstances(aType);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv3) {
                AvailObject aValue = (AvailObject)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv4 = bInstances;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv4) {
                    AvailObject bValue = (AvailObject)element$iv2;
                    boolean bl2 = false;
                    if (!aValue.isFinite() && !bValue.isFinite()) continue;
                    values = A_Set.Companion.setWithElementCanDestroy(values, A_Number.Companion.divideCanDestroy(aValue, bValue, false), true);
                }
            }
            return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(values).makeImmutable();
        }
        Set aBoundaries = new LinkedHashSet();
        Object bInstances = new A_Type[]{IntegerRangeTypeDescriptor.Companion.getNaturalNumbers(), IntegerRangeTypeDescriptor.Companion.singleInt(0), IntegerRangeTypeDescriptor.Companion.inclusive(InfinityDescriptor.Companion.getNegativeInfinity(), IntegerDescriptor.Companion.negativeOne())};
        bInstances = CollectionsKt.listOf((Object[])bInstances);
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv2) {
            A_Type range = (A_Type)element$iv;
            boolean bl = false;
            A_Type clipped = A_Type.Companion.typeIntersection(aType, range);
            if (clipped.isBottom()) continue;
            aBoundaries.add(A_Type.Companion.getLowerBound(clipped));
            aBoundaries.add(A_Type.Companion.getUpperBound(clipped));
        }
        Set bBoundaries = new LinkedHashSet();
        Object $i$f$forEach22 = new A_Type[]{IntegerRangeTypeDescriptor.Companion.getNaturalNumbers(), IntegerRangeTypeDescriptor.Companion.inclusive(InfinityDescriptor.Companion.getNegativeInfinity(), IntegerDescriptor.Companion.negativeOne())};
        $i$f$forEach22 = CollectionsKt.listOf((Object[])$i$f$forEach22);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            A_Type range = (A_Type)element$iv;
            boolean bl = false;
            A_Type clipped = A_Type.Companion.typeIntersection(bType, range);
            if (clipped.isBottom()) continue;
            bBoundaries.add(A_Type.Companion.getLowerBound(clipped));
            bBoundaries.add(A_Type.Companion.getUpperBound(clipped));
        }
        Set quotients = new LinkedHashSet();
        Iterable $this$forEach$iv5 = aBoundaries;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv5) {
            A_Number aValue = (A_Number)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv6 = bBoundaries;
            boolean $i$f$forEach4 = false;
            for (Object element$iv3 : $this$forEach$iv6) {
                A_Number bValue = (A_Number)element$iv3;
                boolean bl3 = false;
                if (!aValue.isFinite() && !bValue.isFinite()) continue;
                quotients.add(A_Number.Companion.divideCanDestroy(aValue, bValue, false));
            }
        }
        if (quotients.isEmpty()) {
            return BottomTypeDescriptor.Companion.getBottom();
        }
        A_Number min2 = (A_Number)CollectionsKt.minWithOrNull((Iterable)quotients, (arg_0, arg_1) -> P_Division.returnTypeGuaranteedByVM$lambda$6(returnTypeGuaranteedByVM.min.1.INSTANCE, arg_0, arg_1));
        A_Number max2 = (A_Number)CollectionsKt.maxWithOrNull((Iterable)quotients, (arg_0, arg_1) -> P_Division.returnTypeGuaranteedByVM$lambda$7(returnTypeGuaranteedByVM.max.1.INSTANCE, arg_0, arg_1));
        A_Number a_Number = min2;
        Intrinsics.checkNotNull((Object)a_Number);
        A_Number a_Number2 = max2;
        Intrinsics.checkNotNull((Object)a_Number2);
        return A_Type.Companion.typeIntersection(IntegerRangeTypeDescriptor.Companion.inclusive(a_Number, a_Number2), IntegerRangeTypeDescriptor.Companion.getIntegers()).makeImmutable();
    }

    @Override
    @NotNull
    public Primitive.Fallibility fallibilityForArgumentTypes(@NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type aType = argumentTypes.get(0);
        A_Type bType = argumentTypes.get(1);
        boolean bTypeIncludesZero = IntegerDescriptor.Companion.getZero().isInstanceOf(bType);
        if (bTypeIncludesZero) {
            A_Type $this$fallibilityForArgumentTypes_u24lambda_u248 = A_Type.Companion.typeIntersection(bType, IntegerRangeTypeDescriptor.Companion.getIntegers());
            boolean bl = false;
            return A_Number.Companion.equalsInt(A_Type.Companion.getLowerBound($this$fallibilityForArgumentTypes_u24lambda_u248), 0) && A_Number.Companion.equalsInt(A_Type.Companion.getUpperBound($this$fallibilityForArgumentTypes_u24lambda_u248), 0) ? Primitive.Fallibility.CallSiteMustFail : Primitive.Fallibility.CallSiteCanFail;
        }
        boolean aTypeIncludesInfinity = InfinityDescriptor.Companion.getNegativeInfinity().isInstanceOf(aType) || InfinityDescriptor.Companion.getPositiveInfinity().isInstanceOf(aType);
        boolean bTypeIncludesInfinity = InfinityDescriptor.Companion.getNegativeInfinity().isInstanceOf(bType) || InfinityDescriptor.Companion.getPositiveInfinity().isInstanceOf(bType);
        return aTypeIncludesInfinity && bTypeIncludesInfinity ? Primitive.Fallibility.CallSiteCanFail : Primitive.Fallibility.CallSiteCannotFail;
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter((Object)functionToCallReg, (String)"functionToCallReg");
        Intrinsics.checkNotNullParameter((Object)rawFunction2, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)callSiteHelper, (String)"callSiteHelper");
        L2ReadBoxedOperand a = arguments.get(0);
        L2ReadBoxedOperand b = arguments.get(1);
        A_Type aType = argumentTypes.get(0);
        A_Type bType = argumentTypes.get(1);
        L2Generator generator = translator.getGenerator();
        if (A_Type.Companion.isSubtypeOf(bType, IntegerRangeTypeDescriptor.Companion.singleInt(1))) {
            callSiteHelper.useAnswer(a);
            return true;
        }
        A_Type aIntersectInt31 = A_Type.Companion.typeIntersection(aType, IntegerRangeTypeDescriptor.Companion.getI31());
        A_Type bIntersectPos31 = A_Type.Companion.typeIntersection(bType, IntegerRangeTypeDescriptor.Companion.inclusive(1L, Integer.MAX_VALUE));
        if (aIntersectInt31.isBottom() || bIntersectPos31.isBottom()) {
            return false;
        }
        L2BasicBlock fallback = generator.createBasicBlock("fall back to boxed division");
        L2ReadIntOperand intA = generator.readInt(new L2SemanticUnboxedInt(a.semanticValue()), fallback);
        L2ReadIntOperand intB = generator.readInt(new L2SemanticUnboxedInt(b.semanticValue()), fallback);
        boolean bl = generator.currentlyReachable();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Object[] objectArray = new A_Type[]{aIntersectInt31, bIntersectPos31};
        A_Type returnTypeIfInts = this.returnTypeGuaranteedByVM(rawFunction2, CollectionsKt.listOf((Object[])objectArray));
        Object[] objectArray2 = new L2SemanticValue[]{a.semanticValue(), b.semanticValue()};
        L2SemanticPrimitiveInvocation semanticQuotient = L2SemanticValue.Companion.primitiveInvocation(this, CollectionsKt.listOf((Object[])objectArray2));
        L2WriteIntOperand quotientWriter = L2Generator.intWrite$default(generator, SetsKt.setOf((Object)new L2SemanticUnboxedInt(semanticQuotient)), TypeRestriction.Companion.restrictionForType(returnTypeIfInts, TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG), null, 4, null);
        L2BasicBlock nonnegativeNumerator = new L2BasicBlock("nonnegative numerator", false, null, 6, null);
        L2_JUMP_IF_COMPARE_INT.Companion.getGreaterOrEqual().compareAndBranch(generator, intA, generator.unboxedIntConstant(0), L2Generator.Companion.edgeTo$default(L2Generator.Companion, nonnegativeNumerator, null, 2, null), L2Generator.Companion.edgeTo$default(L2Generator.Companion, fallback, null, 2, null));
        boolean bl2 = nonnegativeNumerator.currentlyReachable();
        if (_Assertions.ENABLED && !bl2) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        L2Generator.startBlock$default(generator, nonnegativeNumerator, false, null, 6, null);
        L2BasicBlock notZeroDenominator = new L2BasicBlock("fast path division", false, null, 6, null);
        L2_JUMP_IF_COMPARE_INT.Companion.getGreater().compareAndBranch(generator, intB, generator.unboxedIntConstant(0), L2Generator.Companion.edgeTo$default(L2Generator.Companion, notZeroDenominator, null, 2, null), L2Generator.Companion.edgeTo$default(L2Generator.Companion, fallback, null, 2, null));
        boolean bl3 = notZeroDenominator.currentlyReachable();
        if (_Assertions.ENABLED && !bl3) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        L2Generator.startBlock$default(generator, notZeroDenominator, false, null, 6, null);
        L2Operand[] l2OperandArray = new L2Operand[]{intA, intB, quotientWriter};
        translator.addInstruction(L2_BIT_LOGIC_OP.Companion.getWrappedDivide(), l2OperandArray);
        callSiteHelper.useAnswer(generator.readBoxed(semanticQuotient));
        if (fallback.currentlyReachable()) {
            L2Generator.startBlock$default(generator, fallback, false, null, 6, null);
            translator.generateGeneralFunctionInvocation(functionToCallReg, arguments, false, callSiteHelper);
        }
        return true;
    }

    private static final int returnTypeGuaranteedByVM$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final int returnTypeGuaranteedByVM$lambda$7(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

