/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.objects;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.CompiledCodeDescriptor;
import avail.descriptor.functions.FunctionDescriptor;
import avail.descriptor.maps.A_Map;
import avail.descriptor.module.A_Module;
import avail.descriptor.objects.ObjectTypeDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelOne.L1InstructionWriter;
import avail.interpreter.levelOne.L1Operation;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.primitive.objects.P_PrivateGetSpecificObjectField;
import avail.optimizer.L1Translator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0014J\b\u0010\u0012\u001a\u00020\u000eH\u0014JH\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060\u001fR\u00020\u001dH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lavail/interpreter/primitive/objects/P_CreateObjectFieldGetter;", "Lavail/interpreter/Primitive;", "()V", "packedDeclarationNamesForGeneratedFunction", "Lavail/descriptor/tuples/A_String;", "getPackedDeclarationNamesForGeneratedFunction", "()Lavail/descriptor/tuples/A_String;", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "functionReturningConstant", "Lavail/descriptor/functions/A_Function;", "objectType", "Lavail/descriptor/types/A_Type;", "value", "Lavail/descriptor/representation/A_BasicObject;", "privateBlockTypeRestriction", "privateFailureVariableType", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "arguments", "", "argumentTypes", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_CreateObjectFieldGetter
extends Primitive {
    @NotNull
    public static final P_CreateObjectFieldGetter INSTANCE = new P_CreateObjectFieldGetter();
    @NotNull
    private static final A_String packedDeclarationNamesForGeneratedFunction = StringDescriptor.Companion.stringFrom("arg1,outer1");

    private P_CreateObjectFieldGetter() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        List<AvailObject> list2 = interpreter.argsBuffer;
        AvailObject objectType = list2.get(0);
        AvailObject fieldAtom = list2.get(1);
        A_Map map = A_Type.Companion.getFieldTypeMap(objectType);
        if (!A_Map.Companion.hasKey(map, fieldAtom)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_NO_SUCH_FIELD);
        }
        if (A_Atom.Companion.getAtomProperty(fieldAtom, AtomDescriptor.SpecialAtom.EXPLICIT_SUBCLASSING_KEY.getAtom()).getNotNil()) {
            A_Function newFunction = this.functionReturningConstant(objectType, fieldAtom);
            return interpreter.primitiveSuccess(newFunction);
        }
        Object object = interpreter.availLoaderOrNull();
        if (object == null || (object = ((AvailLoader)object).getModule()) == null) {
            object = NilDescriptor.Companion.getNil();
        }
        Object module = object;
        A_Type returnType = objectType.fieldTypeAt(fieldAtom);
        AvailObject rawFunction2 = CompiledCodeDescriptor.Companion.newCompiledCode(TupleDescriptor.Companion.getEmptyTuple(), 0, FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(objectType), returnType, null, 4, null), P_PrivateGetSpecificObjectField.INSTANCE, BottomTypeDescriptor.Companion.getBottom(), TupleDescriptor.Companion.emptyTuple(), TupleDescriptor.Companion.emptyTuple(), TupleDescriptor.Companion.emptyTuple(), ObjectTupleDescriptor.Companion.tuple(InstanceTypeDescriptor.Companion.instanceType(fieldAtom)), (A_Module)module, 0, TupleDescriptor.Companion.getEmptyTuple(), -1, NilDescriptor.Companion.getNil(), packedDeclarationNamesForGeneratedFunction);
        AvailObject newFunction = FunctionDescriptor.Companion.createWithOuters1(rawFunction2, fieldAtom);
        return interpreter.primitiveSuccess(newFunction);
    }

    private final A_Function functionReturningConstant(A_Type objectType, A_BasicObject value) {
        L1InstructionWriter $this$functionReturningConstant_u24lambda_u240 = new L1InstructionWriter(NilDescriptor.Companion.getNil(), 0, NilDescriptor.Companion.getNil());
        boolean bl = false;
        Object[] objectArray = new A_Type[]{objectType};
        $this$functionReturningConstant_u24lambda_u240.argumentTypes((A_Type[])objectArray);
        $this$functionReturningConstant_u24lambda_u240.setReturnType(InstanceTypeDescriptor.Companion.instanceType(value));
        $this$functionReturningConstant_u24lambda_u240.setReturnTypeIfPrimitiveFails($this$functionReturningConstant_u24lambda_u240.getReturnType());
        objectArray = new int[1];
        objectArray[0] = (A_Type)$this$functionReturningConstant_u24lambda_u240.addLiteral(value);
        $this$functionReturningConstant_u24lambda_u240.write(0, L1Operation.L1_doPushLiteral, (int[])objectArray);
        return FunctionDescriptor.Companion.createExceptOuters($this$functionReturningConstant_u24lambda_u240.compiledCode(), 0);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(ObjectTypeDescriptor.Companion.getMostGeneralObjectMeta(), PrimitiveTypeDescriptor.Types.ATOM.getO()), FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(ObjectTypeDescriptor.Companion.getMostGeneralObjectType()), PrimitiveTypeDescriptor.Types.ANY.getO(), null, 4, null), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_NO_SUCH_FIELD};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter((Object)functionToCallReg, (String)"functionToCallReg");
        Intrinsics.checkNotNullParameter((Object)rawFunction2, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)callSiteHelper, (String)"callSiteHelper");
        return false;
    }

    @NotNull
    public final A_String getPackedDeclarationNamesForGeneratedFunction() {
        return packedDeclarationNamesForGeneratedFunction;
    }
}

