/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.objects;

import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2ConstantOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_GET_OBJECT_FIELD;
import avail.optimizer.L1Translator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016JH\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lavail/interpreter/primitive/objects/P_PrivateGetSpecificObjectField;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_PrivateGetSpecificObjectField
extends Primitive {
    @NotNull
    public static final P_PrivateGetSpecificObjectField INSTANCE = new P_PrivateGetSpecificObjectField();

    private P_PrivateGetSpecificObjectField() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.Private, Primitive.Flag.CanInline, Primitive.Flag.CannotFail};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject obj = interpreter.argument(0);
        A_Function a_Function = interpreter.function;
        Intrinsics.checkNotNull((Object)a_Function);
        A_Function primitiveFunction = a_Function;
        boolean bl2 = bl = primitiveFunction.code().codePrimitive() == this;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = A_Function.Companion.getNumOuterVars(primitiveFunction) == 1;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        AvailObject field = primitiveFunction.outerVarAt(1);
        boolean bl4 = field.isAtom();
        if (_Assertions.ENABLED && !bl4) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        return interpreter.primitiveSuccess(obj.fieldAt(field));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return BottomTypeDescriptor.Companion.getBottom();
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter((Object)rawFunction2, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        return A_Type.Companion.getReturnType(rawFunction2.functionType());
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter((Object)functionToCallReg, (String)"functionToCallReg");
        Intrinsics.checkNotNullParameter((Object)rawFunction2, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)callSiteHelper, (String)"callSiteHelper");
        AvailObject availObject = functionToCallReg.constantOrNull();
        if (availObject == null) {
            return false;
        }
        AvailObject function = availObject;
        L2ReadBoxedOperand objectReg = arguments.get(0);
        A_Type objectType = argumentTypes.get(0);
        AvailObject fieldAtom = function.outerVarAt(1);
        A_Type fieldType = objectType.fieldTypeAt(fieldAtom);
        AvailObject constant = objectReg.restriction().getConstantOrNull();
        if (constant != null) {
            callSiteHelper.useAnswer(translator.getGenerator().boxedConstant(constant.fieldAt(fieldAtom)));
        } else if (fieldType.isEnumeration() && !fieldType.isInstanceMeta() && A_Number.Companion.equalsInt(A_Type.Companion.getInstanceCount(fieldType), 1)) {
            callSiteHelper.useAnswer(translator.getGenerator().boxedConstant(A_Type.Companion.getInstance(fieldType)));
        } else {
            L2WriteBoxedOperand write2 = translator.getGenerator().boxedWriteTemp(TypeRestriction.Companion.restrictionForType(fieldType, TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
            L2Operand[] l2OperandArray = new L2Operand[]{objectReg, new L2ConstantOperand(fieldAtom), write2};
            translator.addInstruction(L2_GET_OBJECT_FIELD.INSTANCE, l2OperandArray);
            callSiteHelper.useAnswer(translator.readBoxed(write2));
        }
        return true;
    }
}

